/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListInstancesResponse extends ServiceDiscoveryResponse implements
        ToCopyableBuilder<ListInstancesResponse.Builder, ListInstancesResponse> {
    private static final SdkField<List<InstanceSummary>> INSTANCES_FIELD = SdkField
            .<List<InstanceSummary>> builder(MarshallingType.LIST)
            .memberName("Instances")
            .getter(getter(ListInstancesResponse::instances))
            .setter(setter(Builder::instances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Instances").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InstanceSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstanceSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListInstancesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<InstanceSummary> instances;

    private final String nextToken;

    private ListInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.instances = builder.instances;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Instances property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasInstances() {
        return instances != null && !(instances instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Summary information about the instances that are associated with the specified service.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInstances()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Summary information about the instances that are associated with the specified service.
     */
    public final List<InstanceSummary> instances() {
        return instances;
    }

    /**
     * <p>
     * If more than <code>MaxResults</code> instances match the specified criteria, you can submit another
     * <code>ListInstances</code> request to get the next group of results. Specify the value of <code>NextToken</code>
     * from the previous response in the next request.
     * </p>
     * 
     * @return If more than <code>MaxResults</code> instances match the specified criteria, you can submit another
     *         <code>ListInstances</code> request to get the next group of results. Specify the value of
     *         <code>NextToken</code> from the previous response in the next request.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasInstances() ? instances() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInstancesResponse)) {
            return false;
        }
        ListInstancesResponse other = (ListInstancesResponse) obj;
        return hasInstances() == other.hasInstances() && Objects.equals(instances(), other.instances())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListInstancesResponse").add("Instances", hasInstances() ? instances() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Instances":
            return Optional.ofNullable(clazz.cast(instances()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListInstancesResponse, T> g) {
        return obj -> g.apply((ListInstancesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceDiscoveryResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListInstancesResponse> {
        /**
         * <p>
         * Summary information about the instances that are associated with the specified service.
         * </p>
         * 
         * @param instances
         *        Summary information about the instances that are associated with the specified service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instances(Collection<InstanceSummary> instances);

        /**
         * <p>
         * Summary information about the instances that are associated with the specified service.
         * </p>
         * 
         * @param instances
         *        Summary information about the instances that are associated with the specified service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instances(InstanceSummary... instances);

        /**
         * <p>
         * Summary information about the instances that are associated with the specified service.
         * </p>
         * This is a convenience that creates an instance of the {@link List<InstanceSummary>.Builder} avoiding the need
         * to create one manually via {@link List<InstanceSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InstanceSummary>.Builder#build()} is called immediately and
         * its result is passed to {@link #instances(List<InstanceSummary>)}.
         * 
         * @param instances
         *        a consumer that will call methods on {@link List<InstanceSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instances(List<InstanceSummary>)
         */
        Builder instances(Consumer<InstanceSummary.Builder>... instances);

        /**
         * <p>
         * If more than <code>MaxResults</code> instances match the specified criteria, you can submit another
         * <code>ListInstances</code> request to get the next group of results. Specify the value of
         * <code>NextToken</code> from the previous response in the next request.
         * </p>
         * 
         * @param nextToken
         *        If more than <code>MaxResults</code> instances match the specified criteria, you can submit another
         *        <code>ListInstances</code> request to get the next group of results. Specify the value of
         *        <code>NextToken</code> from the previous response in the next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ServiceDiscoveryResponse.BuilderImpl implements Builder {
        private List<InstanceSummary> instances = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInstancesResponse model) {
            super(model);
            instances(model.instances);
            nextToken(model.nextToken);
        }

        public final List<InstanceSummary.Builder> getInstances() {
            List<InstanceSummary.Builder> result = InstanceSummaryListCopier.copyToBuilder(this.instances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder instances(Collection<InstanceSummary> instances) {
            this.instances = InstanceSummaryListCopier.copy(instances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(InstanceSummary... instances) {
            instances(Arrays.asList(instances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(Consumer<InstanceSummary.Builder>... instances) {
            instances(Stream.of(instances).map(c -> InstanceSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setInstances(Collection<InstanceSummary.BuilderImpl> instances) {
            this.instances = InstanceSummaryListCopier.copyFromBuilder(instances);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListInstancesResponse build() {
            return new ListInstancesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
