/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains information about a specified operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Operation implements SdkPojo, Serializable, ToCopyableBuilder<Operation.Builder, Operation> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(Operation::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(Operation::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(Operation::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorMessage").getter(getter(Operation::errorMessage)).setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()).build();

    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorCode").getter(getter(Operation::errorCode)).setter(setter(Builder::errorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCode").build()).build();

    private static final SdkField<Instant> CREATE_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreateDate").getter(getter(Operation::createDate)).setter(setter(Builder::createDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateDate").build()).build();

    private static final SdkField<Instant> UPDATE_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdateDate").getter(getter(Operation::updateDate)).setter(setter(Builder::updateDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateDate").build()).build();

    private static final SdkField<Map<String, String>> TARGETS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Targets")
            .getter(getter(Operation::targetsAsStrings))
            .setter(setter(Builder::targetsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Targets").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, TYPE_FIELD,
            STATUS_FIELD, ERROR_MESSAGE_FIELD, ERROR_CODE_FIELD, CREATE_DATE_FIELD, UPDATE_DATE_FIELD, TARGETS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String type;

    private final String status;

    private final String errorMessage;

    private final String errorCode;

    private final Instant createDate;

    private final Instant updateDate;

    private final Map<String, String> targets;

    private Operation(BuilderImpl builder) {
        this.id = builder.id;
        this.type = builder.type;
        this.status = builder.status;
        this.errorMessage = builder.errorMessage;
        this.errorCode = builder.errorCode;
        this.createDate = builder.createDate;
        this.updateDate = builder.updateDate;
        this.targets = builder.targets;
    }

    /**
     * <p>
     * The ID of the operation that you want to get information about.
     * </p>
     * 
     * @return The ID of the operation that you want to get information about.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the operation that's associated with the specified ID.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link OperationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The name of the operation that's associated with the specified ID.
     * @see OperationType
     */
    public final OperationType type() {
        return OperationType.fromValue(type);
    }

    /**
     * <p>
     * The name of the operation that's associated with the specified ID.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link OperationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The name of the operation that's associated with the specified ID.
     * @see OperationType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The status of the operation. Values include the following:
     * </p>
     * <dl>
     * <dt>SUBMITTED</dt>
     * <dd>
     * <p>
     * This is the initial state that occurs immediately after you submit a request.
     * </p>
     * </dd>
     * <dt>PENDING</dt>
     * <dd>
     * <p>
     * Cloud Map is performing the operation.
     * </p>
     * </dd>
     * <dt>SUCCESS</dt>
     * <dd>
     * <p>
     * The operation succeeded.
     * </p>
     * </dd>
     * <dt>FAIL</dt>
     * <dd>
     * <p>
     * The operation failed. For the failure reason, see <code>ErrorMessage</code>.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link OperationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the operation. Values include the following:</p>
     *         <dl>
     *         <dt>SUBMITTED</dt>
     *         <dd>
     *         <p>
     *         This is the initial state that occurs immediately after you submit a request.
     *         </p>
     *         </dd>
     *         <dt>PENDING</dt>
     *         <dd>
     *         <p>
     *         Cloud Map is performing the operation.
     *         </p>
     *         </dd>
     *         <dt>SUCCESS</dt>
     *         <dd>
     *         <p>
     *         The operation succeeded.
     *         </p>
     *         </dd>
     *         <dt>FAIL</dt>
     *         <dd>
     *         <p>
     *         The operation failed. For the failure reason, see <code>ErrorMessage</code>.
     *         </p>
     *         </dd>
     * @see OperationStatus
     */
    public final OperationStatus status() {
        return OperationStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the operation. Values include the following:
     * </p>
     * <dl>
     * <dt>SUBMITTED</dt>
     * <dd>
     * <p>
     * This is the initial state that occurs immediately after you submit a request.
     * </p>
     * </dd>
     * <dt>PENDING</dt>
     * <dd>
     * <p>
     * Cloud Map is performing the operation.
     * </p>
     * </dd>
     * <dt>SUCCESS</dt>
     * <dd>
     * <p>
     * The operation succeeded.
     * </p>
     * </dd>
     * <dt>FAIL</dt>
     * <dd>
     * <p>
     * The operation failed. For the failure reason, see <code>ErrorMessage</code>.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link OperationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the operation. Values include the following:</p>
     *         <dl>
     *         <dt>SUBMITTED</dt>
     *         <dd>
     *         <p>
     *         This is the initial state that occurs immediately after you submit a request.
     *         </p>
     *         </dd>
     *         <dt>PENDING</dt>
     *         <dd>
     *         <p>
     *         Cloud Map is performing the operation.
     *         </p>
     *         </dd>
     *         <dt>SUCCESS</dt>
     *         <dd>
     *         <p>
     *         The operation succeeded.
     *         </p>
     *         </dd>
     *         <dt>FAIL</dt>
     *         <dd>
     *         <p>
     *         The operation failed. For the failure reason, see <code>ErrorMessage</code>.
     *         </p>
     *         </dd>
     * @see OperationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * If the value of <code>Status</code> is <code>FAIL</code>, the reason that the operation failed.
     * </p>
     * 
     * @return If the value of <code>Status</code> is <code>FAIL</code>, the reason that the operation failed.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    /**
     * <p>
     * The code associated with <code>ErrorMessage</code>. Values for <code>ErrorCode</code> include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACCESS_DENIED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CANNOT_CREATE_HOSTED_ZONE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EXPIRED_TOKEN</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HOSTED_ZONE_NOT_FOUND</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INTERNAL_FAILURE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INVALID_CHANGE_BATCH</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>THROTTLED_REQUEST</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The code associated with <code>ErrorMessage</code>. Values for <code>ErrorCode</code> include the
     *         following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACCESS_DENIED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CANNOT_CREATE_HOSTED_ZONE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EXPIRED_TOKEN</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>HOSTED_ZONE_NOT_FOUND</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INTERNAL_FAILURE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INVALID_CHANGE_BATCH</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>THROTTLED_REQUEST</code>
     *         </p>
     *         </li>
     */
    public final String errorCode() {
        return errorCode;
    }

    /**
     * <p>
     * The date and time that the request was submitted, in Unix date/time format and Coordinated Universal Time (UTC).
     * The value of <code>CreateDate</code> is accurate to milliseconds. For example, the value
     * <code>1516925490.087</code> represents Friday, January 26, 2018 12:11:30.087 AM.
     * </p>
     * 
     * @return The date and time that the request was submitted, in Unix date/time format and Coordinated Universal Time
     *         (UTC). The value of <code>CreateDate</code> is accurate to milliseconds. For example, the value
     *         <code>1516925490.087</code> represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public final Instant createDate() {
        return createDate;
    }

    /**
     * <p>
     * The date and time that the value of <code>Status</code> changed to the current value, in Unix date/time format
     * and Coordinated Universal Time (UTC). The value of <code>UpdateDate</code> is accurate to milliseconds. For
     * example, the value <code>1516925490.087</code> represents Friday, January 26, 2018 12:11:30.087 AM.
     * </p>
     * 
     * @return The date and time that the value of <code>Status</code> changed to the current value, in Unix date/time
     *         format and Coordinated Universal Time (UTC). The value of <code>UpdateDate</code> is accurate to
     *         milliseconds. For example, the value <code>1516925490.087</code> represents Friday, January 26, 2018
     *         12:11:30.087 AM.
     */
    public final Instant updateDate() {
        return updateDate;
    }

    /**
     * <p>
     * The name of the target entity that's associated with the operation:
     * </p>
     * <dl>
     * <dt>NAMESPACE</dt>
     * <dd>
     * <p>
     * The namespace ID is returned in the <code>ResourceId</code> property.
     * </p>
     * </dd>
     * <dt>SERVICE</dt>
     * <dd>
     * <p>
     * The service ID is returned in the <code>ResourceId</code> property.
     * </p>
     * </dd>
     * <dt>INSTANCE</dt>
     * <dd>
     * <p>
     * The instance ID is returned in the <code>ResourceId</code> property.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTargets()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The name of the target entity that's associated with the operation:</p>
     *         <dl>
     *         <dt>NAMESPACE</dt>
     *         <dd>
     *         <p>
     *         The namespace ID is returned in the <code>ResourceId</code> property.
     *         </p>
     *         </dd>
     *         <dt>SERVICE</dt>
     *         <dd>
     *         <p>
     *         The service ID is returned in the <code>ResourceId</code> property.
     *         </p>
     *         </dd>
     *         <dt>INSTANCE</dt>
     *         <dd>
     *         <p>
     *         The instance ID is returned in the <code>ResourceId</code> property.
     *         </p>
     *         </dd>
     */
    public final Map<OperationTargetType, String> targets() {
        return OperationTargetsMapCopier.copyStringToEnum(targets);
    }

    /**
     * Returns true if the Targets property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTargets() {
        return targets != null && !(targets instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The name of the target entity that's associated with the operation:
     * </p>
     * <dl>
     * <dt>NAMESPACE</dt>
     * <dd>
     * <p>
     * The namespace ID is returned in the <code>ResourceId</code> property.
     * </p>
     * </dd>
     * <dt>SERVICE</dt>
     * <dd>
     * <p>
     * The service ID is returned in the <code>ResourceId</code> property.
     * </p>
     * </dd>
     * <dt>INSTANCE</dt>
     * <dd>
     * <p>
     * The instance ID is returned in the <code>ResourceId</code> property.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTargets()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The name of the target entity that's associated with the operation:</p>
     *         <dl>
     *         <dt>NAMESPACE</dt>
     *         <dd>
     *         <p>
     *         The namespace ID is returned in the <code>ResourceId</code> property.
     *         </p>
     *         </dd>
     *         <dt>SERVICE</dt>
     *         <dd>
     *         <p>
     *         The service ID is returned in the <code>ResourceId</code> property.
     *         </p>
     *         </dd>
     *         <dt>INSTANCE</dt>
     *         <dd>
     *         <p>
     *         The instance ID is returned in the <code>ResourceId</code> property.
     *         </p>
     *         </dd>
     */
    public final Map<String, String> targetsAsStrings() {
        return targets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(createDate());
        hashCode = 31 * hashCode + Objects.hashCode(updateDate());
        hashCode = 31 * hashCode + Objects.hashCode(hasTargets() ? targetsAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Operation)) {
            return false;
        }
        Operation other = (Operation) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(errorMessage(), other.errorMessage()) && Objects.equals(errorCode(), other.errorCode())
                && Objects.equals(createDate(), other.createDate()) && Objects.equals(updateDate(), other.updateDate())
                && hasTargets() == other.hasTargets() && Objects.equals(targetsAsStrings(), other.targetsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Operation").add("Id", id()).add("Type", typeAsString()).add("Status", statusAsString())
                .add("ErrorMessage", errorMessage()).add("ErrorCode", errorCode()).add("CreateDate", createDate())
                .add("UpdateDate", updateDate()).add("Targets", hasTargets() ? targetsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "ErrorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        case "ErrorCode":
            return Optional.ofNullable(clazz.cast(errorCode()));
        case "CreateDate":
            return Optional.ofNullable(clazz.cast(createDate()));
        case "UpdateDate":
            return Optional.ofNullable(clazz.cast(updateDate()));
        case "Targets":
            return Optional.ofNullable(clazz.cast(targetsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Operation, T> g) {
        return obj -> g.apply((Operation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Operation> {
        /**
         * <p>
         * The ID of the operation that you want to get information about.
         * </p>
         * 
         * @param id
         *        The ID of the operation that you want to get information about.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the operation that's associated with the specified ID.
         * </p>
         * 
         * @param type
         *        The name of the operation that's associated with the specified ID.
         * @see OperationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationType
         */
        Builder type(String type);

        /**
         * <p>
         * The name of the operation that's associated with the specified ID.
         * </p>
         * 
         * @param type
         *        The name of the operation that's associated with the specified ID.
         * @see OperationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationType
         */
        Builder type(OperationType type);

        /**
         * <p>
         * The status of the operation. Values include the following:
         * </p>
         * <dl>
         * <dt>SUBMITTED</dt>
         * <dd>
         * <p>
         * This is the initial state that occurs immediately after you submit a request.
         * </p>
         * </dd>
         * <dt>PENDING</dt>
         * <dd>
         * <p>
         * Cloud Map is performing the operation.
         * </p>
         * </dd>
         * <dt>SUCCESS</dt>
         * <dd>
         * <p>
         * The operation succeeded.
         * </p>
         * </dd>
         * <dt>FAIL</dt>
         * <dd>
         * <p>
         * The operation failed. For the failure reason, see <code>ErrorMessage</code>.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param status
         *        The status of the operation. Values include the following:</p>
         *        <dl>
         *        <dt>SUBMITTED</dt>
         *        <dd>
         *        <p>
         *        This is the initial state that occurs immediately after you submit a request.
         *        </p>
         *        </dd>
         *        <dt>PENDING</dt>
         *        <dd>
         *        <p>
         *        Cloud Map is performing the operation.
         *        </p>
         *        </dd>
         *        <dt>SUCCESS</dt>
         *        <dd>
         *        <p>
         *        The operation succeeded.
         *        </p>
         *        </dd>
         *        <dt>FAIL</dt>
         *        <dd>
         *        <p>
         *        The operation failed. For the failure reason, see <code>ErrorMessage</code>.
         *        </p>
         *        </dd>
         * @see OperationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the operation. Values include the following:
         * </p>
         * <dl>
         * <dt>SUBMITTED</dt>
         * <dd>
         * <p>
         * This is the initial state that occurs immediately after you submit a request.
         * </p>
         * </dd>
         * <dt>PENDING</dt>
         * <dd>
         * <p>
         * Cloud Map is performing the operation.
         * </p>
         * </dd>
         * <dt>SUCCESS</dt>
         * <dd>
         * <p>
         * The operation succeeded.
         * </p>
         * </dd>
         * <dt>FAIL</dt>
         * <dd>
         * <p>
         * The operation failed. For the failure reason, see <code>ErrorMessage</code>.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param status
         *        The status of the operation. Values include the following:</p>
         *        <dl>
         *        <dt>SUBMITTED</dt>
         *        <dd>
         *        <p>
         *        This is the initial state that occurs immediately after you submit a request.
         *        </p>
         *        </dd>
         *        <dt>PENDING</dt>
         *        <dd>
         *        <p>
         *        Cloud Map is performing the operation.
         *        </p>
         *        </dd>
         *        <dt>SUCCESS</dt>
         *        <dd>
         *        <p>
         *        The operation succeeded.
         *        </p>
         *        </dd>
         *        <dt>FAIL</dt>
         *        <dd>
         *        <p>
         *        The operation failed. For the failure reason, see <code>ErrorMessage</code>.
         *        </p>
         *        </dd>
         * @see OperationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationStatus
         */
        Builder status(OperationStatus status);

        /**
         * <p>
         * If the value of <code>Status</code> is <code>FAIL</code>, the reason that the operation failed.
         * </p>
         * 
         * @param errorMessage
         *        If the value of <code>Status</code> is <code>FAIL</code>, the reason that the operation failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);

        /**
         * <p>
         * The code associated with <code>ErrorMessage</code>. Values for <code>ErrorCode</code> include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACCESS_DENIED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CANNOT_CREATE_HOSTED_ZONE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EXPIRED_TOKEN</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>HOSTED_ZONE_NOT_FOUND</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INTERNAL_FAILURE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INVALID_CHANGE_BATCH</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>THROTTLED_REQUEST</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param errorCode
         *        The code associated with <code>ErrorMessage</code>. Values for <code>ErrorCode</code> include the
         *        following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACCESS_DENIED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CANNOT_CREATE_HOSTED_ZONE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EXPIRED_TOKEN</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>HOSTED_ZONE_NOT_FOUND</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INTERNAL_FAILURE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INVALID_CHANGE_BATCH</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>THROTTLED_REQUEST</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * The date and time that the request was submitted, in Unix date/time format and Coordinated Universal Time
         * (UTC). The value of <code>CreateDate</code> is accurate to milliseconds. For example, the value
         * <code>1516925490.087</code> represents Friday, January 26, 2018 12:11:30.087 AM.
         * </p>
         * 
         * @param createDate
         *        The date and time that the request was submitted, in Unix date/time format and Coordinated Universal
         *        Time (UTC). The value of <code>CreateDate</code> is accurate to milliseconds. For example, the value
         *        <code>1516925490.087</code> represents Friday, January 26, 2018 12:11:30.087 AM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createDate(Instant createDate);

        /**
         * <p>
         * The date and time that the value of <code>Status</code> changed to the current value, in Unix date/time
         * format and Coordinated Universal Time (UTC). The value of <code>UpdateDate</code> is accurate to
         * milliseconds. For example, the value <code>1516925490.087</code> represents Friday, January 26, 2018
         * 12:11:30.087 AM.
         * </p>
         * 
         * @param updateDate
         *        The date and time that the value of <code>Status</code> changed to the current value, in Unix
         *        date/time format and Coordinated Universal Time (UTC). The value of <code>UpdateDate</code> is
         *        accurate to milliseconds. For example, the value <code>1516925490.087</code> represents Friday,
         *        January 26, 2018 12:11:30.087 AM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateDate(Instant updateDate);

        /**
         * <p>
         * The name of the target entity that's associated with the operation:
         * </p>
         * <dl>
         * <dt>NAMESPACE</dt>
         * <dd>
         * <p>
         * The namespace ID is returned in the <code>ResourceId</code> property.
         * </p>
         * </dd>
         * <dt>SERVICE</dt>
         * <dd>
         * <p>
         * The service ID is returned in the <code>ResourceId</code> property.
         * </p>
         * </dd>
         * <dt>INSTANCE</dt>
         * <dd>
         * <p>
         * The instance ID is returned in the <code>ResourceId</code> property.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param targets
         *        The name of the target entity that's associated with the operation:</p>
         *        <dl>
         *        <dt>NAMESPACE</dt>
         *        <dd>
         *        <p>
         *        The namespace ID is returned in the <code>ResourceId</code> property.
         *        </p>
         *        </dd>
         *        <dt>SERVICE</dt>
         *        <dd>
         *        <p>
         *        The service ID is returned in the <code>ResourceId</code> property.
         *        </p>
         *        </dd>
         *        <dt>INSTANCE</dt>
         *        <dd>
         *        <p>
         *        The instance ID is returned in the <code>ResourceId</code> property.
         *        </p>
         *        </dd>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetsWithStrings(Map<String, String> targets);

        /**
         * <p>
         * The name of the target entity that's associated with the operation:
         * </p>
         * <dl>
         * <dt>NAMESPACE</dt>
         * <dd>
         * <p>
         * The namespace ID is returned in the <code>ResourceId</code> property.
         * </p>
         * </dd>
         * <dt>SERVICE</dt>
         * <dd>
         * <p>
         * The service ID is returned in the <code>ResourceId</code> property.
         * </p>
         * </dd>
         * <dt>INSTANCE</dt>
         * <dd>
         * <p>
         * The instance ID is returned in the <code>ResourceId</code> property.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param targets
         *        The name of the target entity that's associated with the operation:</p>
         *        <dl>
         *        <dt>NAMESPACE</dt>
         *        <dd>
         *        <p>
         *        The namespace ID is returned in the <code>ResourceId</code> property.
         *        </p>
         *        </dd>
         *        <dt>SERVICE</dt>
         *        <dd>
         *        <p>
         *        The service ID is returned in the <code>ResourceId</code> property.
         *        </p>
         *        </dd>
         *        <dt>INSTANCE</dt>
         *        <dd>
         *        <p>
         *        The instance ID is returned in the <code>ResourceId</code> property.
         *        </p>
         *        </dd>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(Map<OperationTargetType, String> targets);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String type;

        private String status;

        private String errorMessage;

        private String errorCode;

        private Instant createDate;

        private Instant updateDate;

        private Map<String, String> targets = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Operation model) {
            id(model.id);
            type(model.type);
            status(model.status);
            errorMessage(model.errorMessage);
            errorCode(model.errorCode);
            createDate(model.createDate);
            updateDate(model.updateDate);
            targetsWithStrings(model.targets);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(OperationType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(OperationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public final String getErrorCode() {
            return errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public final Instant getCreateDate() {
            return createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        public final Instant getUpdateDate() {
            return updateDate;
        }

        @Override
        public final Builder updateDate(Instant updateDate) {
            this.updateDate = updateDate;
            return this;
        }

        public final void setUpdateDate(Instant updateDate) {
            this.updateDate = updateDate;
        }

        public final Map<String, String> getTargets() {
            if (targets instanceof SdkAutoConstructMap) {
                return null;
            }
            return targets;
        }

        @Override
        public final Builder targetsWithStrings(Map<String, String> targets) {
            this.targets = OperationTargetsMapCopier.copy(targets);
            return this;
        }

        @Override
        public final Builder targets(Map<OperationTargetType, String> targets) {
            this.targets = OperationTargetsMapCopier.copyEnumToString(targets);
            return this;
        }

        public final void setTargets(Map<String, String> targets) {
            this.targets = OperationTargetsMapCopier.copy(targets);
        }

        @Override
        public Operation build() {
            return new Operation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
