/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that lets you select the operations that you want to list.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OperationFilter implements SdkPojo, Serializable, ToCopyableBuilder<OperationFilter.Builder, OperationFilter> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(OperationFilter::nameAsString)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<String>> VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Values")
            .getter(getter(OperationFilter::values))
            .setter(setter(Builder::values))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CONDITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Condition").getter(getter(OperationFilter::conditionAsString)).setter(setter(Builder::condition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Condition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, VALUES_FIELD,
            CONDITION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final List<String> values;

    private final String condition;

    private OperationFilter(BuilderImpl builder) {
        this.name = builder.name;
        this.values = builder.values;
        this.condition = builder.condition;
    }

    /**
     * <p>
     * Specify the operations that you want to get:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>NAMESPACE_ID</b>: Gets operations related to specified namespaces.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>SERVICE_ID</b>: Gets operations related to specified services.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>STATUS</b>: Gets operations based on the status of the operations: <code>SUBMITTED</code>,
     * <code>PENDING</code>, <code>SUCCEED</code>, or <code>FAIL</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>TYPE</b>: Gets specified types of operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>UPDATE_DATE</b>: Gets operations that changed status during a specified date/time range.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link OperationFilterName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return Specify the operations that you want to get:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>NAMESPACE_ID</b>: Gets operations related to specified namespaces.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>SERVICE_ID</b>: Gets operations related to specified services.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>STATUS</b>: Gets operations based on the status of the operations: <code>SUBMITTED</code>,
     *         <code>PENDING</code>, <code>SUCCEED</code>, or <code>FAIL</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>TYPE</b>: Gets specified types of operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>UPDATE_DATE</b>: Gets operations that changed status during a specified date/time range.
     *         </p>
     *         </li>
     * @see OperationFilterName
     */
    public final OperationFilterName name() {
        return OperationFilterName.fromValue(name);
    }

    /**
     * <p>
     * Specify the operations that you want to get:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>NAMESPACE_ID</b>: Gets operations related to specified namespaces.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>SERVICE_ID</b>: Gets operations related to specified services.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>STATUS</b>: Gets operations based on the status of the operations: <code>SUBMITTED</code>,
     * <code>PENDING</code>, <code>SUCCEED</code>, or <code>FAIL</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>TYPE</b>: Gets specified types of operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>UPDATE_DATE</b>: Gets operations that changed status during a specified date/time range.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link OperationFilterName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return Specify the operations that you want to get:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>NAMESPACE_ID</b>: Gets operations related to specified namespaces.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>SERVICE_ID</b>: Gets operations related to specified services.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>STATUS</b>: Gets operations based on the status of the operations: <code>SUBMITTED</code>,
     *         <code>PENDING</code>, <code>SUCCEED</code>, or <code>FAIL</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>TYPE</b>: Gets specified types of operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>UPDATE_DATE</b>: Gets operations that changed status during a specified date/time range.
     *         </p>
     *         </li>
     * @see OperationFilterName
     */
    public final String nameAsString() {
        return name;
    }

    /**
     * Returns true if the Values property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasValues() {
        return values != null && !(values instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specify values that are applicable to the value that you specify for <code>Name</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>NAMESPACE_ID</b>: Specify one namespace ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>SERVICE_ID</b>: Specify one service ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>STATUS</b>: Specify one or more statuses: <code>SUBMITTED</code>, <code>PENDING</code>, <code>SUCCEED</code>,
     * or <code>FAIL</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>TYPE</b>: Specify one or more of the following types: <code>CREATE_NAMESPACE</code>,
     * <code>DELETE_NAMESPACE</code>, <code>UPDATE_SERVICE</code>, <code>REGISTER_INSTANCE</code>, or
     * <code>DEREGISTER_INSTANCE</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>UPDATE_DATE</b>: Specify a start date and an end date in Unix date/time format and Coordinated Universal Time
     * (UTC). The start date must be the first value.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasValues()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Specify values that are applicable to the value that you specify for <code>Name</code>: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>NAMESPACE_ID</b>: Specify one namespace ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>SERVICE_ID</b>: Specify one service ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>STATUS</b>: Specify one or more statuses: <code>SUBMITTED</code>, <code>PENDING</code>,
     *         <code>SUCCEED</code>, or <code>FAIL</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>TYPE</b>: Specify one or more of the following types: <code>CREATE_NAMESPACE</code>,
     *         <code>DELETE_NAMESPACE</code>, <code>UPDATE_SERVICE</code>, <code>REGISTER_INSTANCE</code>, or
     *         <code>DEREGISTER_INSTANCE</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>UPDATE_DATE</b>: Specify a start date and an end date in Unix date/time format and Coordinated
     *         Universal Time (UTC). The start date must be the first value.
     *         </p>
     *         </li>
     */
    public final List<String> values() {
        return values;
    }

    /**
     * <p>
     * The operator that you want to use to determine whether an operation matches the specified value. Valid values for
     * condition include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>EQ</code>: When you specify <code>EQ</code> for the condition, you can specify only one value.
     * <code>EQ</code> is supported for <code>NAMESPACE_ID</code>, <code>SERVICE_ID</code>, <code>STATUS</code>, and
     * <code>TYPE</code>. <code>EQ</code> is the default condition and can be omitted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IN</code>: When you specify <code>IN</code> for the condition, you can specify a list of one or more
     * values. <code>IN</code> is supported for <code>STATUS</code> and <code>TYPE</code>. An operation must match one
     * of the specified values to be returned in the response.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>BETWEEN</code>: Specify a start date and an end date in Unix date/time format and Coordinated Universal
     * Time (UTC). The start date must be the first value. <code>BETWEEN</code> is supported for
     * <code>UPDATE_DATE</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #condition} will
     * return {@link FilterCondition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #conditionAsString}.
     * </p>
     * 
     * @return The operator that you want to use to determine whether an operation matches the specified value. Valid
     *         values for condition include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>EQ</code>: When you specify <code>EQ</code> for the condition, you can specify only one value.
     *         <code>EQ</code> is supported for <code>NAMESPACE_ID</code>, <code>SERVICE_ID</code>, <code>STATUS</code>,
     *         and <code>TYPE</code>. <code>EQ</code> is the default condition and can be omitted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IN</code>: When you specify <code>IN</code> for the condition, you can specify a list of one or
     *         more values. <code>IN</code> is supported for <code>STATUS</code> and <code>TYPE</code>. An operation
     *         must match one of the specified values to be returned in the response.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>BETWEEN</code>: Specify a start date and an end date in Unix date/time format and Coordinated
     *         Universal Time (UTC). The start date must be the first value. <code>BETWEEN</code> is supported for
     *         <code>UPDATE_DATE</code>.
     *         </p>
     *         </li>
     * @see FilterCondition
     */
    public final FilterCondition condition() {
        return FilterCondition.fromValue(condition);
    }

    /**
     * <p>
     * The operator that you want to use to determine whether an operation matches the specified value. Valid values for
     * condition include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>EQ</code>: When you specify <code>EQ</code> for the condition, you can specify only one value.
     * <code>EQ</code> is supported for <code>NAMESPACE_ID</code>, <code>SERVICE_ID</code>, <code>STATUS</code>, and
     * <code>TYPE</code>. <code>EQ</code> is the default condition and can be omitted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IN</code>: When you specify <code>IN</code> for the condition, you can specify a list of one or more
     * values. <code>IN</code> is supported for <code>STATUS</code> and <code>TYPE</code>. An operation must match one
     * of the specified values to be returned in the response.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>BETWEEN</code>: Specify a start date and an end date in Unix date/time format and Coordinated Universal
     * Time (UTC). The start date must be the first value. <code>BETWEEN</code> is supported for
     * <code>UPDATE_DATE</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #condition} will
     * return {@link FilterCondition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #conditionAsString}.
     * </p>
     * 
     * @return The operator that you want to use to determine whether an operation matches the specified value. Valid
     *         values for condition include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>EQ</code>: When you specify <code>EQ</code> for the condition, you can specify only one value.
     *         <code>EQ</code> is supported for <code>NAMESPACE_ID</code>, <code>SERVICE_ID</code>, <code>STATUS</code>,
     *         and <code>TYPE</code>. <code>EQ</code> is the default condition and can be omitted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IN</code>: When you specify <code>IN</code> for the condition, you can specify a list of one or
     *         more values. <code>IN</code> is supported for <code>STATUS</code> and <code>TYPE</code>. An operation
     *         must match one of the specified values to be returned in the response.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>BETWEEN</code>: Specify a start date and an end date in Unix date/time format and Coordinated
     *         Universal Time (UTC). The start date must be the first value. <code>BETWEEN</code> is supported for
     *         <code>UPDATE_DATE</code>.
     *         </p>
     *         </li>
     * @see FilterCondition
     */
    public final String conditionAsString() {
        return condition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasValues() ? values() : null);
        hashCode = 31 * hashCode + Objects.hashCode(conditionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OperationFilter)) {
            return false;
        }
        OperationFilter other = (OperationFilter) obj;
        return Objects.equals(nameAsString(), other.nameAsString()) && hasValues() == other.hasValues()
                && Objects.equals(values(), other.values()) && Objects.equals(conditionAsString(), other.conditionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OperationFilter").add("Name", nameAsString()).add("Values", hasValues() ? values() : null)
                .add("Condition", conditionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(nameAsString()));
        case "Values":
            return Optional.ofNullable(clazz.cast(values()));
        case "Condition":
            return Optional.ofNullable(clazz.cast(conditionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OperationFilter, T> g) {
        return obj -> g.apply((OperationFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OperationFilter> {
        /**
         * <p>
         * Specify the operations that you want to get:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>NAMESPACE_ID</b>: Gets operations related to specified namespaces.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>SERVICE_ID</b>: Gets operations related to specified services.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>STATUS</b>: Gets operations based on the status of the operations: <code>SUBMITTED</code>,
         * <code>PENDING</code>, <code>SUCCEED</code>, or <code>FAIL</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>TYPE</b>: Gets specified types of operation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>UPDATE_DATE</b>: Gets operations that changed status during a specified date/time range.
         * </p>
         * </li>
         * </ul>
         * 
         * @param name
         *        Specify the operations that you want to get:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>NAMESPACE_ID</b>: Gets operations related to specified namespaces.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>SERVICE_ID</b>: Gets operations related to specified services.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>STATUS</b>: Gets operations based on the status of the operations: <code>SUBMITTED</code>,
         *        <code>PENDING</code>, <code>SUCCEED</code>, or <code>FAIL</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>TYPE</b>: Gets specified types of operation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>UPDATE_DATE</b>: Gets operations that changed status during a specified date/time range.
         *        </p>
         *        </li>
         * @see OperationFilterName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationFilterName
         */
        Builder name(String name);

        /**
         * <p>
         * Specify the operations that you want to get:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>NAMESPACE_ID</b>: Gets operations related to specified namespaces.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>SERVICE_ID</b>: Gets operations related to specified services.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>STATUS</b>: Gets operations based on the status of the operations: <code>SUBMITTED</code>,
         * <code>PENDING</code>, <code>SUCCEED</code>, or <code>FAIL</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>TYPE</b>: Gets specified types of operation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>UPDATE_DATE</b>: Gets operations that changed status during a specified date/time range.
         * </p>
         * </li>
         * </ul>
         * 
         * @param name
         *        Specify the operations that you want to get:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>NAMESPACE_ID</b>: Gets operations related to specified namespaces.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>SERVICE_ID</b>: Gets operations related to specified services.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>STATUS</b>: Gets operations based on the status of the operations: <code>SUBMITTED</code>,
         *        <code>PENDING</code>, <code>SUCCEED</code>, or <code>FAIL</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>TYPE</b>: Gets specified types of operation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>UPDATE_DATE</b>: Gets operations that changed status during a specified date/time range.
         *        </p>
         *        </li>
         * @see OperationFilterName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationFilterName
         */
        Builder name(OperationFilterName name);

        /**
         * <p>
         * Specify values that are applicable to the value that you specify for <code>Name</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>NAMESPACE_ID</b>: Specify one namespace ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>SERVICE_ID</b>: Specify one service ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>STATUS</b>: Specify one or more statuses: <code>SUBMITTED</code>, <code>PENDING</code>,
         * <code>SUCCEED</code>, or <code>FAIL</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>TYPE</b>: Specify one or more of the following types: <code>CREATE_NAMESPACE</code>,
         * <code>DELETE_NAMESPACE</code>, <code>UPDATE_SERVICE</code>, <code>REGISTER_INSTANCE</code>, or
         * <code>DEREGISTER_INSTANCE</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>UPDATE_DATE</b>: Specify a start date and an end date in Unix date/time format and Coordinated Universal
         * Time (UTC). The start date must be the first value.
         * </p>
         * </li>
         * </ul>
         * 
         * @param values
         *        Specify values that are applicable to the value that you specify for <code>Name</code>: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>NAMESPACE_ID</b>: Specify one namespace ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>SERVICE_ID</b>: Specify one service ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>STATUS</b>: Specify one or more statuses: <code>SUBMITTED</code>, <code>PENDING</code>,
         *        <code>SUCCEED</code>, or <code>FAIL</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>TYPE</b>: Specify one or more of the following types: <code>CREATE_NAMESPACE</code>,
         *        <code>DELETE_NAMESPACE</code>, <code>UPDATE_SERVICE</code>, <code>REGISTER_INSTANCE</code>, or
         *        <code>DEREGISTER_INSTANCE</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>UPDATE_DATE</b>: Specify a start date and an end date in Unix date/time format and Coordinated
         *        Universal Time (UTC). The start date must be the first value.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Collection<String> values);

        /**
         * <p>
         * Specify values that are applicable to the value that you specify for <code>Name</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>NAMESPACE_ID</b>: Specify one namespace ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>SERVICE_ID</b>: Specify one service ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>STATUS</b>: Specify one or more statuses: <code>SUBMITTED</code>, <code>PENDING</code>,
         * <code>SUCCEED</code>, or <code>FAIL</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>TYPE</b>: Specify one or more of the following types: <code>CREATE_NAMESPACE</code>,
         * <code>DELETE_NAMESPACE</code>, <code>UPDATE_SERVICE</code>, <code>REGISTER_INSTANCE</code>, or
         * <code>DEREGISTER_INSTANCE</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>UPDATE_DATE</b>: Specify a start date and an end date in Unix date/time format and Coordinated Universal
         * Time (UTC). The start date must be the first value.
         * </p>
         * </li>
         * </ul>
         * 
         * @param values
         *        Specify values that are applicable to the value that you specify for <code>Name</code>: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>NAMESPACE_ID</b>: Specify one namespace ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>SERVICE_ID</b>: Specify one service ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>STATUS</b>: Specify one or more statuses: <code>SUBMITTED</code>, <code>PENDING</code>,
         *        <code>SUCCEED</code>, or <code>FAIL</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>TYPE</b>: Specify one or more of the following types: <code>CREATE_NAMESPACE</code>,
         *        <code>DELETE_NAMESPACE</code>, <code>UPDATE_SERVICE</code>, <code>REGISTER_INSTANCE</code>, or
         *        <code>DEREGISTER_INSTANCE</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>UPDATE_DATE</b>: Specify a start date and an end date in Unix date/time format and Coordinated
         *        Universal Time (UTC). The start date must be the first value.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(String... values);

        /**
         * <p>
         * The operator that you want to use to determine whether an operation matches the specified value. Valid values
         * for condition include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>EQ</code>: When you specify <code>EQ</code> for the condition, you can specify only one value.
         * <code>EQ</code> is supported for <code>NAMESPACE_ID</code>, <code>SERVICE_ID</code>, <code>STATUS</code>, and
         * <code>TYPE</code>. <code>EQ</code> is the default condition and can be omitted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IN</code>: When you specify <code>IN</code> for the condition, you can specify a list of one or more
         * values. <code>IN</code> is supported for <code>STATUS</code> and <code>TYPE</code>. An operation must match
         * one of the specified values to be returned in the response.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>BETWEEN</code>: Specify a start date and an end date in Unix date/time format and Coordinated Universal
         * Time (UTC). The start date must be the first value. <code>BETWEEN</code> is supported for
         * <code>UPDATE_DATE</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param condition
         *        The operator that you want to use to determine whether an operation matches the specified value. Valid
         *        values for condition include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>EQ</code>: When you specify <code>EQ</code> for the condition, you can specify only one value.
         *        <code>EQ</code> is supported for <code>NAMESPACE_ID</code>, <code>SERVICE_ID</code>,
         *        <code>STATUS</code>, and <code>TYPE</code>. <code>EQ</code> is the default condition and can be
         *        omitted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IN</code>: When you specify <code>IN</code> for the condition, you can specify a list of one or
         *        more values. <code>IN</code> is supported for <code>STATUS</code> and <code>TYPE</code>. An operation
         *        must match one of the specified values to be returned in the response.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>BETWEEN</code>: Specify a start date and an end date in Unix date/time format and Coordinated
         *        Universal Time (UTC). The start date must be the first value. <code>BETWEEN</code> is supported for
         *        <code>UPDATE_DATE</code>.
         *        </p>
         *        </li>
         * @see FilterCondition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FilterCondition
         */
        Builder condition(String condition);

        /**
         * <p>
         * The operator that you want to use to determine whether an operation matches the specified value. Valid values
         * for condition include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>EQ</code>: When you specify <code>EQ</code> for the condition, you can specify only one value.
         * <code>EQ</code> is supported for <code>NAMESPACE_ID</code>, <code>SERVICE_ID</code>, <code>STATUS</code>, and
         * <code>TYPE</code>. <code>EQ</code> is the default condition and can be omitted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IN</code>: When you specify <code>IN</code> for the condition, you can specify a list of one or more
         * values. <code>IN</code> is supported for <code>STATUS</code> and <code>TYPE</code>. An operation must match
         * one of the specified values to be returned in the response.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>BETWEEN</code>: Specify a start date and an end date in Unix date/time format and Coordinated Universal
         * Time (UTC). The start date must be the first value. <code>BETWEEN</code> is supported for
         * <code>UPDATE_DATE</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param condition
         *        The operator that you want to use to determine whether an operation matches the specified value. Valid
         *        values for condition include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>EQ</code>: When you specify <code>EQ</code> for the condition, you can specify only one value.
         *        <code>EQ</code> is supported for <code>NAMESPACE_ID</code>, <code>SERVICE_ID</code>,
         *        <code>STATUS</code>, and <code>TYPE</code>. <code>EQ</code> is the default condition and can be
         *        omitted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IN</code>: When you specify <code>IN</code> for the condition, you can specify a list of one or
         *        more values. <code>IN</code> is supported for <code>STATUS</code> and <code>TYPE</code>. An operation
         *        must match one of the specified values to be returned in the response.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>BETWEEN</code>: Specify a start date and an end date in Unix date/time format and Coordinated
         *        Universal Time (UTC). The start date must be the first value. <code>BETWEEN</code> is supported for
         *        <code>UPDATE_DATE</code>.
         *        </p>
         *        </li>
         * @see FilterCondition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FilterCondition
         */
        Builder condition(FilterCondition condition);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private List<String> values = DefaultSdkAutoConstructList.getInstance();

        private String condition;

        private BuilderImpl() {
        }

        private BuilderImpl(OperationFilter model) {
            name(model.name);
            values(model.values);
            condition(model.condition);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(OperationFilterName name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<String> getValues() {
            if (values instanceof SdkAutoConstructList) {
                return null;
            }
            return values;
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = FilterValuesCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String... values) {
            values(Arrays.asList(values));
            return this;
        }

        public final void setValues(Collection<String> values) {
            this.values = FilterValuesCopier.copy(values);
        }

        public final String getCondition() {
            return condition;
        }

        @Override
        public final Builder condition(String condition) {
            this.condition = condition;
            return this;
        }

        @Override
        public final Builder condition(FilterCondition condition) {
            this.condition(condition == null ? null : condition.toString());
            return this;
        }

        public final void setCondition(String condition) {
            this.condition = condition;
        }

        @Override
        public OperationFilter build() {
            return new OperationFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
