/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * DNS properties for the private DNS namespace.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PrivateDnsPropertiesMutable implements SdkPojo, Serializable,
        ToCopyableBuilder<PrivateDnsPropertiesMutable.Builder, PrivateDnsPropertiesMutable> {
    private static final SdkField<SOA> SOA_FIELD = SdkField.<SOA> builder(MarshallingType.SDK_POJO).memberName("SOA")
            .getter(getter(PrivateDnsPropertiesMutable::soa)).setter(setter(Builder::soa)).constructor(SOA::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SOA").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOA_FIELD));

    private static final long serialVersionUID = 1L;

    private final SOA soa;

    private PrivateDnsPropertiesMutable(BuilderImpl builder) {
        this.soa = builder.soa;
    }

    /**
     * <p>
     * Fields for the Start of Authority (SOA) record for the hosted zone for the private DNS namespace.
     * </p>
     * 
     * @return Fields for the Start of Authority (SOA) record for the hosted zone for the private DNS namespace.
     */
    public final SOA soa() {
        return soa;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(soa());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrivateDnsPropertiesMutable)) {
            return false;
        }
        PrivateDnsPropertiesMutable other = (PrivateDnsPropertiesMutable) obj;
        return Objects.equals(soa(), other.soa());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PrivateDnsPropertiesMutable").add("SOA", soa()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SOA":
            return Optional.ofNullable(clazz.cast(soa()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PrivateDnsPropertiesMutable, T> g) {
        return obj -> g.apply((PrivateDnsPropertiesMutable) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PrivateDnsPropertiesMutable> {
        /**
         * <p>
         * Fields for the Start of Authority (SOA) record for the hosted zone for the private DNS namespace.
         * </p>
         * 
         * @param soa
         *        Fields for the Start of Authority (SOA) record for the hosted zone for the private DNS namespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder soa(SOA soa);

        /**
         * <p>
         * Fields for the Start of Authority (SOA) record for the hosted zone for the private DNS namespace.
         * </p>
         * This is a convenience that creates an instance of the {@link SOA.Builder} avoiding the need to create one
         * manually via {@link SOA#builder()}.
         *
         * When the {@link Consumer} completes, {@link SOA.Builder#build()} is called immediately and its result is
         * passed to {@link #soa(SOA)}.
         * 
         * @param soa
         *        a consumer that will call methods on {@link SOA.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #soa(SOA)
         */
        default Builder soa(Consumer<SOA.Builder> soa) {
            return soa(SOA.builder().applyMutation(soa).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SOA soa;

        private BuilderImpl() {
        }

        private BuilderImpl(PrivateDnsPropertiesMutable model) {
            soa(model.soa);
        }

        public final SOA.Builder getSoa() {
            return soa != null ? soa.toBuilder() : null;
        }

        @Override
        public final Builder soa(SOA soa) {
            this.soa = soa;
            return this;
        }

        public final void setSoa(SOA.BuilderImpl soa) {
            this.soa = soa != null ? soa.build() : null;
        }

        @Override
        public PrivateDnsPropertiesMutable build() {
            return new PrivateDnsPropertiesMutable(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
