/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Updated properties for the public DNS namespace.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PublicDnsNamespaceChange implements SdkPojo, Serializable,
        ToCopyableBuilder<PublicDnsNamespaceChange.Builder, PublicDnsNamespaceChange> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(PublicDnsNamespaceChange::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<PublicDnsNamespacePropertiesChange> PROPERTIES_FIELD = SdkField
            .<PublicDnsNamespacePropertiesChange> builder(MarshallingType.SDK_POJO).memberName("Properties")
            .getter(getter(PublicDnsNamespaceChange::properties)).setter(setter(Builder::properties))
            .constructor(PublicDnsNamespacePropertiesChange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Properties").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            PROPERTIES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String description;

    private final PublicDnsNamespacePropertiesChange properties;

    private PublicDnsNamespaceChange(BuilderImpl builder) {
        this.description = builder.description;
        this.properties = builder.properties;
    }

    /**
     * <p>
     * An updated description for the public DNS namespace.
     * </p>
     * 
     * @return An updated description for the public DNS namespace.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Properties to be updated in the public DNS namespace.
     * </p>
     * 
     * @return Properties to be updated in the public DNS namespace.
     */
    public final PublicDnsNamespacePropertiesChange properties() {
        return properties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(properties());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PublicDnsNamespaceChange)) {
            return false;
        }
        PublicDnsNamespaceChange other = (PublicDnsNamespaceChange) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(properties(), other.properties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PublicDnsNamespaceChange").add("Description", description()).add("Properties", properties())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Properties":
            return Optional.ofNullable(clazz.cast(properties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PublicDnsNamespaceChange, T> g) {
        return obj -> g.apply((PublicDnsNamespaceChange) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PublicDnsNamespaceChange> {
        /**
         * <p>
         * An updated description for the public DNS namespace.
         * </p>
         * 
         * @param description
         *        An updated description for the public DNS namespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Properties to be updated in the public DNS namespace.
         * </p>
         * 
         * @param properties
         *        Properties to be updated in the public DNS namespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder properties(PublicDnsNamespacePropertiesChange properties);

        /**
         * <p>
         * Properties to be updated in the public DNS namespace.
         * </p>
         * This is a convenience that creates an instance of the {@link PublicDnsNamespacePropertiesChange.Builder}
         * avoiding the need to create one manually via {@link PublicDnsNamespacePropertiesChange#builder()}.
         *
         * When the {@link Consumer} completes, {@link PublicDnsNamespacePropertiesChange.Builder#build()} is called
         * immediately and its result is passed to {@link #properties(PublicDnsNamespacePropertiesChange)}.
         * 
         * @param properties
         *        a consumer that will call methods on {@link PublicDnsNamespacePropertiesChange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #properties(PublicDnsNamespacePropertiesChange)
         */
        default Builder properties(Consumer<PublicDnsNamespacePropertiesChange.Builder> properties) {
            return properties(PublicDnsNamespacePropertiesChange.builder().applyMutation(properties).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String description;

        private PublicDnsNamespacePropertiesChange properties;

        private BuilderImpl() {
        }

        private BuilderImpl(PublicDnsNamespaceChange model) {
            description(model.description);
            properties(model.properties);
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final PublicDnsNamespacePropertiesChange.Builder getProperties() {
            return properties != null ? properties.toBuilder() : null;
        }

        @Override
        public final Builder properties(PublicDnsNamespacePropertiesChange properties) {
            this.properties = properties;
            return this;
        }

        public final void setProperties(PublicDnsNamespacePropertiesChange.BuilderImpl properties) {
            this.properties = properties != null ? properties.build() : null;
        }

        @Override
        public PublicDnsNamespaceChange build() {
            return new PublicDnsNamespaceChange(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
