/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdatePublicDnsNamespaceRequest extends ServiceDiscoveryRequest implements
        ToCopyableBuilder<UpdatePublicDnsNamespaceRequest.Builder, UpdatePublicDnsNamespaceRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(UpdatePublicDnsNamespaceRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> UPDATER_REQUEST_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("UpdaterRequestId")
            .getter(getter(UpdatePublicDnsNamespaceRequest::updaterRequestId))
            .setter(setter(Builder::updaterRequestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdaterRequestId").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<PublicDnsNamespaceChange> NAMESPACE_FIELD = SdkField
            .<PublicDnsNamespaceChange> builder(MarshallingType.SDK_POJO).memberName("Namespace")
            .getter(getter(UpdatePublicDnsNamespaceRequest::namespace)).setter(setter(Builder::namespace))
            .constructor(PublicDnsNamespaceChange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Namespace").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            UPDATER_REQUEST_ID_FIELD, NAMESPACE_FIELD));

    private final String id;

    private final String updaterRequestId;

    private final PublicDnsNamespaceChange namespace;

    private UpdatePublicDnsNamespaceRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.updaterRequestId = builder.updaterRequestId;
        this.namespace = builder.namespace;
    }

    /**
     * <p>
     * The ID of the namespace being updated.
     * </p>
     * 
     * @return The ID of the namespace being updated.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * A unique string that identifies the request and that allows failed <code>UpdatePublicDnsNamespace</code> requests
     * to be retried without the risk of running the operation twice. <code>UpdaterRequestId</code> can be any unique
     * string (for example, a date/timestamp).
     * </p>
     * 
     * @return A unique string that identifies the request and that allows failed <code>UpdatePublicDnsNamespace</code>
     *         requests to be retried without the risk of running the operation twice. <code>UpdaterRequestId</code> can
     *         be any unique string (for example, a date/timestamp).
     */
    public final String updaterRequestId() {
        return updaterRequestId;
    }

    /**
     * <p>
     * Updated properties for the public DNS namespace.
     * </p>
     * 
     * @return Updated properties for the public DNS namespace.
     */
    public final PublicDnsNamespaceChange namespace() {
        return namespace;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(updaterRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePublicDnsNamespaceRequest)) {
            return false;
        }
        UpdatePublicDnsNamespaceRequest other = (UpdatePublicDnsNamespaceRequest) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(updaterRequestId(), other.updaterRequestId())
                && Objects.equals(namespace(), other.namespace());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdatePublicDnsNamespaceRequest").add("Id", id()).add("UpdaterRequestId", updaterRequestId())
                .add("Namespace", namespace()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "UpdaterRequestId":
            return Optional.ofNullable(clazz.cast(updaterRequestId()));
        case "Namespace":
            return Optional.ofNullable(clazz.cast(namespace()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdatePublicDnsNamespaceRequest, T> g) {
        return obj -> g.apply((UpdatePublicDnsNamespaceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceDiscoveryRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdatePublicDnsNamespaceRequest> {
        /**
         * <p>
         * The ID of the namespace being updated.
         * </p>
         * 
         * @param id
         *        The ID of the namespace being updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * A unique string that identifies the request and that allows failed <code>UpdatePublicDnsNamespace</code>
         * requests to be retried without the risk of running the operation twice. <code>UpdaterRequestId</code> can be
         * any unique string (for example, a date/timestamp).
         * </p>
         * 
         * @param updaterRequestId
         *        A unique string that identifies the request and that allows failed
         *        <code>UpdatePublicDnsNamespace</code> requests to be retried without the risk of running the operation
         *        twice. <code>UpdaterRequestId</code> can be any unique string (for example, a date/timestamp).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updaterRequestId(String updaterRequestId);

        /**
         * <p>
         * Updated properties for the public DNS namespace.
         * </p>
         * 
         * @param namespace
         *        Updated properties for the public DNS namespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(PublicDnsNamespaceChange namespace);

        /**
         * <p>
         * Updated properties for the public DNS namespace.
         * </p>
         * This is a convenience that creates an instance of the {@link PublicDnsNamespaceChange.Builder} avoiding the
         * need to create one manually via {@link PublicDnsNamespaceChange#builder()}.
         *
         * When the {@link Consumer} completes, {@link PublicDnsNamespaceChange.Builder#build()} is called immediately
         * and its result is passed to {@link #namespace(PublicDnsNamespaceChange)}.
         * 
         * @param namespace
         *        a consumer that will call methods on {@link PublicDnsNamespaceChange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #namespace(PublicDnsNamespaceChange)
         */
        default Builder namespace(Consumer<PublicDnsNamespaceChange.Builder> namespace) {
            return namespace(PublicDnsNamespaceChange.builder().applyMutation(namespace).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ServiceDiscoveryRequest.BuilderImpl implements Builder {
        private String id;

        private String updaterRequestId;

        private PublicDnsNamespaceChange namespace;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePublicDnsNamespaceRequest model) {
            super(model);
            id(model.id);
            updaterRequestId(model.updaterRequestId);
            namespace(model.namespace);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getUpdaterRequestId() {
            return updaterRequestId;
        }

        @Override
        public final Builder updaterRequestId(String updaterRequestId) {
            this.updaterRequestId = updaterRequestId;
            return this;
        }

        public final void setUpdaterRequestId(String updaterRequestId) {
            this.updaterRequestId = updaterRequestId;
        }

        public final PublicDnsNamespaceChange.Builder getNamespace() {
            return namespace != null ? namespace.toBuilder() : null;
        }

        @Override
        public final Builder namespace(PublicDnsNamespaceChange namespace) {
            this.namespace = namespace;
            return this;
        }

        public final void setNamespace(PublicDnsNamespaceChange.BuilderImpl namespace) {
            this.namespace = namespace != null ? namespace.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePublicDnsNamespaceRequest build() {
            return new UpdatePublicDnsNamespaceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
