/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains the ID for the Route 53 hosted zone that Cloud Map creates when you create a namespace.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DnsProperties implements SdkPojo, Serializable, ToCopyableBuilder<DnsProperties.Builder, DnsProperties> {
    private static final SdkField<String> HOSTED_ZONE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HostedZoneId").getter(getter(DnsProperties::hostedZoneId)).setter(setter(Builder::hostedZoneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostedZoneId").build()).build();

    private static final SdkField<SOA> SOA_FIELD = SdkField.<SOA> builder(MarshallingType.SDK_POJO).memberName("SOA")
            .getter(getter(DnsProperties::soa)).setter(setter(Builder::soa)).constructor(SOA::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SOA").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOSTED_ZONE_ID_FIELD,
            SOA_FIELD));

    private static final long serialVersionUID = 1L;

    private final String hostedZoneId;

    private final SOA soa;

    private DnsProperties(BuilderImpl builder) {
        this.hostedZoneId = builder.hostedZoneId;
        this.soa = builder.soa;
    }

    /**
     * <p>
     * The ID for the Route 53 hosted zone that Cloud Map creates when you create a namespace.
     * </p>
     * 
     * @return The ID for the Route 53 hosted zone that Cloud Map creates when you create a namespace.
     */
    public final String hostedZoneId() {
        return hostedZoneId;
    }

    /**
     * <p>
     * Start of Authority (SOA) record for the hosted zone.
     * </p>
     * 
     * @return Start of Authority (SOA) record for the hosted zone.
     */
    public final SOA soa() {
        return soa;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hostedZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(soa());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DnsProperties)) {
            return false;
        }
        DnsProperties other = (DnsProperties) obj;
        return Objects.equals(hostedZoneId(), other.hostedZoneId()) && Objects.equals(soa(), other.soa());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DnsProperties").add("HostedZoneId", hostedZoneId()).add("SOA", soa()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HostedZoneId":
            return Optional.ofNullable(clazz.cast(hostedZoneId()));
        case "SOA":
            return Optional.ofNullable(clazz.cast(soa()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DnsProperties, T> g) {
        return obj -> g.apply((DnsProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DnsProperties> {
        /**
         * <p>
         * The ID for the Route 53 hosted zone that Cloud Map creates when you create a namespace.
         * </p>
         * 
         * @param hostedZoneId
         *        The ID for the Route 53 hosted zone that Cloud Map creates when you create a namespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostedZoneId(String hostedZoneId);

        /**
         * <p>
         * Start of Authority (SOA) record for the hosted zone.
         * </p>
         * 
         * @param soa
         *        Start of Authority (SOA) record for the hosted zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder soa(SOA soa);

        /**
         * <p>
         * Start of Authority (SOA) record for the hosted zone.
         * </p>
         * This is a convenience method that creates an instance of the {@link SOA.Builder} avoiding the need to create
         * one manually via {@link SOA#builder()}.
         *
         * When the {@link Consumer} completes, {@link SOA.Builder#build()} is called immediately and its result is
         * passed to {@link #soa(SOA)}.
         * 
         * @param soa
         *        a consumer that will call methods on {@link SOA.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #soa(SOA)
         */
        default Builder soa(Consumer<SOA.Builder> soa) {
            return soa(SOA.builder().applyMutation(soa).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String hostedZoneId;

        private SOA soa;

        private BuilderImpl() {
        }

        private BuilderImpl(DnsProperties model) {
            hostedZoneId(model.hostedZoneId);
            soa(model.soa);
        }

        public final String getHostedZoneId() {
            return hostedZoneId;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final SOA.Builder getSoa() {
            return soa != null ? soa.toBuilder() : null;
        }

        public final void setSoa(SOA.BuilderImpl soa) {
            this.soa = soa != null ? soa.build() : null;
        }

        @Override
        public final Builder soa(SOA soa) {
            this.soa = soa;
            return this;
        }

        @Override
        public DnsProperties build() {
            return new DnsProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
