/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains information about a specified namespace.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Namespace implements SdkPojo, Serializable, ToCopyableBuilder<Namespace.Builder, Namespace> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(Namespace::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(Namespace::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Namespace::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(Namespace::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(Namespace::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Integer> SERVICE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ServiceCount").getter(getter(Namespace::serviceCount)).setter(setter(Builder::serviceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceCount").build()).build();

    private static final SdkField<NamespaceProperties> PROPERTIES_FIELD = SdkField
            .<NamespaceProperties> builder(MarshallingType.SDK_POJO).memberName("Properties")
            .getter(getter(Namespace::properties)).setter(setter(Builder::properties)).constructor(NamespaceProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Properties").build()).build();

    private static final SdkField<Instant> CREATE_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreateDate").getter(getter(Namespace::createDate)).setter(setter(Builder::createDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateDate").build()).build();

    private static final SdkField<String> CREATOR_REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatorRequestId").getter(getter(Namespace::creatorRequestId)).setter(setter(Builder::creatorRequestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatorRequestId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD,
            NAME_FIELD, TYPE_FIELD, DESCRIPTION_FIELD, SERVICE_COUNT_FIELD, PROPERTIES_FIELD, CREATE_DATE_FIELD,
            CREATOR_REQUEST_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String arn;

    private final String name;

    private final String type;

    private final String description;

    private final Integer serviceCount;

    private final NamespaceProperties properties;

    private final Instant createDate;

    private final String creatorRequestId;

    private Namespace(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.name = builder.name;
        this.type = builder.type;
        this.description = builder.description;
        this.serviceCount = builder.serviceCount;
        this.properties = builder.properties;
        this.createDate = builder.createDate;
        this.creatorRequestId = builder.creatorRequestId;
    }

    /**
     * <p>
     * The ID of a namespace.
     * </p>
     * 
     * @return The ID of a namespace.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that Cloud Map assigns to the namespace when you create it.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that Cloud Map assigns to the namespace when you create it.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the namespace, such as <code>example.com</code>.
     * </p>
     * 
     * @return The name of the namespace, such as <code>example.com</code>.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The type of the namespace. The methods for discovering instances depends on the value that you specify:
     * </p>
     * <dl>
     * <dt>HTTP</dt>
     * <dd>
     * <p>
     * Instances can be discovered only programmatically, using the Cloud Map <code>DiscoverInstances</code> API.
     * </p>
     * </dd>
     * <dt>DNS_PUBLIC</dt>
     * <dd>
     * <p>
     * Instances can be discovered using public DNS queries and using the <code>DiscoverInstances</code> API.
     * </p>
     * </dd>
     * <dt>DNS_PRIVATE</dt>
     * <dd>
     * <p>
     * Instances can be discovered using DNS queries in VPCs and using the <code>DiscoverInstances</code> API.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link NamespaceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the namespace. The methods for discovering instances depends on the value that you
     *         specify:</p>
     *         <dl>
     *         <dt>HTTP</dt>
     *         <dd>
     *         <p>
     *         Instances can be discovered only programmatically, using the Cloud Map <code>DiscoverInstances</code>
     *         API.
     *         </p>
     *         </dd>
     *         <dt>DNS_PUBLIC</dt>
     *         <dd>
     *         <p>
     *         Instances can be discovered using public DNS queries and using the <code>DiscoverInstances</code> API.
     *         </p>
     *         </dd>
     *         <dt>DNS_PRIVATE</dt>
     *         <dd>
     *         <p>
     *         Instances can be discovered using DNS queries in VPCs and using the <code>DiscoverInstances</code> API.
     *         </p>
     *         </dd>
     * @see NamespaceType
     */
    public final NamespaceType type() {
        return NamespaceType.fromValue(type);
    }

    /**
     * <p>
     * The type of the namespace. The methods for discovering instances depends on the value that you specify:
     * </p>
     * <dl>
     * <dt>HTTP</dt>
     * <dd>
     * <p>
     * Instances can be discovered only programmatically, using the Cloud Map <code>DiscoverInstances</code> API.
     * </p>
     * </dd>
     * <dt>DNS_PUBLIC</dt>
     * <dd>
     * <p>
     * Instances can be discovered using public DNS queries and using the <code>DiscoverInstances</code> API.
     * </p>
     * </dd>
     * <dt>DNS_PRIVATE</dt>
     * <dd>
     * <p>
     * Instances can be discovered using DNS queries in VPCs and using the <code>DiscoverInstances</code> API.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link NamespaceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the namespace. The methods for discovering instances depends on the value that you
     *         specify:</p>
     *         <dl>
     *         <dt>HTTP</dt>
     *         <dd>
     *         <p>
     *         Instances can be discovered only programmatically, using the Cloud Map <code>DiscoverInstances</code>
     *         API.
     *         </p>
     *         </dd>
     *         <dt>DNS_PUBLIC</dt>
     *         <dd>
     *         <p>
     *         Instances can be discovered using public DNS queries and using the <code>DiscoverInstances</code> API.
     *         </p>
     *         </dd>
     *         <dt>DNS_PRIVATE</dt>
     *         <dd>
     *         <p>
     *         Instances can be discovered using DNS queries in VPCs and using the <code>DiscoverInstances</code> API.
     *         </p>
     *         </dd>
     * @see NamespaceType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The description that you specify for the namespace when you create it.
     * </p>
     * 
     * @return The description that you specify for the namespace when you create it.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The number of services that are associated with the namespace.
     * </p>
     * 
     * @return The number of services that are associated with the namespace.
     */
    public final Integer serviceCount() {
        return serviceCount;
    }

    /**
     * <p>
     * A complex type that contains information that's specific to the type of the namespace.
     * </p>
     * 
     * @return A complex type that contains information that's specific to the type of the namespace.
     */
    public final NamespaceProperties properties() {
        return properties;
    }

    /**
     * <p>
     * The date that the namespace was created, in Unix date/time format and Coordinated Universal Time (UTC). The value
     * of <code>CreateDate</code> is accurate to milliseconds. For example, the value <code>1516925490.087</code>
     * represents Friday, January 26, 2018 12:11:30.087 AM.
     * </p>
     * 
     * @return The date that the namespace was created, in Unix date/time format and Coordinated Universal Time (UTC).
     *         The value of <code>CreateDate</code> is accurate to milliseconds. For example, the value
     *         <code>1516925490.087</code> represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public final Instant createDate() {
        return createDate;
    }

    /**
     * <p>
     * A unique string that identifies the request and that allows failed requests to be retried without the risk of
     * running an operation twice.
     * </p>
     * 
     * @return A unique string that identifies the request and that allows failed requests to be retried without the
     *         risk of running an operation twice.
     */
    public final String creatorRequestId() {
        return creatorRequestId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(serviceCount());
        hashCode = 31 * hashCode + Objects.hashCode(properties());
        hashCode = 31 * hashCode + Objects.hashCode(createDate());
        hashCode = 31 * hashCode + Objects.hashCode(creatorRequestId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Namespace)) {
            return false;
        }
        Namespace other = (Namespace) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(description(), other.description())
                && Objects.equals(serviceCount(), other.serviceCount()) && Objects.equals(properties(), other.properties())
                && Objects.equals(createDate(), other.createDate())
                && Objects.equals(creatorRequestId(), other.creatorRequestId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Namespace").add("Id", id()).add("Arn", arn()).add("Name", name()).add("Type", typeAsString())
                .add("Description", description()).add("ServiceCount", serviceCount()).add("Properties", properties())
                .add("CreateDate", createDate()).add("CreatorRequestId", creatorRequestId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ServiceCount":
            return Optional.ofNullable(clazz.cast(serviceCount()));
        case "Properties":
            return Optional.ofNullable(clazz.cast(properties()));
        case "CreateDate":
            return Optional.ofNullable(clazz.cast(createDate()));
        case "CreatorRequestId":
            return Optional.ofNullable(clazz.cast(creatorRequestId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Namespace, T> g) {
        return obj -> g.apply((Namespace) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Namespace> {
        /**
         * <p>
         * The ID of a namespace.
         * </p>
         * 
         * @param id
         *        The ID of a namespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The Amazon Resource Name (ARN) that Cloud Map assigns to the namespace when you create it.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) that Cloud Map assigns to the namespace when you create it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the namespace, such as <code>example.com</code>.
         * </p>
         * 
         * @param name
         *        The name of the namespace, such as <code>example.com</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The type of the namespace. The methods for discovering instances depends on the value that you specify:
         * </p>
         * <dl>
         * <dt>HTTP</dt>
         * <dd>
         * <p>
         * Instances can be discovered only programmatically, using the Cloud Map <code>DiscoverInstances</code> API.
         * </p>
         * </dd>
         * <dt>DNS_PUBLIC</dt>
         * <dd>
         * <p>
         * Instances can be discovered using public DNS queries and using the <code>DiscoverInstances</code> API.
         * </p>
         * </dd>
         * <dt>DNS_PRIVATE</dt>
         * <dd>
         * <p>
         * Instances can be discovered using DNS queries in VPCs and using the <code>DiscoverInstances</code> API.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param type
         *        The type of the namespace. The methods for discovering instances depends on the value that you
         *        specify:</p>
         *        <dl>
         *        <dt>HTTP</dt>
         *        <dd>
         *        <p>
         *        Instances can be discovered only programmatically, using the Cloud Map <code>DiscoverInstances</code>
         *        API.
         *        </p>
         *        </dd>
         *        <dt>DNS_PUBLIC</dt>
         *        <dd>
         *        <p>
         *        Instances can be discovered using public DNS queries and using the <code>DiscoverInstances</code> API.
         *        </p>
         *        </dd>
         *        <dt>DNS_PRIVATE</dt>
         *        <dd>
         *        <p>
         *        Instances can be discovered using DNS queries in VPCs and using the <code>DiscoverInstances</code>
         *        API.
         *        </p>
         *        </dd>
         * @see NamespaceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NamespaceType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the namespace. The methods for discovering instances depends on the value that you specify:
         * </p>
         * <dl>
         * <dt>HTTP</dt>
         * <dd>
         * <p>
         * Instances can be discovered only programmatically, using the Cloud Map <code>DiscoverInstances</code> API.
         * </p>
         * </dd>
         * <dt>DNS_PUBLIC</dt>
         * <dd>
         * <p>
         * Instances can be discovered using public DNS queries and using the <code>DiscoverInstances</code> API.
         * </p>
         * </dd>
         * <dt>DNS_PRIVATE</dt>
         * <dd>
         * <p>
         * Instances can be discovered using DNS queries in VPCs and using the <code>DiscoverInstances</code> API.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param type
         *        The type of the namespace. The methods for discovering instances depends on the value that you
         *        specify:</p>
         *        <dl>
         *        <dt>HTTP</dt>
         *        <dd>
         *        <p>
         *        Instances can be discovered only programmatically, using the Cloud Map <code>DiscoverInstances</code>
         *        API.
         *        </p>
         *        </dd>
         *        <dt>DNS_PUBLIC</dt>
         *        <dd>
         *        <p>
         *        Instances can be discovered using public DNS queries and using the <code>DiscoverInstances</code> API.
         *        </p>
         *        </dd>
         *        <dt>DNS_PRIVATE</dt>
         *        <dd>
         *        <p>
         *        Instances can be discovered using DNS queries in VPCs and using the <code>DiscoverInstances</code>
         *        API.
         *        </p>
         *        </dd>
         * @see NamespaceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NamespaceType
         */
        Builder type(NamespaceType type);

        /**
         * <p>
         * The description that you specify for the namespace when you create it.
         * </p>
         * 
         * @param description
         *        The description that you specify for the namespace when you create it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The number of services that are associated with the namespace.
         * </p>
         * 
         * @param serviceCount
         *        The number of services that are associated with the namespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceCount(Integer serviceCount);

        /**
         * <p>
         * A complex type that contains information that's specific to the type of the namespace.
         * </p>
         * 
         * @param properties
         *        A complex type that contains information that's specific to the type of the namespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder properties(NamespaceProperties properties);

        /**
         * <p>
         * A complex type that contains information that's specific to the type of the namespace.
         * </p>
         * This is a convenience method that creates an instance of the {@link NamespaceProperties.Builder} avoiding the
         * need to create one manually via {@link NamespaceProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link NamespaceProperties.Builder#build()} is called immediately and
         * its result is passed to {@link #properties(NamespaceProperties)}.
         * 
         * @param properties
         *        a consumer that will call methods on {@link NamespaceProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #properties(NamespaceProperties)
         */
        default Builder properties(Consumer<NamespaceProperties.Builder> properties) {
            return properties(NamespaceProperties.builder().applyMutation(properties).build());
        }

        /**
         * <p>
         * The date that the namespace was created, in Unix date/time format and Coordinated Universal Time (UTC). The
         * value of <code>CreateDate</code> is accurate to milliseconds. For example, the value
         * <code>1516925490.087</code> represents Friday, January 26, 2018 12:11:30.087 AM.
         * </p>
         * 
         * @param createDate
         *        The date that the namespace was created, in Unix date/time format and Coordinated Universal Time
         *        (UTC). The value of <code>CreateDate</code> is accurate to milliseconds. For example, the value
         *        <code>1516925490.087</code> represents Friday, January 26, 2018 12:11:30.087 AM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createDate(Instant createDate);

        /**
         * <p>
         * A unique string that identifies the request and that allows failed requests to be retried without the risk of
         * running an operation twice.
         * </p>
         * 
         * @param creatorRequestId
         *        A unique string that identifies the request and that allows failed requests to be retried without the
         *        risk of running an operation twice.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creatorRequestId(String creatorRequestId);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String name;

        private String type;

        private String description;

        private Integer serviceCount;

        private NamespaceProperties properties;

        private Instant createDate;

        private String creatorRequestId;

        private BuilderImpl() {
        }

        private BuilderImpl(Namespace model) {
            id(model.id);
            arn(model.arn);
            name(model.name);
            type(model.type);
            description(model.description);
            serviceCount(model.serviceCount);
            properties(model.properties);
            createDate(model.createDate);
            creatorRequestId(model.creatorRequestId);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(NamespaceType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Integer getServiceCount() {
            return serviceCount;
        }

        public final void setServiceCount(Integer serviceCount) {
            this.serviceCount = serviceCount;
        }

        @Override
        public final Builder serviceCount(Integer serviceCount) {
            this.serviceCount = serviceCount;
            return this;
        }

        public final NamespaceProperties.Builder getProperties() {
            return properties != null ? properties.toBuilder() : null;
        }

        public final void setProperties(NamespaceProperties.BuilderImpl properties) {
            this.properties = properties != null ? properties.build() : null;
        }

        @Override
        public final Builder properties(NamespaceProperties properties) {
            this.properties = properties;
            return this;
        }

        public final Instant getCreateDate() {
            return createDate;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final String getCreatorRequestId() {
            return creatorRequestId;
        }

        public final void setCreatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
        }

        @Override
        public final Builder creatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
            return this;
        }

        @Override
        public Namespace build() {
            return new Namespace(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
