/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DiscoverInstancesResponse extends ServiceDiscoveryResponse implements
        ToCopyableBuilder<DiscoverInstancesResponse.Builder, DiscoverInstancesResponse> {
    private static final SdkField<List<HttpInstanceSummary>> INSTANCES_FIELD = SdkField
            .<List<HttpInstanceSummary>> builder(MarshallingType.LIST)
            .memberName("Instances")
            .getter(getter(DiscoverInstancesResponse::instances))
            .setter(setter(Builder::instances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Instances").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<HttpInstanceSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(HttpInstanceSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCES_FIELD));

    private final List<HttpInstanceSummary> instances;

    private DiscoverInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.instances = builder.instances;
    }

    /**
     * For responses, this returns true if the service returned a value for the Instances property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasInstances() {
        return instances != null && !(instances instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A complex type that contains one <code>HttpInstanceSummary</code> for each registered instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInstances} method.
     * </p>
     * 
     * @return A complex type that contains one <code>HttpInstanceSummary</code> for each registered instance.
     */
    public final List<HttpInstanceSummary> instances() {
        return instances;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasInstances() ? instances() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DiscoverInstancesResponse)) {
            return false;
        }
        DiscoverInstancesResponse other = (DiscoverInstancesResponse) obj;
        return hasInstances() == other.hasInstances() && Objects.equals(instances(), other.instances());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DiscoverInstancesResponse").add("Instances", hasInstances() ? instances() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Instances":
            return Optional.ofNullable(clazz.cast(instances()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DiscoverInstancesResponse, T> g) {
        return obj -> g.apply((DiscoverInstancesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceDiscoveryResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DiscoverInstancesResponse> {
        /**
         * <p>
         * A complex type that contains one <code>HttpInstanceSummary</code> for each registered instance.
         * </p>
         * 
         * @param instances
         *        A complex type that contains one <code>HttpInstanceSummary</code> for each registered instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instances(Collection<HttpInstanceSummary> instances);

        /**
         * <p>
         * A complex type that contains one <code>HttpInstanceSummary</code> for each registered instance.
         * </p>
         * 
         * @param instances
         *        A complex type that contains one <code>HttpInstanceSummary</code> for each registered instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instances(HttpInstanceSummary... instances);

        /**
         * <p>
         * A complex type that contains one <code>HttpInstanceSummary</code> for each registered instance.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<HttpInstanceSummary>.Builder}
         * avoiding the need to create one manually via {@link List<HttpInstanceSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<HttpInstanceSummary>.Builder#build()} is called immediately
         * and its result is passed to {@link #instances(List<HttpInstanceSummary>)}.
         * 
         * @param instances
         *        a consumer that will call methods on {@link List<HttpInstanceSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instances(List<HttpInstanceSummary>)
         */
        Builder instances(Consumer<HttpInstanceSummary.Builder>... instances);
    }

    static final class BuilderImpl extends ServiceDiscoveryResponse.BuilderImpl implements Builder {
        private List<HttpInstanceSummary> instances = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DiscoverInstancesResponse model) {
            super(model);
            instances(model.instances);
        }

        public final List<HttpInstanceSummary.Builder> getInstances() {
            List<HttpInstanceSummary.Builder> result = HttpInstanceSummaryListCopier.copyToBuilder(this.instances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstances(Collection<HttpInstanceSummary.BuilderImpl> instances) {
            this.instances = HttpInstanceSummaryListCopier.copyFromBuilder(instances);
        }

        @Override
        public final Builder instances(Collection<HttpInstanceSummary> instances) {
            this.instances = HttpInstanceSummaryListCopier.copy(instances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(HttpInstanceSummary... instances) {
            instances(Arrays.asList(instances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(Consumer<HttpInstanceSummary.Builder>... instances) {
            instances(Stream.of(instances).map(c -> HttpInstanceSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DiscoverInstancesResponse build() {
            return new DiscoverInstancesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
