/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains information about the specified service.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Service implements SdkPojo, Serializable, ToCopyableBuilder<Service.Builder, Service> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(Service::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(Service::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Service::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> NAMESPACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NamespaceId").getter(getter(Service::namespaceId)).setter(setter(Builder::namespaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NamespaceId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(Service::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Integer> INSTANCE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("InstanceCount").getter(getter(Service::instanceCount)).setter(setter(Builder::instanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCount").build()).build();

    private static final SdkField<DnsConfig> DNS_CONFIG_FIELD = SdkField.<DnsConfig> builder(MarshallingType.SDK_POJO)
            .memberName("DnsConfig").getter(getter(Service::dnsConfig)).setter(setter(Builder::dnsConfig))
            .constructor(DnsConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsConfig").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(Service::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<HealthCheckConfig> HEALTH_CHECK_CONFIG_FIELD = SdkField
            .<HealthCheckConfig> builder(MarshallingType.SDK_POJO).memberName("HealthCheckConfig")
            .getter(getter(Service::healthCheckConfig)).setter(setter(Builder::healthCheckConfig))
            .constructor(HealthCheckConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckConfig").build()).build();

    private static final SdkField<HealthCheckCustomConfig> HEALTH_CHECK_CUSTOM_CONFIG_FIELD = SdkField
            .<HealthCheckCustomConfig> builder(MarshallingType.SDK_POJO).memberName("HealthCheckCustomConfig")
            .getter(getter(Service::healthCheckCustomConfig)).setter(setter(Builder::healthCheckCustomConfig))
            .constructor(HealthCheckCustomConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckCustomConfig").build())
            .build();

    private static final SdkField<Instant> CREATE_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreateDate").getter(getter(Service::createDate)).setter(setter(Builder::createDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateDate").build()).build();

    private static final SdkField<String> CREATOR_REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatorRequestId").getter(getter(Service::creatorRequestId)).setter(setter(Builder::creatorRequestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatorRequestId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD,
            NAME_FIELD, NAMESPACE_ID_FIELD, DESCRIPTION_FIELD, INSTANCE_COUNT_FIELD, DNS_CONFIG_FIELD, TYPE_FIELD,
            HEALTH_CHECK_CONFIG_FIELD, HEALTH_CHECK_CUSTOM_CONFIG_FIELD, CREATE_DATE_FIELD, CREATOR_REQUEST_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String arn;

    private final String name;

    private final String namespaceId;

    private final String description;

    private final Integer instanceCount;

    private final DnsConfig dnsConfig;

    private final String type;

    private final HealthCheckConfig healthCheckConfig;

    private final HealthCheckCustomConfig healthCheckCustomConfig;

    private final Instant createDate;

    private final String creatorRequestId;

    private Service(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.name = builder.name;
        this.namespaceId = builder.namespaceId;
        this.description = builder.description;
        this.instanceCount = builder.instanceCount;
        this.dnsConfig = builder.dnsConfig;
        this.type = builder.type;
        this.healthCheckConfig = builder.healthCheckConfig;
        this.healthCheckCustomConfig = builder.healthCheckCustomConfig;
        this.createDate = builder.createDate;
        this.creatorRequestId = builder.creatorRequestId;
    }

    /**
     * <p>
     * The ID that Cloud Map assigned to the service when you created it.
     * </p>
     * 
     * @return The ID that Cloud Map assigned to the service when you created it.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that Cloud Map assigns to the service when you create it.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that Cloud Map assigns to the service when you create it.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the service.
     * </p>
     * 
     * @return The name of the service.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The ID of the namespace that was used to create the service.
     * </p>
     * 
     * @return The ID of the namespace that was used to create the service.
     */
    public final String namespaceId() {
        return namespaceId;
    }

    /**
     * <p>
     * The description of the service.
     * </p>
     * 
     * @return The description of the service.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The number of instances that are currently associated with the service. Instances that were previously associated
     * with the service but that are deleted aren't included in the count. The count might not reflect pending
     * registrations and deregistrations.
     * </p>
     * 
     * @return The number of instances that are currently associated with the service. Instances that were previously
     *         associated with the service but that are deleted aren't included in the count. The count might not
     *         reflect pending registrations and deregistrations.
     */
    public final Integer instanceCount() {
        return instanceCount;
    }

    /**
     * <p>
     * A complex type that contains information about the Route 53 DNS records that you want Cloud Map to create when
     * you register an instance.
     * </p>
     * 
     * @return A complex type that contains information about the Route 53 DNS records that you want Cloud Map to create
     *         when you register an instance.
     */
    public final DnsConfig dnsConfig() {
        return dnsConfig;
    }

    /**
     * <p>
     * Describes the systems that can be used to discover the service instances.
     * </p>
     * <dl>
     * <dt>DNS_HTTP</dt>
     * <dd>
     * <p>
     * The service instances can be discovered using either DNS queries or the <code>DiscoverInstances</code> API
     * operation.
     * </p>
     * </dd>
     * <dt>HTTP</dt>
     * <dd>
     * <p>
     * The service instances can only be discovered using the <code>DiscoverInstances</code> API operation.
     * </p>
     * </dd>
     * <dt>DNS</dt>
     * <dd>
     * <p>
     * Reserved.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ServiceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Describes the systems that can be used to discover the service instances.</p>
     *         <dl>
     *         <dt>DNS_HTTP</dt>
     *         <dd>
     *         <p>
     *         The service instances can be discovered using either DNS queries or the <code>DiscoverInstances</code>
     *         API operation.
     *         </p>
     *         </dd>
     *         <dt>HTTP</dt>
     *         <dd>
     *         <p>
     *         The service instances can only be discovered using the <code>DiscoverInstances</code> API operation.
     *         </p>
     *         </dd>
     *         <dt>DNS</dt>
     *         <dd>
     *         <p>
     *         Reserved.
     *         </p>
     *         </dd>
     * @see ServiceType
     */
    public final ServiceType type() {
        return ServiceType.fromValue(type);
    }

    /**
     * <p>
     * Describes the systems that can be used to discover the service instances.
     * </p>
     * <dl>
     * <dt>DNS_HTTP</dt>
     * <dd>
     * <p>
     * The service instances can be discovered using either DNS queries or the <code>DiscoverInstances</code> API
     * operation.
     * </p>
     * </dd>
     * <dt>HTTP</dt>
     * <dd>
     * <p>
     * The service instances can only be discovered using the <code>DiscoverInstances</code> API operation.
     * </p>
     * </dd>
     * <dt>DNS</dt>
     * <dd>
     * <p>
     * Reserved.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ServiceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Describes the systems that can be used to discover the service instances.</p>
     *         <dl>
     *         <dt>DNS_HTTP</dt>
     *         <dd>
     *         <p>
     *         The service instances can be discovered using either DNS queries or the <code>DiscoverInstances</code>
     *         API operation.
     *         </p>
     *         </dd>
     *         <dt>HTTP</dt>
     *         <dd>
     *         <p>
     *         The service instances can only be discovered using the <code>DiscoverInstances</code> API operation.
     *         </p>
     *         </dd>
     *         <dt>DNS</dt>
     *         <dd>
     *         <p>
     *         Reserved.
     *         </p>
     *         </dd>
     * @see ServiceType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * <i>Public DNS and HTTP namespaces only.</i> A complex type that contains settings for an optional health check.
     * If you specify settings for a health check, Cloud Map associates the health check with the records that you
     * specify in <code>DnsConfig</code>.
     * </p>
     * <p>
     * For information about the charges for health checks, see <a href="http://aws.amazon.com/route53/pricing/">Amazon
     * Route 53 Pricing</a>.
     * </p>
     * 
     * @return <i>Public DNS and HTTP namespaces only.</i> A complex type that contains settings for an optional health
     *         check. If you specify settings for a health check, Cloud Map associates the health check with the records
     *         that you specify in <code>DnsConfig</code>.</p>
     *         <p>
     *         For information about the charges for health checks, see <a
     *         href="http://aws.amazon.com/route53/pricing/">Amazon Route 53 Pricing</a>.
     */
    public final HealthCheckConfig healthCheckConfig() {
        return healthCheckConfig;
    }

    /**
     * <p>
     * A complex type that contains information about an optional custom health check.
     * </p>
     * <important>
     * <p>
     * If you specify a health check configuration, you can specify either <code>HealthCheckCustomConfig</code> or
     * <code>HealthCheckConfig</code> but not both.
     * </p>
     * </important>
     * 
     * @return A complex type that contains information about an optional custom health check.</p> <important>
     *         <p>
     *         If you specify a health check configuration, you can specify either <code>HealthCheckCustomConfig</code>
     *         or <code>HealthCheckConfig</code> but not both.
     *         </p>
     */
    public final HealthCheckCustomConfig healthCheckCustomConfig() {
        return healthCheckCustomConfig;
    }

    /**
     * <p>
     * The date and time that the service was created, in Unix format and Coordinated Universal Time (UTC). The value of
     * <code>CreateDate</code> is accurate to milliseconds. For example, the value <code>1516925490.087</code>
     * represents Friday, January 26, 2018 12:11:30.087 AM.
     * </p>
     * 
     * @return The date and time that the service was created, in Unix format and Coordinated Universal Time (UTC). The
     *         value of <code>CreateDate</code> is accurate to milliseconds. For example, the value
     *         <code>1516925490.087</code> represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public final Instant createDate() {
        return createDate;
    }

    /**
     * <p>
     * A unique string that identifies the request and that allows failed requests to be retried without the risk of
     * running the operation twice. <code>CreatorRequestId</code> can be any unique string (for example, a
     * date/timestamp).
     * </p>
     * 
     * @return A unique string that identifies the request and that allows failed requests to be retried without the
     *         risk of running the operation twice. <code>CreatorRequestId</code> can be any unique string (for example,
     *         a date/timestamp).
     */
    public final String creatorRequestId() {
        return creatorRequestId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(namespaceId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(dnsConfig());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(healthCheckConfig());
        hashCode = 31 * hashCode + Objects.hashCode(healthCheckCustomConfig());
        hashCode = 31 * hashCode + Objects.hashCode(createDate());
        hashCode = 31 * hashCode + Objects.hashCode(creatorRequestId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Service)) {
            return false;
        }
        Service other = (Service) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(namespaceId(), other.namespaceId()) && Objects.equals(description(), other.description())
                && Objects.equals(instanceCount(), other.instanceCount()) && Objects.equals(dnsConfig(), other.dnsConfig())
                && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(healthCheckConfig(), other.healthCheckConfig())
                && Objects.equals(healthCheckCustomConfig(), other.healthCheckCustomConfig())
                && Objects.equals(createDate(), other.createDate())
                && Objects.equals(creatorRequestId(), other.creatorRequestId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Service").add("Id", id()).add("Arn", arn()).add("Name", name())
                .add("NamespaceId", namespaceId()).add("Description", description()).add("InstanceCount", instanceCount())
                .add("DnsConfig", dnsConfig()).add("Type", typeAsString()).add("HealthCheckConfig", healthCheckConfig())
                .add("HealthCheckCustomConfig", healthCheckCustomConfig()).add("CreateDate", createDate())
                .add("CreatorRequestId", creatorRequestId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "NamespaceId":
            return Optional.ofNullable(clazz.cast(namespaceId()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "InstanceCount":
            return Optional.ofNullable(clazz.cast(instanceCount()));
        case "DnsConfig":
            return Optional.ofNullable(clazz.cast(dnsConfig()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "HealthCheckConfig":
            return Optional.ofNullable(clazz.cast(healthCheckConfig()));
        case "HealthCheckCustomConfig":
            return Optional.ofNullable(clazz.cast(healthCheckCustomConfig()));
        case "CreateDate":
            return Optional.ofNullable(clazz.cast(createDate()));
        case "CreatorRequestId":
            return Optional.ofNullable(clazz.cast(creatorRequestId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Service, T> g) {
        return obj -> g.apply((Service) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Service> {
        /**
         * <p>
         * The ID that Cloud Map assigned to the service when you created it.
         * </p>
         * 
         * @param id
         *        The ID that Cloud Map assigned to the service when you created it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The Amazon Resource Name (ARN) that Cloud Map assigns to the service when you create it.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) that Cloud Map assigns to the service when you create it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the service.
         * </p>
         * 
         * @param name
         *        The name of the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ID of the namespace that was used to create the service.
         * </p>
         * 
         * @param namespaceId
         *        The ID of the namespace that was used to create the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespaceId(String namespaceId);

        /**
         * <p>
         * The description of the service.
         * </p>
         * 
         * @param description
         *        The description of the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The number of instances that are currently associated with the service. Instances that were previously
         * associated with the service but that are deleted aren't included in the count. The count might not reflect
         * pending registrations and deregistrations.
         * </p>
         * 
         * @param instanceCount
         *        The number of instances that are currently associated with the service. Instances that were previously
         *        associated with the service but that are deleted aren't included in the count. The count might not
         *        reflect pending registrations and deregistrations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceCount(Integer instanceCount);

        /**
         * <p>
         * A complex type that contains information about the Route 53 DNS records that you want Cloud Map to create
         * when you register an instance.
         * </p>
         * 
         * @param dnsConfig
         *        A complex type that contains information about the Route 53 DNS records that you want Cloud Map to
         *        create when you register an instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsConfig(DnsConfig dnsConfig);

        /**
         * <p>
         * A complex type that contains information about the Route 53 DNS records that you want Cloud Map to create
         * when you register an instance.
         * </p>
         * This is a convenience method that creates an instance of the {@link DnsConfig.Builder} avoiding the need to
         * create one manually via {@link DnsConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link DnsConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #dnsConfig(DnsConfig)}.
         * 
         * @param dnsConfig
         *        a consumer that will call methods on {@link DnsConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dnsConfig(DnsConfig)
         */
        default Builder dnsConfig(Consumer<DnsConfig.Builder> dnsConfig) {
            return dnsConfig(DnsConfig.builder().applyMutation(dnsConfig).build());
        }

        /**
         * <p>
         * Describes the systems that can be used to discover the service instances.
         * </p>
         * <dl>
         * <dt>DNS_HTTP</dt>
         * <dd>
         * <p>
         * The service instances can be discovered using either DNS queries or the <code>DiscoverInstances</code> API
         * operation.
         * </p>
         * </dd>
         * <dt>HTTP</dt>
         * <dd>
         * <p>
         * The service instances can only be discovered using the <code>DiscoverInstances</code> API operation.
         * </p>
         * </dd>
         * <dt>DNS</dt>
         * <dd>
         * <p>
         * Reserved.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param type
         *        Describes the systems that can be used to discover the service instances.</p>
         *        <dl>
         *        <dt>DNS_HTTP</dt>
         *        <dd>
         *        <p>
         *        The service instances can be discovered using either DNS queries or the <code>DiscoverInstances</code>
         *        API operation.
         *        </p>
         *        </dd>
         *        <dt>HTTP</dt>
         *        <dd>
         *        <p>
         *        The service instances can only be discovered using the <code>DiscoverInstances</code> API operation.
         *        </p>
         *        </dd>
         *        <dt>DNS</dt>
         *        <dd>
         *        <p>
         *        Reserved.
         *        </p>
         *        </dd>
         * @see ServiceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceType
         */
        Builder type(String type);

        /**
         * <p>
         * Describes the systems that can be used to discover the service instances.
         * </p>
         * <dl>
         * <dt>DNS_HTTP</dt>
         * <dd>
         * <p>
         * The service instances can be discovered using either DNS queries or the <code>DiscoverInstances</code> API
         * operation.
         * </p>
         * </dd>
         * <dt>HTTP</dt>
         * <dd>
         * <p>
         * The service instances can only be discovered using the <code>DiscoverInstances</code> API operation.
         * </p>
         * </dd>
         * <dt>DNS</dt>
         * <dd>
         * <p>
         * Reserved.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param type
         *        Describes the systems that can be used to discover the service instances.</p>
         *        <dl>
         *        <dt>DNS_HTTP</dt>
         *        <dd>
         *        <p>
         *        The service instances can be discovered using either DNS queries or the <code>DiscoverInstances</code>
         *        API operation.
         *        </p>
         *        </dd>
         *        <dt>HTTP</dt>
         *        <dd>
         *        <p>
         *        The service instances can only be discovered using the <code>DiscoverInstances</code> API operation.
         *        </p>
         *        </dd>
         *        <dt>DNS</dt>
         *        <dd>
         *        <p>
         *        Reserved.
         *        </p>
         *        </dd>
         * @see ServiceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceType
         */
        Builder type(ServiceType type);

        /**
         * <p>
         * <i>Public DNS and HTTP namespaces only.</i> A complex type that contains settings for an optional health
         * check. If you specify settings for a health check, Cloud Map associates the health check with the records
         * that you specify in <code>DnsConfig</code>.
         * </p>
         * <p>
         * For information about the charges for health checks, see <a
         * href="http://aws.amazon.com/route53/pricing/">Amazon Route 53 Pricing</a>.
         * </p>
         * 
         * @param healthCheckConfig
         *        <i>Public DNS and HTTP namespaces only.</i> A complex type that contains settings for an optional
         *        health check. If you specify settings for a health check, Cloud Map associates the health check with
         *        the records that you specify in <code>DnsConfig</code>.</p>
         *        <p>
         *        For information about the charges for health checks, see <a
         *        href="http://aws.amazon.com/route53/pricing/">Amazon Route 53 Pricing</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckConfig(HealthCheckConfig healthCheckConfig);

        /**
         * <p>
         * <i>Public DNS and HTTP namespaces only.</i> A complex type that contains settings for an optional health
         * check. If you specify settings for a health check, Cloud Map associates the health check with the records
         * that you specify in <code>DnsConfig</code>.
         * </p>
         * <p>
         * For information about the charges for health checks, see <a
         * href="http://aws.amazon.com/route53/pricing/">Amazon Route 53 Pricing</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link HealthCheckConfig.Builder} avoiding the
         * need to create one manually via {@link HealthCheckConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link HealthCheckConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #healthCheckConfig(HealthCheckConfig)}.
         * 
         * @param healthCheckConfig
         *        a consumer that will call methods on {@link HealthCheckConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #healthCheckConfig(HealthCheckConfig)
         */
        default Builder healthCheckConfig(Consumer<HealthCheckConfig.Builder> healthCheckConfig) {
            return healthCheckConfig(HealthCheckConfig.builder().applyMutation(healthCheckConfig).build());
        }

        /**
         * <p>
         * A complex type that contains information about an optional custom health check.
         * </p>
         * <important>
         * <p>
         * If you specify a health check configuration, you can specify either <code>HealthCheckCustomConfig</code> or
         * <code>HealthCheckConfig</code> but not both.
         * </p>
         * </important>
         * 
         * @param healthCheckCustomConfig
         *        A complex type that contains information about an optional custom health check.</p> <important>
         *        <p>
         *        If you specify a health check configuration, you can specify either
         *        <code>HealthCheckCustomConfig</code> or <code>HealthCheckConfig</code> but not both.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckCustomConfig(HealthCheckCustomConfig healthCheckCustomConfig);

        /**
         * <p>
         * A complex type that contains information about an optional custom health check.
         * </p>
         * <important>
         * <p>
         * If you specify a health check configuration, you can specify either <code>HealthCheckCustomConfig</code> or
         * <code>HealthCheckConfig</code> but not both.
         * </p>
         * </important> This is a convenience method that creates an instance of the
         * {@link HealthCheckCustomConfig.Builder} avoiding the need to create one manually via
         * {@link HealthCheckCustomConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link HealthCheckCustomConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #healthCheckCustomConfig(HealthCheckCustomConfig)}.
         * 
         * @param healthCheckCustomConfig
         *        a consumer that will call methods on {@link HealthCheckCustomConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #healthCheckCustomConfig(HealthCheckCustomConfig)
         */
        default Builder healthCheckCustomConfig(Consumer<HealthCheckCustomConfig.Builder> healthCheckCustomConfig) {
            return healthCheckCustomConfig(HealthCheckCustomConfig.builder().applyMutation(healthCheckCustomConfig).build());
        }

        /**
         * <p>
         * The date and time that the service was created, in Unix format and Coordinated Universal Time (UTC). The
         * value of <code>CreateDate</code> is accurate to milliseconds. For example, the value
         * <code>1516925490.087</code> represents Friday, January 26, 2018 12:11:30.087 AM.
         * </p>
         * 
         * @param createDate
         *        The date and time that the service was created, in Unix format and Coordinated Universal Time (UTC).
         *        The value of <code>CreateDate</code> is accurate to milliseconds. For example, the value
         *        <code>1516925490.087</code> represents Friday, January 26, 2018 12:11:30.087 AM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createDate(Instant createDate);

        /**
         * <p>
         * A unique string that identifies the request and that allows failed requests to be retried without the risk of
         * running the operation twice. <code>CreatorRequestId</code> can be any unique string (for example, a
         * date/timestamp).
         * </p>
         * 
         * @param creatorRequestId
         *        A unique string that identifies the request and that allows failed requests to be retried without the
         *        risk of running the operation twice. <code>CreatorRequestId</code> can be any unique string (for
         *        example, a date/timestamp).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creatorRequestId(String creatorRequestId);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String name;

        private String namespaceId;

        private String description;

        private Integer instanceCount;

        private DnsConfig dnsConfig;

        private String type;

        private HealthCheckConfig healthCheckConfig;

        private HealthCheckCustomConfig healthCheckCustomConfig;

        private Instant createDate;

        private String creatorRequestId;

        private BuilderImpl() {
        }

        private BuilderImpl(Service model) {
            id(model.id);
            arn(model.arn);
            name(model.name);
            namespaceId(model.namespaceId);
            description(model.description);
            instanceCount(model.instanceCount);
            dnsConfig(model.dnsConfig);
            type(model.type);
            healthCheckConfig(model.healthCheckConfig);
            healthCheckCustomConfig(model.healthCheckCustomConfig);
            createDate(model.createDate);
            creatorRequestId(model.creatorRequestId);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getNamespaceId() {
            return namespaceId;
        }

        public final void setNamespaceId(String namespaceId) {
            this.namespaceId = namespaceId;
        }

        @Override
        public final Builder namespaceId(String namespaceId) {
            this.namespaceId = namespaceId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Integer getInstanceCount() {
            return instanceCount;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final DnsConfig.Builder getDnsConfig() {
            return dnsConfig != null ? dnsConfig.toBuilder() : null;
        }

        public final void setDnsConfig(DnsConfig.BuilderImpl dnsConfig) {
            this.dnsConfig = dnsConfig != null ? dnsConfig.build() : null;
        }

        @Override
        public final Builder dnsConfig(DnsConfig dnsConfig) {
            this.dnsConfig = dnsConfig;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ServiceType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final HealthCheckConfig.Builder getHealthCheckConfig() {
            return healthCheckConfig != null ? healthCheckConfig.toBuilder() : null;
        }

        public final void setHealthCheckConfig(HealthCheckConfig.BuilderImpl healthCheckConfig) {
            this.healthCheckConfig = healthCheckConfig != null ? healthCheckConfig.build() : null;
        }

        @Override
        public final Builder healthCheckConfig(HealthCheckConfig healthCheckConfig) {
            this.healthCheckConfig = healthCheckConfig;
            return this;
        }

        public final HealthCheckCustomConfig.Builder getHealthCheckCustomConfig() {
            return healthCheckCustomConfig != null ? healthCheckCustomConfig.toBuilder() : null;
        }

        public final void setHealthCheckCustomConfig(HealthCheckCustomConfig.BuilderImpl healthCheckCustomConfig) {
            this.healthCheckCustomConfig = healthCheckCustomConfig != null ? healthCheckCustomConfig.build() : null;
        }

        @Override
        public final Builder healthCheckCustomConfig(HealthCheckCustomConfig healthCheckCustomConfig) {
            this.healthCheckCustomConfig = healthCheckCustomConfig;
            return this;
        }

        public final Instant getCreateDate() {
            return createDate;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final String getCreatorRequestId() {
            return creatorRequestId;
        }

        public final void setCreatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
        }

        @Override
        public final Builder creatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
            return this;
        }

        @Override
        public Service build() {
            return new Service(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
