/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListServicesResponse extends ServiceDiscoveryResponse implements
        ToCopyableBuilder<ListServicesResponse.Builder, ListServicesResponse> {
    private static final SdkField<List<ServiceSummary>> SERVICES_FIELD = SdkField
            .<List<ServiceSummary>> builder(MarshallingType.LIST)
            .memberName("Services")
            .getter(getter(ListServicesResponse::services))
            .setter(setter(Builder::services))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Services").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ServiceSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ServiceSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListServicesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ServiceSummary> services;

    private final String nextToken;

    private ListServicesResponse(BuilderImpl builder) {
        super(builder);
        this.services = builder.services;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Services property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasServices() {
        return services != null && !(services instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array that contains one <code>ServiceSummary</code> object for each service that matches the specified filter
     * criteria.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasServices} method.
     * </p>
     * 
     * @return An array that contains one <code>ServiceSummary</code> object for each service that matches the specified
     *         filter criteria.
     */
    public final List<ServiceSummary> services() {
        return services;
    }

    /**
     * <p>
     * If the response contains <code>NextToken</code>, submit another <code>ListServices</code> request to get the next
     * group of results. Specify the value of <code>NextToken</code> from the previous response in the next request.
     * </p>
     * <note>
     * <p>
     * Cloud Map gets <code>MaxResults</code> services and then filters them based on the specified criteria. It's
     * possible that no services in the first <code>MaxResults</code> services matched the specified criteria but that
     * subsequent groups of <code>MaxResults</code> services do contain services that match the criteria.
     * </p>
     * </note>
     * 
     * @return If the response contains <code>NextToken</code>, submit another <code>ListServices</code> request to get
     *         the next group of results. Specify the value of <code>NextToken</code> from the previous response in the
     *         next request.</p> <note>
     *         <p>
     *         Cloud Map gets <code>MaxResults</code> services and then filters them based on the specified criteria.
     *         It's possible that no services in the first <code>MaxResults</code> services matched the specified
     *         criteria but that subsequent groups of <code>MaxResults</code> services do contain services that match
     *         the criteria.
     *         </p>
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasServices() ? services() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServicesResponse)) {
            return false;
        }
        ListServicesResponse other = (ListServicesResponse) obj;
        return hasServices() == other.hasServices() && Objects.equals(services(), other.services())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListServicesResponse").add("Services", hasServices() ? services() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Services":
            return Optional.ofNullable(clazz.cast(services()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListServicesResponse, T> g) {
        return obj -> g.apply((ListServicesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceDiscoveryResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListServicesResponse> {
        /**
         * <p>
         * An array that contains one <code>ServiceSummary</code> object for each service that matches the specified
         * filter criteria.
         * </p>
         * 
         * @param services
         *        An array that contains one <code>ServiceSummary</code> object for each service that matches the
         *        specified filter criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder services(Collection<ServiceSummary> services);

        /**
         * <p>
         * An array that contains one <code>ServiceSummary</code> object for each service that matches the specified
         * filter criteria.
         * </p>
         * 
         * @param services
         *        An array that contains one <code>ServiceSummary</code> object for each service that matches the
         *        specified filter criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder services(ServiceSummary... services);

        /**
         * <p>
         * An array that contains one <code>ServiceSummary</code> object for each service that matches the specified
         * filter criteria.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ServiceSummary>.Builder} avoiding the need
         * to create one manually via {@link List<ServiceSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ServiceSummary>.Builder#build()} is called immediately and
         * its result is passed to {@link #services(List<ServiceSummary>)}.
         * 
         * @param services
         *        a consumer that will call methods on {@link List<ServiceSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #services(List<ServiceSummary>)
         */
        Builder services(Consumer<ServiceSummary.Builder>... services);

        /**
         * <p>
         * If the response contains <code>NextToken</code>, submit another <code>ListServices</code> request to get the
         * next group of results. Specify the value of <code>NextToken</code> from the previous response in the next
         * request.
         * </p>
         * <note>
         * <p>
         * Cloud Map gets <code>MaxResults</code> services and then filters them based on the specified criteria. It's
         * possible that no services in the first <code>MaxResults</code> services matched the specified criteria but
         * that subsequent groups of <code>MaxResults</code> services do contain services that match the criteria.
         * </p>
         * </note>
         * 
         * @param nextToken
         *        If the response contains <code>NextToken</code>, submit another <code>ListServices</code> request to
         *        get the next group of results. Specify the value of <code>NextToken</code> from the previous response
         *        in the next request.</p> <note>
         *        <p>
         *        Cloud Map gets <code>MaxResults</code> services and then filters them based on the specified criteria.
         *        It's possible that no services in the first <code>MaxResults</code> services matched the specified
         *        criteria but that subsequent groups of <code>MaxResults</code> services do contain services that match
         *        the criteria.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ServiceDiscoveryResponse.BuilderImpl implements Builder {
        private List<ServiceSummary> services = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListServicesResponse model) {
            super(model);
            services(model.services);
            nextToken(model.nextToken);
        }

        public final List<ServiceSummary.Builder> getServices() {
            List<ServiceSummary.Builder> result = ServiceSummariesListCopier.copyToBuilder(this.services);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServices(Collection<ServiceSummary.BuilderImpl> services) {
            this.services = ServiceSummariesListCopier.copyFromBuilder(services);
        }

        @Override
        @Transient
        public final Builder services(Collection<ServiceSummary> services) {
            this.services = ServiceSummariesListCopier.copy(services);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder services(ServiceSummary... services) {
            services(Arrays.asList(services));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder services(Consumer<ServiceSummary.Builder>... services) {
            services(Stream.of(services).map(c -> ServiceSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListServicesResponse build() {
            return new ListServicesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
