/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.servicediscovery.ServiceDiscoveryAsyncClient;
import software.amazon.awssdk.services.servicediscovery.internal.UserAgentUtils;
import software.amazon.awssdk.services.servicediscovery.model.ListServicesRequest;
import software.amazon.awssdk.services.servicediscovery.model.ListServicesResponse;

public class ListServicesPublisher
implements SdkPublisher<ListServicesResponse> {
    private final ServiceDiscoveryAsyncClient client;
    private final ListServicesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListServicesPublisher(ServiceDiscoveryAsyncClient client, ListServicesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListServicesPublisher(ServiceDiscoveryAsyncClient client, ListServicesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListServicesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListServicesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListServicesResponseFetcher
    implements AsyncPageFetcher<ListServicesResponse> {
        private ListServicesResponseFetcher() {
        }

        public boolean hasNextPage(ListServicesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListServicesResponse> nextPage(ListServicesResponse previousPage) {
            if (previousPage == null) {
                return ListServicesPublisher.this.client.listServices(ListServicesPublisher.this.firstRequest);
            }
            return ListServicesPublisher.this.client.listServices((ListServicesRequest)((Object)ListServicesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

