/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DiscoverInstancesRequest extends ServiceDiscoveryRequest implements
        ToCopyableBuilder<DiscoverInstancesRequest.Builder, DiscoverInstancesRequest> {
    private static final SdkField<String> NAMESPACE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NamespaceName").getter(getter(DiscoverInstancesRequest::namespaceName))
            .setter(setter(Builder::namespaceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NamespaceName").build()).build();

    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceName").getter(getter(DiscoverInstancesRequest::serviceName)).setter(setter(Builder::serviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceName").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(DiscoverInstancesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<Map<String, String>> QUERY_PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("QueryParameters")
            .getter(getter(DiscoverInstancesRequest::queryParameters))
            .setter(setter(Builder::queryParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryParameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> OPTIONAL_PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("OptionalParameters")
            .getter(getter(DiscoverInstancesRequest::optionalParameters))
            .setter(setter(Builder::optionalParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionalParameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> HEALTH_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HealthStatus").getter(getter(DiscoverInstancesRequest::healthStatusAsString))
            .setter(setter(Builder::healthStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMESPACE_NAME_FIELD,
            SERVICE_NAME_FIELD, MAX_RESULTS_FIELD, QUERY_PARAMETERS_FIELD, OPTIONAL_PARAMETERS_FIELD, HEALTH_STATUS_FIELD));

    private final String namespaceName;

    private final String serviceName;

    private final Integer maxResults;

    private final Map<String, String> queryParameters;

    private final Map<String, String> optionalParameters;

    private final String healthStatus;

    private DiscoverInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.namespaceName = builder.namespaceName;
        this.serviceName = builder.serviceName;
        this.maxResults = builder.maxResults;
        this.queryParameters = builder.queryParameters;
        this.optionalParameters = builder.optionalParameters;
        this.healthStatus = builder.healthStatus;
    }

    /**
     * <p>
     * The <code>HttpName</code> name of the namespace. It's found in the <code>HttpProperties</code> member of the
     * <code>Properties</code> member of the namespace. In most cases, <code>Name</code> and <code>HttpName</code>
     * match. However, if you reuse <code>Name</code> for namespace creation, a generated hash is added to
     * <code>HttpName</code> to distinguish the two.
     * </p>
     * 
     * @return The <code>HttpName</code> name of the namespace. It's found in the <code>HttpProperties</code> member of
     *         the <code>Properties</code> member of the namespace. In most cases, <code>Name</code> and
     *         <code>HttpName</code> match. However, if you reuse <code>Name</code> for namespace creation, a generated
     *         hash is added to <code>HttpName</code> to distinguish the two.
     */
    public final String namespaceName() {
        return namespaceName;
    }

    /**
     * <p>
     * The name of the service that you specified when you registered the instance.
     * </p>
     * 
     * @return The name of the service that you specified when you registered the instance.
     */
    public final String serviceName() {
        return serviceName;
    }

    /**
     * <p>
     * The maximum number of instances that you want Cloud Map to return in the response to a
     * <code>DiscoverInstances</code> request. If you don't specify a value for <code>MaxResults</code>, Cloud Map
     * returns up to 100 instances.
     * </p>
     * 
     * @return The maximum number of instances that you want Cloud Map to return in the response to a
     *         <code>DiscoverInstances</code> request. If you don't specify a value for <code>MaxResults</code>, Cloud
     *         Map returns up to 100 instances.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * For responses, this returns true if the service returned a value for the QueryParameters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasQueryParameters() {
        return queryParameters != null && !(queryParameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Filters to scope the results based on custom attributes for the instance (for example,
     * <code>{version=v1, az=1a}</code>). Only instances that match all the specified key-value pairs are returned.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasQueryParameters} method.
     * </p>
     * 
     * @return Filters to scope the results based on custom attributes for the instance (for example,
     *         <code>{version=v1, az=1a}</code>). Only instances that match all the specified key-value pairs are
     *         returned.
     */
    public final Map<String, String> queryParameters() {
        return queryParameters;
    }

    /**
     * For responses, this returns true if the service returned a value for the OptionalParameters property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOptionalParameters() {
        return optionalParameters != null && !(optionalParameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Opportunistic filters to scope the results based on custom attributes. If there are instances that match both the
     * filters specified in both the <code>QueryParameters</code> parameter and this parameter, all of these instances
     * are returned. Otherwise, the filters are ignored, and only instances that match the filters that are specified in
     * the <code>QueryParameters</code> parameter are returned.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOptionalParameters} method.
     * </p>
     * 
     * @return Opportunistic filters to scope the results based on custom attributes. If there are instances that match
     *         both the filters specified in both the <code>QueryParameters</code> parameter and this parameter, all of
     *         these instances are returned. Otherwise, the filters are ignored, and only instances that match the
     *         filters that are specified in the <code>QueryParameters</code> parameter are returned.
     */
    public final Map<String, String> optionalParameters() {
        return optionalParameters;
    }

    /**
     * <p>
     * The health status of the instances that you want to discover. This parameter is ignored for services that don't
     * have a health check configured, and all instances are returned.
     * </p>
     * <dl>
     * <dt>HEALTHY</dt>
     * <dd>
     * <p>
     * Returns healthy instances.
     * </p>
     * </dd>
     * <dt>UNHEALTHY</dt>
     * <dd>
     * <p>
     * Returns unhealthy instances.
     * </p>
     * </dd>
     * <dt>ALL</dt>
     * <dd>
     * <p>
     * Returns all instances.
     * </p>
     * </dd>
     * <dt>HEALTHY_OR_ELSE_ALL</dt>
     * <dd>
     * <p>
     * Returns healthy instances, unless none are reporting a healthy state. In that case, return all instances. This is
     * also called failing open.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #healthStatus} will
     * return {@link HealthStatusFilter#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #healthStatusAsString}.
     * </p>
     * 
     * @return The health status of the instances that you want to discover. This parameter is ignored for services that
     *         don't have a health check configured, and all instances are returned.</p>
     *         <dl>
     *         <dt>HEALTHY</dt>
     *         <dd>
     *         <p>
     *         Returns healthy instances.
     *         </p>
     *         </dd>
     *         <dt>UNHEALTHY</dt>
     *         <dd>
     *         <p>
     *         Returns unhealthy instances.
     *         </p>
     *         </dd>
     *         <dt>ALL</dt>
     *         <dd>
     *         <p>
     *         Returns all instances.
     *         </p>
     *         </dd>
     *         <dt>HEALTHY_OR_ELSE_ALL</dt>
     *         <dd>
     *         <p>
     *         Returns healthy instances, unless none are reporting a healthy state. In that case, return all instances.
     *         This is also called failing open.
     *         </p>
     *         </dd>
     * @see HealthStatusFilter
     */
    public final HealthStatusFilter healthStatus() {
        return HealthStatusFilter.fromValue(healthStatus);
    }

    /**
     * <p>
     * The health status of the instances that you want to discover. This parameter is ignored for services that don't
     * have a health check configured, and all instances are returned.
     * </p>
     * <dl>
     * <dt>HEALTHY</dt>
     * <dd>
     * <p>
     * Returns healthy instances.
     * </p>
     * </dd>
     * <dt>UNHEALTHY</dt>
     * <dd>
     * <p>
     * Returns unhealthy instances.
     * </p>
     * </dd>
     * <dt>ALL</dt>
     * <dd>
     * <p>
     * Returns all instances.
     * </p>
     * </dd>
     * <dt>HEALTHY_OR_ELSE_ALL</dt>
     * <dd>
     * <p>
     * Returns healthy instances, unless none are reporting a healthy state. In that case, return all instances. This is
     * also called failing open.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #healthStatus} will
     * return {@link HealthStatusFilter#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #healthStatusAsString}.
     * </p>
     * 
     * @return The health status of the instances that you want to discover. This parameter is ignored for services that
     *         don't have a health check configured, and all instances are returned.</p>
     *         <dl>
     *         <dt>HEALTHY</dt>
     *         <dd>
     *         <p>
     *         Returns healthy instances.
     *         </p>
     *         </dd>
     *         <dt>UNHEALTHY</dt>
     *         <dd>
     *         <p>
     *         Returns unhealthy instances.
     *         </p>
     *         </dd>
     *         <dt>ALL</dt>
     *         <dd>
     *         <p>
     *         Returns all instances.
     *         </p>
     *         </dd>
     *         <dt>HEALTHY_OR_ELSE_ALL</dt>
     *         <dd>
     *         <p>
     *         Returns healthy instances, unless none are reporting a healthy state. In that case, return all instances.
     *         This is also called failing open.
     *         </p>
     *         </dd>
     * @see HealthStatusFilter
     */
    public final String healthStatusAsString() {
        return healthStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(namespaceName());
        hashCode = 31 * hashCode + Objects.hashCode(serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(hasQueryParameters() ? queryParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOptionalParameters() ? optionalParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(healthStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DiscoverInstancesRequest)) {
            return false;
        }
        DiscoverInstancesRequest other = (DiscoverInstancesRequest) obj;
        return Objects.equals(namespaceName(), other.namespaceName()) && Objects.equals(serviceName(), other.serviceName())
                && Objects.equals(maxResults(), other.maxResults()) && hasQueryParameters() == other.hasQueryParameters()
                && Objects.equals(queryParameters(), other.queryParameters())
                && hasOptionalParameters() == other.hasOptionalParameters()
                && Objects.equals(optionalParameters(), other.optionalParameters())
                && Objects.equals(healthStatusAsString(), other.healthStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DiscoverInstancesRequest").add("NamespaceName", namespaceName())
                .add("ServiceName", serviceName()).add("MaxResults", maxResults())
                .add("QueryParameters", hasQueryParameters() ? queryParameters() : null)
                .add("OptionalParameters", hasOptionalParameters() ? optionalParameters() : null)
                .add("HealthStatus", healthStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NamespaceName":
            return Optional.ofNullable(clazz.cast(namespaceName()));
        case "ServiceName":
            return Optional.ofNullable(clazz.cast(serviceName()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "QueryParameters":
            return Optional.ofNullable(clazz.cast(queryParameters()));
        case "OptionalParameters":
            return Optional.ofNullable(clazz.cast(optionalParameters()));
        case "HealthStatus":
            return Optional.ofNullable(clazz.cast(healthStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DiscoverInstancesRequest, T> g) {
        return obj -> g.apply((DiscoverInstancesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceDiscoveryRequest.Builder, SdkPojo, CopyableBuilder<Builder, DiscoverInstancesRequest> {
        /**
         * <p>
         * The <code>HttpName</code> name of the namespace. It's found in the <code>HttpProperties</code> member of the
         * <code>Properties</code> member of the namespace. In most cases, <code>Name</code> and <code>HttpName</code>
         * match. However, if you reuse <code>Name</code> for namespace creation, a generated hash is added to
         * <code>HttpName</code> to distinguish the two.
         * </p>
         * 
         * @param namespaceName
         *        The <code>HttpName</code> name of the namespace. It's found in the <code>HttpProperties</code> member
         *        of the <code>Properties</code> member of the namespace. In most cases, <code>Name</code> and
         *        <code>HttpName</code> match. However, if you reuse <code>Name</code> for namespace creation, a
         *        generated hash is added to <code>HttpName</code> to distinguish the two.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespaceName(String namespaceName);

        /**
         * <p>
         * The name of the service that you specified when you registered the instance.
         * </p>
         * 
         * @param serviceName
         *        The name of the service that you specified when you registered the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceName(String serviceName);

        /**
         * <p>
         * The maximum number of instances that you want Cloud Map to return in the response to a
         * <code>DiscoverInstances</code> request. If you don't specify a value for <code>MaxResults</code>, Cloud Map
         * returns up to 100 instances.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of instances that you want Cloud Map to return in the response to a
         *        <code>DiscoverInstances</code> request. If you don't specify a value for <code>MaxResults</code>,
         *        Cloud Map returns up to 100 instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Filters to scope the results based on custom attributes for the instance (for example,
         * <code>{version=v1, az=1a}</code>). Only instances that match all the specified key-value pairs are returned.
         * </p>
         * 
         * @param queryParameters
         *        Filters to scope the results based on custom attributes for the instance (for example,
         *        <code>{version=v1, az=1a}</code>). Only instances that match all the specified key-value pairs are
         *        returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryParameters(Map<String, String> queryParameters);

        /**
         * <p>
         * Opportunistic filters to scope the results based on custom attributes. If there are instances that match both
         * the filters specified in both the <code>QueryParameters</code> parameter and this parameter, all of these
         * instances are returned. Otherwise, the filters are ignored, and only instances that match the filters that
         * are specified in the <code>QueryParameters</code> parameter are returned.
         * </p>
         * 
         * @param optionalParameters
         *        Opportunistic filters to scope the results based on custom attributes. If there are instances that
         *        match both the filters specified in both the <code>QueryParameters</code> parameter and this
         *        parameter, all of these instances are returned. Otherwise, the filters are ignored, and only instances
         *        that match the filters that are specified in the <code>QueryParameters</code> parameter are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionalParameters(Map<String, String> optionalParameters);

        /**
         * <p>
         * The health status of the instances that you want to discover. This parameter is ignored for services that
         * don't have a health check configured, and all instances are returned.
         * </p>
         * <dl>
         * <dt>HEALTHY</dt>
         * <dd>
         * <p>
         * Returns healthy instances.
         * </p>
         * </dd>
         * <dt>UNHEALTHY</dt>
         * <dd>
         * <p>
         * Returns unhealthy instances.
         * </p>
         * </dd>
         * <dt>ALL</dt>
         * <dd>
         * <p>
         * Returns all instances.
         * </p>
         * </dd>
         * <dt>HEALTHY_OR_ELSE_ALL</dt>
         * <dd>
         * <p>
         * Returns healthy instances, unless none are reporting a healthy state. In that case, return all instances.
         * This is also called failing open.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param healthStatus
         *        The health status of the instances that you want to discover. This parameter is ignored for services
         *        that don't have a health check configured, and all instances are returned.</p>
         *        <dl>
         *        <dt>HEALTHY</dt>
         *        <dd>
         *        <p>
         *        Returns healthy instances.
         *        </p>
         *        </dd>
         *        <dt>UNHEALTHY</dt>
         *        <dd>
         *        <p>
         *        Returns unhealthy instances.
         *        </p>
         *        </dd>
         *        <dt>ALL</dt>
         *        <dd>
         *        <p>
         *        Returns all instances.
         *        </p>
         *        </dd>
         *        <dt>HEALTHY_OR_ELSE_ALL</dt>
         *        <dd>
         *        <p>
         *        Returns healthy instances, unless none are reporting a healthy state. In that case, return all
         *        instances. This is also called failing open.
         *        </p>
         *        </dd>
         * @see HealthStatusFilter
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HealthStatusFilter
         */
        Builder healthStatus(String healthStatus);

        /**
         * <p>
         * The health status of the instances that you want to discover. This parameter is ignored for services that
         * don't have a health check configured, and all instances are returned.
         * </p>
         * <dl>
         * <dt>HEALTHY</dt>
         * <dd>
         * <p>
         * Returns healthy instances.
         * </p>
         * </dd>
         * <dt>UNHEALTHY</dt>
         * <dd>
         * <p>
         * Returns unhealthy instances.
         * </p>
         * </dd>
         * <dt>ALL</dt>
         * <dd>
         * <p>
         * Returns all instances.
         * </p>
         * </dd>
         * <dt>HEALTHY_OR_ELSE_ALL</dt>
         * <dd>
         * <p>
         * Returns healthy instances, unless none are reporting a healthy state. In that case, return all instances.
         * This is also called failing open.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param healthStatus
         *        The health status of the instances that you want to discover. This parameter is ignored for services
         *        that don't have a health check configured, and all instances are returned.</p>
         *        <dl>
         *        <dt>HEALTHY</dt>
         *        <dd>
         *        <p>
         *        Returns healthy instances.
         *        </p>
         *        </dd>
         *        <dt>UNHEALTHY</dt>
         *        <dd>
         *        <p>
         *        Returns unhealthy instances.
         *        </p>
         *        </dd>
         *        <dt>ALL</dt>
         *        <dd>
         *        <p>
         *        Returns all instances.
         *        </p>
         *        </dd>
         *        <dt>HEALTHY_OR_ELSE_ALL</dt>
         *        <dd>
         *        <p>
         *        Returns healthy instances, unless none are reporting a healthy state. In that case, return all
         *        instances. This is also called failing open.
         *        </p>
         *        </dd>
         * @see HealthStatusFilter
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HealthStatusFilter
         */
        Builder healthStatus(HealthStatusFilter healthStatus);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ServiceDiscoveryRequest.BuilderImpl implements Builder {
        private String namespaceName;

        private String serviceName;

        private Integer maxResults;

        private Map<String, String> queryParameters = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> optionalParameters = DefaultSdkAutoConstructMap.getInstance();

        private String healthStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DiscoverInstancesRequest model) {
            super(model);
            namespaceName(model.namespaceName);
            serviceName(model.serviceName);
            maxResults(model.maxResults);
            queryParameters(model.queryParameters);
            optionalParameters(model.optionalParameters);
            healthStatus(model.healthStatus);
        }

        public final String getNamespaceName() {
            return namespaceName;
        }

        public final void setNamespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
        }

        @Override
        public final Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public final String getServiceName() {
            return serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Map<String, String> getQueryParameters() {
            if (queryParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return queryParameters;
        }

        public final void setQueryParameters(Map<String, String> queryParameters) {
            this.queryParameters = AttributesCopier.copy(queryParameters);
        }

        @Override
        public final Builder queryParameters(Map<String, String> queryParameters) {
            this.queryParameters = AttributesCopier.copy(queryParameters);
            return this;
        }

        public final Map<String, String> getOptionalParameters() {
            if (optionalParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return optionalParameters;
        }

        public final void setOptionalParameters(Map<String, String> optionalParameters) {
            this.optionalParameters = AttributesCopier.copy(optionalParameters);
        }

        @Override
        public final Builder optionalParameters(Map<String, String> optionalParameters) {
            this.optionalParameters = AttributesCopier.copy(optionalParameters);
            return this;
        }

        public final String getHealthStatus() {
            return healthStatus;
        }

        public final void setHealthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
        }

        @Override
        public final Builder healthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
            return this;
        }

        @Override
        public final Builder healthStatus(HealthStatusFilter healthStatus) {
            this.healthStatus(healthStatus == null ? null : healthStatus.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DiscoverInstancesRequest build() {
            return new DiscoverInstancesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
