/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * DNS properties for the private DNS namespace.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PrivateDnsNamespaceProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<PrivateDnsNamespaceProperties.Builder, PrivateDnsNamespaceProperties> {
    private static final SdkField<PrivateDnsPropertiesMutable> DNS_PROPERTIES_FIELD = SdkField
            .<PrivateDnsPropertiesMutable> builder(MarshallingType.SDK_POJO).memberName("DnsProperties")
            .getter(getter(PrivateDnsNamespaceProperties::dnsProperties)).setter(setter(Builder::dnsProperties))
            .constructor(PrivateDnsPropertiesMutable::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsProperties").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DNS_PROPERTIES_FIELD));

    private static final long serialVersionUID = 1L;

    private final PrivateDnsPropertiesMutable dnsProperties;

    private PrivateDnsNamespaceProperties(BuilderImpl builder) {
        this.dnsProperties = builder.dnsProperties;
    }

    /**
     * <p>
     * DNS properties for the private DNS namespace.
     * </p>
     * 
     * @return DNS properties for the private DNS namespace.
     */
    public final PrivateDnsPropertiesMutable dnsProperties() {
        return dnsProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dnsProperties());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrivateDnsNamespaceProperties)) {
            return false;
        }
        PrivateDnsNamespaceProperties other = (PrivateDnsNamespaceProperties) obj;
        return Objects.equals(dnsProperties(), other.dnsProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PrivateDnsNamespaceProperties").add("DnsProperties", dnsProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DnsProperties":
            return Optional.ofNullable(clazz.cast(dnsProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PrivateDnsNamespaceProperties, T> g) {
        return obj -> g.apply((PrivateDnsNamespaceProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PrivateDnsNamespaceProperties> {
        /**
         * <p>
         * DNS properties for the private DNS namespace.
         * </p>
         * 
         * @param dnsProperties
         *        DNS properties for the private DNS namespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsProperties(PrivateDnsPropertiesMutable dnsProperties);

        /**
         * <p>
         * DNS properties for the private DNS namespace.
         * </p>
         * This is a convenience method that creates an instance of the {@link PrivateDnsPropertiesMutable.Builder}
         * avoiding the need to create one manually via {@link PrivateDnsPropertiesMutable#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PrivateDnsPropertiesMutable.Builder#build()} is called
         * immediately and its result is passed to {@link #dnsProperties(PrivateDnsPropertiesMutable)}.
         * 
         * @param dnsProperties
         *        a consumer that will call methods on {@link PrivateDnsPropertiesMutable.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dnsProperties(PrivateDnsPropertiesMutable)
         */
        default Builder dnsProperties(Consumer<PrivateDnsPropertiesMutable.Builder> dnsProperties) {
            return dnsProperties(PrivateDnsPropertiesMutable.builder().applyMutation(dnsProperties).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private PrivateDnsPropertiesMutable dnsProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(PrivateDnsNamespaceProperties model) {
            dnsProperties(model.dnsProperties);
        }

        public final PrivateDnsPropertiesMutable.Builder getDnsProperties() {
            return dnsProperties != null ? dnsProperties.toBuilder() : null;
        }

        public final void setDnsProperties(PrivateDnsPropertiesMutable.BuilderImpl dnsProperties) {
            this.dnsProperties = dnsProperties != null ? dnsProperties.build() : null;
        }

        @Override
        public final Builder dnsProperties(PrivateDnsPropertiesMutable dnsProperties) {
            this.dnsProperties = dnsProperties;
            return this;
        }

        @Override
        public PrivateDnsNamespaceProperties build() {
            return new PrivateDnsNamespaceProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
