/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.servicediscovery.model.DnsRecord;
import software.amazon.awssdk.services.servicediscovery.model.DnsRecordListCopier;
import software.amazon.awssdk.services.servicediscovery.model.RoutingPolicy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DnsConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DnsConfig> {
    private static final SdkField<String> NAMESPACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NamespaceId").getter(DnsConfig.getter(DnsConfig::namespaceId)).setter(DnsConfig.setter(Builder::namespaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NamespaceId").build()}).build();
    private static final SdkField<String> ROUTING_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoutingPolicy").getter(DnsConfig.getter(DnsConfig::routingPolicyAsString)).setter(DnsConfig.setter(Builder::routingPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingPolicy").build()}).build();
    private static final SdkField<List<DnsRecord>> DNS_RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DnsRecords").getter(DnsConfig.getter(DnsConfig::dnsRecords)).setter(DnsConfig.setter(Builder::dnsRecords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsRecords").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DnsRecord::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMESPACE_ID_FIELD, ROUTING_POLICY_FIELD, DNS_RECORDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("NamespaceId", NAMESPACE_ID_FIELD);
            this.put("RoutingPolicy", ROUTING_POLICY_FIELD);
            this.put("DnsRecords", DNS_RECORDS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String namespaceId;
    private final String routingPolicy;
    private final List<DnsRecord> dnsRecords;

    private DnsConfig(BuilderImpl builder) {
        this.namespaceId = builder.namespaceId;
        this.routingPolicy = builder.routingPolicy;
        this.dnsRecords = builder.dnsRecords;
    }

    @Deprecated
    public final String namespaceId() {
        return this.namespaceId;
    }

    public final RoutingPolicy routingPolicy() {
        return RoutingPolicy.fromValue(this.routingPolicy);
    }

    public final String routingPolicyAsString() {
        return this.routingPolicy;
    }

    public final boolean hasDnsRecords() {
        return this.dnsRecords != null && !(this.dnsRecords instanceof SdkAutoConstructList);
    }

    public final List<DnsRecord> dnsRecords() {
        return this.dnsRecords;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.namespaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.routingPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDnsRecords() ? this.dnsRecords() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DnsConfig)) {
            return false;
        }
        DnsConfig other = (DnsConfig)obj;
        return Objects.equals(this.namespaceId(), other.namespaceId()) && Objects.equals(this.routingPolicyAsString(), other.routingPolicyAsString()) && this.hasDnsRecords() == other.hasDnsRecords() && Objects.equals(this.dnsRecords(), other.dnsRecords());
    }

    public final String toString() {
        return ToString.builder((String)"DnsConfig").add("NamespaceId", (Object)this.namespaceId()).add("RoutingPolicy", (Object)this.routingPolicyAsString()).add("DnsRecords", this.hasDnsRecords() ? this.dnsRecords() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NamespaceId": {
                return Optional.ofNullable(clazz.cast(this.namespaceId()));
            }
            case "RoutingPolicy": {
                return Optional.ofNullable(clazz.cast(this.routingPolicyAsString()));
            }
            case "DnsRecords": {
                return Optional.ofNullable(clazz.cast(this.dnsRecords()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DnsConfig, T> g) {
        return obj -> g.apply((DnsConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String namespaceId;
        private String routingPolicy;
        private List<DnsRecord> dnsRecords = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DnsConfig model) {
            this.namespaceId(model.namespaceId);
            this.routingPolicy(model.routingPolicy);
            this.dnsRecords(model.dnsRecords);
        }

        @Deprecated
        public final String getNamespaceId() {
            return this.namespaceId;
        }

        @Deprecated
        public final void setNamespaceId(String namespaceId) {
            this.namespaceId = namespaceId;
        }

        @Override
        @Deprecated
        public final Builder namespaceId(String namespaceId) {
            this.namespaceId = namespaceId;
            return this;
        }

        public final String getRoutingPolicy() {
            return this.routingPolicy;
        }

        public final void setRoutingPolicy(String routingPolicy) {
            this.routingPolicy = routingPolicy;
        }

        @Override
        public final Builder routingPolicy(String routingPolicy) {
            this.routingPolicy = routingPolicy;
            return this;
        }

        @Override
        public final Builder routingPolicy(RoutingPolicy routingPolicy) {
            this.routingPolicy(routingPolicy == null ? null : routingPolicy.toString());
            return this;
        }

        public final List<DnsRecord.Builder> getDnsRecords() {
            List<DnsRecord.Builder> result = DnsRecordListCopier.copyToBuilder(this.dnsRecords);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDnsRecords(Collection<DnsRecord.BuilderImpl> dnsRecords) {
            this.dnsRecords = DnsRecordListCopier.copyFromBuilder(dnsRecords);
        }

        @Override
        public final Builder dnsRecords(Collection<DnsRecord> dnsRecords) {
            this.dnsRecords = DnsRecordListCopier.copy(dnsRecords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dnsRecords(DnsRecord ... dnsRecords) {
            this.dnsRecords(Arrays.asList(dnsRecords));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dnsRecords(Consumer<DnsRecord.Builder> ... dnsRecords) {
            this.dnsRecords(Stream.of(dnsRecords).map(c -> (DnsRecord)((DnsRecord.Builder)DnsRecord.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public DnsConfig build() {
            return new DnsConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DnsConfig> {
        @Deprecated
        public Builder namespaceId(String var1);

        public Builder routingPolicy(String var1);

        public Builder routingPolicy(RoutingPolicy var1);

        public Builder dnsRecords(Collection<DnsRecord> var1);

        public Builder dnsRecords(DnsRecord ... var1);

        public Builder dnsRecords(Consumer<DnsRecord.Builder> ... var1);
    }
}

