/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetInstancesHealthStatusResponse extends ServiceDiscoveryResponse implements
        ToCopyableBuilder<GetInstancesHealthStatusResponse.Builder, GetInstancesHealthStatusResponse> {
    private static final SdkField<Map<String, String>> STATUS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(GetInstancesHealthStatusResponse::statusAsStrings))
            .setter(setter(Builder::statusWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetInstancesHealthStatusResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(STATUS_FIELD, NEXT_TOKEN_FIELD));

    private final Map<String, String> status;

    private final String nextToken;

    private GetInstancesHealthStatusResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A complex type that contains the IDs and the health status of the instances that you specified in the
     * <code>GetInstancesHealthStatus</code> request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A complex type that contains the IDs and the health status of the instances that you specified in the
     *         <code>GetInstancesHealthStatus</code> request.
     */
    public Map<String, HealthStatus> status() {
        return TypeConverter.convert(status, Function.identity(), HealthStatus::fromValue, (k, v) -> true);
    }

    /**
     * <p>
     * A complex type that contains the IDs and the health status of the instances that you specified in the
     * <code>GetInstancesHealthStatus</code> request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A complex type that contains the IDs and the health status of the instances that you specified in the
     *         <code>GetInstancesHealthStatus</code> request.
     */
    public Map<String, String> statusAsStrings() {
        return status;
    }

    /**
     * <p>
     * If more than <code>MaxResults</code> instances match the specified criteria, you can submit another
     * <code>GetInstancesHealthStatus</code> request to get the next group of results. Specify the value of
     * <code>NextToken</code> from the previous response in the next request.
     * </p>
     * 
     * @return If more than <code>MaxResults</code> instances match the specified criteria, you can submit another
     *         <code>GetInstancesHealthStatus</code> request to get the next group of results. Specify the value of
     *         <code>NextToken</code> from the previous response in the next request.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInstancesHealthStatusResponse)) {
            return false;
        }
        GetInstancesHealthStatusResponse other = (GetInstancesHealthStatusResponse) obj;
        return Objects.equals(statusAsStrings(), other.statusAsStrings()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("GetInstancesHealthStatusResponse").add("Status", statusAsStrings())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsStrings()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetInstancesHealthStatusResponse, T> g) {
        return obj -> g.apply((GetInstancesHealthStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceDiscoveryResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetInstancesHealthStatusResponse> {
        /**
         * <p>
         * A complex type that contains the IDs and the health status of the instances that you specified in the
         * <code>GetInstancesHealthStatus</code> request.
         * </p>
         * 
         * @param status
         *        A complex type that contains the IDs and the health status of the instances that you specified in the
         *        <code>GetInstancesHealthStatus</code> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusWithStrings(Map<String, String> status);

        /**
         * <p>
         * A complex type that contains the IDs and the health status of the instances that you specified in the
         * <code>GetInstancesHealthStatus</code> request.
         * </p>
         * 
         * @param status
         *        A complex type that contains the IDs and the health status of the instances that you specified in the
         *        <code>GetInstancesHealthStatus</code> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Map<String, HealthStatus> status);

        /**
         * <p>
         * If more than <code>MaxResults</code> instances match the specified criteria, you can submit another
         * <code>GetInstancesHealthStatus</code> request to get the next group of results. Specify the value of
         * <code>NextToken</code> from the previous response in the next request.
         * </p>
         * 
         * @param nextToken
         *        If more than <code>MaxResults</code> instances match the specified criteria, you can submit another
         *        <code>GetInstancesHealthStatus</code> request to get the next group of results. Specify the value of
         *        <code>NextToken</code> from the previous response in the next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ServiceDiscoveryResponse.BuilderImpl implements Builder {
        private Map<String, String> status = DefaultSdkAutoConstructMap.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInstancesHealthStatusResponse model) {
            super(model);
            statusWithStrings(model.status);
            nextToken(model.nextToken);
        }

        public final Map<String, String> getStatusAsStrings() {
            return status;
        }

        @Override
        public final Builder statusWithStrings(Map<String, String> status) {
            this.status = InstanceHealthStatusMapCopier.copy(status);
            return this;
        }

        @Override
        public final Builder status(Map<String, HealthStatus> status) {
            this.status = InstanceHealthStatusMapCopier.copyEnumToString(status);
            return this;
        }

        public final void setStatusWithStrings(Map<String, String> status) {
            this.status = InstanceHealthStatusMapCopier.copy(status);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetInstancesHealthStatusResponse build() {
            return new GetInstancesHealthStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
