/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains information about an instance that AWS Cloud Map creates when you submit a
 * <code>RegisterInstance</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Instance implements SdkPojo, Serializable, ToCopyableBuilder<Instance.Builder, Instance> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Instance::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> CREATOR_REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Instance::creatorRequestId)).setter(setter(Builder::creatorRequestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatorRequestId").build()).build();

    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(Instance::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            CREATOR_REQUEST_ID_FIELD, ATTRIBUTES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String creatorRequestId;

    private final Map<String, String> attributes;

    private Instance(BuilderImpl builder) {
        this.id = builder.id;
        this.creatorRequestId = builder.creatorRequestId;
        this.attributes = builder.attributes;
    }

    /**
     * <p>
     * An identifier that you want to associate with the instance. Note the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the service that is specified by <code>ServiceId</code> includes settings for an SRV record, the value of
     * <code>InstanceId</code> is automatically included as part of the value for the SRV record. For more information,
     * see <a>DnsRecord$Type</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can use this value to update an existing instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * To register a new instance, you must specify a value that is unique among instances that you register by using
     * the same service.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you specify an existing <code>InstanceId</code> and <code>ServiceId</code>, AWS Cloud Map updates the existing
     * DNS records. If there's also an existing health check, AWS Cloud Map deletes the old health check and creates a
     * new one.
     * </p>
     * <note>
     * <p>
     * The health check isn't deleted immediately, so it will still appear for a while if you submit a
     * <code>ListHealthChecks</code> request, for example.
     * </p>
     * </note></li>
     * </ul>
     * 
     * @return An identifier that you want to associate with the instance. Note the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         If the service that is specified by <code>ServiceId</code> includes settings for an SRV record, the value
     *         of <code>InstanceId</code> is automatically included as part of the value for the SRV record. For more
     *         information, see <a>DnsRecord$Type</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You can use this value to update an existing instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To register a new instance, you must specify a value that is unique among instances that you register by
     *         using the same service.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you specify an existing <code>InstanceId</code> and <code>ServiceId</code>, AWS Cloud Map updates the
     *         existing DNS records. If there's also an existing health check, AWS Cloud Map deletes the old health
     *         check and creates a new one.
     *         </p>
     *         <note>
     *         <p>
     *         The health check isn't deleted immediately, so it will still appear for a while if you submit a
     *         <code>ListHealthChecks</code> request, for example.
     *         </p>
     *         </note></li>
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * A unique string that identifies the request and that allows failed <code>RegisterInstance</code> requests to be
     * retried without the risk of executing the operation twice. You must use a unique <code>CreatorRequestId</code>
     * string every time you submit a <code>RegisterInstance</code> request if you're registering additional instances
     * for the same namespace and service. <code>CreatorRequestId</code> can be any unique string, for example, a
     * date/time stamp.
     * </p>
     * 
     * @return A unique string that identifies the request and that allows failed <code>RegisterInstance</code> requests
     *         to be retried without the risk of executing the operation twice. You must use a unique
     *         <code>CreatorRequestId</code> string every time you submit a <code>RegisterInstance</code> request if
     *         you're registering additional instances for the same namespace and service. <code>CreatorRequestId</code>
     *         can be any unique string, for example, a date/time stamp.
     */
    public String creatorRequestId() {
        return creatorRequestId;
    }

    /**
     * <p>
     * A string map that contains the following information for the service that you specify in <code>ServiceId</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The attributes that apply to the records that are defined in the service.
     * </p>
     * </li>
     * <li>
     * <p>
     * For each attribute, the applicable value.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Supported attribute keys include the following:
     * </p>
     * <p>
     * <b>AWS_ALIAS_DNS_NAME</b>
     * </p>
     * <p>
     * <b/>
     * </p>
     * <p>
     * If you want AWS Cloud Map to create a Route 53 alias record that routes traffic to an Elastic Load Balancing load
     * balancer, specify the DNS name that is associated with the load balancer. For information about how to get the
     * DNS name, see "DNSName" in the topic <a
     * href="http://docs.aws.amazon.com/Route53/latest/APIReference/API_AliasTarget.html">AliasTarget</a>.
     * </p>
     * <p>
     * Note the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The configuration for the service that is specified by <code>ServiceId</code> must include settings for an A
     * record, an AAAA record, or both.
     * </p>
     * </li>
     * <li>
     * <p>
     * In the service that is specified by <code>ServiceId</code>, the value of <code>RoutingPolicy</code> must be
     * <code>WEIGHTED</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the service that is specified by <code>ServiceId</code> includes <code>HealthCheckConfig</code> settings, AWS
     * Cloud Map will create the health check, but it won't associate the health check with the alias record.
     * </p>
     * </li>
     * <li>
     * <p>
     * Auto naming currently doesn't support creating alias records that route traffic to AWS resources other than ELB
     * load balancers.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you specify a value for <code>AWS_ALIAS_DNS_NAME</code>, don't specify values for any of the
     * <code>AWS_INSTANCE</code> attributes.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>AWS_INSTANCE_CNAME</b>
     * </p>
     * <p>
     * If the service configuration includes a CNAME record, the domain name that you want Route 53 to return in
     * response to DNS queries, for example, <code>example.com</code>.
     * </p>
     * <p>
     * This value is required if the service specified by <code>ServiceId</code> includes settings for an CNAME record.
     * </p>
     * <p>
     * <b>AWS_INSTANCE_IPV4</b>
     * </p>
     * <p>
     * If the service configuration includes an A record, the IPv4 address that you want Route 53 to return in response
     * to DNS queries, for example, <code>192.0.2.44</code>.
     * </p>
     * <p>
     * This value is required if the service specified by <code>ServiceId</code> includes settings for an A record. If
     * the service includes settings for an SRV record, you must specify a value for <code>AWS_INSTANCE_IPV4</code>,
     * <code>AWS_INSTANCE_IPV6</code>, or both.
     * </p>
     * <p>
     * <b>AWS_INSTANCE_IPV6</b>
     * </p>
     * <p>
     * If the service configuration includes an AAAA record, the IPv6 address that you want Route 53 to return in
     * response to DNS queries, for example, <code>2001:0db8:85a3:0000:0000:abcd:0001:2345</code>.
     * </p>
     * <p>
     * This value is required if the service specified by <code>ServiceId</code> includes settings for an AAAA record.
     * If the service includes settings for an SRV record, you must specify a value for <code>AWS_INSTANCE_IPV4</code>,
     * <code>AWS_INSTANCE_IPV6</code>, or both.
     * </p>
     * <p>
     * <b>AWS_INSTANCE_PORT</b>
     * </p>
     * <p>
     * If the service includes an SRV record, the value that you want Route 53 to return for the port.
     * </p>
     * <p>
     * If the service includes <code>HealthCheckConfig</code>, the port on the endpoint that you want Route 53 to send
     * requests to.
     * </p>
     * <p>
     * This value is required if you specified settings for an SRV record when you created the service.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A string map that contains the following information for the service that you specify in
     *         <code>ServiceId</code>:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The attributes that apply to the records that are defined in the service.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For each attribute, the applicable value.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Supported attribute keys include the following:
     *         </p>
     *         <p>
     *         <b>AWS_ALIAS_DNS_NAME</b>
     *         </p>
     *         <p>
     *         <b/>
     *         </p>
     *         <p>
     *         If you want AWS Cloud Map to create a Route 53 alias record that routes traffic to an Elastic Load
     *         Balancing load balancer, specify the DNS name that is associated with the load balancer. For information
     *         about how to get the DNS name, see "DNSName" in the topic <a
     *         href="http://docs.aws.amazon.com/Route53/latest/APIReference/API_AliasTarget.html">AliasTarget</a>.
     *         </p>
     *         <p>
     *         Note the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The configuration for the service that is specified by <code>ServiceId</code> must include settings for
     *         an A record, an AAAA record, or both.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         In the service that is specified by <code>ServiceId</code>, the value of <code>RoutingPolicy</code> must
     *         be <code>WEIGHTED</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If the service that is specified by <code>ServiceId</code> includes <code>HealthCheckConfig</code>
     *         settings, AWS Cloud Map will create the health check, but it won't associate the health check with the
     *         alias record.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Auto naming currently doesn't support creating alias records that route traffic to AWS resources other
     *         than ELB load balancers.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you specify a value for <code>AWS_ALIAS_DNS_NAME</code>, don't specify values for any of the
     *         <code>AWS_INSTANCE</code> attributes.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <b>AWS_INSTANCE_CNAME</b>
     *         </p>
     *         <p>
     *         If the service configuration includes a CNAME record, the domain name that you want Route 53 to return in
     *         response to DNS queries, for example, <code>example.com</code>.
     *         </p>
     *         <p>
     *         This value is required if the service specified by <code>ServiceId</code> includes settings for an CNAME
     *         record.
     *         </p>
     *         <p>
     *         <b>AWS_INSTANCE_IPV4</b>
     *         </p>
     *         <p>
     *         If the service configuration includes an A record, the IPv4 address that you want Route 53 to return in
     *         response to DNS queries, for example, <code>192.0.2.44</code>.
     *         </p>
     *         <p>
     *         This value is required if the service specified by <code>ServiceId</code> includes settings for an A
     *         record. If the service includes settings for an SRV record, you must specify a value for
     *         <code>AWS_INSTANCE_IPV4</code>, <code>AWS_INSTANCE_IPV6</code>, or both.
     *         </p>
     *         <p>
     *         <b>AWS_INSTANCE_IPV6</b>
     *         </p>
     *         <p>
     *         If the service configuration includes an AAAA record, the IPv6 address that you want Route 53 to return
     *         in response to DNS queries, for example, <code>2001:0db8:85a3:0000:0000:abcd:0001:2345</code>.
     *         </p>
     *         <p>
     *         This value is required if the service specified by <code>ServiceId</code> includes settings for an AAAA
     *         record. If the service includes settings for an SRV record, you must specify a value for
     *         <code>AWS_INSTANCE_IPV4</code>, <code>AWS_INSTANCE_IPV6</code>, or both.
     *         </p>
     *         <p>
     *         <b>AWS_INSTANCE_PORT</b>
     *         </p>
     *         <p>
     *         If the service includes an SRV record, the value that you want Route 53 to return for the port.
     *         </p>
     *         <p>
     *         If the service includes <code>HealthCheckConfig</code>, the port on the endpoint that you want Route 53
     *         to send requests to.
     *         </p>
     *         <p>
     *         This value is required if you specified settings for an SRV record when you created the service.
     */
    public Map<String, String> attributes() {
        return attributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(creatorRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(attributes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Instance)) {
            return false;
        }
        Instance other = (Instance) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(creatorRequestId(), other.creatorRequestId())
                && Objects.equals(attributes(), other.attributes());
    }

    @Override
    public String toString() {
        return ToString.builder("Instance").add("Id", id()).add("CreatorRequestId", creatorRequestId())
                .add("Attributes", attributes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "CreatorRequestId":
            return Optional.ofNullable(clazz.cast(creatorRequestId()));
        case "Attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Instance, T> g) {
        return obj -> g.apply((Instance) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Instance> {
        /**
         * <p>
         * An identifier that you want to associate with the instance. Note the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If the service that is specified by <code>ServiceId</code> includes settings for an SRV record, the value of
         * <code>InstanceId</code> is automatically included as part of the value for the SRV record. For more
         * information, see <a>DnsRecord$Type</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * You can use this value to update an existing instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * To register a new instance, you must specify a value that is unique among instances that you register by
         * using the same service.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you specify an existing <code>InstanceId</code> and <code>ServiceId</code>, AWS Cloud Map updates the
         * existing DNS records. If there's also an existing health check, AWS Cloud Map deletes the old health check
         * and creates a new one.
         * </p>
         * <note>
         * <p>
         * The health check isn't deleted immediately, so it will still appear for a while if you submit a
         * <code>ListHealthChecks</code> request, for example.
         * </p>
         * </note></li>
         * </ul>
         * 
         * @param id
         *        An identifier that you want to associate with the instance. Note the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        If the service that is specified by <code>ServiceId</code> includes settings for an SRV record, the
         *        value of <code>InstanceId</code> is automatically included as part of the value for the SRV record.
         *        For more information, see <a>DnsRecord$Type</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        You can use this value to update an existing instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        To register a new instance, you must specify a value that is unique among instances that you register
         *        by using the same service.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you specify an existing <code>InstanceId</code> and <code>ServiceId</code>, AWS Cloud Map updates
         *        the existing DNS records. If there's also an existing health check, AWS Cloud Map deletes the old
         *        health check and creates a new one.
         *        </p>
         *        <note>
         *        <p>
         *        The health check isn't deleted immediately, so it will still appear for a while if you submit a
         *        <code>ListHealthChecks</code> request, for example.
         *        </p>
         *        </note></li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * A unique string that identifies the request and that allows failed <code>RegisterInstance</code> requests to
         * be retried without the risk of executing the operation twice. You must use a unique
         * <code>CreatorRequestId</code> string every time you submit a <code>RegisterInstance</code> request if you're
         * registering additional instances for the same namespace and service. <code>CreatorRequestId</code> can be any
         * unique string, for example, a date/time stamp.
         * </p>
         * 
         * @param creatorRequestId
         *        A unique string that identifies the request and that allows failed <code>RegisterInstance</code>
         *        requests to be retried without the risk of executing the operation twice. You must use a unique
         *        <code>CreatorRequestId</code> string every time you submit a <code>RegisterInstance</code> request if
         *        you're registering additional instances for the same namespace and service.
         *        <code>CreatorRequestId</code> can be any unique string, for example, a date/time stamp.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creatorRequestId(String creatorRequestId);

        /**
         * <p>
         * A string map that contains the following information for the service that you specify in
         * <code>ServiceId</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The attributes that apply to the records that are defined in the service.
         * </p>
         * </li>
         * <li>
         * <p>
         * For each attribute, the applicable value.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Supported attribute keys include the following:
         * </p>
         * <p>
         * <b>AWS_ALIAS_DNS_NAME</b>
         * </p>
         * <p>
         * <b/>
         * </p>
         * <p>
         * If you want AWS Cloud Map to create a Route 53 alias record that routes traffic to an Elastic Load Balancing
         * load balancer, specify the DNS name that is associated with the load balancer. For information about how to
         * get the DNS name, see "DNSName" in the topic <a
         * href="http://docs.aws.amazon.com/Route53/latest/APIReference/API_AliasTarget.html">AliasTarget</a>.
         * </p>
         * <p>
         * Note the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The configuration for the service that is specified by <code>ServiceId</code> must include settings for an A
         * record, an AAAA record, or both.
         * </p>
         * </li>
         * <li>
         * <p>
         * In the service that is specified by <code>ServiceId</code>, the value of <code>RoutingPolicy</code> must be
         * <code>WEIGHTED</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * If the service that is specified by <code>ServiceId</code> includes <code>HealthCheckConfig</code> settings,
         * AWS Cloud Map will create the health check, but it won't associate the health check with the alias record.
         * </p>
         * </li>
         * <li>
         * <p>
         * Auto naming currently doesn't support creating alias records that route traffic to AWS resources other than
         * ELB load balancers.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you specify a value for <code>AWS_ALIAS_DNS_NAME</code>, don't specify values for any of the
         * <code>AWS_INSTANCE</code> attributes.
         * </p>
         * </li>
         * </ul>
         * <p>
         * <b>AWS_INSTANCE_CNAME</b>
         * </p>
         * <p>
         * If the service configuration includes a CNAME record, the domain name that you want Route 53 to return in
         * response to DNS queries, for example, <code>example.com</code>.
         * </p>
         * <p>
         * This value is required if the service specified by <code>ServiceId</code> includes settings for an CNAME
         * record.
         * </p>
         * <p>
         * <b>AWS_INSTANCE_IPV4</b>
         * </p>
         * <p>
         * If the service configuration includes an A record, the IPv4 address that you want Route 53 to return in
         * response to DNS queries, for example, <code>192.0.2.44</code>.
         * </p>
         * <p>
         * This value is required if the service specified by <code>ServiceId</code> includes settings for an A record.
         * If the service includes settings for an SRV record, you must specify a value for
         * <code>AWS_INSTANCE_IPV4</code>, <code>AWS_INSTANCE_IPV6</code>, or both.
         * </p>
         * <p>
         * <b>AWS_INSTANCE_IPV6</b>
         * </p>
         * <p>
         * If the service configuration includes an AAAA record, the IPv6 address that you want Route 53 to return in
         * response to DNS queries, for example, <code>2001:0db8:85a3:0000:0000:abcd:0001:2345</code>.
         * </p>
         * <p>
         * This value is required if the service specified by <code>ServiceId</code> includes settings for an AAAA
         * record. If the service includes settings for an SRV record, you must specify a value for
         * <code>AWS_INSTANCE_IPV4</code>, <code>AWS_INSTANCE_IPV6</code>, or both.
         * </p>
         * <p>
         * <b>AWS_INSTANCE_PORT</b>
         * </p>
         * <p>
         * If the service includes an SRV record, the value that you want Route 53 to return for the port.
         * </p>
         * <p>
         * If the service includes <code>HealthCheckConfig</code>, the port on the endpoint that you want Route 53 to
         * send requests to.
         * </p>
         * <p>
         * This value is required if you specified settings for an SRV record when you created the service.
         * </p>
         * 
         * @param attributes
         *        A string map that contains the following information for the service that you specify in
         *        <code>ServiceId</code>:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        The attributes that apply to the records that are defined in the service.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For each attribute, the applicable value.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Supported attribute keys include the following:
         *        </p>
         *        <p>
         *        <b>AWS_ALIAS_DNS_NAME</b>
         *        </p>
         *        <p>
         *        <b/>
         *        </p>
         *        <p>
         *        If you want AWS Cloud Map to create a Route 53 alias record that routes traffic to an Elastic Load
         *        Balancing load balancer, specify the DNS name that is associated with the load balancer. For
         *        information about how to get the DNS name, see "DNSName" in the topic <a
         *        href="http://docs.aws.amazon.com/Route53/latest/APIReference/API_AliasTarget.html">AliasTarget</a>.
         *        </p>
         *        <p>
         *        Note the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The configuration for the service that is specified by <code>ServiceId</code> must include settings
         *        for an A record, an AAAA record, or both.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        In the service that is specified by <code>ServiceId</code>, the value of <code>RoutingPolicy</code>
         *        must be <code>WEIGHTED</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If the service that is specified by <code>ServiceId</code> includes <code>HealthCheckConfig</code>
         *        settings, AWS Cloud Map will create the health check, but it won't associate the health check with the
         *        alias record.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Auto naming currently doesn't support creating alias records that route traffic to AWS resources other
         *        than ELB load balancers.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you specify a value for <code>AWS_ALIAS_DNS_NAME</code>, don't specify values for any of the
         *        <code>AWS_INSTANCE</code> attributes.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <b>AWS_INSTANCE_CNAME</b>
         *        </p>
         *        <p>
         *        If the service configuration includes a CNAME record, the domain name that you want Route 53 to return
         *        in response to DNS queries, for example, <code>example.com</code>.
         *        </p>
         *        <p>
         *        This value is required if the service specified by <code>ServiceId</code> includes settings for an
         *        CNAME record.
         *        </p>
         *        <p>
         *        <b>AWS_INSTANCE_IPV4</b>
         *        </p>
         *        <p>
         *        If the service configuration includes an A record, the IPv4 address that you want Route 53 to return
         *        in response to DNS queries, for example, <code>192.0.2.44</code>.
         *        </p>
         *        <p>
         *        This value is required if the service specified by <code>ServiceId</code> includes settings for an A
         *        record. If the service includes settings for an SRV record, you must specify a value for
         *        <code>AWS_INSTANCE_IPV4</code>, <code>AWS_INSTANCE_IPV6</code>, or both.
         *        </p>
         *        <p>
         *        <b>AWS_INSTANCE_IPV6</b>
         *        </p>
         *        <p>
         *        If the service configuration includes an AAAA record, the IPv6 address that you want Route 53 to
         *        return in response to DNS queries, for example, <code>2001:0db8:85a3:0000:0000:abcd:0001:2345</code>.
         *        </p>
         *        <p>
         *        This value is required if the service specified by <code>ServiceId</code> includes settings for an
         *        AAAA record. If the service includes settings for an SRV record, you must specify a value for
         *        <code>AWS_INSTANCE_IPV4</code>, <code>AWS_INSTANCE_IPV6</code>, or both.
         *        </p>
         *        <p>
         *        <b>AWS_INSTANCE_PORT</b>
         *        </p>
         *        <p>
         *        If the service includes an SRV record, the value that you want Route 53 to return for the port.
         *        </p>
         *        <p>
         *        If the service includes <code>HealthCheckConfig</code>, the port on the endpoint that you want Route
         *        53 to send requests to.
         *        </p>
         *        <p>
         *        This value is required if you specified settings for an SRV record when you created the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, String> attributes);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String creatorRequestId;

        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Instance model) {
            id(model.id);
            creatorRequestId(model.creatorRequestId);
            attributes(model.attributes);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getCreatorRequestId() {
            return creatorRequestId;
        }

        @Override
        public final Builder creatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
            return this;
        }

        public final void setCreatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
        }

        public final Map<String, String> getAttributes() {
            return attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
        }

        @Override
        public Instance build() {
            return new Instance(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
