/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DiscoverInstancesRevisionResponse extends ServiceDiscoveryResponse implements
        ToCopyableBuilder<DiscoverInstancesRevisionResponse.Builder, DiscoverInstancesRevisionResponse> {
    private static final SdkField<Long> INSTANCES_REVISION_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("InstancesRevision").getter(getter(DiscoverInstancesRevisionResponse::instancesRevision))
            .setter(setter(Builder::instancesRevision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancesRevision").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCES_REVISION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Long instancesRevision;

    private DiscoverInstancesRevisionResponse(BuilderImpl builder) {
        super(builder);
        this.instancesRevision = builder.instancesRevision;
    }

    /**
     * <p>
     * The increasing revision associated to the response Instances list. If a new instance is registered or
     * deregistered, the <code>InstancesRevision</code> updates. The health status updates don't update
     * <code>InstancesRevision</code>.
     * </p>
     * 
     * @return The increasing revision associated to the response Instances list. If a new instance is registered or
     *         deregistered, the <code>InstancesRevision</code> updates. The health status updates don't update
     *         <code>InstancesRevision</code>.
     */
    public final Long instancesRevision() {
        return instancesRevision;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instancesRevision());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DiscoverInstancesRevisionResponse)) {
            return false;
        }
        DiscoverInstancesRevisionResponse other = (DiscoverInstancesRevisionResponse) obj;
        return Objects.equals(instancesRevision(), other.instancesRevision());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DiscoverInstancesRevisionResponse").add("InstancesRevision", instancesRevision()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstancesRevision":
            return Optional.ofNullable(clazz.cast(instancesRevision()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstancesRevision", INSTANCES_REVISION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DiscoverInstancesRevisionResponse, T> g) {
        return obj -> g.apply((DiscoverInstancesRevisionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceDiscoveryResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DiscoverInstancesRevisionResponse> {
        /**
         * <p>
         * The increasing revision associated to the response Instances list. If a new instance is registered or
         * deregistered, the <code>InstancesRevision</code> updates. The health status updates don't update
         * <code>InstancesRevision</code>.
         * </p>
         * 
         * @param instancesRevision
         *        The increasing revision associated to the response Instances list. If a new instance is registered or
         *        deregistered, the <code>InstancesRevision</code> updates. The health status updates don't update
         *        <code>InstancesRevision</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instancesRevision(Long instancesRevision);
    }

    static final class BuilderImpl extends ServiceDiscoveryResponse.BuilderImpl implements Builder {
        private Long instancesRevision;

        private BuilderImpl() {
        }

        private BuilderImpl(DiscoverInstancesRevisionResponse model) {
            super(model);
            instancesRevision(model.instancesRevision);
        }

        public final Long getInstancesRevision() {
            return instancesRevision;
        }

        public final void setInstancesRevision(Long instancesRevision) {
            this.instancesRevision = instancesRevision;
        }

        @Override
        public final Builder instancesRevision(Long instancesRevision) {
            this.instancesRevision = instancesRevision;
            return this;
        }

        @Override
        public DiscoverInstancesRevisionResponse build() {
            return new DiscoverInstancesRevisionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
