/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetServiceAttributesResponse extends ServiceDiscoveryResponse implements
        ToCopyableBuilder<GetServiceAttributesResponse.Builder, GetServiceAttributesResponse> {
    private static final SdkField<ServiceAttributes> SERVICE_ATTRIBUTES_FIELD = SdkField
            .<ServiceAttributes> builder(MarshallingType.SDK_POJO).memberName("ServiceAttributes")
            .getter(getter(GetServiceAttributesResponse::serviceAttributes)).setter(setter(Builder::serviceAttributes))
            .constructor(ServiceAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceAttributes").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_ATTRIBUTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ServiceAttributes serviceAttributes;

    private GetServiceAttributesResponse(BuilderImpl builder) {
        super(builder);
        this.serviceAttributes = builder.serviceAttributes;
    }

    /**
     * <p>
     * A complex type that contains the service ARN and a list of attribute key-value pairs associated with the service.
     * </p>
     * 
     * @return A complex type that contains the service ARN and a list of attribute key-value pairs associated with the
     *         service.
     */
    public final ServiceAttributes serviceAttributes() {
        return serviceAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serviceAttributes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetServiceAttributesResponse)) {
            return false;
        }
        GetServiceAttributesResponse other = (GetServiceAttributesResponse) obj;
        return Objects.equals(serviceAttributes(), other.serviceAttributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetServiceAttributesResponse").add("ServiceAttributes", serviceAttributes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceAttributes":
            return Optional.ofNullable(clazz.cast(serviceAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ServiceAttributes", SERVICE_ATTRIBUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetServiceAttributesResponse, T> g) {
        return obj -> g.apply((GetServiceAttributesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceDiscoveryResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetServiceAttributesResponse> {
        /**
         * <p>
         * A complex type that contains the service ARN and a list of attribute key-value pairs associated with the
         * service.
         * </p>
         * 
         * @param serviceAttributes
         *        A complex type that contains the service ARN and a list of attribute key-value pairs associated with
         *        the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceAttributes(ServiceAttributes serviceAttributes);

        /**
         * <p>
         * A complex type that contains the service ARN and a list of attribute key-value pairs associated with the
         * service.
         * </p>
         * This is a convenience method that creates an instance of the {@link ServiceAttributes.Builder} avoiding the
         * need to create one manually via {@link ServiceAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServiceAttributes.Builder#build()} is called immediately and its
         * result is passed to {@link #serviceAttributes(ServiceAttributes)}.
         * 
         * @param serviceAttributes
         *        a consumer that will call methods on {@link ServiceAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceAttributes(ServiceAttributes)
         */
        default Builder serviceAttributes(Consumer<ServiceAttributes.Builder> serviceAttributes) {
            return serviceAttributes(ServiceAttributes.builder().applyMutation(serviceAttributes).build());
        }
    }

    static final class BuilderImpl extends ServiceDiscoveryResponse.BuilderImpl implements Builder {
        private ServiceAttributes serviceAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(GetServiceAttributesResponse model) {
            super(model);
            serviceAttributes(model.serviceAttributes);
        }

        public final ServiceAttributes.Builder getServiceAttributes() {
            return serviceAttributes != null ? serviceAttributes.toBuilder() : null;
        }

        public final void setServiceAttributes(ServiceAttributes.BuilderImpl serviceAttributes) {
            this.serviceAttributes = serviceAttributes != null ? serviceAttributes.build() : null;
        }

        @Override
        public final Builder serviceAttributes(ServiceAttributes serviceAttributes) {
            this.serviceAttributes = serviceAttributes;
            return this;
        }

        @Override
        public GetServiceAttributesResponse build() {
            return new GetServiceAttributesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
