/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains information about an optional custom health check. A custom health check, which requires
 * that you use a third-party health checker to evaluate the health of your resources, is useful in the following
 * circumstances:
 * </p>
 * <ul>
 * <li>
 * <p>
 * You can't use a health check that's defined by <code>HealthCheckConfig</code> because the resource isn't available
 * over the internet. For example, you can use a custom health check when the instance is in an Amazon VPC. (To check
 * the health of resources in a VPC, the health checker must also be in the VPC.)
 * </p>
 * </li>
 * <li>
 * <p>
 * You want to use a third-party health checker regardless of where your resources are located.
 * </p>
 * </li>
 * </ul>
 * <important>
 * <p>
 * If you specify a health check configuration, you can specify either <code>HealthCheckCustomConfig</code> or
 * <code>HealthCheckConfig</code> but not both.
 * </p>
 * </important>
 * <p>
 * To change the status of a custom health check, submit an <code>UpdateInstanceCustomHealthStatus</code> request. Cloud
 * Map doesn't monitor the status of the resource, it just keeps a record of the status specified in the most recent
 * <code>UpdateInstanceCustomHealthStatus</code> request.
 * </p>
 * <p>
 * Here's how custom health checks work:
 * </p>
 * <ol>
 * <li>
 * <p>
 * You create a service.
 * </p>
 * </li>
 * <li>
 * <p>
 * You register an instance.
 * </p>
 * </li>
 * <li>
 * <p>
 * You configure a third-party health checker to monitor the resource that's associated with the new instance.
 * </p>
 * <note>
 * <p>
 * Cloud Map doesn't check the health of the resource directly.
 * </p>
 * </note></li>
 * <li>
 * <p>
 * The third-party health-checker determines that the resource is unhealthy and notifies your application.
 * </p>
 * </li>
 * <li>
 * <p>
 * Your application submits an <code>UpdateInstanceCustomHealthStatus</code> request.
 * </p>
 * </li>
 * <li>
 * <p>
 * Cloud Map waits for 30 seconds.
 * </p>
 * </li>
 * <li>
 * <p>
 * If another <code>UpdateInstanceCustomHealthStatus</code> request doesn't arrive during that time to change the status
 * back to healthy, Cloud Map stops routing traffic to the resource.
 * </p>
 * </li>
 * </ol>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HealthCheckCustomConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<HealthCheckCustomConfig.Builder, HealthCheckCustomConfig> {
    private static final SdkField<Integer> FAILURE_THRESHOLD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FailureThreshold").getter(getter(HealthCheckCustomConfig::failureThreshold))
            .setter(setter(Builder::failureThreshold))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureThreshold").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILURE_THRESHOLD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer failureThreshold;

    private HealthCheckCustomConfig(BuilderImpl builder) {
        this.failureThreshold = builder.failureThreshold;
    }

    /**
     * <important>
     * <p>
     * This parameter is no longer supported and is always set to 1. Cloud Map waits for approximately 30 seconds after
     * receiving an <code>UpdateInstanceCustomHealthStatus</code> request before changing the status of the service
     * instance.
     * </p>
     * </important>
     * <p>
     * The number of 30-second intervals that you want Cloud Map to wait after receiving an
     * <code>UpdateInstanceCustomHealthStatus</code> request before it changes the health status of a service instance.
     * </p>
     * <p>
     * Sending a second or subsequent <code>UpdateInstanceCustomHealthStatus</code> request with the same value before
     * 30 seconds has passed doesn't accelerate the change. Cloud Map still waits <code>30</code> seconds after the
     * first request to make the change.
     * </p>
     * 
     * @return <p>
     *         This parameter is no longer supported and is always set to 1. Cloud Map waits for approximately 30
     *         seconds after receiving an <code>UpdateInstanceCustomHealthStatus</code> request before changing the
     *         status of the service instance.
     *         </p>
     *         </important>
     *         <p>
     *         The number of 30-second intervals that you want Cloud Map to wait after receiving an
     *         <code>UpdateInstanceCustomHealthStatus</code> request before it changes the health status of a service
     *         instance.
     *         </p>
     *         <p>
     *         Sending a second or subsequent <code>UpdateInstanceCustomHealthStatus</code> request with the same value
     *         before 30 seconds has passed doesn't accelerate the change. Cloud Map still waits <code>30</code> seconds
     *         after the first request to make the change.
     * @deprecated Configurable FailureThreshold of HealthCheckCustomConfig is deprecated. It will always have value 1.
     */
    @Deprecated
    public final Integer failureThreshold() {
        return failureThreshold;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(failureThreshold());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HealthCheckCustomConfig)) {
            return false;
        }
        HealthCheckCustomConfig other = (HealthCheckCustomConfig) obj;
        return Objects.equals(failureThreshold(), other.failureThreshold());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HealthCheckCustomConfig").add("FailureThreshold", failureThreshold()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FailureThreshold":
            return Optional.ofNullable(clazz.cast(failureThreshold()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FailureThreshold", FAILURE_THRESHOLD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HealthCheckCustomConfig, T> g) {
        return obj -> g.apply((HealthCheckCustomConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HealthCheckCustomConfig> {
        /**
         * <important>
         * <p>
         * This parameter is no longer supported and is always set to 1. Cloud Map waits for approximately 30 seconds
         * after receiving an <code>UpdateInstanceCustomHealthStatus</code> request before changing the status of the
         * service instance.
         * </p>
         * </important>
         * <p>
         * The number of 30-second intervals that you want Cloud Map to wait after receiving an
         * <code>UpdateInstanceCustomHealthStatus</code> request before it changes the health status of a service
         * instance.
         * </p>
         * <p>
         * Sending a second or subsequent <code>UpdateInstanceCustomHealthStatus</code> request with the same value
         * before 30 seconds has passed doesn't accelerate the change. Cloud Map still waits <code>30</code> seconds
         * after the first request to make the change.
         * </p>
         * 
         * @param failureThreshold
         *        <p>
         *        This parameter is no longer supported and is always set to 1. Cloud Map waits for approximately 30
         *        seconds after receiving an <code>UpdateInstanceCustomHealthStatus</code> request before changing the
         *        status of the service instance.
         *        </p>
         *        </important>
         *        <p>
         *        The number of 30-second intervals that you want Cloud Map to wait after receiving an
         *        <code>UpdateInstanceCustomHealthStatus</code> request before it changes the health status of a service
         *        instance.
         *        </p>
         *        <p>
         *        Sending a second or subsequent <code>UpdateInstanceCustomHealthStatus</code> request with the same
         *        value before 30 seconds has passed doesn't accelerate the change. Cloud Map still waits
         *        <code>30</code> seconds after the first request to make the change.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated Configurable FailureThreshold of HealthCheckCustomConfig is deprecated. It will always have value
         *             1.
         */
        @Deprecated
        Builder failureThreshold(Integer failureThreshold);
    }

    static final class BuilderImpl implements Builder {
        private Integer failureThreshold;

        private BuilderImpl() {
        }

        private BuilderImpl(HealthCheckCustomConfig model) {
            failureThreshold(model.failureThreshold);
        }

        @Deprecated
        public final Integer getFailureThreshold() {
            return failureThreshold;
        }

        @Deprecated
        public final void setFailureThreshold(Integer failureThreshold) {
            this.failureThreshold = failureThreshold;
        }

        @Override
        @Deprecated
        public final Builder failureThreshold(Integer failureThreshold) {
            this.failureThreshold = failureThreshold;
            return this;
        }

        @Override
        public HealthCheckCustomConfig build() {
            return new HealthCheckCustomConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
