/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListNamespacesResponse extends ServiceDiscoveryResponse implements
        ToCopyableBuilder<ListNamespacesResponse.Builder, ListNamespacesResponse> {
    private static final SdkField<List<NamespaceSummary>> NAMESPACES_FIELD = SdkField
            .<List<NamespaceSummary>> builder(MarshallingType.LIST)
            .memberName("Namespaces")
            .getter(getter(ListNamespacesResponse::namespaces))
            .setter(setter(Builder::namespaces))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Namespaces").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NamespaceSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(NamespaceSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListNamespacesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMESPACES_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<NamespaceSummary> namespaces;

    private final String nextToken;

    private ListNamespacesResponse(BuilderImpl builder) {
        super(builder);
        this.namespaces = builder.namespaces;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Namespaces property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasNamespaces() {
        return namespaces != null && !(namespaces instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array that contains one <code>NamespaceSummary</code> object for each namespace that matches the specified
     * filter criteria.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNamespaces} method.
     * </p>
     * 
     * @return An array that contains one <code>NamespaceSummary</code> object for each namespace that matches the
     *         specified filter criteria.
     */
    public final List<NamespaceSummary> namespaces() {
        return namespaces;
    }

    /**
     * <p>
     * If the response contains <code>NextToken</code>, submit another <code>ListNamespaces</code> request to get the
     * next group of results. Specify the value of <code>NextToken</code> from the previous response in the next
     * request.
     * </p>
     * <note>
     * <p>
     * Cloud Map gets <code>MaxResults</code> namespaces and then filters them based on the specified criteria. It's
     * possible that no namespaces in the first <code>MaxResults</code> namespaces matched the specified criteria but
     * that subsequent groups of <code>MaxResults</code> namespaces do contain namespaces that match the criteria.
     * </p>
     * </note>
     * 
     * @return If the response contains <code>NextToken</code>, submit another <code>ListNamespaces</code> request to
     *         get the next group of results. Specify the value of <code>NextToken</code> from the previous response in
     *         the next request.</p> <note>
     *         <p>
     *         Cloud Map gets <code>MaxResults</code> namespaces and then filters them based on the specified criteria.
     *         It's possible that no namespaces in the first <code>MaxResults</code> namespaces matched the specified
     *         criteria but that subsequent groups of <code>MaxResults</code> namespaces do contain namespaces that
     *         match the criteria.
     *         </p>
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasNamespaces() ? namespaces() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListNamespacesResponse)) {
            return false;
        }
        ListNamespacesResponse other = (ListNamespacesResponse) obj;
        return hasNamespaces() == other.hasNamespaces() && Objects.equals(namespaces(), other.namespaces())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListNamespacesResponse").add("Namespaces", hasNamespaces() ? namespaces() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Namespaces":
            return Optional.ofNullable(clazz.cast(namespaces()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Namespaces", NAMESPACES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListNamespacesResponse, T> g) {
        return obj -> g.apply((ListNamespacesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceDiscoveryResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListNamespacesResponse> {
        /**
         * <p>
         * An array that contains one <code>NamespaceSummary</code> object for each namespace that matches the specified
         * filter criteria.
         * </p>
         * 
         * @param namespaces
         *        An array that contains one <code>NamespaceSummary</code> object for each namespace that matches the
         *        specified filter criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespaces(Collection<NamespaceSummary> namespaces);

        /**
         * <p>
         * An array that contains one <code>NamespaceSummary</code> object for each namespace that matches the specified
         * filter criteria.
         * </p>
         * 
         * @param namespaces
         *        An array that contains one <code>NamespaceSummary</code> object for each namespace that matches the
         *        specified filter criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespaces(NamespaceSummary... namespaces);

        /**
         * <p>
         * An array that contains one <code>NamespaceSummary</code> object for each namespace that matches the specified
         * filter criteria.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.servicediscovery.model.NamespaceSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.servicediscovery.model.NamespaceSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.servicediscovery.model.NamespaceSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #namespaces(List<NamespaceSummary>)}.
         * 
         * @param namespaces
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.servicediscovery.model.NamespaceSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #namespaces(java.util.Collection<NamespaceSummary>)
         */
        Builder namespaces(Consumer<NamespaceSummary.Builder>... namespaces);

        /**
         * <p>
         * If the response contains <code>NextToken</code>, submit another <code>ListNamespaces</code> request to get
         * the next group of results. Specify the value of <code>NextToken</code> from the previous response in the next
         * request.
         * </p>
         * <note>
         * <p>
         * Cloud Map gets <code>MaxResults</code> namespaces and then filters them based on the specified criteria. It's
         * possible that no namespaces in the first <code>MaxResults</code> namespaces matched the specified criteria
         * but that subsequent groups of <code>MaxResults</code> namespaces do contain namespaces that match the
         * criteria.
         * </p>
         * </note>
         * 
         * @param nextToken
         *        If the response contains <code>NextToken</code>, submit another <code>ListNamespaces</code> request to
         *        get the next group of results. Specify the value of <code>NextToken</code> from the previous response
         *        in the next request.</p> <note>
         *        <p>
         *        Cloud Map gets <code>MaxResults</code> namespaces and then filters them based on the specified
         *        criteria. It's possible that no namespaces in the first <code>MaxResults</code> namespaces matched the
         *        specified criteria but that subsequent groups of <code>MaxResults</code> namespaces do contain
         *        namespaces that match the criteria.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ServiceDiscoveryResponse.BuilderImpl implements Builder {
        private List<NamespaceSummary> namespaces = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListNamespacesResponse model) {
            super(model);
            namespaces(model.namespaces);
            nextToken(model.nextToken);
        }

        public final List<NamespaceSummary.Builder> getNamespaces() {
            List<NamespaceSummary.Builder> result = NamespaceSummariesListCopier.copyToBuilder(this.namespaces);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNamespaces(Collection<NamespaceSummary.BuilderImpl> namespaces) {
            this.namespaces = NamespaceSummariesListCopier.copyFromBuilder(namespaces);
        }

        @Override
        public final Builder namespaces(Collection<NamespaceSummary> namespaces) {
            this.namespaces = NamespaceSummariesListCopier.copy(namespaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder namespaces(NamespaceSummary... namespaces) {
            namespaces(Arrays.asList(namespaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder namespaces(Consumer<NamespaceSummary.Builder>... namespaces) {
            namespaces(Stream.of(namespaces).map(c -> NamespaceSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListNamespacesResponse build() {
            return new ListNamespacesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
