/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Updated properties for the private DNS namespace.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PrivateDnsNamespacePropertiesChange implements SdkPojo, Serializable,
        ToCopyableBuilder<PrivateDnsNamespacePropertiesChange.Builder, PrivateDnsNamespacePropertiesChange> {
    private static final SdkField<PrivateDnsPropertiesMutableChange> DNS_PROPERTIES_FIELD = SdkField
            .<PrivateDnsPropertiesMutableChange> builder(MarshallingType.SDK_POJO).memberName("DnsProperties")
            .getter(getter(PrivateDnsNamespacePropertiesChange::dnsProperties)).setter(setter(Builder::dnsProperties))
            .constructor(PrivateDnsPropertiesMutableChange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsProperties").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DNS_PROPERTIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final PrivateDnsPropertiesMutableChange dnsProperties;

    private PrivateDnsNamespacePropertiesChange(BuilderImpl builder) {
        this.dnsProperties = builder.dnsProperties;
    }

    /**
     * <p>
     * Updated DNS properties for the private DNS namespace.
     * </p>
     * 
     * @return Updated DNS properties for the private DNS namespace.
     */
    public final PrivateDnsPropertiesMutableChange dnsProperties() {
        return dnsProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dnsProperties());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrivateDnsNamespacePropertiesChange)) {
            return false;
        }
        PrivateDnsNamespacePropertiesChange other = (PrivateDnsNamespacePropertiesChange) obj;
        return Objects.equals(dnsProperties(), other.dnsProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PrivateDnsNamespacePropertiesChange").add("DnsProperties", dnsProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DnsProperties":
            return Optional.ofNullable(clazz.cast(dnsProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DnsProperties", DNS_PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PrivateDnsNamespacePropertiesChange, T> g) {
        return obj -> g.apply((PrivateDnsNamespacePropertiesChange) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PrivateDnsNamespacePropertiesChange> {
        /**
         * <p>
         * Updated DNS properties for the private DNS namespace.
         * </p>
         * 
         * @param dnsProperties
         *        Updated DNS properties for the private DNS namespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsProperties(PrivateDnsPropertiesMutableChange dnsProperties);

        /**
         * <p>
         * Updated DNS properties for the private DNS namespace.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link PrivateDnsPropertiesMutableChange.Builder} avoiding the need to create one manually via
         * {@link PrivateDnsPropertiesMutableChange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PrivateDnsPropertiesMutableChange.Builder#build()} is called
         * immediately and its result is passed to {@link #dnsProperties(PrivateDnsPropertiesMutableChange)}.
         * 
         * @param dnsProperties
         *        a consumer that will call methods on {@link PrivateDnsPropertiesMutableChange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dnsProperties(PrivateDnsPropertiesMutableChange)
         */
        default Builder dnsProperties(Consumer<PrivateDnsPropertiesMutableChange.Builder> dnsProperties) {
            return dnsProperties(PrivateDnsPropertiesMutableChange.builder().applyMutation(dnsProperties).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private PrivateDnsPropertiesMutableChange dnsProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(PrivateDnsNamespacePropertiesChange model) {
            dnsProperties(model.dnsProperties);
        }

        public final PrivateDnsPropertiesMutableChange.Builder getDnsProperties() {
            return dnsProperties != null ? dnsProperties.toBuilder() : null;
        }

        public final void setDnsProperties(PrivateDnsPropertiesMutableChange.BuilderImpl dnsProperties) {
            this.dnsProperties = dnsProperties != null ? dnsProperties.build() : null;
        }

        @Override
        public final Builder dnsProperties(PrivateDnsPropertiesMutableChange dnsProperties) {
            this.dnsProperties = dnsProperties;
            return this;
        }

        @Override
        public PrivateDnsNamespacePropertiesChange build() {
            return new PrivateDnsNamespacePropertiesChange(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
