/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The service can't be created because a service with the same name already exists.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceAlreadyExistsException extends ServiceDiscoveryException implements
        ToCopyableBuilder<ServiceAlreadyExistsException.Builder, ServiceAlreadyExistsException> {
    private static final SdkField<String> CREATOR_REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatorRequestId").getter(getter(ServiceAlreadyExistsException::creatorRequestId))
            .setter(setter(Builder::creatorRequestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatorRequestId").build()).build();

    private static final SdkField<String> SERVICE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceId").getter(getter(ServiceAlreadyExistsException::serviceId)).setter(setter(Builder::serviceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATOR_REQUEST_ID_FIELD,
            SERVICE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String creatorRequestId;

    private final String serviceId;

    private ServiceAlreadyExistsException(BuilderImpl builder) {
        super(builder);
        this.creatorRequestId = builder.creatorRequestId;
        this.serviceId = builder.serviceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * <p>
     * The <code>CreatorRequestId</code> that was used to create the service.
     * </p>
     * 
     * @return The <code>CreatorRequestId</code> that was used to create the service.
     */
    public String creatorRequestId() {
        return creatorRequestId;
    }

    /**
     * <p>
     * The ID of the existing service.
     * </p>
     * 
     * @return The ID of the existing service.
     */
    public String serviceId() {
        return serviceId;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CreatorRequestId", CREATOR_REQUEST_ID_FIELD);
        map.put("ServiceId", SERVICE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceAlreadyExistsException, T> g) {
        return obj -> g.apply((ServiceAlreadyExistsException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceAlreadyExistsException>,
            ServiceDiscoveryException.Builder {
        /**
         * <p>
         * The <code>CreatorRequestId</code> that was used to create the service.
         * </p>
         * 
         * @param creatorRequestId
         *        The <code>CreatorRequestId</code> that was used to create the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creatorRequestId(String creatorRequestId);

        /**
         * <p>
         * The ID of the existing service.
         * </p>
         * 
         * @param serviceId
         *        The ID of the existing service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceId(String serviceId);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);

        @Override
        Builder writableStackTrace(Boolean writableStackTrace);
    }

    static final class BuilderImpl extends ServiceDiscoveryException.BuilderImpl implements Builder {
        private String creatorRequestId;

        private String serviceId;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceAlreadyExistsException model) {
            super(model);
            creatorRequestId(model.creatorRequestId);
            serviceId(model.serviceId);
        }

        public final String getCreatorRequestId() {
            return creatorRequestId;
        }

        public final void setCreatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
        }

        @Override
        public final Builder creatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
            return this;
        }

        public final String getServiceId() {
            return serviceId;
        }

        public final void setServiceId(String serviceId) {
            this.serviceId = serviceId;
        }

        @Override
        public final Builder serviceId(String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BuilderImpl writableStackTrace(Boolean writableStackTrace) {
            this.writableStackTrace = writableStackTrace;
            return this;
        }

        @Override
        public ServiceAlreadyExistsException build() {
            return new ServiceAlreadyExistsException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
