/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that lets you specify the namespaces that you want to list services for.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceFilter implements SdkPojo, Serializable, ToCopyableBuilder<ServiceFilter.Builder, ServiceFilter> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ServiceFilter::nameAsString)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<String>> VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Values")
            .getter(getter(ServiceFilter::values))
            .setter(setter(Builder::values))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CONDITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Condition").getter(getter(ServiceFilter::conditionAsString)).setter(setter(Builder::condition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Condition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, VALUES_FIELD,
            CONDITION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final List<String> values;

    private final String condition;

    private ServiceFilter(BuilderImpl builder) {
        this.name = builder.name;
        this.values = builder.values;
        this.condition = builder.condition;
    }

    /**
     * <p>
     * Specify <code>NAMESPACE_ID</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link ServiceFilterName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return Specify <code>NAMESPACE_ID</code>.
     * @see ServiceFilterName
     */
    public final ServiceFilterName name() {
        return ServiceFilterName.fromValue(name);
    }

    /**
     * <p>
     * Specify <code>NAMESPACE_ID</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link ServiceFilterName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return Specify <code>NAMESPACE_ID</code>.
     * @see ServiceFilterName
     */
    public final String nameAsString() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Values property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasValues() {
        return values != null && !(values instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The values that are applicable to the value that you specify for <code>Condition</code> to filter the list of
     * services.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasValues} method.
     * </p>
     * 
     * @return The values that are applicable to the value that you specify for <code>Condition</code> to filter the
     *         list of services.
     */
    public final List<String> values() {
        return values;
    }

    /**
     * <p>
     * The operator that you want to use to determine whether a service is returned by <code>ListServices</code>. Valid
     * values for <code>Condition</code> include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>EQ</code>: When you specify <code>EQ</code>, specify one namespace ID for <code>Values</code>.
     * <code>EQ</code> is the default condition and can be omitted.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #condition} will
     * return {@link FilterCondition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #conditionAsString}.
     * </p>
     * 
     * @return The operator that you want to use to determine whether a service is returned by <code>ListServices</code>
     *         . Valid values for <code>Condition</code> include the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>EQ</code>: When you specify <code>EQ</code>, specify one namespace ID for <code>Values</code>.
     *         <code>EQ</code> is the default condition and can be omitted.
     *         </p>
     *         </li>
     * @see FilterCondition
     */
    public final FilterCondition condition() {
        return FilterCondition.fromValue(condition);
    }

    /**
     * <p>
     * The operator that you want to use to determine whether a service is returned by <code>ListServices</code>. Valid
     * values for <code>Condition</code> include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>EQ</code>: When you specify <code>EQ</code>, specify one namespace ID for <code>Values</code>.
     * <code>EQ</code> is the default condition and can be omitted.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #condition} will
     * return {@link FilterCondition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #conditionAsString}.
     * </p>
     * 
     * @return The operator that you want to use to determine whether a service is returned by <code>ListServices</code>
     *         . Valid values for <code>Condition</code> include the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>EQ</code>: When you specify <code>EQ</code>, specify one namespace ID for <code>Values</code>.
     *         <code>EQ</code> is the default condition and can be omitted.
     *         </p>
     *         </li>
     * @see FilterCondition
     */
    public final String conditionAsString() {
        return condition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasValues() ? values() : null);
        hashCode = 31 * hashCode + Objects.hashCode(conditionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceFilter)) {
            return false;
        }
        ServiceFilter other = (ServiceFilter) obj;
        return Objects.equals(nameAsString(), other.nameAsString()) && hasValues() == other.hasValues()
                && Objects.equals(values(), other.values()) && Objects.equals(conditionAsString(), other.conditionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServiceFilter").add("Name", nameAsString()).add("Values", hasValues() ? values() : null)
                .add("Condition", conditionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(nameAsString()));
        case "Values":
            return Optional.ofNullable(clazz.cast(values()));
        case "Condition":
            return Optional.ofNullable(clazz.cast(conditionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Values", VALUES_FIELD);
        map.put("Condition", CONDITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceFilter, T> g) {
        return obj -> g.apply((ServiceFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceFilter> {
        /**
         * <p>
         * Specify <code>NAMESPACE_ID</code>.
         * </p>
         * 
         * @param name
         *        Specify <code>NAMESPACE_ID</code>.
         * @see ServiceFilterName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceFilterName
         */
        Builder name(String name);

        /**
         * <p>
         * Specify <code>NAMESPACE_ID</code>.
         * </p>
         * 
         * @param name
         *        Specify <code>NAMESPACE_ID</code>.
         * @see ServiceFilterName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceFilterName
         */
        Builder name(ServiceFilterName name);

        /**
         * <p>
         * The values that are applicable to the value that you specify for <code>Condition</code> to filter the list of
         * services.
         * </p>
         * 
         * @param values
         *        The values that are applicable to the value that you specify for <code>Condition</code> to filter the
         *        list of services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Collection<String> values);

        /**
         * <p>
         * The values that are applicable to the value that you specify for <code>Condition</code> to filter the list of
         * services.
         * </p>
         * 
         * @param values
         *        The values that are applicable to the value that you specify for <code>Condition</code> to filter the
         *        list of services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(String... values);

        /**
         * <p>
         * The operator that you want to use to determine whether a service is returned by <code>ListServices</code>.
         * Valid values for <code>Condition</code> include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>EQ</code>: When you specify <code>EQ</code>, specify one namespace ID for <code>Values</code>.
         * <code>EQ</code> is the default condition and can be omitted.
         * </p>
         * </li>
         * </ul>
         * 
         * @param condition
         *        The operator that you want to use to determine whether a service is returned by
         *        <code>ListServices</code>. Valid values for <code>Condition</code> include the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>EQ</code>: When you specify <code>EQ</code>, specify one namespace ID for <code>Values</code>.
         *        <code>EQ</code> is the default condition and can be omitted.
         *        </p>
         *        </li>
         * @see FilterCondition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FilterCondition
         */
        Builder condition(String condition);

        /**
         * <p>
         * The operator that you want to use to determine whether a service is returned by <code>ListServices</code>.
         * Valid values for <code>Condition</code> include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>EQ</code>: When you specify <code>EQ</code>, specify one namespace ID for <code>Values</code>.
         * <code>EQ</code> is the default condition and can be omitted.
         * </p>
         * </li>
         * </ul>
         * 
         * @param condition
         *        The operator that you want to use to determine whether a service is returned by
         *        <code>ListServices</code>. Valid values for <code>Condition</code> include the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>EQ</code>: When you specify <code>EQ</code>, specify one namespace ID for <code>Values</code>.
         *        <code>EQ</code> is the default condition and can be omitted.
         *        </p>
         *        </li>
         * @see FilterCondition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FilterCondition
         */
        Builder condition(FilterCondition condition);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private List<String> values = DefaultSdkAutoConstructList.getInstance();

        private String condition;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceFilter model) {
            name(model.name);
            values(model.values);
            condition(model.condition);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(ServiceFilterName name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final Collection<String> getValues() {
            if (values instanceof SdkAutoConstructList) {
                return null;
            }
            return values;
        }

        public final void setValues(Collection<String> values) {
            this.values = FilterValuesCopier.copy(values);
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = FilterValuesCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String... values) {
            values(Arrays.asList(values));
            return this;
        }

        public final String getCondition() {
            return condition;
        }

        public final void setCondition(String condition) {
            this.condition = condition;
        }

        @Override
        public final Builder condition(String condition) {
            this.condition = condition;
            return this;
        }

        @Override
        public final Builder condition(FilterCondition condition) {
            this.condition(condition == null ? null : condition.toString());
            return this;
        }

        @Override
        public ServiceFilter build() {
            return new ServiceFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
