/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateInstanceCustomHealthStatusRequest extends ServiceDiscoveryRequest implements
        ToCopyableBuilder<UpdateInstanceCustomHealthStatusRequest.Builder, UpdateInstanceCustomHealthStatusRequest> {
    private static final SdkField<String> SERVICE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceId").getter(getter(UpdateInstanceCustomHealthStatusRequest::serviceId))
            .setter(setter(Builder::serviceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceId").build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(UpdateInstanceCustomHealthStatusRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(UpdateInstanceCustomHealthStatusRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_ID_FIELD,
            INSTANCE_ID_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String serviceId;

    private final String instanceId;

    private final String status;

    private UpdateInstanceCustomHealthStatusRequest(BuilderImpl builder) {
        super(builder);
        this.serviceId = builder.serviceId;
        this.instanceId = builder.instanceId;
        this.status = builder.status;
    }

    /**
     * <p>
     * The ID of the service that includes the configuration for the custom health check that you want to change the
     * status for.
     * </p>
     * 
     * @return The ID of the service that includes the configuration for the custom health check that you want to change
     *         the status for.
     */
    public final String serviceId() {
        return serviceId;
    }

    /**
     * <p>
     * The ID of the instance that you want to change the health status for.
     * </p>
     * 
     * @return The ID of the instance that you want to change the health status for.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The new status of the instance, <code>HEALTHY</code> or <code>UNHEALTHY</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CustomHealthStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The new status of the instance, <code>HEALTHY</code> or <code>UNHEALTHY</code>.
     * @see CustomHealthStatus
     */
    public final CustomHealthStatus status() {
        return CustomHealthStatus.fromValue(status);
    }

    /**
     * <p>
     * The new status of the instance, <code>HEALTHY</code> or <code>UNHEALTHY</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CustomHealthStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The new status of the instance, <code>HEALTHY</code> or <code>UNHEALTHY</code>.
     * @see CustomHealthStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serviceId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateInstanceCustomHealthStatusRequest)) {
            return false;
        }
        UpdateInstanceCustomHealthStatusRequest other = (UpdateInstanceCustomHealthStatusRequest) obj;
        return Objects.equals(serviceId(), other.serviceId()) && Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateInstanceCustomHealthStatusRequest").add("ServiceId", serviceId())
                .add("InstanceId", instanceId()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceId":
            return Optional.ofNullable(clazz.cast(serviceId()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ServiceId", SERVICE_ID_FIELD);
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateInstanceCustomHealthStatusRequest, T> g) {
        return obj -> g.apply((UpdateInstanceCustomHealthStatusRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceDiscoveryRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateInstanceCustomHealthStatusRequest> {
        /**
         * <p>
         * The ID of the service that includes the configuration for the custom health check that you want to change the
         * status for.
         * </p>
         * 
         * @param serviceId
         *        The ID of the service that includes the configuration for the custom health check that you want to
         *        change the status for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceId(String serviceId);

        /**
         * <p>
         * The ID of the instance that you want to change the health status for.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance that you want to change the health status for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The new status of the instance, <code>HEALTHY</code> or <code>UNHEALTHY</code>.
         * </p>
         * 
         * @param status
         *        The new status of the instance, <code>HEALTHY</code> or <code>UNHEALTHY</code>.
         * @see CustomHealthStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CustomHealthStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The new status of the instance, <code>HEALTHY</code> or <code>UNHEALTHY</code>.
         * </p>
         * 
         * @param status
         *        The new status of the instance, <code>HEALTHY</code> or <code>UNHEALTHY</code>.
         * @see CustomHealthStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CustomHealthStatus
         */
        Builder status(CustomHealthStatus status);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ServiceDiscoveryRequest.BuilderImpl implements Builder {
        private String serviceId;

        private String instanceId;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateInstanceCustomHealthStatusRequest model) {
            super(model);
            serviceId(model.serviceId);
            instanceId(model.instanceId);
            status(model.status);
        }

        public final String getServiceId() {
            return serviceId;
        }

        public final void setServiceId(String serviceId) {
            this.serviceId = serviceId;
        }

        @Override
        public final Builder serviceId(String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CustomHealthStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateInstanceCustomHealthStatusRequest build() {
            return new UpdateInstanceCustomHealthStatusRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
