/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum HealthStatusFilter {
    HEALTHY("HEALTHY"),
    UNHEALTHY("UNHEALTHY"),
    ALL("ALL"),
    HEALTHY_OR_ELSE_ALL("HEALTHY_OR_ELSE_ALL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, HealthStatusFilter> VALUE_MAP;
    private final String value;

    private HealthStatusFilter(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static HealthStatusFilter fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<HealthStatusFilter> knownValues() {
        EnumSet<HealthStatusFilter> knownValues = EnumSet.allOf(HealthStatusFilter.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(HealthStatusFilter.class, HealthStatusFilter::toString);
    }
}

