/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.servicediscovery.model.NamespaceProperties;
import software.amazon.awssdk.services.servicediscovery.model.NamespaceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NamespaceSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NamespaceSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(NamespaceSummary.getter(NamespaceSummary::id)).setter(NamespaceSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(NamespaceSummary.getter(NamespaceSummary::arn)).setter(NamespaceSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(NamespaceSummary.getter(NamespaceSummary::name)).setter(NamespaceSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(NamespaceSummary.getter(NamespaceSummary::typeAsString)).setter(NamespaceSummary.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(NamespaceSummary.getter(NamespaceSummary::description)).setter(NamespaceSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Integer> SERVICE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ServiceCount").getter(NamespaceSummary.getter(NamespaceSummary::serviceCount)).setter(NamespaceSummary.setter(Builder::serviceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceCount").build()}).build();
    private static final SdkField<NamespaceProperties> PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Properties").getter(NamespaceSummary.getter(NamespaceSummary::properties)).setter(NamespaceSummary.setter(Builder::properties)).constructor(NamespaceProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Properties").build()}).build();
    private static final SdkField<Instant> CREATE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreateDate").getter(NamespaceSummary.getter(NamespaceSummary::createDate)).setter(NamespaceSummary.setter(Builder::createDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD, NAME_FIELD, TYPE_FIELD, DESCRIPTION_FIELD, SERVICE_COUNT_FIELD, PROPERTIES_FIELD, CREATE_DATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NamespaceSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String arn;
    private final String name;
    private final String type;
    private final String description;
    private final Integer serviceCount;
    private final NamespaceProperties properties;
    private final Instant createDate;

    private NamespaceSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.name = builder.name;
        this.type = builder.type;
        this.description = builder.description;
        this.serviceCount = builder.serviceCount;
        this.properties = builder.properties;
        this.createDate = builder.createDate;
    }

    public final String id() {
        return this.id;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final NamespaceType type() {
        return NamespaceType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String description() {
        return this.description;
    }

    public final Integer serviceCount() {
        return this.serviceCount;
    }

    public final NamespaceProperties properties() {
        return this.properties;
    }

    public final Instant createDate() {
        return this.createDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.properties());
        hashCode = 31 * hashCode + Objects.hashCode(this.createDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NamespaceSummary)) {
            return false;
        }
        NamespaceSummary other = (NamespaceSummary)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.serviceCount(), other.serviceCount()) && Objects.equals(this.properties(), other.properties()) && Objects.equals(this.createDate(), other.createDate());
    }

    public final String toString() {
        return ToString.builder((String)"NamespaceSummary").add("Id", (Object)this.id()).add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("Type", (Object)this.typeAsString()).add("Description", (Object)this.description()).add("ServiceCount", (Object)this.serviceCount()).add("Properties", (Object)this.properties()).add("CreateDate", (Object)this.createDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ServiceCount": {
                return Optional.ofNullable(clazz.cast(this.serviceCount()));
            }
            case "Properties": {
                return Optional.ofNullable(clazz.cast(this.properties()));
            }
            case "CreateDate": {
                return Optional.ofNullable(clazz.cast(this.createDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Id", ID_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("ServiceCount", SERVICE_COUNT_FIELD);
        map.put("Properties", PROPERTIES_FIELD);
        map.put("CreateDate", CREATE_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NamespaceSummary, T> g) {
        return obj -> g.apply((NamespaceSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String arn;
        private String name;
        private String type;
        private String description;
        private Integer serviceCount;
        private NamespaceProperties properties;
        private Instant createDate;

        private BuilderImpl() {
        }

        private BuilderImpl(NamespaceSummary model) {
            this.id(model.id);
            this.arn(model.arn);
            this.name(model.name);
            this.type(model.type);
            this.description(model.description);
            this.serviceCount(model.serviceCount);
            this.properties(model.properties);
            this.createDate(model.createDate);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(NamespaceType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Integer getServiceCount() {
            return this.serviceCount;
        }

        public final void setServiceCount(Integer serviceCount) {
            this.serviceCount = serviceCount;
        }

        @Override
        public final Builder serviceCount(Integer serviceCount) {
            this.serviceCount = serviceCount;
            return this;
        }

        public final NamespaceProperties.Builder getProperties() {
            return this.properties != null ? this.properties.toBuilder() : null;
        }

        public final void setProperties(NamespaceProperties.BuilderImpl properties) {
            this.properties = properties != null ? properties.build() : null;
        }

        @Override
        public final Builder properties(NamespaceProperties properties) {
            this.properties = properties;
            return this;
        }

        public final Instant getCreateDate() {
            return this.createDate;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public NamespaceSummary build() {
            return new NamespaceSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NamespaceSummary> {
        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder type(String var1);

        public Builder type(NamespaceType var1);

        public Builder description(String var1);

        public Builder serviceCount(Integer var1);

        public Builder properties(NamespaceProperties var1);

        default public Builder properties(Consumer<NamespaceProperties.Builder> properties) {
            return this.properties((NamespaceProperties)((NamespaceProperties.Builder)NamespaceProperties.builder().applyMutation(properties)).build());
        }

        public Builder createDate(Instant var1);
    }
}

