/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.servicediscovery.ServiceDiscoveryClient;
import software.amazon.awssdk.services.servicediscovery.ServiceDiscoveryServiceClientConfiguration;
import software.amazon.awssdk.services.servicediscovery.internal.ServiceDiscoveryServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.servicediscovery.model.CreateHttpNamespaceRequest;
import software.amazon.awssdk.services.servicediscovery.model.CreateHttpNamespaceResponse;
import software.amazon.awssdk.services.servicediscovery.model.CreatePrivateDnsNamespaceRequest;
import software.amazon.awssdk.services.servicediscovery.model.CreatePrivateDnsNamespaceResponse;
import software.amazon.awssdk.services.servicediscovery.model.CreatePublicDnsNamespaceRequest;
import software.amazon.awssdk.services.servicediscovery.model.CreatePublicDnsNamespaceResponse;
import software.amazon.awssdk.services.servicediscovery.model.CreateServiceRequest;
import software.amazon.awssdk.services.servicediscovery.model.CreateServiceResponse;
import software.amazon.awssdk.services.servicediscovery.model.CustomHealthNotFoundException;
import software.amazon.awssdk.services.servicediscovery.model.DeleteNamespaceRequest;
import software.amazon.awssdk.services.servicediscovery.model.DeleteNamespaceResponse;
import software.amazon.awssdk.services.servicediscovery.model.DeleteServiceAttributesRequest;
import software.amazon.awssdk.services.servicediscovery.model.DeleteServiceAttributesResponse;
import software.amazon.awssdk.services.servicediscovery.model.DeleteServiceRequest;
import software.amazon.awssdk.services.servicediscovery.model.DeleteServiceResponse;
import software.amazon.awssdk.services.servicediscovery.model.DeregisterInstanceRequest;
import software.amazon.awssdk.services.servicediscovery.model.DeregisterInstanceResponse;
import software.amazon.awssdk.services.servicediscovery.model.DiscoverInstancesRequest;
import software.amazon.awssdk.services.servicediscovery.model.DiscoverInstancesResponse;
import software.amazon.awssdk.services.servicediscovery.model.DiscoverInstancesRevisionRequest;
import software.amazon.awssdk.services.servicediscovery.model.DiscoverInstancesRevisionResponse;
import software.amazon.awssdk.services.servicediscovery.model.DuplicateRequestException;
import software.amazon.awssdk.services.servicediscovery.model.GetInstanceRequest;
import software.amazon.awssdk.services.servicediscovery.model.GetInstanceResponse;
import software.amazon.awssdk.services.servicediscovery.model.GetInstancesHealthStatusRequest;
import software.amazon.awssdk.services.servicediscovery.model.GetInstancesHealthStatusResponse;
import software.amazon.awssdk.services.servicediscovery.model.GetNamespaceRequest;
import software.amazon.awssdk.services.servicediscovery.model.GetNamespaceResponse;
import software.amazon.awssdk.services.servicediscovery.model.GetOperationRequest;
import software.amazon.awssdk.services.servicediscovery.model.GetOperationResponse;
import software.amazon.awssdk.services.servicediscovery.model.GetServiceAttributesRequest;
import software.amazon.awssdk.services.servicediscovery.model.GetServiceAttributesResponse;
import software.amazon.awssdk.services.servicediscovery.model.GetServiceRequest;
import software.amazon.awssdk.services.servicediscovery.model.GetServiceResponse;
import software.amazon.awssdk.services.servicediscovery.model.InstanceNotFoundException;
import software.amazon.awssdk.services.servicediscovery.model.InvalidInputException;
import software.amazon.awssdk.services.servicediscovery.model.ListInstancesRequest;
import software.amazon.awssdk.services.servicediscovery.model.ListInstancesResponse;
import software.amazon.awssdk.services.servicediscovery.model.ListNamespacesRequest;
import software.amazon.awssdk.services.servicediscovery.model.ListNamespacesResponse;
import software.amazon.awssdk.services.servicediscovery.model.ListOperationsRequest;
import software.amazon.awssdk.services.servicediscovery.model.ListOperationsResponse;
import software.amazon.awssdk.services.servicediscovery.model.ListServicesRequest;
import software.amazon.awssdk.services.servicediscovery.model.ListServicesResponse;
import software.amazon.awssdk.services.servicediscovery.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.servicediscovery.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.servicediscovery.model.NamespaceAlreadyExistsException;
import software.amazon.awssdk.services.servicediscovery.model.NamespaceNotFoundException;
import software.amazon.awssdk.services.servicediscovery.model.OperationNotFoundException;
import software.amazon.awssdk.services.servicediscovery.model.RegisterInstanceRequest;
import software.amazon.awssdk.services.servicediscovery.model.RegisterInstanceResponse;
import software.amazon.awssdk.services.servicediscovery.model.RequestLimitExceededException;
import software.amazon.awssdk.services.servicediscovery.model.ResourceInUseException;
import software.amazon.awssdk.services.servicediscovery.model.ResourceLimitExceededException;
import software.amazon.awssdk.services.servicediscovery.model.ResourceNotFoundException;
import software.amazon.awssdk.services.servicediscovery.model.ServiceAlreadyExistsException;
import software.amazon.awssdk.services.servicediscovery.model.ServiceAttributesLimitExceededException;
import software.amazon.awssdk.services.servicediscovery.model.ServiceDiscoveryException;
import software.amazon.awssdk.services.servicediscovery.model.ServiceNotFoundException;
import software.amazon.awssdk.services.servicediscovery.model.TagResourceRequest;
import software.amazon.awssdk.services.servicediscovery.model.TagResourceResponse;
import software.amazon.awssdk.services.servicediscovery.model.TooManyTagsException;
import software.amazon.awssdk.services.servicediscovery.model.UntagResourceRequest;
import software.amazon.awssdk.services.servicediscovery.model.UntagResourceResponse;
import software.amazon.awssdk.services.servicediscovery.model.UpdateHttpNamespaceRequest;
import software.amazon.awssdk.services.servicediscovery.model.UpdateHttpNamespaceResponse;
import software.amazon.awssdk.services.servicediscovery.model.UpdateInstanceCustomHealthStatusRequest;
import software.amazon.awssdk.services.servicediscovery.model.UpdateInstanceCustomHealthStatusResponse;
import software.amazon.awssdk.services.servicediscovery.model.UpdatePrivateDnsNamespaceRequest;
import software.amazon.awssdk.services.servicediscovery.model.UpdatePrivateDnsNamespaceResponse;
import software.amazon.awssdk.services.servicediscovery.model.UpdatePublicDnsNamespaceRequest;
import software.amazon.awssdk.services.servicediscovery.model.UpdatePublicDnsNamespaceResponse;
import software.amazon.awssdk.services.servicediscovery.model.UpdateServiceAttributesRequest;
import software.amazon.awssdk.services.servicediscovery.model.UpdateServiceAttributesResponse;
import software.amazon.awssdk.services.servicediscovery.model.UpdateServiceRequest;
import software.amazon.awssdk.services.servicediscovery.model.UpdateServiceResponse;
import software.amazon.awssdk.services.servicediscovery.transform.CreateHttpNamespaceRequestMarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.CreatePrivateDnsNamespaceRequestMarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.CreatePublicDnsNamespaceRequestMarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.CreateServiceRequestMarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.DeleteNamespaceRequestMarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.DeleteServiceAttributesRequestMarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.DeleteServiceRequestMarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.DeregisterInstanceRequestMarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.DiscoverInstancesRequestMarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.DiscoverInstancesRevisionRequestMarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.GetInstanceRequestMarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.GetInstancesHealthStatusRequestMarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.GetNamespaceRequestMarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.GetOperationRequestMarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.GetServiceAttributesRequestMarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.GetServiceRequestMarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.ListInstancesRequestMarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.ListNamespacesRequestMarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.ListOperationsRequestMarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.ListServicesRequestMarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.RegisterInstanceRequestMarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.UpdateHttpNamespaceRequestMarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.UpdateInstanceCustomHealthStatusRequestMarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.UpdatePrivateDnsNamespaceRequestMarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.UpdatePublicDnsNamespaceRequestMarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.UpdateServiceAttributesRequestMarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.UpdateServiceRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultServiceDiscoveryClient
implements ServiceDiscoveryClient {
    private static final Logger log = Logger.loggerFor(DefaultServiceDiscoveryClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultServiceDiscoveryClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"ServiceDiscovery#2.33.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateHttpNamespaceResponse createHttpNamespace(CreateHttpNamespaceRequest createHttpNamespaceRequest) throws InvalidInputException, NamespaceAlreadyExistsException, ResourceLimitExceededException, DuplicateRequestException, TooManyTagsException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateHttpNamespaceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "ResourceInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "DuplicateRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                }
                case "ServiceAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAlreadyExistsException::builder).build());
                }
                case "ServiceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "InstanceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InstanceNotFoundException::builder).build());
                }
                case "OperationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotFoundException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "ServiceAttributesLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAttributesLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAttributesLimitExceededException::builder).build());
                }
                case "NamespaceAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceAlreadyExistsException::builder).build());
                }
                case "NamespaceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "CustomHealthNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomHealthNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomHealthNotFoundException::builder).build());
                }
                case "ResourceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createHttpNamespaceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceDiscoveryClient.resolveMetricPublishers(clientConfiguration, createHttpNamespaceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ServiceDiscovery");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateHttpNamespace");
            CreateHttpNamespaceResponse createHttpNamespaceResponse = (CreateHttpNamespaceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateHttpNamespace").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createHttpNamespaceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateHttpNamespaceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createHttpNamespaceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceDiscoveryClient.lambda$createHttpNamespace$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreatePrivateDnsNamespaceResponse createPrivateDnsNamespace(CreatePrivateDnsNamespaceRequest createPrivateDnsNamespaceRequest) throws InvalidInputException, NamespaceAlreadyExistsException, ResourceLimitExceededException, DuplicateRequestException, TooManyTagsException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreatePrivateDnsNamespaceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "ResourceInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "DuplicateRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                }
                case "ServiceAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAlreadyExistsException::builder).build());
                }
                case "ServiceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "InstanceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InstanceNotFoundException::builder).build());
                }
                case "OperationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotFoundException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "ServiceAttributesLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAttributesLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAttributesLimitExceededException::builder).build());
                }
                case "NamespaceAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceAlreadyExistsException::builder).build());
                }
                case "NamespaceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "CustomHealthNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomHealthNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomHealthNotFoundException::builder).build());
                }
                case "ResourceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createPrivateDnsNamespaceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceDiscoveryClient.resolveMetricPublishers(clientConfiguration, createPrivateDnsNamespaceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ServiceDiscovery");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreatePrivateDnsNamespace");
            CreatePrivateDnsNamespaceResponse createPrivateDnsNamespaceResponse = (CreatePrivateDnsNamespaceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreatePrivateDnsNamespace").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createPrivateDnsNamespaceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreatePrivateDnsNamespaceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createPrivateDnsNamespaceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceDiscoveryClient.lambda$createPrivateDnsNamespace$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreatePublicDnsNamespaceResponse createPublicDnsNamespace(CreatePublicDnsNamespaceRequest createPublicDnsNamespaceRequest) throws InvalidInputException, NamespaceAlreadyExistsException, ResourceLimitExceededException, DuplicateRequestException, TooManyTagsException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreatePublicDnsNamespaceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "ResourceInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "DuplicateRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                }
                case "ServiceAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAlreadyExistsException::builder).build());
                }
                case "ServiceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "InstanceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InstanceNotFoundException::builder).build());
                }
                case "OperationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotFoundException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "ServiceAttributesLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAttributesLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAttributesLimitExceededException::builder).build());
                }
                case "NamespaceAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceAlreadyExistsException::builder).build());
                }
                case "NamespaceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "CustomHealthNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomHealthNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomHealthNotFoundException::builder).build());
                }
                case "ResourceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createPublicDnsNamespaceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceDiscoveryClient.resolveMetricPublishers(clientConfiguration, createPublicDnsNamespaceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ServiceDiscovery");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreatePublicDnsNamespace");
            CreatePublicDnsNamespaceResponse createPublicDnsNamespaceResponse = (CreatePublicDnsNamespaceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreatePublicDnsNamespace").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createPublicDnsNamespaceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreatePublicDnsNamespaceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createPublicDnsNamespaceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceDiscoveryClient.lambda$createPublicDnsNamespace$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateServiceResponse createService(CreateServiceRequest createServiceRequest) throws InvalidInputException, ResourceLimitExceededException, NamespaceNotFoundException, ServiceAlreadyExistsException, TooManyTagsException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateServiceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "ResourceInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "DuplicateRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                }
                case "ServiceAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAlreadyExistsException::builder).build());
                }
                case "ServiceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "InstanceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InstanceNotFoundException::builder).build());
                }
                case "OperationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotFoundException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "ServiceAttributesLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAttributesLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAttributesLimitExceededException::builder).build());
                }
                case "NamespaceAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceAlreadyExistsException::builder).build());
                }
                case "NamespaceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "CustomHealthNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomHealthNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomHealthNotFoundException::builder).build());
                }
                case "ResourceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createServiceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceDiscoveryClient.resolveMetricPublishers(clientConfiguration, createServiceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ServiceDiscovery");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateService");
            CreateServiceResponse createServiceResponse = (CreateServiceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateService").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createServiceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateServiceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createServiceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceDiscoveryClient.lambda$createService$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteNamespaceResponse deleteNamespace(DeleteNamespaceRequest deleteNamespaceRequest) throws InvalidInputException, NamespaceNotFoundException, ResourceInUseException, DuplicateRequestException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteNamespaceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "ResourceInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "DuplicateRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                }
                case "ServiceAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAlreadyExistsException::builder).build());
                }
                case "ServiceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "InstanceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InstanceNotFoundException::builder).build());
                }
                case "OperationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotFoundException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "ServiceAttributesLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAttributesLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAttributesLimitExceededException::builder).build());
                }
                case "NamespaceAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceAlreadyExistsException::builder).build());
                }
                case "NamespaceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "CustomHealthNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomHealthNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomHealthNotFoundException::builder).build());
                }
                case "ResourceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteNamespaceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceDiscoveryClient.resolveMetricPublishers(clientConfiguration, deleteNamespaceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ServiceDiscovery");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteNamespace");
            DeleteNamespaceResponse deleteNamespaceResponse = (DeleteNamespaceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteNamespace").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteNamespaceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteNamespaceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteNamespaceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceDiscoveryClient.lambda$deleteNamespace$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteServiceResponse deleteService(DeleteServiceRequest deleteServiceRequest) throws InvalidInputException, ServiceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteServiceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "ResourceInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "DuplicateRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                }
                case "ServiceAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAlreadyExistsException::builder).build());
                }
                case "ServiceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "InstanceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InstanceNotFoundException::builder).build());
                }
                case "OperationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotFoundException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "ServiceAttributesLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAttributesLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAttributesLimitExceededException::builder).build());
                }
                case "NamespaceAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceAlreadyExistsException::builder).build());
                }
                case "NamespaceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "CustomHealthNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomHealthNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomHealthNotFoundException::builder).build());
                }
                case "ResourceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteServiceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceDiscoveryClient.resolveMetricPublishers(clientConfiguration, deleteServiceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ServiceDiscovery");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteService");
            DeleteServiceResponse deleteServiceResponse = (DeleteServiceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteService").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteServiceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteServiceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteServiceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceDiscoveryClient.lambda$deleteService$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteServiceAttributesResponse deleteServiceAttributes(DeleteServiceAttributesRequest deleteServiceAttributesRequest) throws InvalidInputException, ServiceNotFoundException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteServiceAttributesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "ResourceInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "DuplicateRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                }
                case "ServiceAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAlreadyExistsException::builder).build());
                }
                case "ServiceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "InstanceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InstanceNotFoundException::builder).build());
                }
                case "OperationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotFoundException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "ServiceAttributesLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAttributesLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAttributesLimitExceededException::builder).build());
                }
                case "NamespaceAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceAlreadyExistsException::builder).build());
                }
                case "NamespaceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "CustomHealthNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomHealthNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomHealthNotFoundException::builder).build());
                }
                case "ResourceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteServiceAttributesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceDiscoveryClient.resolveMetricPublishers(clientConfiguration, deleteServiceAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ServiceDiscovery");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteServiceAttributes");
            DeleteServiceAttributesResponse deleteServiceAttributesResponse = (DeleteServiceAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteServiceAttributes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteServiceAttributesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteServiceAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteServiceAttributesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceDiscoveryClient.lambda$deleteServiceAttributes$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeregisterInstanceResponse deregisterInstance(DeregisterInstanceRequest deregisterInstanceRequest) throws DuplicateRequestException, InvalidInputException, InstanceNotFoundException, ResourceInUseException, ServiceNotFoundException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeregisterInstanceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "ResourceInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "DuplicateRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                }
                case "ServiceAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAlreadyExistsException::builder).build());
                }
                case "ServiceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "InstanceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InstanceNotFoundException::builder).build());
                }
                case "OperationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotFoundException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "ServiceAttributesLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAttributesLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAttributesLimitExceededException::builder).build());
                }
                case "NamespaceAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceAlreadyExistsException::builder).build());
                }
                case "NamespaceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "CustomHealthNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomHealthNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomHealthNotFoundException::builder).build());
                }
                case "ResourceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deregisterInstanceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceDiscoveryClient.resolveMetricPublishers(clientConfiguration, deregisterInstanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ServiceDiscovery");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeregisterInstance");
            DeregisterInstanceResponse deregisterInstanceResponse = (DeregisterInstanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeregisterInstance").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deregisterInstanceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeregisterInstanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deregisterInstanceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceDiscoveryClient.lambda$deregisterInstance$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DiscoverInstancesResponse discoverInstances(DiscoverInstancesRequest discoverInstancesRequest) throws ServiceNotFoundException, NamespaceNotFoundException, InvalidInputException, RequestLimitExceededException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DiscoverInstancesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "ResourceInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "DuplicateRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                }
                case "ServiceAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAlreadyExistsException::builder).build());
                }
                case "ServiceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "InstanceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InstanceNotFoundException::builder).build());
                }
                case "OperationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotFoundException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "ServiceAttributesLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAttributesLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAttributesLimitExceededException::builder).build());
                }
                case "NamespaceAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceAlreadyExistsException::builder).build());
                }
                case "NamespaceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "CustomHealthNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomHealthNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomHealthNotFoundException::builder).build());
                }
                case "ResourceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)discoverInstancesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceDiscoveryClient.resolveMetricPublishers(clientConfiguration, discoverInstancesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ServiceDiscovery");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DiscoverInstances");
            String hostPrefix = "data-";
            String resolvedHostExpression = "data-";
            DiscoverInstancesResponse discoverInstancesResponse = (DiscoverInstancesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DiscoverInstances").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)discoverInstancesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DiscoverInstancesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return discoverInstancesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceDiscoveryClient.lambda$discoverInstances$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DiscoverInstancesRevisionResponse discoverInstancesRevision(DiscoverInstancesRevisionRequest discoverInstancesRevisionRequest) throws ServiceNotFoundException, NamespaceNotFoundException, InvalidInputException, RequestLimitExceededException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DiscoverInstancesRevisionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "ResourceInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "DuplicateRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                }
                case "ServiceAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAlreadyExistsException::builder).build());
                }
                case "ServiceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "InstanceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InstanceNotFoundException::builder).build());
                }
                case "OperationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotFoundException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "ServiceAttributesLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAttributesLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAttributesLimitExceededException::builder).build());
                }
                case "NamespaceAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceAlreadyExistsException::builder).build());
                }
                case "NamespaceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "CustomHealthNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomHealthNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomHealthNotFoundException::builder).build());
                }
                case "ResourceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)discoverInstancesRevisionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceDiscoveryClient.resolveMetricPublishers(clientConfiguration, discoverInstancesRevisionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ServiceDiscovery");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DiscoverInstancesRevision");
            String hostPrefix = "data-";
            String resolvedHostExpression = "data-";
            DiscoverInstancesRevisionResponse discoverInstancesRevisionResponse = (DiscoverInstancesRevisionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DiscoverInstancesRevision").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)discoverInstancesRevisionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DiscoverInstancesRevisionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return discoverInstancesRevisionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceDiscoveryClient.lambda$discoverInstancesRevision$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetInstanceResponse getInstance(GetInstanceRequest getInstanceRequest) throws InstanceNotFoundException, InvalidInputException, ServiceNotFoundException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetInstanceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "ResourceInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "DuplicateRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                }
                case "ServiceAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAlreadyExistsException::builder).build());
                }
                case "ServiceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "InstanceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InstanceNotFoundException::builder).build());
                }
                case "OperationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotFoundException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "ServiceAttributesLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAttributesLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAttributesLimitExceededException::builder).build());
                }
                case "NamespaceAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceAlreadyExistsException::builder).build());
                }
                case "NamespaceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "CustomHealthNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomHealthNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomHealthNotFoundException::builder).build());
                }
                case "ResourceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getInstanceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceDiscoveryClient.resolveMetricPublishers(clientConfiguration, getInstanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ServiceDiscovery");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetInstance");
            GetInstanceResponse getInstanceResponse = (GetInstanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetInstance").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getInstanceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetInstanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getInstanceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceDiscoveryClient.lambda$getInstance$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetInstancesHealthStatusResponse getInstancesHealthStatus(GetInstancesHealthStatusRequest getInstancesHealthStatusRequest) throws InstanceNotFoundException, InvalidInputException, ServiceNotFoundException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetInstancesHealthStatusResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "ResourceInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "DuplicateRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                }
                case "ServiceAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAlreadyExistsException::builder).build());
                }
                case "ServiceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "InstanceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InstanceNotFoundException::builder).build());
                }
                case "OperationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotFoundException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "ServiceAttributesLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAttributesLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAttributesLimitExceededException::builder).build());
                }
                case "NamespaceAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceAlreadyExistsException::builder).build());
                }
                case "NamespaceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "CustomHealthNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomHealthNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomHealthNotFoundException::builder).build());
                }
                case "ResourceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getInstancesHealthStatusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceDiscoveryClient.resolveMetricPublishers(clientConfiguration, getInstancesHealthStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ServiceDiscovery");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetInstancesHealthStatus");
            GetInstancesHealthStatusResponse getInstancesHealthStatusResponse = (GetInstancesHealthStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetInstancesHealthStatus").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getInstancesHealthStatusRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetInstancesHealthStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getInstancesHealthStatusResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceDiscoveryClient.lambda$getInstancesHealthStatus$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetNamespaceResponse getNamespace(GetNamespaceRequest getNamespaceRequest) throws InvalidInputException, NamespaceNotFoundException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetNamespaceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "ResourceInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "DuplicateRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                }
                case "ServiceAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAlreadyExistsException::builder).build());
                }
                case "ServiceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "InstanceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InstanceNotFoundException::builder).build());
                }
                case "OperationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotFoundException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "ServiceAttributesLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAttributesLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAttributesLimitExceededException::builder).build());
                }
                case "NamespaceAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceAlreadyExistsException::builder).build());
                }
                case "NamespaceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "CustomHealthNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomHealthNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomHealthNotFoundException::builder).build());
                }
                case "ResourceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getNamespaceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceDiscoveryClient.resolveMetricPublishers(clientConfiguration, getNamespaceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ServiceDiscovery");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetNamespace");
            GetNamespaceResponse getNamespaceResponse = (GetNamespaceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetNamespace").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getNamespaceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetNamespaceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getNamespaceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceDiscoveryClient.lambda$getNamespace$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetOperationResponse getOperation(GetOperationRequest getOperationRequest) throws InvalidInputException, OperationNotFoundException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetOperationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "ResourceInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "DuplicateRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                }
                case "ServiceAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAlreadyExistsException::builder).build());
                }
                case "ServiceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "InstanceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InstanceNotFoundException::builder).build());
                }
                case "OperationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotFoundException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "ServiceAttributesLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAttributesLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAttributesLimitExceededException::builder).build());
                }
                case "NamespaceAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceAlreadyExistsException::builder).build());
                }
                case "NamespaceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "CustomHealthNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomHealthNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomHealthNotFoundException::builder).build());
                }
                case "ResourceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getOperationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceDiscoveryClient.resolveMetricPublishers(clientConfiguration, getOperationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ServiceDiscovery");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetOperation");
            GetOperationResponse getOperationResponse = (GetOperationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetOperation").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getOperationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetOperationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getOperationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceDiscoveryClient.lambda$getOperation$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetServiceResponse getService(GetServiceRequest getServiceRequest) throws InvalidInputException, ServiceNotFoundException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetServiceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "ResourceInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "DuplicateRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                }
                case "ServiceAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAlreadyExistsException::builder).build());
                }
                case "ServiceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "InstanceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InstanceNotFoundException::builder).build());
                }
                case "OperationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotFoundException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "ServiceAttributesLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAttributesLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAttributesLimitExceededException::builder).build());
                }
                case "NamespaceAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceAlreadyExistsException::builder).build());
                }
                case "NamespaceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "CustomHealthNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomHealthNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomHealthNotFoundException::builder).build());
                }
                case "ResourceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getServiceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceDiscoveryClient.resolveMetricPublishers(clientConfiguration, getServiceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ServiceDiscovery");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetService");
            GetServiceResponse getServiceResponse = (GetServiceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetService").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getServiceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetServiceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getServiceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceDiscoveryClient.lambda$getService$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetServiceAttributesResponse getServiceAttributes(GetServiceAttributesRequest getServiceAttributesRequest) throws InvalidInputException, ServiceNotFoundException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetServiceAttributesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "ResourceInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "DuplicateRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                }
                case "ServiceAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAlreadyExistsException::builder).build());
                }
                case "ServiceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "InstanceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InstanceNotFoundException::builder).build());
                }
                case "OperationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotFoundException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "ServiceAttributesLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAttributesLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAttributesLimitExceededException::builder).build());
                }
                case "NamespaceAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceAlreadyExistsException::builder).build());
                }
                case "NamespaceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "CustomHealthNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomHealthNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomHealthNotFoundException::builder).build());
                }
                case "ResourceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getServiceAttributesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceDiscoveryClient.resolveMetricPublishers(clientConfiguration, getServiceAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ServiceDiscovery");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetServiceAttributes");
            GetServiceAttributesResponse getServiceAttributesResponse = (GetServiceAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetServiceAttributes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getServiceAttributesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetServiceAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getServiceAttributesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceDiscoveryClient.lambda$getServiceAttributes$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListInstancesResponse listInstances(ListInstancesRequest listInstancesRequest) throws ServiceNotFoundException, InvalidInputException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListInstancesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "ResourceInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "DuplicateRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                }
                case "ServiceAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAlreadyExistsException::builder).build());
                }
                case "ServiceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "InstanceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InstanceNotFoundException::builder).build());
                }
                case "OperationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotFoundException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "ServiceAttributesLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAttributesLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAttributesLimitExceededException::builder).build());
                }
                case "NamespaceAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceAlreadyExistsException::builder).build());
                }
                case "NamespaceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "CustomHealthNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomHealthNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomHealthNotFoundException::builder).build());
                }
                case "ResourceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listInstancesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceDiscoveryClient.resolveMetricPublishers(clientConfiguration, listInstancesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ServiceDiscovery");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListInstances");
            ListInstancesResponse listInstancesResponse = (ListInstancesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListInstances").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listInstancesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListInstancesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listInstancesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceDiscoveryClient.lambda$listInstances$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListNamespacesResponse listNamespaces(ListNamespacesRequest listNamespacesRequest) throws InvalidInputException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListNamespacesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "ResourceInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "DuplicateRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                }
                case "ServiceAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAlreadyExistsException::builder).build());
                }
                case "ServiceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "InstanceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InstanceNotFoundException::builder).build());
                }
                case "OperationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotFoundException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "ServiceAttributesLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAttributesLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAttributesLimitExceededException::builder).build());
                }
                case "NamespaceAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceAlreadyExistsException::builder).build());
                }
                case "NamespaceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "CustomHealthNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomHealthNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomHealthNotFoundException::builder).build());
                }
                case "ResourceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listNamespacesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceDiscoveryClient.resolveMetricPublishers(clientConfiguration, listNamespacesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ServiceDiscovery");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListNamespaces");
            ListNamespacesResponse listNamespacesResponse = (ListNamespacesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListNamespaces").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listNamespacesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListNamespacesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listNamespacesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceDiscoveryClient.lambda$listNamespaces$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListOperationsResponse listOperations(ListOperationsRequest listOperationsRequest) throws InvalidInputException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListOperationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "ResourceInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "DuplicateRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                }
                case "ServiceAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAlreadyExistsException::builder).build());
                }
                case "ServiceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "InstanceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InstanceNotFoundException::builder).build());
                }
                case "OperationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotFoundException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "ServiceAttributesLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAttributesLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAttributesLimitExceededException::builder).build());
                }
                case "NamespaceAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceAlreadyExistsException::builder).build());
                }
                case "NamespaceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "CustomHealthNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomHealthNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomHealthNotFoundException::builder).build());
                }
                case "ResourceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listOperationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceDiscoveryClient.resolveMetricPublishers(clientConfiguration, listOperationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ServiceDiscovery");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListOperations");
            ListOperationsResponse listOperationsResponse = (ListOperationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListOperations").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listOperationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListOperationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listOperationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceDiscoveryClient.lambda$listOperations$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListServicesResponse listServices(ListServicesRequest listServicesRequest) throws InvalidInputException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListServicesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "ResourceInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "DuplicateRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                }
                case "ServiceAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAlreadyExistsException::builder).build());
                }
                case "ServiceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "InstanceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InstanceNotFoundException::builder).build());
                }
                case "OperationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotFoundException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "ServiceAttributesLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAttributesLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAttributesLimitExceededException::builder).build());
                }
                case "NamespaceAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceAlreadyExistsException::builder).build());
                }
                case "NamespaceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "CustomHealthNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomHealthNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomHealthNotFoundException::builder).build());
                }
                case "ResourceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listServicesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceDiscoveryClient.resolveMetricPublishers(clientConfiguration, listServicesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ServiceDiscovery");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListServices");
            ListServicesResponse listServicesResponse = (ListServicesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListServices").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listServicesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListServicesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listServicesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceDiscoveryClient.lambda$listServices$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ResourceNotFoundException, InvalidInputException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "ResourceInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "DuplicateRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                }
                case "ServiceAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAlreadyExistsException::builder).build());
                }
                case "ServiceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "InstanceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InstanceNotFoundException::builder).build());
                }
                case "OperationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotFoundException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "ServiceAttributesLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAttributesLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAttributesLimitExceededException::builder).build());
                }
                case "NamespaceAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceAlreadyExistsException::builder).build());
                }
                case "NamespaceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "CustomHealthNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomHealthNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomHealthNotFoundException::builder).build());
                }
                case "ResourceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceDiscoveryClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ServiceDiscovery");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceDiscoveryClient.lambda$listTagsForResource$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RegisterInstanceResponse registerInstance(RegisterInstanceRequest registerInstanceRequest) throws DuplicateRequestException, InvalidInputException, ResourceInUseException, ResourceLimitExceededException, ServiceNotFoundException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RegisterInstanceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "ResourceInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "DuplicateRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                }
                case "ServiceAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAlreadyExistsException::builder).build());
                }
                case "ServiceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "InstanceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InstanceNotFoundException::builder).build());
                }
                case "OperationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotFoundException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "ServiceAttributesLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAttributesLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAttributesLimitExceededException::builder).build());
                }
                case "NamespaceAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceAlreadyExistsException::builder).build());
                }
                case "NamespaceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "CustomHealthNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomHealthNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomHealthNotFoundException::builder).build());
                }
                case "ResourceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)registerInstanceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceDiscoveryClient.resolveMetricPublishers(clientConfiguration, registerInstanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ServiceDiscovery");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RegisterInstance");
            RegisterInstanceResponse registerInstanceResponse = (RegisterInstanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RegisterInstance").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)registerInstanceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RegisterInstanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return registerInstanceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceDiscoveryClient.lambda$registerInstance$43((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException, TooManyTagsException, InvalidInputException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "ResourceInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "DuplicateRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                }
                case "ServiceAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAlreadyExistsException::builder).build());
                }
                case "ServiceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "InstanceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InstanceNotFoundException::builder).build());
                }
                case "OperationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotFoundException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "ServiceAttributesLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAttributesLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAttributesLimitExceededException::builder).build());
                }
                case "NamespaceAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceAlreadyExistsException::builder).build());
                }
                case "NamespaceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "CustomHealthNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomHealthNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomHealthNotFoundException::builder).build());
                }
                case "ResourceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceDiscoveryClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ServiceDiscovery");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceDiscoveryClient.lambda$tagResource$45((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException, InvalidInputException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "ResourceInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "DuplicateRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                }
                case "ServiceAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAlreadyExistsException::builder).build());
                }
                case "ServiceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "InstanceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InstanceNotFoundException::builder).build());
                }
                case "OperationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotFoundException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "ServiceAttributesLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAttributesLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAttributesLimitExceededException::builder).build());
                }
                case "NamespaceAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceAlreadyExistsException::builder).build());
                }
                case "NamespaceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "CustomHealthNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomHealthNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomHealthNotFoundException::builder).build());
                }
                case "ResourceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceDiscoveryClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ServiceDiscovery");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceDiscoveryClient.lambda$untagResource$47((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateHttpNamespaceResponse updateHttpNamespace(UpdateHttpNamespaceRequest updateHttpNamespaceRequest) throws InvalidInputException, NamespaceNotFoundException, ResourceInUseException, DuplicateRequestException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateHttpNamespaceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "ResourceInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "DuplicateRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                }
                case "ServiceAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAlreadyExistsException::builder).build());
                }
                case "ServiceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "InstanceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InstanceNotFoundException::builder).build());
                }
                case "OperationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotFoundException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "ServiceAttributesLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAttributesLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAttributesLimitExceededException::builder).build());
                }
                case "NamespaceAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceAlreadyExistsException::builder).build());
                }
                case "NamespaceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "CustomHealthNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomHealthNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomHealthNotFoundException::builder).build());
                }
                case "ResourceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateHttpNamespaceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceDiscoveryClient.resolveMetricPublishers(clientConfiguration, updateHttpNamespaceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ServiceDiscovery");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateHttpNamespace");
            UpdateHttpNamespaceResponse updateHttpNamespaceResponse = (UpdateHttpNamespaceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateHttpNamespace").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateHttpNamespaceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateHttpNamespaceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateHttpNamespaceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceDiscoveryClient.lambda$updateHttpNamespace$49((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateInstanceCustomHealthStatusResponse updateInstanceCustomHealthStatus(UpdateInstanceCustomHealthStatusRequest updateInstanceCustomHealthStatusRequest) throws InstanceNotFoundException, ServiceNotFoundException, CustomHealthNotFoundException, InvalidInputException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateInstanceCustomHealthStatusResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "ResourceInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "DuplicateRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                }
                case "ServiceAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAlreadyExistsException::builder).build());
                }
                case "ServiceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "InstanceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InstanceNotFoundException::builder).build());
                }
                case "OperationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotFoundException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "ServiceAttributesLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAttributesLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAttributesLimitExceededException::builder).build());
                }
                case "NamespaceAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceAlreadyExistsException::builder).build());
                }
                case "NamespaceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "CustomHealthNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomHealthNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomHealthNotFoundException::builder).build());
                }
                case "ResourceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateInstanceCustomHealthStatusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceDiscoveryClient.resolveMetricPublishers(clientConfiguration, updateInstanceCustomHealthStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ServiceDiscovery");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateInstanceCustomHealthStatus");
            UpdateInstanceCustomHealthStatusResponse updateInstanceCustomHealthStatusResponse = (UpdateInstanceCustomHealthStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateInstanceCustomHealthStatus").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateInstanceCustomHealthStatusRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateInstanceCustomHealthStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateInstanceCustomHealthStatusResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceDiscoveryClient.lambda$updateInstanceCustomHealthStatus$51((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdatePrivateDnsNamespaceResponse updatePrivateDnsNamespace(UpdatePrivateDnsNamespaceRequest updatePrivateDnsNamespaceRequest) throws InvalidInputException, NamespaceNotFoundException, ResourceInUseException, DuplicateRequestException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdatePrivateDnsNamespaceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "ResourceInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "DuplicateRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                }
                case "ServiceAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAlreadyExistsException::builder).build());
                }
                case "ServiceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "InstanceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InstanceNotFoundException::builder).build());
                }
                case "OperationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotFoundException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "ServiceAttributesLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAttributesLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAttributesLimitExceededException::builder).build());
                }
                case "NamespaceAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceAlreadyExistsException::builder).build());
                }
                case "NamespaceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "CustomHealthNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomHealthNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomHealthNotFoundException::builder).build());
                }
                case "ResourceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updatePrivateDnsNamespaceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceDiscoveryClient.resolveMetricPublishers(clientConfiguration, updatePrivateDnsNamespaceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ServiceDiscovery");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdatePrivateDnsNamespace");
            UpdatePrivateDnsNamespaceResponse updatePrivateDnsNamespaceResponse = (UpdatePrivateDnsNamespaceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdatePrivateDnsNamespace").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updatePrivateDnsNamespaceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdatePrivateDnsNamespaceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updatePrivateDnsNamespaceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceDiscoveryClient.lambda$updatePrivateDnsNamespace$53((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdatePublicDnsNamespaceResponse updatePublicDnsNamespace(UpdatePublicDnsNamespaceRequest updatePublicDnsNamespaceRequest) throws InvalidInputException, NamespaceNotFoundException, ResourceInUseException, DuplicateRequestException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdatePublicDnsNamespaceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "ResourceInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "DuplicateRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                }
                case "ServiceAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAlreadyExistsException::builder).build());
                }
                case "ServiceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "InstanceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InstanceNotFoundException::builder).build());
                }
                case "OperationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotFoundException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "ServiceAttributesLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAttributesLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAttributesLimitExceededException::builder).build());
                }
                case "NamespaceAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceAlreadyExistsException::builder).build());
                }
                case "NamespaceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "CustomHealthNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomHealthNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomHealthNotFoundException::builder).build());
                }
                case "ResourceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updatePublicDnsNamespaceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceDiscoveryClient.resolveMetricPublishers(clientConfiguration, updatePublicDnsNamespaceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ServiceDiscovery");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdatePublicDnsNamespace");
            UpdatePublicDnsNamespaceResponse updatePublicDnsNamespaceResponse = (UpdatePublicDnsNamespaceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdatePublicDnsNamespace").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updatePublicDnsNamespaceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdatePublicDnsNamespaceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updatePublicDnsNamespaceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceDiscoveryClient.lambda$updatePublicDnsNamespace$55((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateServiceResponse updateService(UpdateServiceRequest updateServiceRequest) throws DuplicateRequestException, InvalidInputException, ServiceNotFoundException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateServiceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "ResourceInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "DuplicateRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                }
                case "ServiceAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAlreadyExistsException::builder).build());
                }
                case "ServiceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "InstanceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InstanceNotFoundException::builder).build());
                }
                case "OperationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotFoundException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "ServiceAttributesLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAttributesLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAttributesLimitExceededException::builder).build());
                }
                case "NamespaceAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceAlreadyExistsException::builder).build());
                }
                case "NamespaceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "CustomHealthNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomHealthNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomHealthNotFoundException::builder).build());
                }
                case "ResourceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateServiceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceDiscoveryClient.resolveMetricPublishers(clientConfiguration, updateServiceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ServiceDiscovery");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateService");
            UpdateServiceResponse updateServiceResponse = (UpdateServiceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateService").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateServiceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateServiceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateServiceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceDiscoveryClient.lambda$updateService$57((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateServiceAttributesResponse updateServiceAttributes(UpdateServiceAttributesRequest updateServiceAttributesRequest) throws InvalidInputException, ServiceNotFoundException, ServiceAttributesLimitExceededException, AwsServiceException, SdkClientException, ServiceDiscoveryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateServiceAttributesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "ResourceInUse": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "DuplicateRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                }
                case "ServiceAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAlreadyExistsException::builder).build());
                }
                case "ServiceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                }
                case "InstanceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InstanceNotFoundException::builder).build());
                }
                case "OperationNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotFoundException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "ServiceAttributesLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAttributesLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAttributesLimitExceededException::builder).build());
                }
                case "NamespaceAlreadyExists": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceAlreadyExistsException::builder).build());
                }
                case "NamespaceNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                }
                case "CustomHealthNotFound": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CustomHealthNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomHealthNotFoundException::builder).build());
                }
                case "ResourceLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateServiceAttributesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceDiscoveryClient.resolveMetricPublishers(clientConfiguration, updateServiceAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ServiceDiscovery");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateServiceAttributes");
            UpdateServiceAttributesResponse updateServiceAttributesResponse = (UpdateServiceAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateServiceAttributes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateServiceAttributesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateServiceAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateServiceAttributesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceDiscoveryClient.lambda$updateServiceAttributes$59((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "servicediscovery";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        ServiceDiscoveryServiceClientConfigurationBuilder serviceConfigBuilder = new ServiceDiscoveryServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(ServiceDiscoveryException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1");
    }

    @Override
    public final ServiceDiscoveryServiceClientConfiguration serviceClientConfiguration() {
        return new ServiceDiscoveryServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateServiceAttributes$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateService$57(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updatePublicDnsNamespace$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updatePrivateDnsNamespace$53(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateInstanceCustomHealthStatus$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateHttpNamespace$49(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$45(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$registerInstance$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listServices$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listOperations$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listNamespaces$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listInstances$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getServiceAttributes$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getService$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getOperation$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getNamespace$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getInstancesHealthStatus$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getInstance$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$discoverInstancesRevision$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$discoverInstances$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deregisterInstance$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteServiceAttributes$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteService$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteNamespace$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createService$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createPublicDnsNamespace$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createPrivateDnsNamespace$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createHttpNamespace$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

