/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.servicediscovery.ServiceDiscoveryAsyncClient;
import software.amazon.awssdk.services.servicediscovery.ServiceDiscoveryServiceClientConfiguration;
import software.amazon.awssdk.services.servicediscovery.internal.ServiceDiscoveryServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.servicediscovery.model.CreateHttpNamespaceRequest;
import software.amazon.awssdk.services.servicediscovery.model.CreateHttpNamespaceResponse;
import software.amazon.awssdk.services.servicediscovery.model.CreatePrivateDnsNamespaceRequest;
import software.amazon.awssdk.services.servicediscovery.model.CreatePrivateDnsNamespaceResponse;
import software.amazon.awssdk.services.servicediscovery.model.CreatePublicDnsNamespaceRequest;
import software.amazon.awssdk.services.servicediscovery.model.CreatePublicDnsNamespaceResponse;
import software.amazon.awssdk.services.servicediscovery.model.CreateServiceRequest;
import software.amazon.awssdk.services.servicediscovery.model.CreateServiceResponse;
import software.amazon.awssdk.services.servicediscovery.model.CustomHealthNotFoundException;
import software.amazon.awssdk.services.servicediscovery.model.DeleteNamespaceRequest;
import software.amazon.awssdk.services.servicediscovery.model.DeleteNamespaceResponse;
import software.amazon.awssdk.services.servicediscovery.model.DeleteServiceAttributesRequest;
import software.amazon.awssdk.services.servicediscovery.model.DeleteServiceAttributesResponse;
import software.amazon.awssdk.services.servicediscovery.model.DeleteServiceRequest;
import software.amazon.awssdk.services.servicediscovery.model.DeleteServiceResponse;
import software.amazon.awssdk.services.servicediscovery.model.DeregisterInstanceRequest;
import software.amazon.awssdk.services.servicediscovery.model.DeregisterInstanceResponse;
import software.amazon.awssdk.services.servicediscovery.model.DiscoverInstancesRequest;
import software.amazon.awssdk.services.servicediscovery.model.DiscoverInstancesResponse;
import software.amazon.awssdk.services.servicediscovery.model.DiscoverInstancesRevisionRequest;
import software.amazon.awssdk.services.servicediscovery.model.DiscoverInstancesRevisionResponse;
import software.amazon.awssdk.services.servicediscovery.model.DuplicateRequestException;
import software.amazon.awssdk.services.servicediscovery.model.GetInstanceRequest;
import software.amazon.awssdk.services.servicediscovery.model.GetInstanceResponse;
import software.amazon.awssdk.services.servicediscovery.model.GetInstancesHealthStatusRequest;
import software.amazon.awssdk.services.servicediscovery.model.GetInstancesHealthStatusResponse;
import software.amazon.awssdk.services.servicediscovery.model.GetNamespaceRequest;
import software.amazon.awssdk.services.servicediscovery.model.GetNamespaceResponse;
import software.amazon.awssdk.services.servicediscovery.model.GetOperationRequest;
import software.amazon.awssdk.services.servicediscovery.model.GetOperationResponse;
import software.amazon.awssdk.services.servicediscovery.model.GetServiceAttributesRequest;
import software.amazon.awssdk.services.servicediscovery.model.GetServiceAttributesResponse;
import software.amazon.awssdk.services.servicediscovery.model.GetServiceRequest;
import software.amazon.awssdk.services.servicediscovery.model.GetServiceResponse;
import software.amazon.awssdk.services.servicediscovery.model.InstanceNotFoundException;
import software.amazon.awssdk.services.servicediscovery.model.InvalidInputException;
import software.amazon.awssdk.services.servicediscovery.model.ListInstancesRequest;
import software.amazon.awssdk.services.servicediscovery.model.ListInstancesResponse;
import software.amazon.awssdk.services.servicediscovery.model.ListNamespacesRequest;
import software.amazon.awssdk.services.servicediscovery.model.ListNamespacesResponse;
import software.amazon.awssdk.services.servicediscovery.model.ListOperationsRequest;
import software.amazon.awssdk.services.servicediscovery.model.ListOperationsResponse;
import software.amazon.awssdk.services.servicediscovery.model.ListServicesRequest;
import software.amazon.awssdk.services.servicediscovery.model.ListServicesResponse;
import software.amazon.awssdk.services.servicediscovery.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.servicediscovery.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.servicediscovery.model.NamespaceAlreadyExistsException;
import software.amazon.awssdk.services.servicediscovery.model.NamespaceNotFoundException;
import software.amazon.awssdk.services.servicediscovery.model.OperationNotFoundException;
import software.amazon.awssdk.services.servicediscovery.model.RegisterInstanceRequest;
import software.amazon.awssdk.services.servicediscovery.model.RegisterInstanceResponse;
import software.amazon.awssdk.services.servicediscovery.model.RequestLimitExceededException;
import software.amazon.awssdk.services.servicediscovery.model.ResourceInUseException;
import software.amazon.awssdk.services.servicediscovery.model.ResourceLimitExceededException;
import software.amazon.awssdk.services.servicediscovery.model.ResourceNotFoundException;
import software.amazon.awssdk.services.servicediscovery.model.ServiceAlreadyExistsException;
import software.amazon.awssdk.services.servicediscovery.model.ServiceAttributesLimitExceededException;
import software.amazon.awssdk.services.servicediscovery.model.ServiceDiscoveryException;
import software.amazon.awssdk.services.servicediscovery.model.ServiceNotFoundException;
import software.amazon.awssdk.services.servicediscovery.model.TagResourceRequest;
import software.amazon.awssdk.services.servicediscovery.model.TagResourceResponse;
import software.amazon.awssdk.services.servicediscovery.model.TooManyTagsException;
import software.amazon.awssdk.services.servicediscovery.model.UntagResourceRequest;
import software.amazon.awssdk.services.servicediscovery.model.UntagResourceResponse;
import software.amazon.awssdk.services.servicediscovery.model.UpdateHttpNamespaceRequest;
import software.amazon.awssdk.services.servicediscovery.model.UpdateHttpNamespaceResponse;
import software.amazon.awssdk.services.servicediscovery.model.UpdateInstanceCustomHealthStatusRequest;
import software.amazon.awssdk.services.servicediscovery.model.UpdateInstanceCustomHealthStatusResponse;
import software.amazon.awssdk.services.servicediscovery.model.UpdatePrivateDnsNamespaceRequest;
import software.amazon.awssdk.services.servicediscovery.model.UpdatePrivateDnsNamespaceResponse;
import software.amazon.awssdk.services.servicediscovery.model.UpdatePublicDnsNamespaceRequest;
import software.amazon.awssdk.services.servicediscovery.model.UpdatePublicDnsNamespaceResponse;
import software.amazon.awssdk.services.servicediscovery.model.UpdateServiceAttributesRequest;
import software.amazon.awssdk.services.servicediscovery.model.UpdateServiceAttributesResponse;
import software.amazon.awssdk.services.servicediscovery.model.UpdateServiceRequest;
import software.amazon.awssdk.services.servicediscovery.model.UpdateServiceResponse;
import software.amazon.awssdk.services.servicediscovery.transform.CreateHttpNamespaceRequestMarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.CreatePrivateDnsNamespaceRequestMarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.CreatePublicDnsNamespaceRequestMarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.CreateServiceRequestMarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.DeleteNamespaceRequestMarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.DeleteServiceAttributesRequestMarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.DeleteServiceRequestMarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.DeregisterInstanceRequestMarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.DiscoverInstancesRequestMarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.DiscoverInstancesRevisionRequestMarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.GetInstanceRequestMarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.GetInstancesHealthStatusRequestMarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.GetNamespaceRequestMarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.GetOperationRequestMarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.GetServiceAttributesRequestMarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.GetServiceRequestMarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.ListInstancesRequestMarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.ListNamespacesRequestMarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.ListOperationsRequestMarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.ListServicesRequestMarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.RegisterInstanceRequestMarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.UpdateHttpNamespaceRequestMarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.UpdateInstanceCustomHealthStatusRequestMarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.UpdatePrivateDnsNamespaceRequestMarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.UpdatePublicDnsNamespaceRequestMarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.UpdateServiceAttributesRequestMarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.UpdateServiceRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultServiceDiscoveryAsyncClient
implements ServiceDiscoveryAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultServiceDiscoveryAsyncClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultServiceDiscoveryAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"ServiceDiscovery#2.34.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public CompletableFuture<CreateHttpNamespaceResponse> createHttpNamespace(CreateHttpNamespaceRequest createHttpNamespaceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createHttpNamespaceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceDiscoveryAsyncClient.resolveMetricPublishers(clientConfiguration, createHttpNamespaceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ServiceDiscovery");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateHttpNamespace");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateHttpNamespaceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "ResourceInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "DuplicateRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                    }
                    case "ServiceAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAlreadyExistsException::builder).build());
                    }
                    case "ServiceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "InstanceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InstanceNotFoundException::builder).build());
                    }
                    case "OperationNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotFoundException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "ServiceAttributesLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAttributesLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAttributesLimitExceededException::builder).build());
                    }
                    case "NamespaceAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceAlreadyExistsException::builder).build());
                    }
                    case "NamespaceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "CustomHealthNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomHealthNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomHealthNotFoundException::builder).build());
                    }
                    case "ResourceLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateHttpNamespace").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateHttpNamespaceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createHttpNamespaceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultServiceDiscoveryAsyncClient.lambda$createHttpNamespace$2(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultServiceDiscoveryAsyncClient.lambda$createHttpNamespace$3((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreatePrivateDnsNamespaceResponse> createPrivateDnsNamespace(CreatePrivateDnsNamespaceRequest createPrivateDnsNamespaceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createPrivateDnsNamespaceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceDiscoveryAsyncClient.resolveMetricPublishers(clientConfiguration, createPrivateDnsNamespaceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ServiceDiscovery");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreatePrivateDnsNamespace");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreatePrivateDnsNamespaceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "ResourceInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "DuplicateRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                    }
                    case "ServiceAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAlreadyExistsException::builder).build());
                    }
                    case "ServiceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "InstanceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InstanceNotFoundException::builder).build());
                    }
                    case "OperationNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotFoundException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "ServiceAttributesLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAttributesLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAttributesLimitExceededException::builder).build());
                    }
                    case "NamespaceAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceAlreadyExistsException::builder).build());
                    }
                    case "NamespaceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "CustomHealthNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomHealthNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomHealthNotFoundException::builder).build());
                    }
                    case "ResourceLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreatePrivateDnsNamespace").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreatePrivateDnsNamespaceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createPrivateDnsNamespaceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultServiceDiscoveryAsyncClient.lambda$createPrivateDnsNamespace$6(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultServiceDiscoveryAsyncClient.lambda$createPrivateDnsNamespace$7((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreatePublicDnsNamespaceResponse> createPublicDnsNamespace(CreatePublicDnsNamespaceRequest createPublicDnsNamespaceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createPublicDnsNamespaceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceDiscoveryAsyncClient.resolveMetricPublishers(clientConfiguration, createPublicDnsNamespaceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ServiceDiscovery");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreatePublicDnsNamespace");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreatePublicDnsNamespaceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "ResourceInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "DuplicateRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                    }
                    case "ServiceAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAlreadyExistsException::builder).build());
                    }
                    case "ServiceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "InstanceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InstanceNotFoundException::builder).build());
                    }
                    case "OperationNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotFoundException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "ServiceAttributesLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAttributesLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAttributesLimitExceededException::builder).build());
                    }
                    case "NamespaceAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceAlreadyExistsException::builder).build());
                    }
                    case "NamespaceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "CustomHealthNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomHealthNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomHealthNotFoundException::builder).build());
                    }
                    case "ResourceLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreatePublicDnsNamespace").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreatePublicDnsNamespaceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createPublicDnsNamespaceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultServiceDiscoveryAsyncClient.lambda$createPublicDnsNamespace$10(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultServiceDiscoveryAsyncClient.lambda$createPublicDnsNamespace$11((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateServiceResponse> createService(CreateServiceRequest createServiceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createServiceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceDiscoveryAsyncClient.resolveMetricPublishers(clientConfiguration, createServiceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ServiceDiscovery");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateService");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateServiceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "ResourceInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "DuplicateRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                    }
                    case "ServiceAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAlreadyExistsException::builder).build());
                    }
                    case "ServiceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "InstanceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InstanceNotFoundException::builder).build());
                    }
                    case "OperationNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotFoundException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "ServiceAttributesLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAttributesLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAttributesLimitExceededException::builder).build());
                    }
                    case "NamespaceAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceAlreadyExistsException::builder).build());
                    }
                    case "NamespaceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "CustomHealthNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomHealthNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomHealthNotFoundException::builder).build());
                    }
                    case "ResourceLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateService").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateServiceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createServiceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultServiceDiscoveryAsyncClient.lambda$createService$14(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultServiceDiscoveryAsyncClient.lambda$createService$15((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteNamespaceResponse> deleteNamespace(DeleteNamespaceRequest deleteNamespaceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteNamespaceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceDiscoveryAsyncClient.resolveMetricPublishers(clientConfiguration, deleteNamespaceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ServiceDiscovery");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteNamespace");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteNamespaceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "ResourceInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "DuplicateRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                    }
                    case "ServiceAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAlreadyExistsException::builder).build());
                    }
                    case "ServiceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "InstanceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InstanceNotFoundException::builder).build());
                    }
                    case "OperationNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotFoundException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "ServiceAttributesLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAttributesLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAttributesLimitExceededException::builder).build());
                    }
                    case "NamespaceAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceAlreadyExistsException::builder).build());
                    }
                    case "NamespaceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "CustomHealthNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomHealthNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomHealthNotFoundException::builder).build());
                    }
                    case "ResourceLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteNamespace").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteNamespaceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteNamespaceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultServiceDiscoveryAsyncClient.lambda$deleteNamespace$18(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultServiceDiscoveryAsyncClient.lambda$deleteNamespace$19((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteServiceResponse> deleteService(DeleteServiceRequest deleteServiceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteServiceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceDiscoveryAsyncClient.resolveMetricPublishers(clientConfiguration, deleteServiceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ServiceDiscovery");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteService");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteServiceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "ResourceInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "DuplicateRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                    }
                    case "ServiceAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAlreadyExistsException::builder).build());
                    }
                    case "ServiceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "InstanceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InstanceNotFoundException::builder).build());
                    }
                    case "OperationNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotFoundException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "ServiceAttributesLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAttributesLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAttributesLimitExceededException::builder).build());
                    }
                    case "NamespaceAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceAlreadyExistsException::builder).build());
                    }
                    case "NamespaceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "CustomHealthNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomHealthNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomHealthNotFoundException::builder).build());
                    }
                    case "ResourceLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteService").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteServiceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteServiceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultServiceDiscoveryAsyncClient.lambda$deleteService$22(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultServiceDiscoveryAsyncClient.lambda$deleteService$23((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteServiceAttributesResponse> deleteServiceAttributes(DeleteServiceAttributesRequest deleteServiceAttributesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteServiceAttributesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceDiscoveryAsyncClient.resolveMetricPublishers(clientConfiguration, deleteServiceAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ServiceDiscovery");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteServiceAttributes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteServiceAttributesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "ResourceInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "DuplicateRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                    }
                    case "ServiceAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAlreadyExistsException::builder).build());
                    }
                    case "ServiceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "InstanceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InstanceNotFoundException::builder).build());
                    }
                    case "OperationNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotFoundException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "ServiceAttributesLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAttributesLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAttributesLimitExceededException::builder).build());
                    }
                    case "NamespaceAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceAlreadyExistsException::builder).build());
                    }
                    case "NamespaceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "CustomHealthNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomHealthNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomHealthNotFoundException::builder).build());
                    }
                    case "ResourceLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteServiceAttributes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteServiceAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteServiceAttributesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultServiceDiscoveryAsyncClient.lambda$deleteServiceAttributes$26(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultServiceDiscoveryAsyncClient.lambda$deleteServiceAttributes$27((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeregisterInstanceResponse> deregisterInstance(DeregisterInstanceRequest deregisterInstanceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deregisterInstanceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceDiscoveryAsyncClient.resolveMetricPublishers(clientConfiguration, deregisterInstanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ServiceDiscovery");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeregisterInstance");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeregisterInstanceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "ResourceInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "DuplicateRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                    }
                    case "ServiceAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAlreadyExistsException::builder).build());
                    }
                    case "ServiceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "InstanceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InstanceNotFoundException::builder).build());
                    }
                    case "OperationNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotFoundException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "ServiceAttributesLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAttributesLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAttributesLimitExceededException::builder).build());
                    }
                    case "NamespaceAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceAlreadyExistsException::builder).build());
                    }
                    case "NamespaceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "CustomHealthNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomHealthNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomHealthNotFoundException::builder).build());
                    }
                    case "ResourceLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeregisterInstance").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeregisterInstanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deregisterInstanceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultServiceDiscoveryAsyncClient.lambda$deregisterInstance$30(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultServiceDiscoveryAsyncClient.lambda$deregisterInstance$31((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DiscoverInstancesResponse> discoverInstances(DiscoverInstancesRequest discoverInstancesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)discoverInstancesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceDiscoveryAsyncClient.resolveMetricPublishers(clientConfiguration, discoverInstancesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ServiceDiscovery");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DiscoverInstances");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DiscoverInstancesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "ResourceInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "DuplicateRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                    }
                    case "ServiceAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAlreadyExistsException::builder).build());
                    }
                    case "ServiceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "InstanceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InstanceNotFoundException::builder).build());
                    }
                    case "OperationNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotFoundException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "ServiceAttributesLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAttributesLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAttributesLimitExceededException::builder).build());
                    }
                    case "NamespaceAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceAlreadyExistsException::builder).build());
                    }
                    case "NamespaceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "CustomHealthNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomHealthNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomHealthNotFoundException::builder).build());
                    }
                    case "ResourceLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "data-";
            String resolvedHostExpression = "data-";
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DiscoverInstances").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DiscoverInstancesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)discoverInstancesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultServiceDiscoveryAsyncClient.lambda$discoverInstances$34(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultServiceDiscoveryAsyncClient.lambda$discoverInstances$35((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DiscoverInstancesRevisionResponse> discoverInstancesRevision(DiscoverInstancesRevisionRequest discoverInstancesRevisionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)discoverInstancesRevisionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceDiscoveryAsyncClient.resolveMetricPublishers(clientConfiguration, discoverInstancesRevisionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ServiceDiscovery");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DiscoverInstancesRevision");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DiscoverInstancesRevisionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "ResourceInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "DuplicateRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                    }
                    case "ServiceAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAlreadyExistsException::builder).build());
                    }
                    case "ServiceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "InstanceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InstanceNotFoundException::builder).build());
                    }
                    case "OperationNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotFoundException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "ServiceAttributesLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAttributesLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAttributesLimitExceededException::builder).build());
                    }
                    case "NamespaceAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceAlreadyExistsException::builder).build());
                    }
                    case "NamespaceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "CustomHealthNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomHealthNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomHealthNotFoundException::builder).build());
                    }
                    case "ResourceLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "data-";
            String resolvedHostExpression = "data-";
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DiscoverInstancesRevision").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DiscoverInstancesRevisionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)discoverInstancesRevisionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultServiceDiscoveryAsyncClient.lambda$discoverInstancesRevision$38(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultServiceDiscoveryAsyncClient.lambda$discoverInstancesRevision$39((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetInstanceResponse> getInstance(GetInstanceRequest getInstanceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getInstanceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceDiscoveryAsyncClient.resolveMetricPublishers(clientConfiguration, getInstanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ServiceDiscovery");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetInstance");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetInstanceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "ResourceInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "DuplicateRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                    }
                    case "ServiceAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAlreadyExistsException::builder).build());
                    }
                    case "ServiceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "InstanceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InstanceNotFoundException::builder).build());
                    }
                    case "OperationNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotFoundException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "ServiceAttributesLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAttributesLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAttributesLimitExceededException::builder).build());
                    }
                    case "NamespaceAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceAlreadyExistsException::builder).build());
                    }
                    case "NamespaceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "CustomHealthNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomHealthNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomHealthNotFoundException::builder).build());
                    }
                    case "ResourceLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetInstance").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetInstanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getInstanceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultServiceDiscoveryAsyncClient.lambda$getInstance$42(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultServiceDiscoveryAsyncClient.lambda$getInstance$43((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetInstancesHealthStatusResponse> getInstancesHealthStatus(GetInstancesHealthStatusRequest getInstancesHealthStatusRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getInstancesHealthStatusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceDiscoveryAsyncClient.resolveMetricPublishers(clientConfiguration, getInstancesHealthStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ServiceDiscovery");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetInstancesHealthStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetInstancesHealthStatusResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "ResourceInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "DuplicateRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                    }
                    case "ServiceAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAlreadyExistsException::builder).build());
                    }
                    case "ServiceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "InstanceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InstanceNotFoundException::builder).build());
                    }
                    case "OperationNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotFoundException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "ServiceAttributesLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAttributesLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAttributesLimitExceededException::builder).build());
                    }
                    case "NamespaceAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceAlreadyExistsException::builder).build());
                    }
                    case "NamespaceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "CustomHealthNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomHealthNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomHealthNotFoundException::builder).build());
                    }
                    case "ResourceLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetInstancesHealthStatus").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetInstancesHealthStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getInstancesHealthStatusRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultServiceDiscoveryAsyncClient.lambda$getInstancesHealthStatus$46(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultServiceDiscoveryAsyncClient.lambda$getInstancesHealthStatus$47((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetNamespaceResponse> getNamespace(GetNamespaceRequest getNamespaceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getNamespaceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceDiscoveryAsyncClient.resolveMetricPublishers(clientConfiguration, getNamespaceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ServiceDiscovery");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetNamespace");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetNamespaceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "ResourceInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "DuplicateRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                    }
                    case "ServiceAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAlreadyExistsException::builder).build());
                    }
                    case "ServiceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "InstanceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InstanceNotFoundException::builder).build());
                    }
                    case "OperationNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotFoundException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "ServiceAttributesLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAttributesLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAttributesLimitExceededException::builder).build());
                    }
                    case "NamespaceAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceAlreadyExistsException::builder).build());
                    }
                    case "NamespaceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "CustomHealthNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomHealthNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomHealthNotFoundException::builder).build());
                    }
                    case "ResourceLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetNamespace").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetNamespaceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getNamespaceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultServiceDiscoveryAsyncClient.lambda$getNamespace$50(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultServiceDiscoveryAsyncClient.lambda$getNamespace$51((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetOperationResponse> getOperation(GetOperationRequest getOperationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getOperationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceDiscoveryAsyncClient.resolveMetricPublishers(clientConfiguration, getOperationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ServiceDiscovery");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetOperation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetOperationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "ResourceInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "DuplicateRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                    }
                    case "ServiceAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAlreadyExistsException::builder).build());
                    }
                    case "ServiceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "InstanceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InstanceNotFoundException::builder).build());
                    }
                    case "OperationNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotFoundException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "ServiceAttributesLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAttributesLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAttributesLimitExceededException::builder).build());
                    }
                    case "NamespaceAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceAlreadyExistsException::builder).build());
                    }
                    case "NamespaceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "CustomHealthNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomHealthNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomHealthNotFoundException::builder).build());
                    }
                    case "ResourceLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetOperation").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetOperationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getOperationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultServiceDiscoveryAsyncClient.lambda$getOperation$54(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultServiceDiscoveryAsyncClient.lambda$getOperation$55((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetServiceResponse> getService(GetServiceRequest getServiceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getServiceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceDiscoveryAsyncClient.resolveMetricPublishers(clientConfiguration, getServiceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ServiceDiscovery");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetService");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetServiceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "ResourceInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "DuplicateRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                    }
                    case "ServiceAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAlreadyExistsException::builder).build());
                    }
                    case "ServiceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "InstanceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InstanceNotFoundException::builder).build());
                    }
                    case "OperationNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotFoundException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "ServiceAttributesLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAttributesLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAttributesLimitExceededException::builder).build());
                    }
                    case "NamespaceAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceAlreadyExistsException::builder).build());
                    }
                    case "NamespaceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "CustomHealthNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomHealthNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomHealthNotFoundException::builder).build());
                    }
                    case "ResourceLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetService").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetServiceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getServiceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultServiceDiscoveryAsyncClient.lambda$getService$58(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultServiceDiscoveryAsyncClient.lambda$getService$59((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetServiceAttributesResponse> getServiceAttributes(GetServiceAttributesRequest getServiceAttributesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getServiceAttributesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceDiscoveryAsyncClient.resolveMetricPublishers(clientConfiguration, getServiceAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ServiceDiscovery");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetServiceAttributes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetServiceAttributesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "ResourceInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "DuplicateRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                    }
                    case "ServiceAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAlreadyExistsException::builder).build());
                    }
                    case "ServiceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "InstanceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InstanceNotFoundException::builder).build());
                    }
                    case "OperationNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotFoundException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "ServiceAttributesLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAttributesLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAttributesLimitExceededException::builder).build());
                    }
                    case "NamespaceAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceAlreadyExistsException::builder).build());
                    }
                    case "NamespaceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "CustomHealthNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomHealthNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomHealthNotFoundException::builder).build());
                    }
                    case "ResourceLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetServiceAttributes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetServiceAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getServiceAttributesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultServiceDiscoveryAsyncClient.lambda$getServiceAttributes$62(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultServiceDiscoveryAsyncClient.lambda$getServiceAttributes$63((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListInstancesResponse> listInstances(ListInstancesRequest listInstancesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listInstancesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceDiscoveryAsyncClient.resolveMetricPublishers(clientConfiguration, listInstancesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ServiceDiscovery");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListInstances");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListInstancesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "ResourceInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "DuplicateRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                    }
                    case "ServiceAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAlreadyExistsException::builder).build());
                    }
                    case "ServiceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "InstanceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InstanceNotFoundException::builder).build());
                    }
                    case "OperationNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotFoundException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "ServiceAttributesLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAttributesLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAttributesLimitExceededException::builder).build());
                    }
                    case "NamespaceAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceAlreadyExistsException::builder).build());
                    }
                    case "NamespaceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "CustomHealthNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomHealthNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomHealthNotFoundException::builder).build());
                    }
                    case "ResourceLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListInstances").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListInstancesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listInstancesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultServiceDiscoveryAsyncClient.lambda$listInstances$66(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultServiceDiscoveryAsyncClient.lambda$listInstances$67((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListNamespacesResponse> listNamespaces(ListNamespacesRequest listNamespacesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listNamespacesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceDiscoveryAsyncClient.resolveMetricPublishers(clientConfiguration, listNamespacesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ServiceDiscovery");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListNamespaces");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListNamespacesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "ResourceInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "DuplicateRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                    }
                    case "ServiceAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAlreadyExistsException::builder).build());
                    }
                    case "ServiceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "InstanceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InstanceNotFoundException::builder).build());
                    }
                    case "OperationNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotFoundException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "ServiceAttributesLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAttributesLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAttributesLimitExceededException::builder).build());
                    }
                    case "NamespaceAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceAlreadyExistsException::builder).build());
                    }
                    case "NamespaceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "CustomHealthNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomHealthNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomHealthNotFoundException::builder).build());
                    }
                    case "ResourceLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListNamespaces").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListNamespacesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listNamespacesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultServiceDiscoveryAsyncClient.lambda$listNamespaces$70(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultServiceDiscoveryAsyncClient.lambda$listNamespaces$71((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListOperationsResponse> listOperations(ListOperationsRequest listOperationsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listOperationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceDiscoveryAsyncClient.resolveMetricPublishers(clientConfiguration, listOperationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ServiceDiscovery");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListOperations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListOperationsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "ResourceInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "DuplicateRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                    }
                    case "ServiceAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAlreadyExistsException::builder).build());
                    }
                    case "ServiceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "InstanceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InstanceNotFoundException::builder).build());
                    }
                    case "OperationNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotFoundException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "ServiceAttributesLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAttributesLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAttributesLimitExceededException::builder).build());
                    }
                    case "NamespaceAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceAlreadyExistsException::builder).build());
                    }
                    case "NamespaceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "CustomHealthNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomHealthNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomHealthNotFoundException::builder).build());
                    }
                    case "ResourceLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListOperations").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListOperationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listOperationsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultServiceDiscoveryAsyncClient.lambda$listOperations$74(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultServiceDiscoveryAsyncClient.lambda$listOperations$75((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListServicesResponse> listServices(ListServicesRequest listServicesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listServicesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceDiscoveryAsyncClient.resolveMetricPublishers(clientConfiguration, listServicesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ServiceDiscovery");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListServices");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListServicesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "ResourceInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "DuplicateRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                    }
                    case "ServiceAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAlreadyExistsException::builder).build());
                    }
                    case "ServiceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "InstanceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InstanceNotFoundException::builder).build());
                    }
                    case "OperationNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotFoundException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "ServiceAttributesLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAttributesLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAttributesLimitExceededException::builder).build());
                    }
                    case "NamespaceAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceAlreadyExistsException::builder).build());
                    }
                    case "NamespaceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "CustomHealthNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomHealthNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomHealthNotFoundException::builder).build());
                    }
                    case "ResourceLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListServices").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListServicesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listServicesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultServiceDiscoveryAsyncClient.lambda$listServices$78(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultServiceDiscoveryAsyncClient.lambda$listServices$79((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceDiscoveryAsyncClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ServiceDiscovery");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "ResourceInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "DuplicateRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                    }
                    case "ServiceAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAlreadyExistsException::builder).build());
                    }
                    case "ServiceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "InstanceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InstanceNotFoundException::builder).build());
                    }
                    case "OperationNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotFoundException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "ServiceAttributesLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAttributesLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAttributesLimitExceededException::builder).build());
                    }
                    case "NamespaceAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceAlreadyExistsException::builder).build());
                    }
                    case "NamespaceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "CustomHealthNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomHealthNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomHealthNotFoundException::builder).build());
                    }
                    case "ResourceLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listTagsForResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultServiceDiscoveryAsyncClient.lambda$listTagsForResource$82(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultServiceDiscoveryAsyncClient.lambda$listTagsForResource$83((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RegisterInstanceResponse> registerInstance(RegisterInstanceRequest registerInstanceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)registerInstanceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceDiscoveryAsyncClient.resolveMetricPublishers(clientConfiguration, registerInstanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ServiceDiscovery");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RegisterInstance");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RegisterInstanceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "ResourceInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "DuplicateRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                    }
                    case "ServiceAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAlreadyExistsException::builder).build());
                    }
                    case "ServiceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "InstanceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InstanceNotFoundException::builder).build());
                    }
                    case "OperationNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotFoundException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "ServiceAttributesLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAttributesLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAttributesLimitExceededException::builder).build());
                    }
                    case "NamespaceAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceAlreadyExistsException::builder).build());
                    }
                    case "NamespaceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "CustomHealthNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomHealthNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomHealthNotFoundException::builder).build());
                    }
                    case "ResourceLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RegisterInstance").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RegisterInstanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)registerInstanceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultServiceDiscoveryAsyncClient.lambda$registerInstance$86(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultServiceDiscoveryAsyncClient.lambda$registerInstance$87((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceDiscoveryAsyncClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ServiceDiscovery");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "ResourceInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "DuplicateRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                    }
                    case "ServiceAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAlreadyExistsException::builder).build());
                    }
                    case "ServiceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "InstanceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InstanceNotFoundException::builder).build());
                    }
                    case "OperationNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotFoundException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "ServiceAttributesLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAttributesLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAttributesLimitExceededException::builder).build());
                    }
                    case "NamespaceAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceAlreadyExistsException::builder).build());
                    }
                    case "NamespaceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "CustomHealthNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomHealthNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomHealthNotFoundException::builder).build());
                    }
                    case "ResourceLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)tagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultServiceDiscoveryAsyncClient.lambda$tagResource$90(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultServiceDiscoveryAsyncClient.lambda$tagResource$91((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceDiscoveryAsyncClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ServiceDiscovery");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "ResourceInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "DuplicateRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                    }
                    case "ServiceAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAlreadyExistsException::builder).build());
                    }
                    case "ServiceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "InstanceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InstanceNotFoundException::builder).build());
                    }
                    case "OperationNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotFoundException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "ServiceAttributesLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAttributesLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAttributesLimitExceededException::builder).build());
                    }
                    case "NamespaceAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceAlreadyExistsException::builder).build());
                    }
                    case "NamespaceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "CustomHealthNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomHealthNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomHealthNotFoundException::builder).build());
                    }
                    case "ResourceLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)untagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultServiceDiscoveryAsyncClient.lambda$untagResource$94(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultServiceDiscoveryAsyncClient.lambda$untagResource$95((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateHttpNamespaceResponse> updateHttpNamespace(UpdateHttpNamespaceRequest updateHttpNamespaceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateHttpNamespaceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceDiscoveryAsyncClient.resolveMetricPublishers(clientConfiguration, updateHttpNamespaceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ServiceDiscovery");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateHttpNamespace");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateHttpNamespaceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "ResourceInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "DuplicateRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                    }
                    case "ServiceAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAlreadyExistsException::builder).build());
                    }
                    case "ServiceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "InstanceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InstanceNotFoundException::builder).build());
                    }
                    case "OperationNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotFoundException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "ServiceAttributesLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAttributesLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAttributesLimitExceededException::builder).build());
                    }
                    case "NamespaceAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceAlreadyExistsException::builder).build());
                    }
                    case "NamespaceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "CustomHealthNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomHealthNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomHealthNotFoundException::builder).build());
                    }
                    case "ResourceLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateHttpNamespace").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateHttpNamespaceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateHttpNamespaceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultServiceDiscoveryAsyncClient.lambda$updateHttpNamespace$98(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultServiceDiscoveryAsyncClient.lambda$updateHttpNamespace$99((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateInstanceCustomHealthStatusResponse> updateInstanceCustomHealthStatus(UpdateInstanceCustomHealthStatusRequest updateInstanceCustomHealthStatusRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateInstanceCustomHealthStatusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceDiscoveryAsyncClient.resolveMetricPublishers(clientConfiguration, updateInstanceCustomHealthStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ServiceDiscovery");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateInstanceCustomHealthStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateInstanceCustomHealthStatusResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "ResourceInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "DuplicateRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                    }
                    case "ServiceAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAlreadyExistsException::builder).build());
                    }
                    case "ServiceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "InstanceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InstanceNotFoundException::builder).build());
                    }
                    case "OperationNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotFoundException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "ServiceAttributesLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAttributesLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAttributesLimitExceededException::builder).build());
                    }
                    case "NamespaceAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceAlreadyExistsException::builder).build());
                    }
                    case "NamespaceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "CustomHealthNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomHealthNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomHealthNotFoundException::builder).build());
                    }
                    case "ResourceLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateInstanceCustomHealthStatus").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateInstanceCustomHealthStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateInstanceCustomHealthStatusRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultServiceDiscoveryAsyncClient.lambda$updateInstanceCustomHealthStatus$102(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultServiceDiscoveryAsyncClient.lambda$updateInstanceCustomHealthStatus$103((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdatePrivateDnsNamespaceResponse> updatePrivateDnsNamespace(UpdatePrivateDnsNamespaceRequest updatePrivateDnsNamespaceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updatePrivateDnsNamespaceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceDiscoveryAsyncClient.resolveMetricPublishers(clientConfiguration, updatePrivateDnsNamespaceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ServiceDiscovery");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdatePrivateDnsNamespace");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdatePrivateDnsNamespaceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "ResourceInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "DuplicateRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                    }
                    case "ServiceAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAlreadyExistsException::builder).build());
                    }
                    case "ServiceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "InstanceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InstanceNotFoundException::builder).build());
                    }
                    case "OperationNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotFoundException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "ServiceAttributesLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAttributesLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAttributesLimitExceededException::builder).build());
                    }
                    case "NamespaceAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceAlreadyExistsException::builder).build());
                    }
                    case "NamespaceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "CustomHealthNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomHealthNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomHealthNotFoundException::builder).build());
                    }
                    case "ResourceLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdatePrivateDnsNamespace").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdatePrivateDnsNamespaceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updatePrivateDnsNamespaceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultServiceDiscoveryAsyncClient.lambda$updatePrivateDnsNamespace$106(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultServiceDiscoveryAsyncClient.lambda$updatePrivateDnsNamespace$107((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdatePublicDnsNamespaceResponse> updatePublicDnsNamespace(UpdatePublicDnsNamespaceRequest updatePublicDnsNamespaceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updatePublicDnsNamespaceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceDiscoveryAsyncClient.resolveMetricPublishers(clientConfiguration, updatePublicDnsNamespaceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ServiceDiscovery");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdatePublicDnsNamespace");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdatePublicDnsNamespaceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "ResourceInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "DuplicateRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                    }
                    case "ServiceAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAlreadyExistsException::builder).build());
                    }
                    case "ServiceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "InstanceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InstanceNotFoundException::builder).build());
                    }
                    case "OperationNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotFoundException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "ServiceAttributesLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAttributesLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAttributesLimitExceededException::builder).build());
                    }
                    case "NamespaceAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceAlreadyExistsException::builder).build());
                    }
                    case "NamespaceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "CustomHealthNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomHealthNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomHealthNotFoundException::builder).build());
                    }
                    case "ResourceLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdatePublicDnsNamespace").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdatePublicDnsNamespaceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updatePublicDnsNamespaceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultServiceDiscoveryAsyncClient.lambda$updatePublicDnsNamespace$110(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultServiceDiscoveryAsyncClient.lambda$updatePublicDnsNamespace$111((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateServiceResponse> updateService(UpdateServiceRequest updateServiceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateServiceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceDiscoveryAsyncClient.resolveMetricPublishers(clientConfiguration, updateServiceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ServiceDiscovery");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateService");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateServiceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "ResourceInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "DuplicateRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                    }
                    case "ServiceAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAlreadyExistsException::builder).build());
                    }
                    case "ServiceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "InstanceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InstanceNotFoundException::builder).build());
                    }
                    case "OperationNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotFoundException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "ServiceAttributesLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAttributesLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAttributesLimitExceededException::builder).build());
                    }
                    case "NamespaceAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceAlreadyExistsException::builder).build());
                    }
                    case "NamespaceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "CustomHealthNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomHealthNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomHealthNotFoundException::builder).build());
                    }
                    case "ResourceLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateService").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateServiceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateServiceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultServiceDiscoveryAsyncClient.lambda$updateService$114(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultServiceDiscoveryAsyncClient.lambda$updateService$115((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateServiceAttributesResponse> updateServiceAttributes(UpdateServiceAttributesRequest updateServiceAttributesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateServiceAttributesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceDiscoveryAsyncClient.resolveMetricPublishers(clientConfiguration, updateServiceAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ServiceDiscovery");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateServiceAttributes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateServiceAttributesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "ResourceInUse": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUse").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "DuplicateRequest": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                    }
                    case "ServiceAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAlreadyExistsException::builder).build());
                    }
                    case "ServiceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceNotFoundException::builder).build());
                    }
                    case "InstanceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InstanceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InstanceNotFoundException::builder).build());
                    }
                    case "OperationNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotFoundException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidInput": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                    }
                    case "ServiceAttributesLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceAttributesLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceAttributesLimitExceededException::builder).build());
                    }
                    case "NamespaceAlreadyExists": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceAlreadyExists").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceAlreadyExistsException::builder).build());
                    }
                    case "NamespaceNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NamespaceNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NamespaceNotFoundException::builder).build());
                    }
                    case "CustomHealthNotFound": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomHealthNotFound").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CustomHealthNotFoundException::builder).build());
                    }
                    case "ResourceLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateServiceAttributes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateServiceAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateServiceAttributesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultServiceDiscoveryAsyncClient.lambda$updateServiceAttributes$118(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultServiceDiscoveryAsyncClient.lambda$updateServiceAttributes$119((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public final ServiceDiscoveryServiceClientConfiguration serviceClientConfiguration() {
        return new ServiceDiscoveryServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public final String serviceName() {
        return "servicediscovery";
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(ServiceDiscoveryException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1");
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        ServiceDiscoveryServiceClientConfigurationBuilder serviceConfigBuilder = new ServiceDiscoveryServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateServiceAttributes$119(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateServiceAttributes$118(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateServiceAttributesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateService$115(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateService$114(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateServiceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updatePublicDnsNamespace$111(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updatePublicDnsNamespace$110(List metricPublishers, MetricCollector apiCallMetricCollector, UpdatePublicDnsNamespaceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updatePrivateDnsNamespace$107(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updatePrivateDnsNamespace$106(List metricPublishers, MetricCollector apiCallMetricCollector, UpdatePrivateDnsNamespaceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateInstanceCustomHealthStatus$103(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateInstanceCustomHealthStatus$102(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateInstanceCustomHealthStatusResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateHttpNamespace$99(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateHttpNamespace$98(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateHttpNamespaceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$untagResource$95(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$94(List metricPublishers, MetricCollector apiCallMetricCollector, UntagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$tagResource$91(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$90(List metricPublishers, MetricCollector apiCallMetricCollector, TagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$registerInstance$87(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$registerInstance$86(List metricPublishers, MetricCollector apiCallMetricCollector, RegisterInstanceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listTagsForResource$83(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$82(List metricPublishers, MetricCollector apiCallMetricCollector, ListTagsForResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listServices$79(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listServices$78(List metricPublishers, MetricCollector apiCallMetricCollector, ListServicesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listOperations$75(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listOperations$74(List metricPublishers, MetricCollector apiCallMetricCollector, ListOperationsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listNamespaces$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listNamespaces$70(List metricPublishers, MetricCollector apiCallMetricCollector, ListNamespacesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listInstances$67(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listInstances$66(List metricPublishers, MetricCollector apiCallMetricCollector, ListInstancesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getServiceAttributes$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getServiceAttributes$62(List metricPublishers, MetricCollector apiCallMetricCollector, GetServiceAttributesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getService$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getService$58(List metricPublishers, MetricCollector apiCallMetricCollector, GetServiceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getOperation$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getOperation$54(List metricPublishers, MetricCollector apiCallMetricCollector, GetOperationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getNamespace$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getNamespace$50(List metricPublishers, MetricCollector apiCallMetricCollector, GetNamespaceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getInstancesHealthStatus$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getInstancesHealthStatus$46(List metricPublishers, MetricCollector apiCallMetricCollector, GetInstancesHealthStatusResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getInstance$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getInstance$42(List metricPublishers, MetricCollector apiCallMetricCollector, GetInstanceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$discoverInstancesRevision$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$discoverInstancesRevision$38(List metricPublishers, MetricCollector apiCallMetricCollector, DiscoverInstancesRevisionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$discoverInstances$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$discoverInstances$34(List metricPublishers, MetricCollector apiCallMetricCollector, DiscoverInstancesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deregisterInstance$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deregisterInstance$30(List metricPublishers, MetricCollector apiCallMetricCollector, DeregisterInstanceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteServiceAttributes$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteServiceAttributes$26(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteServiceAttributesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteService$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteService$22(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteServiceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteNamespace$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteNamespace$18(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteNamespaceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createService$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createService$14(List metricPublishers, MetricCollector apiCallMetricCollector, CreateServiceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createPublicDnsNamespace$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createPublicDnsNamespace$10(List metricPublishers, MetricCollector apiCallMetricCollector, CreatePublicDnsNamespaceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createPrivateDnsNamespace$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createPrivateDnsNamespace$6(List metricPublishers, MetricCollector apiCallMetricCollector, CreatePrivateDnsNamespaceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createHttpNamespace$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createHttpNamespace$2(List metricPublishers, MetricCollector apiCallMetricCollector, CreateHttpNamespaceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }
}

