/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.servicediscovery.model.FilterCondition;
import software.amazon.awssdk.services.servicediscovery.model.FilterValuesCopier;
import software.amazon.awssdk.services.servicediscovery.model.NamespaceFilterName;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NamespaceFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NamespaceFilter> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(NamespaceFilter.getter(NamespaceFilter::nameAsString)).setter(NamespaceFilter.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<String>> VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(NamespaceFilter.getter(NamespaceFilter::values)).setter(NamespaceFilter.setter(Builder::values)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(NamespaceFilter.getter(NamespaceFilter::conditionAsString)).setter(NamespaceFilter.setter(Builder::condition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Condition").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, VALUES_FIELD, CONDITION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final List<String> values;
    private final String condition;

    private NamespaceFilter(BuilderImpl builder) {
        this.name = builder.name;
        this.values = builder.values;
        this.condition = builder.condition;
    }

    public NamespaceFilterName name() {
        return NamespaceFilterName.fromValue(this.name);
    }

    public String nameAsString() {
        return this.name;
    }

    public List<String> values() {
        return this.values;
    }

    public FilterCondition condition() {
        return FilterCondition.fromValue(this.condition);
    }

    public String conditionAsString() {
        return this.condition;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.values());
        hashCode = 31 * hashCode + Objects.hashCode(this.conditionAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NamespaceFilter)) {
            return false;
        }
        NamespaceFilter other = (NamespaceFilter)obj;
        return Objects.equals(this.nameAsString(), other.nameAsString()) && Objects.equals(this.values(), other.values()) && Objects.equals(this.conditionAsString(), other.conditionAsString());
    }

    public String toString() {
        return ToString.builder((String)"NamespaceFilter").add("Name", (Object)this.nameAsString()).add("Values", this.values()).add("Condition", (Object)this.conditionAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.nameAsString()));
            }
            case "Values": {
                return Optional.ofNullable(clazz.cast(this.values()));
            }
            case "Condition": {
                return Optional.ofNullable(clazz.cast(this.conditionAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NamespaceFilter, T> g) {
        return obj -> g.apply((NamespaceFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private List<String> values = DefaultSdkAutoConstructList.getInstance();
        private String condition;

        private BuilderImpl() {
        }

        private BuilderImpl(NamespaceFilter model) {
            this.name(model.name);
            this.values(model.values);
            this.condition(model.condition);
        }

        public final String getNameAsString() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(NamespaceFilterName name) {
            this.name(name.toString());
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<String> getValues() {
            return this.values;
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = FilterValuesCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String ... values) {
            this.values(Arrays.asList(values));
            return this;
        }

        public final void setValues(Collection<String> values) {
            this.values = FilterValuesCopier.copy(values);
        }

        public final String getConditionAsString() {
            return this.condition;
        }

        @Override
        public final Builder condition(String condition) {
            this.condition = condition;
            return this;
        }

        @Override
        public final Builder condition(FilterCondition condition) {
            this.condition(condition.toString());
            return this;
        }

        public final void setCondition(String condition) {
            this.condition = condition;
        }

        public NamespaceFilter build() {
            return new NamespaceFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NamespaceFilter> {
        public Builder name(String var1);

        public Builder name(NamespaceFilterName var1);

        public Builder values(Collection<String> var1);

        public Builder values(String ... var1);

        public Builder condition(String var1);

        public Builder condition(FilterCondition var1);
    }
}

