/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that identifies the namespaces that you want to list. You can choose to list public or private
 * namespaces.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NamespaceFilter implements SdkPojo, Serializable, ToCopyableBuilder<NamespaceFilter.Builder, NamespaceFilter> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(NamespaceFilter::nameAsString)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<String>> VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(NamespaceFilter::values))
            .setter(setter(Builder::values))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CONDITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(NamespaceFilter::conditionAsString)).setter(setter(Builder::condition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Condition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, VALUES_FIELD,
            CONDITION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final List<String> values;

    private final String condition;

    private NamespaceFilter(BuilderImpl builder) {
        this.name = builder.name;
        this.values = builder.values;
        this.condition = builder.condition;
    }

    /**
     * <p>
     * Specify <code>TYPE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link NamespaceFilterName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return Specify <code>TYPE</code>.
     * @see NamespaceFilterName
     */
    public NamespaceFilterName name() {
        return NamespaceFilterName.fromValue(name);
    }

    /**
     * <p>
     * Specify <code>TYPE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link NamespaceFilterName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return Specify <code>TYPE</code>.
     * @see NamespaceFilterName
     */
    public String nameAsString() {
        return name;
    }

    /**
     * <p>
     * If you specify <code>EQ</code> for <code>Condition</code>, specify either <code>DNS_PUBLIC</code> or
     * <code>DNS_PRIVATE</code>.
     * </p>
     * <p>
     * If you specify <code>IN</code> for <code>Condition</code>, you can specify <code>DNS_PUBLIC</code>,
     * <code>DNS_PRIVATE</code>, or both.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return If you specify <code>EQ</code> for <code>Condition</code>, specify either <code>DNS_PUBLIC</code> or
     *         <code>DNS_PRIVATE</code>.</p>
     *         <p>
     *         If you specify <code>IN</code> for <code>Condition</code>, you can specify <code>DNS_PUBLIC</code>,
     *         <code>DNS_PRIVATE</code>, or both.
     */
    public List<String> values() {
        return values;
    }

    /**
     * <p>
     * The operator that you want to use to determine whether <code>ListNamespaces</code> returns a namespace. Valid
     * values for <code>condition</code> include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>EQ</code>: When you specify <code>EQ</code> for the condition, you can choose to list only public
     * namespaces or private namespaces, but not both. <code>EQ</code> is the default condition and can be omitted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IN</code>: When you specify <code>IN</code> for the condition, you can choose to list public namespaces,
     * private namespaces, or both.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>BETWEEN</code>: Not applicable
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #condition} will
     * return {@link FilterCondition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #conditionAsString}.
     * </p>
     * 
     * @return The operator that you want to use to determine whether <code>ListNamespaces</code> returns a namespace.
     *         Valid values for <code>condition</code> include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>EQ</code>: When you specify <code>EQ</code> for the condition, you can choose to list only public
     *         namespaces or private namespaces, but not both. <code>EQ</code> is the default condition and can be
     *         omitted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IN</code>: When you specify <code>IN</code> for the condition, you can choose to list public
     *         namespaces, private namespaces, or both.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>BETWEEN</code>: Not applicable
     *         </p>
     *         </li>
     * @see FilterCondition
     */
    public FilterCondition condition() {
        return FilterCondition.fromValue(condition);
    }

    /**
     * <p>
     * The operator that you want to use to determine whether <code>ListNamespaces</code> returns a namespace. Valid
     * values for <code>condition</code> include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>EQ</code>: When you specify <code>EQ</code> for the condition, you can choose to list only public
     * namespaces or private namespaces, but not both. <code>EQ</code> is the default condition and can be omitted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IN</code>: When you specify <code>IN</code> for the condition, you can choose to list public namespaces,
     * private namespaces, or both.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>BETWEEN</code>: Not applicable
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #condition} will
     * return {@link FilterCondition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #conditionAsString}.
     * </p>
     * 
     * @return The operator that you want to use to determine whether <code>ListNamespaces</code> returns a namespace.
     *         Valid values for <code>condition</code> include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>EQ</code>: When you specify <code>EQ</code> for the condition, you can choose to list only public
     *         namespaces or private namespaces, but not both. <code>EQ</code> is the default condition and can be
     *         omitted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IN</code>: When you specify <code>IN</code> for the condition, you can choose to list public
     *         namespaces, private namespaces, or both.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>BETWEEN</code>: Not applicable
     *         </p>
     *         </li>
     * @see FilterCondition
     */
    public String conditionAsString() {
        return condition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(values());
        hashCode = 31 * hashCode + Objects.hashCode(conditionAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NamespaceFilter)) {
            return false;
        }
        NamespaceFilter other = (NamespaceFilter) obj;
        return Objects.equals(nameAsString(), other.nameAsString()) && Objects.equals(values(), other.values())
                && Objects.equals(conditionAsString(), other.conditionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("NamespaceFilter").add("Name", nameAsString()).add("Values", values())
                .add("Condition", conditionAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(nameAsString()));
        case "Values":
            return Optional.ofNullable(clazz.cast(values()));
        case "Condition":
            return Optional.ofNullable(clazz.cast(conditionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NamespaceFilter, T> g) {
        return obj -> g.apply((NamespaceFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NamespaceFilter> {
        /**
         * <p>
         * Specify <code>TYPE</code>.
         * </p>
         * 
         * @param name
         *        Specify <code>TYPE</code>.
         * @see NamespaceFilterName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NamespaceFilterName
         */
        Builder name(String name);

        /**
         * <p>
         * Specify <code>TYPE</code>.
         * </p>
         * 
         * @param name
         *        Specify <code>TYPE</code>.
         * @see NamespaceFilterName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NamespaceFilterName
         */
        Builder name(NamespaceFilterName name);

        /**
         * <p>
         * If you specify <code>EQ</code> for <code>Condition</code>, specify either <code>DNS_PUBLIC</code> or
         * <code>DNS_PRIVATE</code>.
         * </p>
         * <p>
         * If you specify <code>IN</code> for <code>Condition</code>, you can specify <code>DNS_PUBLIC</code>,
         * <code>DNS_PRIVATE</code>, or both.
         * </p>
         * 
         * @param values
         *        If you specify <code>EQ</code> for <code>Condition</code>, specify either <code>DNS_PUBLIC</code> or
         *        <code>DNS_PRIVATE</code>.</p>
         *        <p>
         *        If you specify <code>IN</code> for <code>Condition</code>, you can specify <code>DNS_PUBLIC</code>,
         *        <code>DNS_PRIVATE</code>, or both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Collection<String> values);

        /**
         * <p>
         * If you specify <code>EQ</code> for <code>Condition</code>, specify either <code>DNS_PUBLIC</code> or
         * <code>DNS_PRIVATE</code>.
         * </p>
         * <p>
         * If you specify <code>IN</code> for <code>Condition</code>, you can specify <code>DNS_PUBLIC</code>,
         * <code>DNS_PRIVATE</code>, or both.
         * </p>
         * 
         * @param values
         *        If you specify <code>EQ</code> for <code>Condition</code>, specify either <code>DNS_PUBLIC</code> or
         *        <code>DNS_PRIVATE</code>.</p>
         *        <p>
         *        If you specify <code>IN</code> for <code>Condition</code>, you can specify <code>DNS_PUBLIC</code>,
         *        <code>DNS_PRIVATE</code>, or both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(String... values);

        /**
         * <p>
         * The operator that you want to use to determine whether <code>ListNamespaces</code> returns a namespace. Valid
         * values for <code>condition</code> include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>EQ</code>: When you specify <code>EQ</code> for the condition, you can choose to list only public
         * namespaces or private namespaces, but not both. <code>EQ</code> is the default condition and can be omitted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IN</code>: When you specify <code>IN</code> for the condition, you can choose to list public
         * namespaces, private namespaces, or both.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>BETWEEN</code>: Not applicable
         * </p>
         * </li>
         * </ul>
         * 
         * @param condition
         *        The operator that you want to use to determine whether <code>ListNamespaces</code> returns a
         *        namespace. Valid values for <code>condition</code> include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>EQ</code>: When you specify <code>EQ</code> for the condition, you can choose to list only
         *        public namespaces or private namespaces, but not both. <code>EQ</code> is the default condition and
         *        can be omitted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IN</code>: When you specify <code>IN</code> for the condition, you can choose to list public
         *        namespaces, private namespaces, or both.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>BETWEEN</code>: Not applicable
         *        </p>
         *        </li>
         * @see FilterCondition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FilterCondition
         */
        Builder condition(String condition);

        /**
         * <p>
         * The operator that you want to use to determine whether <code>ListNamespaces</code> returns a namespace. Valid
         * values for <code>condition</code> include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>EQ</code>: When you specify <code>EQ</code> for the condition, you can choose to list only public
         * namespaces or private namespaces, but not both. <code>EQ</code> is the default condition and can be omitted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IN</code>: When you specify <code>IN</code> for the condition, you can choose to list public
         * namespaces, private namespaces, or both.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>BETWEEN</code>: Not applicable
         * </p>
         * </li>
         * </ul>
         * 
         * @param condition
         *        The operator that you want to use to determine whether <code>ListNamespaces</code> returns a
         *        namespace. Valid values for <code>condition</code> include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>EQ</code>: When you specify <code>EQ</code> for the condition, you can choose to list only
         *        public namespaces or private namespaces, but not both. <code>EQ</code> is the default condition and
         *        can be omitted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IN</code>: When you specify <code>IN</code> for the condition, you can choose to list public
         *        namespaces, private namespaces, or both.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>BETWEEN</code>: Not applicable
         *        </p>
         *        </li>
         * @see FilterCondition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FilterCondition
         */
        Builder condition(FilterCondition condition);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private List<String> values = DefaultSdkAutoConstructList.getInstance();

        private String condition;

        private BuilderImpl() {
        }

        private BuilderImpl(NamespaceFilter model) {
            name(model.name);
            values(model.values);
            condition(model.condition);
        }

        public final String getNameAsString() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(NamespaceFilterName name) {
            this.name(name.toString());
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<String> getValues() {
            return values;
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = FilterValuesCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String... values) {
            values(Arrays.asList(values));
            return this;
        }

        public final void setValues(Collection<String> values) {
            this.values = FilterValuesCopier.copy(values);
        }

        public final String getConditionAsString() {
            return condition;
        }

        @Override
        public final Builder condition(String condition) {
            this.condition = condition;
            return this;
        }

        @Override
        public final Builder condition(FilterCondition condition) {
            this.condition(condition.toString());
            return this;
        }

        public final void setCondition(String condition) {
            this.condition = condition;
        }

        @Override
        public NamespaceFilter build() {
            return new NamespaceFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
