/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListNamespacesResponse extends ServiceDiscoveryResponse implements
        ToCopyableBuilder<ListNamespacesResponse.Builder, ListNamespacesResponse> {
    private static final SdkField<List<NamespaceSummary>> NAMESPACES_FIELD = SdkField
            .<List<NamespaceSummary>> builder(MarshallingType.LIST)
            .getter(getter(ListNamespacesResponse::namespaces))
            .setter(setter(Builder::namespaces))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Namespaces").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NamespaceSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(NamespaceSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListNamespacesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMESPACES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<NamespaceSummary> namespaces;

    private final String nextToken;

    private ListNamespacesResponse(BuilderImpl builder) {
        super(builder);
        this.namespaces = builder.namespaces;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * An array that contains one <code>NamespaceSummary</code> object for each namespace that matches the specified
     * filter criteria.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array that contains one <code>NamespaceSummary</code> object for each namespace that matches the
     *         specified filter criteria.
     */
    public List<NamespaceSummary> namespaces() {
        return namespaces;
    }

    /**
     * <p>
     * If the response contains <code>NextToken</code>, submit another <code>ListNamespaces</code> request to get the
     * next group of results. Specify the value of <code>NextToken</code> from the previous response in the next
     * request.
     * </p>
     * <note>
     * <p>
     * AWS Cloud Map gets <code>MaxResults</code> namespaces and then filters them based on the specified criteria. It's
     * possible that no namespaces in the first <code>MaxResults</code> namespaces matched the specified criteria but
     * that subsequent groups of <code>MaxResults</code> namespaces do contain namespaces that match the criteria.
     * </p>
     * </note>
     * 
     * @return If the response contains <code>NextToken</code>, submit another <code>ListNamespaces</code> request to
     *         get the next group of results. Specify the value of <code>NextToken</code> from the previous response in
     *         the next request.</p> <note>
     *         <p>
     *         AWS Cloud Map gets <code>MaxResults</code> namespaces and then filters them based on the specified
     *         criteria. It's possible that no namespaces in the first <code>MaxResults</code> namespaces matched the
     *         specified criteria but that subsequent groups of <code>MaxResults</code> namespaces do contain namespaces
     *         that match the criteria.
     *         </p>
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(namespaces());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListNamespacesResponse)) {
            return false;
        }
        ListNamespacesResponse other = (ListNamespacesResponse) obj;
        return Objects.equals(namespaces(), other.namespaces()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListNamespacesResponse").add("Namespaces", namespaces()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Namespaces":
            return Optional.ofNullable(clazz.cast(namespaces()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListNamespacesResponse, T> g) {
        return obj -> g.apply((ListNamespacesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceDiscoveryResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListNamespacesResponse> {
        /**
         * <p>
         * An array that contains one <code>NamespaceSummary</code> object for each namespace that matches the specified
         * filter criteria.
         * </p>
         * 
         * @param namespaces
         *        An array that contains one <code>NamespaceSummary</code> object for each namespace that matches the
         *        specified filter criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespaces(Collection<NamespaceSummary> namespaces);

        /**
         * <p>
         * An array that contains one <code>NamespaceSummary</code> object for each namespace that matches the specified
         * filter criteria.
         * </p>
         * 
         * @param namespaces
         *        An array that contains one <code>NamespaceSummary</code> object for each namespace that matches the
         *        specified filter criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespaces(NamespaceSummary... namespaces);

        /**
         * <p>
         * An array that contains one <code>NamespaceSummary</code> object for each namespace that matches the specified
         * filter criteria.
         * </p>
         * This is a convenience that creates an instance of the {@link List<NamespaceSummary>.Builder} avoiding the
         * need to create one manually via {@link List<NamespaceSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<NamespaceSummary>.Builder#build()} is called immediately and
         * its result is passed to {@link #namespaces(List<NamespaceSummary>)}.
         * 
         * @param namespaces
         *        a consumer that will call methods on {@link List<NamespaceSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #namespaces(List<NamespaceSummary>)
         */
        Builder namespaces(Consumer<NamespaceSummary.Builder>... namespaces);

        /**
         * <p>
         * If the response contains <code>NextToken</code>, submit another <code>ListNamespaces</code> request to get
         * the next group of results. Specify the value of <code>NextToken</code> from the previous response in the next
         * request.
         * </p>
         * <note>
         * <p>
         * AWS Cloud Map gets <code>MaxResults</code> namespaces and then filters them based on the specified criteria.
         * It's possible that no namespaces in the first <code>MaxResults</code> namespaces matched the specified
         * criteria but that subsequent groups of <code>MaxResults</code> namespaces do contain namespaces that match
         * the criteria.
         * </p>
         * </note>
         * 
         * @param nextToken
         *        If the response contains <code>NextToken</code>, submit another <code>ListNamespaces</code> request to
         *        get the next group of results. Specify the value of <code>NextToken</code> from the previous response
         *        in the next request.</p> <note>
         *        <p>
         *        AWS Cloud Map gets <code>MaxResults</code> namespaces and then filters them based on the specified
         *        criteria. It's possible that no namespaces in the first <code>MaxResults</code> namespaces matched the
         *        specified criteria but that subsequent groups of <code>MaxResults</code> namespaces do contain
         *        namespaces that match the criteria.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ServiceDiscoveryResponse.BuilderImpl implements Builder {
        private List<NamespaceSummary> namespaces = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListNamespacesResponse model) {
            super(model);
            namespaces(model.namespaces);
            nextToken(model.nextToken);
        }

        public final Collection<NamespaceSummary.Builder> getNamespaces() {
            return namespaces != null ? namespaces.stream().map(NamespaceSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder namespaces(Collection<NamespaceSummary> namespaces) {
            this.namespaces = NamespaceSummariesListCopier.copy(namespaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder namespaces(NamespaceSummary... namespaces) {
            namespaces(Arrays.asList(namespaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder namespaces(Consumer<NamespaceSummary.Builder>... namespaces) {
            namespaces(Stream.of(namespaces).map(c -> NamespaceSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setNamespaces(Collection<NamespaceSummary.BuilderImpl> namespaces) {
            this.namespaces = NamespaceSummariesListCopier.copyFromBuilder(namespaces);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListNamespacesResponse build() {
            return new ListNamespacesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
