/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.servicediscovery.model.DnsConfigChange;
import software.amazon.awssdk.services.servicediscovery.model.HealthCheckConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceChange
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServiceChange> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ServiceChange.getter(ServiceChange::description)).setter(ServiceChange.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<DnsConfigChange> DNS_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ServiceChange.getter(ServiceChange::dnsConfig)).setter(ServiceChange.setter(Builder::dnsConfig)).constructor(DnsConfigChange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsConfig").build()}).build();
    private static final SdkField<HealthCheckConfig> HEALTH_CHECK_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ServiceChange.getter(ServiceChange::healthCheckConfig)).setter(ServiceChange.setter(Builder::healthCheckConfig)).constructor(HealthCheckConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, DNS_CONFIG_FIELD, HEALTH_CHECK_CONFIG_FIELD));
    private static final long serialVersionUID = 1L;
    private final String description;
    private final DnsConfigChange dnsConfig;
    private final HealthCheckConfig healthCheckConfig;

    private ServiceChange(BuilderImpl builder) {
        this.description = builder.description;
        this.dnsConfig = builder.dnsConfig;
        this.healthCheckConfig = builder.healthCheckConfig;
    }

    public String description() {
        return this.description;
    }

    public DnsConfigChange dnsConfig() {
        return this.dnsConfig;
    }

    public HealthCheckConfig healthCheckConfig() {
        return this.healthCheckConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckConfig());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceChange)) {
            return false;
        }
        ServiceChange other = (ServiceChange)obj;
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.dnsConfig(), other.dnsConfig()) && Objects.equals(this.healthCheckConfig(), other.healthCheckConfig());
    }

    public String toString() {
        return ToString.builder((String)"ServiceChange").add("Description", (Object)this.description()).add("DnsConfig", (Object)this.dnsConfig()).add("HealthCheckConfig", (Object)this.healthCheckConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DnsConfig": {
                return Optional.ofNullable(clazz.cast(this.dnsConfig()));
            }
            case "HealthCheckConfig": {
                return Optional.ofNullable(clazz.cast(this.healthCheckConfig()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServiceChange, T> g) {
        return obj -> g.apply((ServiceChange)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String description;
        private DnsConfigChange dnsConfig;
        private HealthCheckConfig healthCheckConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceChange model) {
            this.description(model.description);
            this.dnsConfig(model.dnsConfig);
            this.healthCheckConfig(model.healthCheckConfig);
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final DnsConfigChange.Builder getDnsConfig() {
            return this.dnsConfig != null ? this.dnsConfig.toBuilder() : null;
        }

        @Override
        public final Builder dnsConfig(DnsConfigChange dnsConfig) {
            this.dnsConfig = dnsConfig;
            return this;
        }

        public final void setDnsConfig(DnsConfigChange.BuilderImpl dnsConfig) {
            this.dnsConfig = dnsConfig != null ? dnsConfig.build() : null;
        }

        public final HealthCheckConfig.Builder getHealthCheckConfig() {
            return this.healthCheckConfig != null ? this.healthCheckConfig.toBuilder() : null;
        }

        @Override
        public final Builder healthCheckConfig(HealthCheckConfig healthCheckConfig) {
            this.healthCheckConfig = healthCheckConfig;
            return this;
        }

        public final void setHealthCheckConfig(HealthCheckConfig.BuilderImpl healthCheckConfig) {
            this.healthCheckConfig = healthCheckConfig != null ? healthCheckConfig.build() : null;
        }

        public ServiceChange build() {
            return new ServiceChange(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServiceChange> {
        public Builder description(String var1);

        public Builder dnsConfig(DnsConfigChange var1);

        default public Builder dnsConfig(Consumer<DnsConfigChange.Builder> dnsConfig) {
            return this.dnsConfig((DnsConfigChange)((DnsConfigChange.Builder)DnsConfigChange.builder().applyMutation(dnsConfig)).build());
        }

        public Builder healthCheckConfig(HealthCheckConfig var1);

        default public Builder healthCheckConfig(Consumer<HealthCheckConfig.Builder> healthCheckConfig) {
            return this.healthCheckConfig((HealthCheckConfig)((HealthCheckConfig.Builder)HealthCheckConfig.builder().applyMutation(healthCheckConfig)).build());
        }
    }
}

