/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains information about an operation that matches the criteria that you specified in a
 * <a>ListOperations</a> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OperationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<OperationSummary.Builder, OperationSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(OperationSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(OperationSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String status;

    private OperationSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.status = builder.status;
    }

    /**
     * <p>
     * The ID for an operation.
     * </p>
     * 
     * @return The ID for an operation.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The status of the operation. Values include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>SUBMITTED</b>: This is the initial state immediately after you submit a request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>PENDING</b>: AWS Cloud Map is performing the operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>SUCCESS</b>: The operation succeeded.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>FAIL</b>: The operation failed. For the failure reason, see <code>ErrorMessage</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link OperationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the operation. Values include the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>SUBMITTED</b>: This is the initial state immediately after you submit a request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>PENDING</b>: AWS Cloud Map is performing the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>SUCCESS</b>: The operation succeeded.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>FAIL</b>: The operation failed. For the failure reason, see <code>ErrorMessage</code>.
     *         </p>
     *         </li>
     * @see OperationStatus
     */
    public OperationStatus status() {
        return OperationStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the operation. Values include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>SUBMITTED</b>: This is the initial state immediately after you submit a request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>PENDING</b>: AWS Cloud Map is performing the operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>SUCCESS</b>: The operation succeeded.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>FAIL</b>: The operation failed. For the failure reason, see <code>ErrorMessage</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link OperationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the operation. Values include the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>SUBMITTED</b>: This is the initial state immediately after you submit a request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>PENDING</b>: AWS Cloud Map is performing the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>SUCCESS</b>: The operation succeeded.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>FAIL</b>: The operation failed. For the failure reason, see <code>ErrorMessage</code>.
     *         </p>
     *         </li>
     * @see OperationStatus
     */
    public String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OperationSummary)) {
            return false;
        }
        OperationSummary other = (OperationSummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("OperationSummary").add("Id", id()).add("Status", statusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OperationSummary, T> g) {
        return obj -> g.apply((OperationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OperationSummary> {
        /**
         * <p>
         * The ID for an operation.
         * </p>
         * 
         * @param id
         *        The ID for an operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The status of the operation. Values include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>SUBMITTED</b>: This is the initial state immediately after you submit a request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>PENDING</b>: AWS Cloud Map is performing the operation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>SUCCESS</b>: The operation succeeded.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>FAIL</b>: The operation failed. For the failure reason, see <code>ErrorMessage</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the operation. Values include the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>SUBMITTED</b>: This is the initial state immediately after you submit a request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>PENDING</b>: AWS Cloud Map is performing the operation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>SUCCESS</b>: The operation succeeded.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>FAIL</b>: The operation failed. For the failure reason, see <code>ErrorMessage</code>.
         *        </p>
         *        </li>
         * @see OperationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the operation. Values include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>SUBMITTED</b>: This is the initial state immediately after you submit a request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>PENDING</b>: AWS Cloud Map is performing the operation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>SUCCESS</b>: The operation succeeded.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>FAIL</b>: The operation failed. For the failure reason, see <code>ErrorMessage</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the operation. Values include the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>SUBMITTED</b>: This is the initial state immediately after you submit a request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>PENDING</b>: AWS Cloud Map is performing the operation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>SUCCESS</b>: The operation succeeded.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>FAIL</b>: The operation failed. For the failure reason, see <code>ErrorMessage</code>.
         *        </p>
         *        </li>
         * @see OperationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationStatus
         */
        Builder status(OperationStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(OperationSummary model) {
            id(model.id);
            status(model.status);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getStatusAsString() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(OperationStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public OperationSummary build() {
            return new OperationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
