/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * In a response to a <a>DiscoverInstance</a> request, <code>HttpInstanceSummary</code> contains information about one
 * instance that matches the values that you specified in the request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HttpInstanceSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<HttpInstanceSummary.Builder, HttpInstanceSummary> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HttpInstanceSummary::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<String> NAMESPACE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HttpInstanceSummary::namespaceName)).setter(setter(Builder::namespaceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NamespaceName").build()).build();

    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HttpInstanceSummary::serviceName)).setter(setter(Builder::serviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceName").build()).build();

    private static final SdkField<String> HEALTH_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HttpInstanceSummary::healthStatusAsString)).setter(setter(Builder::healthStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthStatus").build()).build();

    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(HttpInstanceSummary::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            NAMESPACE_NAME_FIELD, SERVICE_NAME_FIELD, HEALTH_STATUS_FIELD, ATTRIBUTES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String instanceId;

    private final String namespaceName;

    private final String serviceName;

    private final String healthStatus;

    private final Map<String, String> attributes;

    private HttpInstanceSummary(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.namespaceName = builder.namespaceName;
        this.serviceName = builder.serviceName;
        this.healthStatus = builder.healthStatus;
        this.attributes = builder.attributes;
    }

    /**
     * <p>
     * The ID of an instance that matches the values that you specified in the request.
     * </p>
     * 
     * @return The ID of an instance that matches the values that you specified in the request.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The name of the namespace that you specified when you registered the instance.
     * </p>
     * 
     * @return The name of the namespace that you specified when you registered the instance.
     */
    public String namespaceName() {
        return namespaceName;
    }

    /**
     * <p>
     * The name of the service that you specified when you registered the instance.
     * </p>
     * 
     * @return The name of the service that you specified when you registered the instance.
     */
    public String serviceName() {
        return serviceName;
    }

    /**
     * <p>
     * If you configured health checking in the service, the current health status of the service instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #healthStatus} will
     * return {@link HealthStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #healthStatusAsString}.
     * </p>
     * 
     * @return If you configured health checking in the service, the current health status of the service instance.
     * @see HealthStatus
     */
    public HealthStatus healthStatus() {
        return HealthStatus.fromValue(healthStatus);
    }

    /**
     * <p>
     * If you configured health checking in the service, the current health status of the service instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #healthStatus} will
     * return {@link HealthStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #healthStatusAsString}.
     * </p>
     * 
     * @return If you configured health checking in the service, the current health status of the service instance.
     * @see HealthStatus
     */
    public String healthStatusAsString() {
        return healthStatus;
    }

    /**
     * <p>
     * If you included any attributes when you registered the instance, the values of those attributes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return If you included any attributes when you registered the instance, the values of those attributes.
     */
    public Map<String, String> attributes() {
        return attributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(namespaceName());
        hashCode = 31 * hashCode + Objects.hashCode(serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(healthStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(attributes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HttpInstanceSummary)) {
            return false;
        }
        HttpInstanceSummary other = (HttpInstanceSummary) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(namespaceName(), other.namespaceName())
                && Objects.equals(serviceName(), other.serviceName())
                && Objects.equals(healthStatusAsString(), other.healthStatusAsString())
                && Objects.equals(attributes(), other.attributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("HttpInstanceSummary").add("InstanceId", instanceId()).add("NamespaceName", namespaceName())
                .add("ServiceName", serviceName()).add("HealthStatus", healthStatusAsString()).add("Attributes", attributes())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "NamespaceName":
            return Optional.ofNullable(clazz.cast(namespaceName()));
        case "ServiceName":
            return Optional.ofNullable(clazz.cast(serviceName()));
        case "HealthStatus":
            return Optional.ofNullable(clazz.cast(healthStatusAsString()));
        case "Attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HttpInstanceSummary, T> g) {
        return obj -> g.apply((HttpInstanceSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HttpInstanceSummary> {
        /**
         * <p>
         * The ID of an instance that matches the values that you specified in the request.
         * </p>
         * 
         * @param instanceId
         *        The ID of an instance that matches the values that you specified in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The name of the namespace that you specified when you registered the instance.
         * </p>
         * 
         * @param namespaceName
         *        The name of the namespace that you specified when you registered the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespaceName(String namespaceName);

        /**
         * <p>
         * The name of the service that you specified when you registered the instance.
         * </p>
         * 
         * @param serviceName
         *        The name of the service that you specified when you registered the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceName(String serviceName);

        /**
         * <p>
         * If you configured health checking in the service, the current health status of the service instance.
         * </p>
         * 
         * @param healthStatus
         *        If you configured health checking in the service, the current health status of the service instance.
         * @see HealthStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HealthStatus
         */
        Builder healthStatus(String healthStatus);

        /**
         * <p>
         * If you configured health checking in the service, the current health status of the service instance.
         * </p>
         * 
         * @param healthStatus
         *        If you configured health checking in the service, the current health status of the service instance.
         * @see HealthStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HealthStatus
         */
        Builder healthStatus(HealthStatus healthStatus);

        /**
         * <p>
         * If you included any attributes when you registered the instance, the values of those attributes.
         * </p>
         * 
         * @param attributes
         *        If you included any attributes when you registered the instance, the values of those attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, String> attributes);
    }

    static final class BuilderImpl implements Builder {
        private String instanceId;

        private String namespaceName;

        private String serviceName;

        private String healthStatus;

        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(HttpInstanceSummary model) {
            instanceId(model.instanceId);
            namespaceName(model.namespaceName);
            serviceName(model.serviceName);
            healthStatus(model.healthStatus);
            attributes(model.attributes);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getNamespaceName() {
            return namespaceName;
        }

        @Override
        public final Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public final void setNamespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
        }

        public final String getServiceName() {
            return serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public final String getHealthStatusAsString() {
            return healthStatus;
        }

        @Override
        public final Builder healthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
            return this;
        }

        @Override
        public final Builder healthStatus(HealthStatus healthStatus) {
            this.healthStatus(healthStatus == null ? null : healthStatus.toString());
            return this;
        }

        public final void setHealthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
        }

        public final Map<String, String> getAttributes() {
            return attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
        }

        @Override
        public HttpInstanceSummary build() {
            return new HttpInstanceSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
