/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicequotas.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListServiceQuotasRequest extends ServiceQuotasRequest implements
        ToCopyableBuilder<ListServiceQuotasRequest.Builder, ListServiceQuotasRequest> {
    private static final SdkField<String> SERVICE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListServiceQuotasRequest::serviceCode)).setter(setter(Builder::serviceCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceCode").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListServiceQuotasRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ListServiceQuotasRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_CODE_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final String serviceCode;

    private final String nextToken;

    private final Integer maxResults;

    private ListServiceQuotasRequest(BuilderImpl builder) {
        super(builder);
        this.serviceCode = builder.serviceCode;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The identifier for a service. When performing an operation, use the <code>ServiceCode</code> to specify a
     * particular service.
     * </p>
     * 
     * @return The identifier for a service. When performing an operation, use the <code>ServiceCode</code> to specify a
     *         particular service.
     */
    public String serviceCode() {
        return serviceCode;
    }

    /**
     * <p>
     * (Optional) Use this parameter in a request if you receive a <code>NextToken</code> response in a previous request
     * that indicates that there's more output available. In a subsequent call, set it to the value of the previous
     * call's <code>NextToken</code> response to indicate where the output should continue from.
     * </p>
     * 
     * @return (Optional) Use this parameter in a request if you receive a <code>NextToken</code> response in a previous
     *         request that indicates that there's more output available. In a subsequent call, set it to the value of
     *         the previous call's <code>NextToken</code> response to indicate where the output should continue from.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * (Optional) Limits the number of results that you want to include in the response. If you don't include this
     * parameter, the response defaults to a value that's specific to the operation. If additional items exist beyond
     * the specified maximum, the <code>NextToken</code> element is present and has a value (isn't null). Include that
     * value as the <code>NextToken</code> request parameter in the call to the operation to get the next part of the
     * results. You should check <code>NextToken</code> after every operation to ensure that you receive all of the
     * results.
     * </p>
     * 
     * @return (Optional) Limits the number of results that you want to include in the response. If you don't include
     *         this parameter, the response defaults to a value that's specific to the operation. If additional items
     *         exist beyond the specified maximum, the <code>NextToken</code> element is present and has a value (isn't
     *         null). Include that value as the <code>NextToken</code> request parameter in the call to the operation to
     *         get the next part of the results. You should check <code>NextToken</code> after every operation to ensure
     *         that you receive all of the results.
     */
    public Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serviceCode());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServiceQuotasRequest)) {
            return false;
        }
        ListServiceQuotasRequest other = (ListServiceQuotasRequest) obj;
        return Objects.equals(serviceCode(), other.serviceCode()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListServiceQuotasRequest").add("ServiceCode", serviceCode()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceCode":
            return Optional.ofNullable(clazz.cast(serviceCode()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListServiceQuotasRequest, T> g) {
        return obj -> g.apply((ListServiceQuotasRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceQuotasRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListServiceQuotasRequest> {
        /**
         * <p>
         * The identifier for a service. When performing an operation, use the <code>ServiceCode</code> to specify a
         * particular service.
         * </p>
         * 
         * @param serviceCode
         *        The identifier for a service. When performing an operation, use the <code>ServiceCode</code> to
         *        specify a particular service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceCode(String serviceCode);

        /**
         * <p>
         * (Optional) Use this parameter in a request if you receive a <code>NextToken</code> response in a previous
         * request that indicates that there's more output available. In a subsequent call, set it to the value of the
         * previous call's <code>NextToken</code> response to indicate where the output should continue from.
         * </p>
         * 
         * @param nextToken
         *        (Optional) Use this parameter in a request if you receive a <code>NextToken</code> response in a
         *        previous request that indicates that there's more output available. In a subsequent call, set it to
         *        the value of the previous call's <code>NextToken</code> response to indicate where the output should
         *        continue from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * (Optional) Limits the number of results that you want to include in the response. If you don't include this
         * parameter, the response defaults to a value that's specific to the operation. If additional items exist
         * beyond the specified maximum, the <code>NextToken</code> element is present and has a value (isn't null).
         * Include that value as the <code>NextToken</code> request parameter in the call to the operation to get the
         * next part of the results. You should check <code>NextToken</code> after every operation to ensure that you
         * receive all of the results.
         * </p>
         * 
         * @param maxResults
         *        (Optional) Limits the number of results that you want to include in the response. If you don't include
         *        this parameter, the response defaults to a value that's specific to the operation. If additional items
         *        exist beyond the specified maximum, the <code>NextToken</code> element is present and has a value
         *        (isn't null). Include that value as the <code>NextToken</code> request parameter in the call to the
         *        operation to get the next part of the results. You should check <code>NextToken</code> after every
         *        operation to ensure that you receive all of the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ServiceQuotasRequest.BuilderImpl implements Builder {
        private String serviceCode;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListServiceQuotasRequest model) {
            super(model);
            serviceCode(model.serviceCode);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getServiceCode() {
            return serviceCode;
        }

        @Override
        public final Builder serviceCode(String serviceCode) {
            this.serviceCode = serviceCode;
            return this;
        }

        public final void setServiceCode(String serviceCode) {
            this.serviceCode = serviceCode;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListServiceQuotasRequest build() {
            return new ListServiceQuotasRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
