/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicequotas;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.servicequotas.model.AssociateServiceQuotaTemplateRequest;
import software.amazon.awssdk.services.servicequotas.model.AssociateServiceQuotaTemplateResponse;
import software.amazon.awssdk.services.servicequotas.model.DeleteServiceQuotaIncreaseRequestFromTemplateRequest;
import software.amazon.awssdk.services.servicequotas.model.DeleteServiceQuotaIncreaseRequestFromTemplateResponse;
import software.amazon.awssdk.services.servicequotas.model.DisassociateServiceQuotaTemplateRequest;
import software.amazon.awssdk.services.servicequotas.model.DisassociateServiceQuotaTemplateResponse;
import software.amazon.awssdk.services.servicequotas.model.GetAssociationForServiceQuotaTemplateRequest;
import software.amazon.awssdk.services.servicequotas.model.GetAssociationForServiceQuotaTemplateResponse;
import software.amazon.awssdk.services.servicequotas.model.GetAwsDefaultServiceQuotaRequest;
import software.amazon.awssdk.services.servicequotas.model.GetAwsDefaultServiceQuotaResponse;
import software.amazon.awssdk.services.servicequotas.model.GetRequestedServiceQuotaChangeRequest;
import software.amazon.awssdk.services.servicequotas.model.GetRequestedServiceQuotaChangeResponse;
import software.amazon.awssdk.services.servicequotas.model.GetServiceQuotaIncreaseRequestFromTemplateRequest;
import software.amazon.awssdk.services.servicequotas.model.GetServiceQuotaIncreaseRequestFromTemplateResponse;
import software.amazon.awssdk.services.servicequotas.model.GetServiceQuotaRequest;
import software.amazon.awssdk.services.servicequotas.model.GetServiceQuotaResponse;
import software.amazon.awssdk.services.servicequotas.model.ListAwsDefaultServiceQuotasRequest;
import software.amazon.awssdk.services.servicequotas.model.ListAwsDefaultServiceQuotasResponse;
import software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaRequest;
import software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaResponse;
import software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryRequest;
import software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryResponse;
import software.amazon.awssdk.services.servicequotas.model.ListServiceQuotaIncreaseRequestsInTemplateRequest;
import software.amazon.awssdk.services.servicequotas.model.ListServiceQuotaIncreaseRequestsInTemplateResponse;
import software.amazon.awssdk.services.servicequotas.model.ListServiceQuotasRequest;
import software.amazon.awssdk.services.servicequotas.model.ListServiceQuotasResponse;
import software.amazon.awssdk.services.servicequotas.model.ListServicesRequest;
import software.amazon.awssdk.services.servicequotas.model.ListServicesResponse;
import software.amazon.awssdk.services.servicequotas.model.PutServiceQuotaIncreaseRequestIntoTemplateRequest;
import software.amazon.awssdk.services.servicequotas.model.PutServiceQuotaIncreaseRequestIntoTemplateResponse;
import software.amazon.awssdk.services.servicequotas.model.RequestServiceQuotaIncreaseRequest;
import software.amazon.awssdk.services.servicequotas.model.RequestServiceQuotaIncreaseResponse;
import software.amazon.awssdk.services.servicequotas.paginators.ListAWSDefaultServiceQuotasPublisher;
import software.amazon.awssdk.services.servicequotas.paginators.ListRequestedServiceQuotaChangeHistoryByQuotaPublisher;
import software.amazon.awssdk.services.servicequotas.paginators.ListRequestedServiceQuotaChangeHistoryPublisher;
import software.amazon.awssdk.services.servicequotas.paginators.ListServiceQuotaIncreaseRequestsInTemplatePublisher;
import software.amazon.awssdk.services.servicequotas.paginators.ListServiceQuotasPublisher;
import software.amazon.awssdk.services.servicequotas.paginators.ListServicesPublisher;

/**
 * Service client for accessing Service Quotas asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * Service Quotas is a web service that you can use to manage many of your AWS service quotas. Quotas, also referred to
 * as limits, are the maximum values for a resource, item, or operation. This guide provide descriptions of the Service
 * Quotas actions that you can call from an API. For the Service Quotas user guide, which explains how to use Service
 * Quotas from the console, see <a href="https://docs.aws.amazon.com/servicequotas/latest/userguide/intro.html">What is
 * Service Quotas</a>.
 * </p>
 * <note>
 * <p>
 * AWS provides SDKs that consist of libraries and sample code for programming languages and platforms (Java, Ruby,
 * .NET, iOS, Android, etc...,). The SDKs provide a convenient way to create programmatic access to Service Quotas and
 * AWS. For information about the AWS SDKs, including how to download and install them, see the <a
 * href="https://docs.aws.amazon.com/aws.amazon.com/tools">Tools for Amazon Web Services</a> page.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public interface ServiceQuotasAsyncClient extends SdkClient {
    String SERVICE_NAME = "servicequotas";

    /**
     * Create a {@link ServiceQuotasAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static ServiceQuotasAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ServiceQuotasAsyncClient}.
     */
    static ServiceQuotasAsyncClientBuilder builder() {
        return new DefaultServiceQuotasAsyncClientBuilder();
    }

    /**
     * <p>
     * Associates the Service Quotas template with your organization so that when new accounts are created in your
     * organization, the template submits increase requests for the specified service quotas. Use the Service Quotas
     * template to request an increase for any adjustable quota value. After you define the Service Quotas template, use
     * this operation to associate, or enable, the template.
     * </p>
     *
     * @param associateServiceQuotaTemplateRequest
     * @return A Java Future containing the result of the AssociateServiceQuotaTemplate operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DependencyAccessDeniedException You can't perform this action because a dependency does not have
     *         access.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>AwsServiceAccessNotEnabledException The action you attempted is not allowed unless Service Access
     *         with Service Quotas is enabled in your organization. To enable, call
     *         <a>AssociateServiceQuotaTemplate</a>.</li>
     *         <li>OrganizationNotInAllFeaturesModeException The organization that your account belongs to, is not in
     *         All Features mode. To enable all features mode, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/APIReference/API_EnableAllFeatures.html"
     *         >EnableAllFeatures</a>.</li>
     *         <li>TemplatesNotAvailableInRegionException The Service Quotas template is not available in the Region
     *         where you are making the request. Please make the request in us-east-1.</li>
     *         <li>NoAvailableOrganizationException The account making this call is not a member of an organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.AssociateServiceQuotaTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/AssociateServiceQuotaTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateServiceQuotaTemplateResponse> associateServiceQuotaTemplate(
            AssociateServiceQuotaTemplateRequest associateServiceQuotaTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates the Service Quotas template with your organization so that when new accounts are created in your
     * organization, the template submits increase requests for the specified service quotas. Use the Service Quotas
     * template to request an increase for any adjustable quota value. After you define the Service Quotas template, use
     * this operation to associate, or enable, the template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateServiceQuotaTemplateRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateServiceQuotaTemplateRequest#builder()}
     * </p>
     *
     * @param associateServiceQuotaTemplateRequest
     *        A {@link Consumer} that will call methods on {@link AssociateServiceQuotaTemplateRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the AssociateServiceQuotaTemplate operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DependencyAccessDeniedException You can't perform this action because a dependency does not have
     *         access.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>AwsServiceAccessNotEnabledException The action you attempted is not allowed unless Service Access
     *         with Service Quotas is enabled in your organization. To enable, call
     *         <a>AssociateServiceQuotaTemplate</a>.</li>
     *         <li>OrganizationNotInAllFeaturesModeException The organization that your account belongs to, is not in
     *         All Features mode. To enable all features mode, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/APIReference/API_EnableAllFeatures.html"
     *         >EnableAllFeatures</a>.</li>
     *         <li>TemplatesNotAvailableInRegionException The Service Quotas template is not available in the Region
     *         where you are making the request. Please make the request in us-east-1.</li>
     *         <li>NoAvailableOrganizationException The account making this call is not a member of an organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.AssociateServiceQuotaTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/AssociateServiceQuotaTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateServiceQuotaTemplateResponse> associateServiceQuotaTemplate(
            Consumer<AssociateServiceQuotaTemplateRequest.Builder> associateServiceQuotaTemplateRequest) {
        return associateServiceQuotaTemplate(AssociateServiceQuotaTemplateRequest.builder()
                .applyMutation(associateServiceQuotaTemplateRequest).build());
    }

    /**
     * <p>
     * Removes a service quota increase request from the Service Quotas template.
     * </p>
     *
     * @param deleteServiceQuotaIncreaseRequestFromTemplateRequest
     * @return A Java Future containing the result of the DeleteServiceQuotaIncreaseRequestFromTemplate operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>DependencyAccessDeniedException You can't perform this action because a dependency does not have
     *         access.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>NoSuchResourceException The specified resource does not exist.</li>
     *         <li>IllegalArgumentException Invalid input was provided.</li>
     *         <li>AwsServiceAccessNotEnabledException The action you attempted is not allowed unless Service Access
     *         with Service Quotas is enabled in your organization. To enable, call
     *         <a>AssociateServiceQuotaTemplate</a>.</li>
     *         <li>TemplatesNotAvailableInRegionException The Service Quotas template is not available in the Region
     *         where you are making the request. Please make the request in us-east-1.</li>
     *         <li>NoAvailableOrganizationException The account making this call is not a member of an organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.DeleteServiceQuotaIncreaseRequestFromTemplate
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/DeleteServiceQuotaIncreaseRequestFromTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteServiceQuotaIncreaseRequestFromTemplateResponse> deleteServiceQuotaIncreaseRequestFromTemplate(
            DeleteServiceQuotaIncreaseRequestFromTemplateRequest deleteServiceQuotaIncreaseRequestFromTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a service quota increase request from the Service Quotas template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteServiceQuotaIncreaseRequestFromTemplateRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteServiceQuotaIncreaseRequestFromTemplateRequest#builder()}
     * </p>
     *
     * @param deleteServiceQuotaIncreaseRequestFromTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DeleteServiceQuotaIncreaseRequestFromTemplateRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteServiceQuotaIncreaseRequestFromTemplate operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>DependencyAccessDeniedException You can't perform this action because a dependency does not have
     *         access.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>NoSuchResourceException The specified resource does not exist.</li>
     *         <li>IllegalArgumentException Invalid input was provided.</li>
     *         <li>AwsServiceAccessNotEnabledException The action you attempted is not allowed unless Service Access
     *         with Service Quotas is enabled in your organization. To enable, call
     *         <a>AssociateServiceQuotaTemplate</a>.</li>
     *         <li>TemplatesNotAvailableInRegionException The Service Quotas template is not available in the Region
     *         where you are making the request. Please make the request in us-east-1.</li>
     *         <li>NoAvailableOrganizationException The account making this call is not a member of an organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.DeleteServiceQuotaIncreaseRequestFromTemplate
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/DeleteServiceQuotaIncreaseRequestFromTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteServiceQuotaIncreaseRequestFromTemplateResponse> deleteServiceQuotaIncreaseRequestFromTemplate(
            Consumer<DeleteServiceQuotaIncreaseRequestFromTemplateRequest.Builder> deleteServiceQuotaIncreaseRequestFromTemplateRequest) {
        return deleteServiceQuotaIncreaseRequestFromTemplate(DeleteServiceQuotaIncreaseRequestFromTemplateRequest.builder()
                .applyMutation(deleteServiceQuotaIncreaseRequestFromTemplateRequest).build());
    }

    /**
     * <p>
     * Disables the Service Quotas template. Once the template is disabled, it does not request quota increases for new
     * accounts in your organization. Disabling the quota template does not apply the quota increase requests from the
     * template.
     * </p>
     * <p>
     * <b>Related operations</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * To enable the quota template, call <a>AssociateServiceQuotaTemplate</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * To delete a specific service quota from the template, use <a>DeleteServiceQuotaIncreaseRequestFromTemplate</a>.
     * </p>
     * </li>
     * </ul>
     *
     * @param disassociateServiceQuotaTemplateRequest
     * @return A Java Future containing the result of the DisassociateServiceQuotaTemplate operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DependencyAccessDeniedException You can't perform this action because a dependency does not have
     *         access.</li>
     *         <li>ServiceQuotaTemplateNotInUseException The quota request template is not associated with your
     *         organization. </p>
     *         <p>
     *         To use the template, call <a>AssociateServiceQuotaTemplate</a>.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>AwsServiceAccessNotEnabledException The action you attempted is not allowed unless Service Access
     *         with Service Quotas is enabled in your organization. To enable, call
     *         <a>AssociateServiceQuotaTemplate</a>.</li>
     *         <li>TemplatesNotAvailableInRegionException The Service Quotas template is not available in the Region
     *         where you are making the request. Please make the request in us-east-1.</li>
     *         <li>NoAvailableOrganizationException The account making this call is not a member of an organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.DisassociateServiceQuotaTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/DisassociateServiceQuotaTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateServiceQuotaTemplateResponse> disassociateServiceQuotaTemplate(
            DisassociateServiceQuotaTemplateRequest disassociateServiceQuotaTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables the Service Quotas template. Once the template is disabled, it does not request quota increases for new
     * accounts in your organization. Disabling the quota template does not apply the quota increase requests from the
     * template.
     * </p>
     * <p>
     * <b>Related operations</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * To enable the quota template, call <a>AssociateServiceQuotaTemplate</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * To delete a specific service quota from the template, use <a>DeleteServiceQuotaIncreaseRequestFromTemplate</a>.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateServiceQuotaTemplateRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateServiceQuotaTemplateRequest#builder()}
     * </p>
     *
     * @param disassociateServiceQuotaTemplateRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateServiceQuotaTemplateRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DisassociateServiceQuotaTemplate operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DependencyAccessDeniedException You can't perform this action because a dependency does not have
     *         access.</li>
     *         <li>ServiceQuotaTemplateNotInUseException The quota request template is not associated with your
     *         organization. </p>
     *         <p>
     *         To use the template, call <a>AssociateServiceQuotaTemplate</a>.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>AwsServiceAccessNotEnabledException The action you attempted is not allowed unless Service Access
     *         with Service Quotas is enabled in your organization. To enable, call
     *         <a>AssociateServiceQuotaTemplate</a>.</li>
     *         <li>TemplatesNotAvailableInRegionException The Service Quotas template is not available in the Region
     *         where you are making the request. Please make the request in us-east-1.</li>
     *         <li>NoAvailableOrganizationException The account making this call is not a member of an organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.DisassociateServiceQuotaTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/DisassociateServiceQuotaTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateServiceQuotaTemplateResponse> disassociateServiceQuotaTemplate(
            Consumer<DisassociateServiceQuotaTemplateRequest.Builder> disassociateServiceQuotaTemplateRequest) {
        return disassociateServiceQuotaTemplate(DisassociateServiceQuotaTemplateRequest.builder()
                .applyMutation(disassociateServiceQuotaTemplateRequest).build());
    }

    /**
     * <p>
     * Retrieves the default service quotas values. The Value returned for each quota is the AWS default value, even if
     * the quotas have been increased..
     * </p>
     *
     * @param getAwsDefaultServiceQuotaRequest
     * @return A Java Future containing the result of the GetAWSDefaultServiceQuota operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>NoSuchResourceException The specified resource does not exist.</li>
     *         <li>IllegalArgumentException Invalid input was provided.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.GetAWSDefaultServiceQuota
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/GetAWSDefaultServiceQuota"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAwsDefaultServiceQuotaResponse> getAWSDefaultServiceQuota(
            GetAwsDefaultServiceQuotaRequest getAwsDefaultServiceQuotaRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the default service quotas values. The Value returned for each quota is the AWS default value, even if
     * the quotas have been increased..
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAwsDefaultServiceQuotaRequest.Builder} avoiding
     * the need to create one manually via {@link GetAwsDefaultServiceQuotaRequest#builder()}
     * </p>
     *
     * @param getAwsDefaultServiceQuotaRequest
     *        A {@link Consumer} that will call methods on {@link GetAWSDefaultServiceQuotaRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetAWSDefaultServiceQuota operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>NoSuchResourceException The specified resource does not exist.</li>
     *         <li>IllegalArgumentException Invalid input was provided.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.GetAWSDefaultServiceQuota
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/GetAWSDefaultServiceQuota"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAwsDefaultServiceQuotaResponse> getAWSDefaultServiceQuota(
            Consumer<GetAwsDefaultServiceQuotaRequest.Builder> getAwsDefaultServiceQuotaRequest) {
        return getAWSDefaultServiceQuota(GetAwsDefaultServiceQuotaRequest.builder()
                .applyMutation(getAwsDefaultServiceQuotaRequest).build());
    }

    /**
     * <p>
     * Retrieves the <code>ServiceQuotaTemplateAssociationStatus</code> value from the service. Use this action to
     * determine if the Service Quota template is associated, or enabled.
     * </p>
     *
     * @param getAssociationForServiceQuotaTemplateRequest
     * @return A Java Future containing the result of the GetAssociationForServiceQuotaTemplate operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DependencyAccessDeniedException You can't perform this action because a dependency does not have
     *         access.</li>
     *         <li>ServiceQuotaTemplateNotInUseException The quota request template is not associated with your
     *         organization. </p>
     *         <p>
     *         To use the template, call <a>AssociateServiceQuotaTemplate</a>.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>AwsServiceAccessNotEnabledException The action you attempted is not allowed unless Service Access
     *         with Service Quotas is enabled in your organization. To enable, call
     *         <a>AssociateServiceQuotaTemplate</a>.</li>
     *         <li>TemplatesNotAvailableInRegionException The Service Quotas template is not available in the Region
     *         where you are making the request. Please make the request in us-east-1.</li>
     *         <li>NoAvailableOrganizationException The account making this call is not a member of an organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.GetAssociationForServiceQuotaTemplate
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/GetAssociationForServiceQuotaTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAssociationForServiceQuotaTemplateResponse> getAssociationForServiceQuotaTemplate(
            GetAssociationForServiceQuotaTemplateRequest getAssociationForServiceQuotaTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the <code>ServiceQuotaTemplateAssociationStatus</code> value from the service. Use this action to
     * determine if the Service Quota template is associated, or enabled.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetAssociationForServiceQuotaTemplateRequest.Builder} avoiding the need to create one manually via
     * {@link GetAssociationForServiceQuotaTemplateRequest#builder()}
     * </p>
     *
     * @param getAssociationForServiceQuotaTemplateRequest
     *        A {@link Consumer} that will call methods on {@link GetAssociationForServiceQuotaTemplateRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetAssociationForServiceQuotaTemplate operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DependencyAccessDeniedException You can't perform this action because a dependency does not have
     *         access.</li>
     *         <li>ServiceQuotaTemplateNotInUseException The quota request template is not associated with your
     *         organization. </p>
     *         <p>
     *         To use the template, call <a>AssociateServiceQuotaTemplate</a>.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>AwsServiceAccessNotEnabledException The action you attempted is not allowed unless Service Access
     *         with Service Quotas is enabled in your organization. To enable, call
     *         <a>AssociateServiceQuotaTemplate</a>.</li>
     *         <li>TemplatesNotAvailableInRegionException The Service Quotas template is not available in the Region
     *         where you are making the request. Please make the request in us-east-1.</li>
     *         <li>NoAvailableOrganizationException The account making this call is not a member of an organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.GetAssociationForServiceQuotaTemplate
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/GetAssociationForServiceQuotaTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAssociationForServiceQuotaTemplateResponse> getAssociationForServiceQuotaTemplate(
            Consumer<GetAssociationForServiceQuotaTemplateRequest.Builder> getAssociationForServiceQuotaTemplateRequest) {
        return getAssociationForServiceQuotaTemplate(GetAssociationForServiceQuotaTemplateRequest.builder()
                .applyMutation(getAssociationForServiceQuotaTemplateRequest).build());
    }

    /**
     * <p>
     * Retrieves the details for a particular increase request.
     * </p>
     *
     * @param getRequestedServiceQuotaChangeRequest
     * @return A Java Future containing the result of the GetRequestedServiceQuotaChange operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>NoSuchResourceException The specified resource does not exist.</li>
     *         <li>IllegalArgumentException Invalid input was provided.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.GetRequestedServiceQuotaChange
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/GetRequestedServiceQuotaChange"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRequestedServiceQuotaChangeResponse> getRequestedServiceQuotaChange(
            GetRequestedServiceQuotaChangeRequest getRequestedServiceQuotaChangeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the details for a particular increase request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRequestedServiceQuotaChangeRequest.Builder}
     * avoiding the need to create one manually via {@link GetRequestedServiceQuotaChangeRequest#builder()}
     * </p>
     *
     * @param getRequestedServiceQuotaChangeRequest
     *        A {@link Consumer} that will call methods on {@link GetRequestedServiceQuotaChangeRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetRequestedServiceQuotaChange operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>NoSuchResourceException The specified resource does not exist.</li>
     *         <li>IllegalArgumentException Invalid input was provided.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.GetRequestedServiceQuotaChange
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/GetRequestedServiceQuotaChange"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRequestedServiceQuotaChangeResponse> getRequestedServiceQuotaChange(
            Consumer<GetRequestedServiceQuotaChangeRequest.Builder> getRequestedServiceQuotaChangeRequest) {
        return getRequestedServiceQuotaChange(GetRequestedServiceQuotaChangeRequest.builder()
                .applyMutation(getRequestedServiceQuotaChangeRequest).build());
    }

    /**
     * <p>
     * Returns the details for the specified service quota. This operation provides a different Value than the
     * <code>GetAWSDefaultServiceQuota</code> operation. This operation returns the applied value for each quota.
     * <code>GetAWSDefaultServiceQuota</code> returns the default AWS value for each quota.
     * </p>
     *
     * @param getServiceQuotaRequest
     * @return A Java Future containing the result of the GetServiceQuota operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>NoSuchResourceException The specified resource does not exist.</li>
     *         <li>IllegalArgumentException Invalid input was provided.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.GetServiceQuota
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/GetServiceQuota" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetServiceQuotaResponse> getServiceQuota(GetServiceQuotaRequest getServiceQuotaRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the details for the specified service quota. This operation provides a different Value than the
     * <code>GetAWSDefaultServiceQuota</code> operation. This operation returns the applied value for each quota.
     * <code>GetAWSDefaultServiceQuota</code> returns the default AWS value for each quota.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetServiceQuotaRequest.Builder} avoiding the need
     * to create one manually via {@link GetServiceQuotaRequest#builder()}
     * </p>
     *
     * @param getServiceQuotaRequest
     *        A {@link Consumer} that will call methods on {@link GetServiceQuotaRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetServiceQuota operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>NoSuchResourceException The specified resource does not exist.</li>
     *         <li>IllegalArgumentException Invalid input was provided.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.GetServiceQuota
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/GetServiceQuota" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetServiceQuotaResponse> getServiceQuota(
            Consumer<GetServiceQuotaRequest.Builder> getServiceQuotaRequest) {
        return getServiceQuota(GetServiceQuotaRequest.builder().applyMutation(getServiceQuotaRequest).build());
    }

    /**
     * <p>
     * Returns the details of the service quota increase request in your template.
     * </p>
     *
     * @param getServiceQuotaIncreaseRequestFromTemplateRequest
     * @return A Java Future containing the result of the GetServiceQuotaIncreaseRequestFromTemplate operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>DependencyAccessDeniedException You can't perform this action because a dependency does not have
     *         access.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>NoSuchResourceException The specified resource does not exist.</li>
     *         <li>IllegalArgumentException Invalid input was provided.</li>
     *         <li>AwsServiceAccessNotEnabledException The action you attempted is not allowed unless Service Access
     *         with Service Quotas is enabled in your organization. To enable, call
     *         <a>AssociateServiceQuotaTemplate</a>.</li>
     *         <li>TemplatesNotAvailableInRegionException The Service Quotas template is not available in the Region
     *         where you are making the request. Please make the request in us-east-1.</li>
     *         <li>NoAvailableOrganizationException The account making this call is not a member of an organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.GetServiceQuotaIncreaseRequestFromTemplate
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/GetServiceQuotaIncreaseRequestFromTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetServiceQuotaIncreaseRequestFromTemplateResponse> getServiceQuotaIncreaseRequestFromTemplate(
            GetServiceQuotaIncreaseRequestFromTemplateRequest getServiceQuotaIncreaseRequestFromTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the details of the service quota increase request in your template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetServiceQuotaIncreaseRequestFromTemplateRequest.Builder} avoiding the need to create one manually via
     * {@link GetServiceQuotaIncreaseRequestFromTemplateRequest#builder()}
     * </p>
     *
     * @param getServiceQuotaIncreaseRequestFromTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link GetServiceQuotaIncreaseRequestFromTemplateRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetServiceQuotaIncreaseRequestFromTemplate operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>DependencyAccessDeniedException You can't perform this action because a dependency does not have
     *         access.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>NoSuchResourceException The specified resource does not exist.</li>
     *         <li>IllegalArgumentException Invalid input was provided.</li>
     *         <li>AwsServiceAccessNotEnabledException The action you attempted is not allowed unless Service Access
     *         with Service Quotas is enabled in your organization. To enable, call
     *         <a>AssociateServiceQuotaTemplate</a>.</li>
     *         <li>TemplatesNotAvailableInRegionException The Service Quotas template is not available in the Region
     *         where you are making the request. Please make the request in us-east-1.</li>
     *         <li>NoAvailableOrganizationException The account making this call is not a member of an organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.GetServiceQuotaIncreaseRequestFromTemplate
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/GetServiceQuotaIncreaseRequestFromTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetServiceQuotaIncreaseRequestFromTemplateResponse> getServiceQuotaIncreaseRequestFromTemplate(
            Consumer<GetServiceQuotaIncreaseRequestFromTemplateRequest.Builder> getServiceQuotaIncreaseRequestFromTemplateRequest) {
        return getServiceQuotaIncreaseRequestFromTemplate(GetServiceQuotaIncreaseRequestFromTemplateRequest.builder()
                .applyMutation(getServiceQuotaIncreaseRequestFromTemplateRequest).build());
    }

    /**
     * <p>
     * Lists all default service quotas for the specified AWS service or all AWS services. ListAWSDefaultServiceQuotas
     * is similar to <a>ListServiceQuotas</a> except for the Value object. The Value object returned by
     * <code>ListAWSDefaultServiceQuotas</code> is the default value assigned by AWS. This request returns a list of all
     * service quotas for the specified service. The listing of each you'll see the default values are the values that
     * AWS provides for the quotas.
     * </p>
     * <note>
     * <p>
     * Always check the <code>NextToken</code> response parameter when calling any of the <code>List*</code> operations.
     * These operations can return an unexpected list of results, even when there are more results available. When this
     * happens, the <code>NextToken</code> response parameter contains a value to pass the next call to the same API to
     * request the next part of the list.
     * </p>
     * </note>
     *
     * @param listAwsDefaultServiceQuotasRequest
     * @return A Java Future containing the result of the ListAWSDefaultServiceQuotas operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>NoSuchResourceException The specified resource does not exist.</li>
     *         <li>IllegalArgumentException Invalid input was provided.</li>
     *         <li>InvalidPaginationTokenException Invalid input was provided.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.ListAWSDefaultServiceQuotas
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListAWSDefaultServiceQuotas"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAwsDefaultServiceQuotasResponse> listAWSDefaultServiceQuotas(
            ListAwsDefaultServiceQuotasRequest listAwsDefaultServiceQuotasRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all default service quotas for the specified AWS service or all AWS services. ListAWSDefaultServiceQuotas
     * is similar to <a>ListServiceQuotas</a> except for the Value object. The Value object returned by
     * <code>ListAWSDefaultServiceQuotas</code> is the default value assigned by AWS. This request returns a list of all
     * service quotas for the specified service. The listing of each you'll see the default values are the values that
     * AWS provides for the quotas.
     * </p>
     * <note>
     * <p>
     * Always check the <code>NextToken</code> response parameter when calling any of the <code>List*</code> operations.
     * These operations can return an unexpected list of results, even when there are more results available. When this
     * happens, the <code>NextToken</code> response parameter contains a value to pass the next call to the same API to
     * request the next part of the list.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAwsDefaultServiceQuotasRequest.Builder}
     * avoiding the need to create one manually via {@link ListAwsDefaultServiceQuotasRequest#builder()}
     * </p>
     *
     * @param listAwsDefaultServiceQuotasRequest
     *        A {@link Consumer} that will call methods on {@link ListAWSDefaultServiceQuotasRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListAWSDefaultServiceQuotas operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>NoSuchResourceException The specified resource does not exist.</li>
     *         <li>IllegalArgumentException Invalid input was provided.</li>
     *         <li>InvalidPaginationTokenException Invalid input was provided.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.ListAWSDefaultServiceQuotas
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListAWSDefaultServiceQuotas"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAwsDefaultServiceQuotasResponse> listAWSDefaultServiceQuotas(
            Consumer<ListAwsDefaultServiceQuotasRequest.Builder> listAwsDefaultServiceQuotasRequest) {
        return listAWSDefaultServiceQuotas(ListAwsDefaultServiceQuotasRequest.builder()
                .applyMutation(listAwsDefaultServiceQuotasRequest).build());
    }

    /**
     * <p>
     * Lists all default service quotas for the specified AWS service or all AWS services. ListAWSDefaultServiceQuotas
     * is similar to <a>ListServiceQuotas</a> except for the Value object. The Value object returned by
     * <code>ListAWSDefaultServiceQuotas</code> is the default value assigned by AWS. This request returns a list of all
     * service quotas for the specified service. The listing of each you'll see the default values are the values that
     * AWS provides for the quotas.
     * </p>
     * <note>
     * <p>
     * Always check the <code>NextToken</code> response parameter when calling any of the <code>List*</code> operations.
     * These operations can return an unexpected list of results, even when there are more results available. When this
     * happens, the <code>NextToken</code> response parameter contains a value to pass the next call to the same API to
     * request the next part of the list.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listAWSDefaultServiceQuotas(software.amazon.awssdk.services.servicequotas.model.ListAwsDefaultServiceQuotasRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicequotas.paginators.ListAWSDefaultServiceQuotasPublisher publisher = client.listAWSDefaultServiceQuotasPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicequotas.paginators.ListAWSDefaultServiceQuotasPublisher publisher = client.listAWSDefaultServiceQuotasPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicequotas.model.ListAwsDefaultServiceQuotasResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicequotas.model.ListAwsDefaultServiceQuotasResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAWSDefaultServiceQuotas(software.amazon.awssdk.services.servicequotas.model.ListAwsDefaultServiceQuotasRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAwsDefaultServiceQuotasRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>NoSuchResourceException The specified resource does not exist.</li>
     *         <li>IllegalArgumentException Invalid input was provided.</li>
     *         <li>InvalidPaginationTokenException Invalid input was provided.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.ListAWSDefaultServiceQuotas
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListAWSDefaultServiceQuotas"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAWSDefaultServiceQuotasPublisher listAWSDefaultServiceQuotasPaginator(
            ListAwsDefaultServiceQuotasRequest listAwsDefaultServiceQuotasRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all default service quotas for the specified AWS service or all AWS services. ListAWSDefaultServiceQuotas
     * is similar to <a>ListServiceQuotas</a> except for the Value object. The Value object returned by
     * <code>ListAWSDefaultServiceQuotas</code> is the default value assigned by AWS. This request returns a list of all
     * service quotas for the specified service. The listing of each you'll see the default values are the values that
     * AWS provides for the quotas.
     * </p>
     * <note>
     * <p>
     * Always check the <code>NextToken</code> response parameter when calling any of the <code>List*</code> operations.
     * These operations can return an unexpected list of results, even when there are more results available. When this
     * happens, the <code>NextToken</code> response parameter contains a value to pass the next call to the same API to
     * request the next part of the list.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listAWSDefaultServiceQuotas(software.amazon.awssdk.services.servicequotas.model.ListAwsDefaultServiceQuotasRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicequotas.paginators.ListAWSDefaultServiceQuotasPublisher publisher = client.listAWSDefaultServiceQuotasPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicequotas.paginators.ListAWSDefaultServiceQuotasPublisher publisher = client.listAWSDefaultServiceQuotasPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicequotas.model.ListAwsDefaultServiceQuotasResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicequotas.model.ListAwsDefaultServiceQuotasResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAWSDefaultServiceQuotas(software.amazon.awssdk.services.servicequotas.model.ListAwsDefaultServiceQuotasRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAwsDefaultServiceQuotasRequest.Builder}
     * avoiding the need to create one manually via {@link ListAwsDefaultServiceQuotasRequest#builder()}
     * </p>
     *
     * @param listAwsDefaultServiceQuotasRequest
     *        A {@link Consumer} that will call methods on {@link ListAWSDefaultServiceQuotasRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>NoSuchResourceException The specified resource does not exist.</li>
     *         <li>IllegalArgumentException Invalid input was provided.</li>
     *         <li>InvalidPaginationTokenException Invalid input was provided.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.ListAWSDefaultServiceQuotas
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListAWSDefaultServiceQuotas"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAWSDefaultServiceQuotasPublisher listAWSDefaultServiceQuotasPaginator(
            Consumer<ListAwsDefaultServiceQuotasRequest.Builder> listAwsDefaultServiceQuotasRequest) {
        return listAWSDefaultServiceQuotasPaginator(ListAwsDefaultServiceQuotasRequest.builder()
                .applyMutation(listAwsDefaultServiceQuotasRequest).build());
    }

    /**
     * <p>
     * Requests a list of the changes to quotas for a service.
     * </p>
     *
     * @param listRequestedServiceQuotaChangeHistoryRequest
     * @return A Java Future containing the result of the ListRequestedServiceQuotaChangeHistory operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>NoSuchResourceException The specified resource does not exist.</li>
     *         <li>IllegalArgumentException Invalid input was provided.</li>
     *         <li>InvalidPaginationTokenException Invalid input was provided.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.ListRequestedServiceQuotaChangeHistory
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListRequestedServiceQuotaChangeHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRequestedServiceQuotaChangeHistoryResponse> listRequestedServiceQuotaChangeHistory(
            ListRequestedServiceQuotaChangeHistoryRequest listRequestedServiceQuotaChangeHistoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Requests a list of the changes to quotas for a service.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListRequestedServiceQuotaChangeHistoryRequest.Builder} avoiding the need to create one manually via
     * {@link ListRequestedServiceQuotaChangeHistoryRequest#builder()}
     * </p>
     *
     * @param listRequestedServiceQuotaChangeHistoryRequest
     *        A {@link Consumer} that will call methods on {@link ListRequestedServiceQuotaChangeHistoryRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListRequestedServiceQuotaChangeHistory operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>NoSuchResourceException The specified resource does not exist.</li>
     *         <li>IllegalArgumentException Invalid input was provided.</li>
     *         <li>InvalidPaginationTokenException Invalid input was provided.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.ListRequestedServiceQuotaChangeHistory
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListRequestedServiceQuotaChangeHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRequestedServiceQuotaChangeHistoryResponse> listRequestedServiceQuotaChangeHistory(
            Consumer<ListRequestedServiceQuotaChangeHistoryRequest.Builder> listRequestedServiceQuotaChangeHistoryRequest) {
        return listRequestedServiceQuotaChangeHistory(ListRequestedServiceQuotaChangeHistoryRequest.builder()
                .applyMutation(listRequestedServiceQuotaChangeHistoryRequest).build());
    }

    /**
     * <p>
     * Requests a list of the changes to specific service quotas. This command provides additional granularity over the
     * <code>ListRequestedServiceQuotaChangeHistory</code> command. Once a quota change request has reached
     * <code>CASE_CLOSED, APPROVED,</code> or <code>DENIED</code>, the history has been kept for 90 days.
     * </p>
     *
     * @param listRequestedServiceQuotaChangeHistoryByQuotaRequest
     * @return A Java Future containing the result of the ListRequestedServiceQuotaChangeHistoryByQuota operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>NoSuchResourceException The specified resource does not exist.</li>
     *         <li>IllegalArgumentException Invalid input was provided.</li>
     *         <li>InvalidPaginationTokenException Invalid input was provided.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.ListRequestedServiceQuotaChangeHistoryByQuota
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListRequestedServiceQuotaChangeHistoryByQuota"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRequestedServiceQuotaChangeHistoryByQuotaResponse> listRequestedServiceQuotaChangeHistoryByQuota(
            ListRequestedServiceQuotaChangeHistoryByQuotaRequest listRequestedServiceQuotaChangeHistoryByQuotaRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Requests a list of the changes to specific service quotas. This command provides additional granularity over the
     * <code>ListRequestedServiceQuotaChangeHistory</code> command. Once a quota change request has reached
     * <code>CASE_CLOSED, APPROVED,</code> or <code>DENIED</code>, the history has been kept for 90 days.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListRequestedServiceQuotaChangeHistoryByQuotaRequest.Builder} avoiding the need to create one manually via
     * {@link ListRequestedServiceQuotaChangeHistoryByQuotaRequest#builder()}
     * </p>
     *
     * @param listRequestedServiceQuotaChangeHistoryByQuotaRequest
     *        A {@link Consumer} that will call methods on
     *        {@link ListRequestedServiceQuotaChangeHistoryByQuotaRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListRequestedServiceQuotaChangeHistoryByQuota operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>NoSuchResourceException The specified resource does not exist.</li>
     *         <li>IllegalArgumentException Invalid input was provided.</li>
     *         <li>InvalidPaginationTokenException Invalid input was provided.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.ListRequestedServiceQuotaChangeHistoryByQuota
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListRequestedServiceQuotaChangeHistoryByQuota"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRequestedServiceQuotaChangeHistoryByQuotaResponse> listRequestedServiceQuotaChangeHistoryByQuota(
            Consumer<ListRequestedServiceQuotaChangeHistoryByQuotaRequest.Builder> listRequestedServiceQuotaChangeHistoryByQuotaRequest) {
        return listRequestedServiceQuotaChangeHistoryByQuota(ListRequestedServiceQuotaChangeHistoryByQuotaRequest.builder()
                .applyMutation(listRequestedServiceQuotaChangeHistoryByQuotaRequest).build());
    }

    /**
     * <p>
     * Requests a list of the changes to specific service quotas. This command provides additional granularity over the
     * <code>ListRequestedServiceQuotaChangeHistory</code> command. Once a quota change request has reached
     * <code>CASE_CLOSED, APPROVED,</code> or <code>DENIED</code>, the history has been kept for 90 days.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRequestedServiceQuotaChangeHistoryByQuota(software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicequotas.paginators.ListRequestedServiceQuotaChangeHistoryByQuotaPublisher publisher = client.listRequestedServiceQuotaChangeHistoryByQuotaPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicequotas.paginators.ListRequestedServiceQuotaChangeHistoryByQuotaPublisher publisher = client.listRequestedServiceQuotaChangeHistoryByQuotaPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRequestedServiceQuotaChangeHistoryByQuota(software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRequestedServiceQuotaChangeHistoryByQuotaRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>NoSuchResourceException The specified resource does not exist.</li>
     *         <li>IllegalArgumentException Invalid input was provided.</li>
     *         <li>InvalidPaginationTokenException Invalid input was provided.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.ListRequestedServiceQuotaChangeHistoryByQuota
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListRequestedServiceQuotaChangeHistoryByQuota"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRequestedServiceQuotaChangeHistoryByQuotaPublisher listRequestedServiceQuotaChangeHistoryByQuotaPaginator(
            ListRequestedServiceQuotaChangeHistoryByQuotaRequest listRequestedServiceQuotaChangeHistoryByQuotaRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Requests a list of the changes to specific service quotas. This command provides additional granularity over the
     * <code>ListRequestedServiceQuotaChangeHistory</code> command. Once a quota change request has reached
     * <code>CASE_CLOSED, APPROVED,</code> or <code>DENIED</code>, the history has been kept for 90 days.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRequestedServiceQuotaChangeHistoryByQuota(software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicequotas.paginators.ListRequestedServiceQuotaChangeHistoryByQuotaPublisher publisher = client.listRequestedServiceQuotaChangeHistoryByQuotaPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicequotas.paginators.ListRequestedServiceQuotaChangeHistoryByQuotaPublisher publisher = client.listRequestedServiceQuotaChangeHistoryByQuotaPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRequestedServiceQuotaChangeHistoryByQuota(software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListRequestedServiceQuotaChangeHistoryByQuotaRequest.Builder} avoiding the need to create one manually via
     * {@link ListRequestedServiceQuotaChangeHistoryByQuotaRequest#builder()}
     * </p>
     *
     * @param listRequestedServiceQuotaChangeHistoryByQuotaRequest
     *        A {@link Consumer} that will call methods on
     *        {@link ListRequestedServiceQuotaChangeHistoryByQuotaRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>NoSuchResourceException The specified resource does not exist.</li>
     *         <li>IllegalArgumentException Invalid input was provided.</li>
     *         <li>InvalidPaginationTokenException Invalid input was provided.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.ListRequestedServiceQuotaChangeHistoryByQuota
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListRequestedServiceQuotaChangeHistoryByQuota"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRequestedServiceQuotaChangeHistoryByQuotaPublisher listRequestedServiceQuotaChangeHistoryByQuotaPaginator(
            Consumer<ListRequestedServiceQuotaChangeHistoryByQuotaRequest.Builder> listRequestedServiceQuotaChangeHistoryByQuotaRequest) {
        return listRequestedServiceQuotaChangeHistoryByQuotaPaginator(ListRequestedServiceQuotaChangeHistoryByQuotaRequest
                .builder().applyMutation(listRequestedServiceQuotaChangeHistoryByQuotaRequest).build());
    }

    /**
     * <p>
     * Requests a list of the changes to quotas for a service.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRequestedServiceQuotaChangeHistory(software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicequotas.paginators.ListRequestedServiceQuotaChangeHistoryPublisher publisher = client.listRequestedServiceQuotaChangeHistoryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicequotas.paginators.ListRequestedServiceQuotaChangeHistoryPublisher publisher = client.listRequestedServiceQuotaChangeHistoryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRequestedServiceQuotaChangeHistory(software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRequestedServiceQuotaChangeHistoryRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>NoSuchResourceException The specified resource does not exist.</li>
     *         <li>IllegalArgumentException Invalid input was provided.</li>
     *         <li>InvalidPaginationTokenException Invalid input was provided.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.ListRequestedServiceQuotaChangeHistory
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListRequestedServiceQuotaChangeHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRequestedServiceQuotaChangeHistoryPublisher listRequestedServiceQuotaChangeHistoryPaginator(
            ListRequestedServiceQuotaChangeHistoryRequest listRequestedServiceQuotaChangeHistoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Requests a list of the changes to quotas for a service.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRequestedServiceQuotaChangeHistory(software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicequotas.paginators.ListRequestedServiceQuotaChangeHistoryPublisher publisher = client.listRequestedServiceQuotaChangeHistoryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicequotas.paginators.ListRequestedServiceQuotaChangeHistoryPublisher publisher = client.listRequestedServiceQuotaChangeHistoryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRequestedServiceQuotaChangeHistory(software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListRequestedServiceQuotaChangeHistoryRequest.Builder} avoiding the need to create one manually via
     * {@link ListRequestedServiceQuotaChangeHistoryRequest#builder()}
     * </p>
     *
     * @param listRequestedServiceQuotaChangeHistoryRequest
     *        A {@link Consumer} that will call methods on {@link ListRequestedServiceQuotaChangeHistoryRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>NoSuchResourceException The specified resource does not exist.</li>
     *         <li>IllegalArgumentException Invalid input was provided.</li>
     *         <li>InvalidPaginationTokenException Invalid input was provided.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.ListRequestedServiceQuotaChangeHistory
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListRequestedServiceQuotaChangeHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRequestedServiceQuotaChangeHistoryPublisher listRequestedServiceQuotaChangeHistoryPaginator(
            Consumer<ListRequestedServiceQuotaChangeHistoryRequest.Builder> listRequestedServiceQuotaChangeHistoryRequest) {
        return listRequestedServiceQuotaChangeHistoryPaginator(ListRequestedServiceQuotaChangeHistoryRequest.builder()
                .applyMutation(listRequestedServiceQuotaChangeHistoryRequest).build());
    }

    /**
     * <p>
     * Returns a list of the quota increase requests in the template.
     * </p>
     *
     * @param listServiceQuotaIncreaseRequestsInTemplateRequest
     * @return A Java Future containing the result of the ListServiceQuotaIncreaseRequestsInTemplate operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>DependencyAccessDeniedException You can't perform this action because a dependency does not have
     *         access.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>IllegalArgumentException Invalid input was provided.</li>
     *         <li>AwsServiceAccessNotEnabledException The action you attempted is not allowed unless Service Access
     *         with Service Quotas is enabled in your organization. To enable, call
     *         <a>AssociateServiceQuotaTemplate</a>.</li>
     *         <li>TemplatesNotAvailableInRegionException The Service Quotas template is not available in the Region
     *         where you are making the request. Please make the request in us-east-1.</li>
     *         <li>NoAvailableOrganizationException The account making this call is not a member of an organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.ListServiceQuotaIncreaseRequestsInTemplate
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListServiceQuotaIncreaseRequestsInTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListServiceQuotaIncreaseRequestsInTemplateResponse> listServiceQuotaIncreaseRequestsInTemplate(
            ListServiceQuotaIncreaseRequestsInTemplateRequest listServiceQuotaIncreaseRequestsInTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the quota increase requests in the template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListServiceQuotaIncreaseRequestsInTemplateRequest.Builder} avoiding the need to create one manually via
     * {@link ListServiceQuotaIncreaseRequestsInTemplateRequest#builder()}
     * </p>
     *
     * @param listServiceQuotaIncreaseRequestsInTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link ListServiceQuotaIncreaseRequestsInTemplateRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListServiceQuotaIncreaseRequestsInTemplate operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>DependencyAccessDeniedException You can't perform this action because a dependency does not have
     *         access.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>IllegalArgumentException Invalid input was provided.</li>
     *         <li>AwsServiceAccessNotEnabledException The action you attempted is not allowed unless Service Access
     *         with Service Quotas is enabled in your organization. To enable, call
     *         <a>AssociateServiceQuotaTemplate</a>.</li>
     *         <li>TemplatesNotAvailableInRegionException The Service Quotas template is not available in the Region
     *         where you are making the request. Please make the request in us-east-1.</li>
     *         <li>NoAvailableOrganizationException The account making this call is not a member of an organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.ListServiceQuotaIncreaseRequestsInTemplate
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListServiceQuotaIncreaseRequestsInTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListServiceQuotaIncreaseRequestsInTemplateResponse> listServiceQuotaIncreaseRequestsInTemplate(
            Consumer<ListServiceQuotaIncreaseRequestsInTemplateRequest.Builder> listServiceQuotaIncreaseRequestsInTemplateRequest) {
        return listServiceQuotaIncreaseRequestsInTemplate(ListServiceQuotaIncreaseRequestsInTemplateRequest.builder()
                .applyMutation(listServiceQuotaIncreaseRequestsInTemplateRequest).build());
    }

    /**
     * <p>
     * Returns a list of the quota increase requests in the template.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listServiceQuotaIncreaseRequestsInTemplate(software.amazon.awssdk.services.servicequotas.model.ListServiceQuotaIncreaseRequestsInTemplateRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicequotas.paginators.ListServiceQuotaIncreaseRequestsInTemplatePublisher publisher = client.listServiceQuotaIncreaseRequestsInTemplatePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicequotas.paginators.ListServiceQuotaIncreaseRequestsInTemplatePublisher publisher = client.listServiceQuotaIncreaseRequestsInTemplatePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicequotas.model.ListServiceQuotaIncreaseRequestsInTemplateResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicequotas.model.ListServiceQuotaIncreaseRequestsInTemplateResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServiceQuotaIncreaseRequestsInTemplate(software.amazon.awssdk.services.servicequotas.model.ListServiceQuotaIncreaseRequestsInTemplateRequest)}
     * operation.</b>
     * </p>
     *
     * @param listServiceQuotaIncreaseRequestsInTemplateRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>DependencyAccessDeniedException You can't perform this action because a dependency does not have
     *         access.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>IllegalArgumentException Invalid input was provided.</li>
     *         <li>AwsServiceAccessNotEnabledException The action you attempted is not allowed unless Service Access
     *         with Service Quotas is enabled in your organization. To enable, call
     *         <a>AssociateServiceQuotaTemplate</a>.</li>
     *         <li>TemplatesNotAvailableInRegionException The Service Quotas template is not available in the Region
     *         where you are making the request. Please make the request in us-east-1.</li>
     *         <li>NoAvailableOrganizationException The account making this call is not a member of an organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.ListServiceQuotaIncreaseRequestsInTemplate
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListServiceQuotaIncreaseRequestsInTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceQuotaIncreaseRequestsInTemplatePublisher listServiceQuotaIncreaseRequestsInTemplatePaginator(
            ListServiceQuotaIncreaseRequestsInTemplateRequest listServiceQuotaIncreaseRequestsInTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the quota increase requests in the template.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listServiceQuotaIncreaseRequestsInTemplate(software.amazon.awssdk.services.servicequotas.model.ListServiceQuotaIncreaseRequestsInTemplateRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicequotas.paginators.ListServiceQuotaIncreaseRequestsInTemplatePublisher publisher = client.listServiceQuotaIncreaseRequestsInTemplatePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicequotas.paginators.ListServiceQuotaIncreaseRequestsInTemplatePublisher publisher = client.listServiceQuotaIncreaseRequestsInTemplatePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicequotas.model.ListServiceQuotaIncreaseRequestsInTemplateResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicequotas.model.ListServiceQuotaIncreaseRequestsInTemplateResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServiceQuotaIncreaseRequestsInTemplate(software.amazon.awssdk.services.servicequotas.model.ListServiceQuotaIncreaseRequestsInTemplateRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListServiceQuotaIncreaseRequestsInTemplateRequest.Builder} avoiding the need to create one manually via
     * {@link ListServiceQuotaIncreaseRequestsInTemplateRequest#builder()}
     * </p>
     *
     * @param listServiceQuotaIncreaseRequestsInTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link ListServiceQuotaIncreaseRequestsInTemplateRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>DependencyAccessDeniedException You can't perform this action because a dependency does not have
     *         access.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>IllegalArgumentException Invalid input was provided.</li>
     *         <li>AwsServiceAccessNotEnabledException The action you attempted is not allowed unless Service Access
     *         with Service Quotas is enabled in your organization. To enable, call
     *         <a>AssociateServiceQuotaTemplate</a>.</li>
     *         <li>TemplatesNotAvailableInRegionException The Service Quotas template is not available in the Region
     *         where you are making the request. Please make the request in us-east-1.</li>
     *         <li>NoAvailableOrganizationException The account making this call is not a member of an organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.ListServiceQuotaIncreaseRequestsInTemplate
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListServiceQuotaIncreaseRequestsInTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceQuotaIncreaseRequestsInTemplatePublisher listServiceQuotaIncreaseRequestsInTemplatePaginator(
            Consumer<ListServiceQuotaIncreaseRequestsInTemplateRequest.Builder> listServiceQuotaIncreaseRequestsInTemplateRequest) {
        return listServiceQuotaIncreaseRequestsInTemplatePaginator(ListServiceQuotaIncreaseRequestsInTemplateRequest.builder()
                .applyMutation(listServiceQuotaIncreaseRequestsInTemplateRequest).build());
    }

    /**
     * <p>
     * Lists all service quotas for the specified AWS service. This request returns a list of the service quotas for the
     * specified service. you'll see the default values are the values that AWS provides for the quotas.
     * </p>
     * <note>
     * <p>
     * Always check the <code>NextToken</code> response parameter when calling any of the <code>List*</code> operations.
     * These operations can return an unexpected list of results, even when there are more results available. When this
     * happens, the <code>NextToken</code> response parameter contains a value to pass the next call to the same API to
     * request the next part of the list.
     * </p>
     * </note>
     *
     * @param listServiceQuotasRequest
     * @return A Java Future containing the result of the ListServiceQuotas operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>NoSuchResourceException The specified resource does not exist.</li>
     *         <li>IllegalArgumentException Invalid input was provided.</li>
     *         <li>InvalidPaginationTokenException Invalid input was provided.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.ListServiceQuotas
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListServiceQuotas"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListServiceQuotasResponse> listServiceQuotas(ListServiceQuotasRequest listServiceQuotasRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all service quotas for the specified AWS service. This request returns a list of the service quotas for the
     * specified service. you'll see the default values are the values that AWS provides for the quotas.
     * </p>
     * <note>
     * <p>
     * Always check the <code>NextToken</code> response parameter when calling any of the <code>List*</code> operations.
     * These operations can return an unexpected list of results, even when there are more results available. When this
     * happens, the <code>NextToken</code> response parameter contains a value to pass the next call to the same API to
     * request the next part of the list.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServiceQuotasRequest.Builder} avoiding the need
     * to create one manually via {@link ListServiceQuotasRequest#builder()}
     * </p>
     *
     * @param listServiceQuotasRequest
     *        A {@link Consumer} that will call methods on {@link ListServiceQuotasRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListServiceQuotas operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>NoSuchResourceException The specified resource does not exist.</li>
     *         <li>IllegalArgumentException Invalid input was provided.</li>
     *         <li>InvalidPaginationTokenException Invalid input was provided.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.ListServiceQuotas
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListServiceQuotas"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListServiceQuotasResponse> listServiceQuotas(
            Consumer<ListServiceQuotasRequest.Builder> listServiceQuotasRequest) {
        return listServiceQuotas(ListServiceQuotasRequest.builder().applyMutation(listServiceQuotasRequest).build());
    }

    /**
     * <p>
     * Lists all service quotas for the specified AWS service. This request returns a list of the service quotas for the
     * specified service. you'll see the default values are the values that AWS provides for the quotas.
     * </p>
     * <note>
     * <p>
     * Always check the <code>NextToken</code> response parameter when calling any of the <code>List*</code> operations.
     * These operations can return an unexpected list of results, even when there are more results available. When this
     * happens, the <code>NextToken</code> response parameter contains a value to pass the next call to the same API to
     * request the next part of the list.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listServiceQuotas(software.amazon.awssdk.services.servicequotas.model.ListServiceQuotasRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicequotas.paginators.ListServiceQuotasPublisher publisher = client.listServiceQuotasPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicequotas.paginators.ListServiceQuotasPublisher publisher = client.listServiceQuotasPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicequotas.model.ListServiceQuotasResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicequotas.model.ListServiceQuotasResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServiceQuotas(software.amazon.awssdk.services.servicequotas.model.ListServiceQuotasRequest)}
     * operation.</b>
     * </p>
     *
     * @param listServiceQuotasRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>NoSuchResourceException The specified resource does not exist.</li>
     *         <li>IllegalArgumentException Invalid input was provided.</li>
     *         <li>InvalidPaginationTokenException Invalid input was provided.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.ListServiceQuotas
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListServiceQuotas"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceQuotasPublisher listServiceQuotasPaginator(ListServiceQuotasRequest listServiceQuotasRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all service quotas for the specified AWS service. This request returns a list of the service quotas for the
     * specified service. you'll see the default values are the values that AWS provides for the quotas.
     * </p>
     * <note>
     * <p>
     * Always check the <code>NextToken</code> response parameter when calling any of the <code>List*</code> operations.
     * These operations can return an unexpected list of results, even when there are more results available. When this
     * happens, the <code>NextToken</code> response parameter contains a value to pass the next call to the same API to
     * request the next part of the list.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listServiceQuotas(software.amazon.awssdk.services.servicequotas.model.ListServiceQuotasRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicequotas.paginators.ListServiceQuotasPublisher publisher = client.listServiceQuotasPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicequotas.paginators.ListServiceQuotasPublisher publisher = client.listServiceQuotasPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicequotas.model.ListServiceQuotasResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicequotas.model.ListServiceQuotasResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServiceQuotas(software.amazon.awssdk.services.servicequotas.model.ListServiceQuotasRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServiceQuotasRequest.Builder} avoiding the need
     * to create one manually via {@link ListServiceQuotasRequest#builder()}
     * </p>
     *
     * @param listServiceQuotasRequest
     *        A {@link Consumer} that will call methods on {@link ListServiceQuotasRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>NoSuchResourceException The specified resource does not exist.</li>
     *         <li>IllegalArgumentException Invalid input was provided.</li>
     *         <li>InvalidPaginationTokenException Invalid input was provided.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.ListServiceQuotas
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListServiceQuotas"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceQuotasPublisher listServiceQuotasPaginator(
            Consumer<ListServiceQuotasRequest.Builder> listServiceQuotasRequest) {
        return listServiceQuotasPaginator(ListServiceQuotasRequest.builder().applyMutation(listServiceQuotasRequest).build());
    }

    /**
     * <p>
     * Lists the AWS services available in Service Quotas. Not all AWS services are available in Service Quotas. To list
     * the see the list of the service quotas for a specific service, use <a>ListServiceQuotas</a>.
     * </p>
     *
     * @param listServicesRequest
     * @return A Java Future containing the result of the ListServices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>IllegalArgumentException Invalid input was provided.</li>
     *         <li>InvalidPaginationTokenException Invalid input was provided.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.ListServices
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListServices" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListServicesResponse> listServices(ListServicesRequest listServicesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the AWS services available in Service Quotas. Not all AWS services are available in Service Quotas. To list
     * the see the list of the service quotas for a specific service, use <a>ListServiceQuotas</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServicesRequest.Builder} avoiding the need to
     * create one manually via {@link ListServicesRequest#builder()}
     * </p>
     *
     * @param listServicesRequest
     *        A {@link Consumer} that will call methods on {@link ListServicesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListServices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>IllegalArgumentException Invalid input was provided.</li>
     *         <li>InvalidPaginationTokenException Invalid input was provided.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.ListServices
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListServices" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListServicesResponse> listServices(Consumer<ListServicesRequest.Builder> listServicesRequest) {
        return listServices(ListServicesRequest.builder().applyMutation(listServicesRequest).build());
    }

    /**
     * <p>
     * Lists the AWS services available in Service Quotas. Not all AWS services are available in Service Quotas. To list
     * the see the list of the service quotas for a specific service, use <a>ListServiceQuotas</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listServices(software.amazon.awssdk.services.servicequotas.model.ListServicesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicequotas.paginators.ListServicesPublisher publisher = client.listServicesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicequotas.paginators.ListServicesPublisher publisher = client.listServicesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicequotas.model.ListServicesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicequotas.model.ListServicesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServices(software.amazon.awssdk.services.servicequotas.model.ListServicesRequest)} operation.</b>
     * </p>
     *
     * @param listServicesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>IllegalArgumentException Invalid input was provided.</li>
     *         <li>InvalidPaginationTokenException Invalid input was provided.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.ListServices
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListServices" target="_top">AWS
     *      API Documentation</a>
     */
    default ListServicesPublisher listServicesPaginator(ListServicesRequest listServicesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the AWS services available in Service Quotas. Not all AWS services are available in Service Quotas. To list
     * the see the list of the service quotas for a specific service, use <a>ListServiceQuotas</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listServices(software.amazon.awssdk.services.servicequotas.model.ListServicesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicequotas.paginators.ListServicesPublisher publisher = client.listServicesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicequotas.paginators.ListServicesPublisher publisher = client.listServicesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicequotas.model.ListServicesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicequotas.model.ListServicesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServices(software.amazon.awssdk.services.servicequotas.model.ListServicesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServicesRequest.Builder} avoiding the need to
     * create one manually via {@link ListServicesRequest#builder()}
     * </p>
     *
     * @param listServicesRequest
     *        A {@link Consumer} that will call methods on {@link ListServicesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>IllegalArgumentException Invalid input was provided.</li>
     *         <li>InvalidPaginationTokenException Invalid input was provided.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.ListServices
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListServices" target="_top">AWS
     *      API Documentation</a>
     */
    default ListServicesPublisher listServicesPaginator(Consumer<ListServicesRequest.Builder> listServicesRequest) {
        return listServicesPaginator(ListServicesRequest.builder().applyMutation(listServicesRequest).build());
    }

    /**
     * <p>
     * Defines and adds a quota to the service quota template. To add a quota to the template, you must provide the
     * <code>ServiceCode</code>, <code>QuotaCode</code>, <code>AwsRegion</code>, and <code>DesiredValue</code>. Once you
     * add a quota to the template, use <a>ListServiceQuotaIncreaseRequestsInTemplate</a> to see the list of quotas in
     * the template.
     * </p>
     *
     * @param putServiceQuotaIncreaseRequestIntoTemplateRequest
     * @return A Java Future containing the result of the PutServiceQuotaIncreaseRequestIntoTemplate operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>DependencyAccessDeniedException You can't perform this action because a dependency does not have
     *         access.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>IllegalArgumentException Invalid input was provided.</li>
     *         <li>QuotaExceededException You have exceeded your service quota. To perform the requested action, remove
     *         some of the relevant resources, or use Service Quotas to request a service quota increase.</li>
     *         <li>NoSuchResourceException The specified resource does not exist.</li>
     *         <li>AwsServiceAccessNotEnabledException The action you attempted is not allowed unless Service Access
     *         with Service Quotas is enabled in your organization. To enable, call
     *         <a>AssociateServiceQuotaTemplate</a>.</li>
     *         <li>TemplatesNotAvailableInRegionException The Service Quotas template is not available in the Region
     *         where you are making the request. Please make the request in us-east-1.</li>
     *         <li>NoAvailableOrganizationException The account making this call is not a member of an organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.PutServiceQuotaIncreaseRequestIntoTemplate
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/PutServiceQuotaIncreaseRequestIntoTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutServiceQuotaIncreaseRequestIntoTemplateResponse> putServiceQuotaIncreaseRequestIntoTemplate(
            PutServiceQuotaIncreaseRequestIntoTemplateRequest putServiceQuotaIncreaseRequestIntoTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Defines and adds a quota to the service quota template. To add a quota to the template, you must provide the
     * <code>ServiceCode</code>, <code>QuotaCode</code>, <code>AwsRegion</code>, and <code>DesiredValue</code>. Once you
     * add a quota to the template, use <a>ListServiceQuotaIncreaseRequestsInTemplate</a> to see the list of quotas in
     * the template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link PutServiceQuotaIncreaseRequestIntoTemplateRequest.Builder} avoiding the need to create one manually via
     * {@link PutServiceQuotaIncreaseRequestIntoTemplateRequest#builder()}
     * </p>
     *
     * @param putServiceQuotaIncreaseRequestIntoTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link PutServiceQuotaIncreaseRequestIntoTemplateRequest.Builder} to create a request.
     * @return A Java Future containing the result of the PutServiceQuotaIncreaseRequestIntoTemplate operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>DependencyAccessDeniedException You can't perform this action because a dependency does not have
     *         access.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>IllegalArgumentException Invalid input was provided.</li>
     *         <li>QuotaExceededException You have exceeded your service quota. To perform the requested action, remove
     *         some of the relevant resources, or use Service Quotas to request a service quota increase.</li>
     *         <li>NoSuchResourceException The specified resource does not exist.</li>
     *         <li>AwsServiceAccessNotEnabledException The action you attempted is not allowed unless Service Access
     *         with Service Quotas is enabled in your organization. To enable, call
     *         <a>AssociateServiceQuotaTemplate</a>.</li>
     *         <li>TemplatesNotAvailableInRegionException The Service Quotas template is not available in the Region
     *         where you are making the request. Please make the request in us-east-1.</li>
     *         <li>NoAvailableOrganizationException The account making this call is not a member of an organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.PutServiceQuotaIncreaseRequestIntoTemplate
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/PutServiceQuotaIncreaseRequestIntoTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutServiceQuotaIncreaseRequestIntoTemplateResponse> putServiceQuotaIncreaseRequestIntoTemplate(
            Consumer<PutServiceQuotaIncreaseRequestIntoTemplateRequest.Builder> putServiceQuotaIncreaseRequestIntoTemplateRequest) {
        return putServiceQuotaIncreaseRequestIntoTemplate(PutServiceQuotaIncreaseRequestIntoTemplateRequest.builder()
                .applyMutation(putServiceQuotaIncreaseRequestIntoTemplateRequest).build());
    }

    /**
     * <p>
     * Retrieves the details of a service quota increase request. The response to this command provides the details in
     * the <a>RequestedServiceQuotaChange</a> object.
     * </p>
     *
     * @param requestServiceQuotaIncreaseRequest
     * @return A Java Future containing the result of the RequestServiceQuotaIncrease operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DependencyAccessDeniedException You can't perform this action because a dependency does not have
     *         access.</li>
     *         <li>QuotaExceededException You have exceeded your service quota. To perform the requested action, remove
     *         some of the relevant resources, or use Service Quotas to request a service quota increase.</li>
     *         <li>ResourceAlreadyExistsException The specified resource already exists.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>NoSuchResourceException The specified resource does not exist.</li>
     *         <li>IllegalArgumentException Invalid input was provided.</li>
     *         <li>InvalidResourceStateException Invalid input was provided for the .</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.RequestServiceQuotaIncrease
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/RequestServiceQuotaIncrease"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RequestServiceQuotaIncreaseResponse> requestServiceQuotaIncrease(
            RequestServiceQuotaIncreaseRequest requestServiceQuotaIncreaseRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the details of a service quota increase request. The response to this command provides the details in
     * the <a>RequestedServiceQuotaChange</a> object.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RequestServiceQuotaIncreaseRequest.Builder}
     * avoiding the need to create one manually via {@link RequestServiceQuotaIncreaseRequest#builder()}
     * </p>
     *
     * @param requestServiceQuotaIncreaseRequest
     *        A {@link Consumer} that will call methods on {@link RequestServiceQuotaIncreaseRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the RequestServiceQuotaIncrease operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DependencyAccessDeniedException You can't perform this action because a dependency does not have
     *         access.</li>
     *         <li>QuotaExceededException You have exceeded your service quota. To perform the requested action, remove
     *         some of the relevant resources, or use Service Quotas to request a service quota increase.</li>
     *         <li>ResourceAlreadyExistsException The specified resource already exists.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>NoSuchResourceException The specified resource does not exist.</li>
     *         <li>IllegalArgumentException Invalid input was provided.</li>
     *         <li>InvalidResourceStateException Invalid input was provided for the .</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.RequestServiceQuotaIncrease
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/RequestServiceQuotaIncrease"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RequestServiceQuotaIncreaseResponse> requestServiceQuotaIncrease(
            Consumer<RequestServiceQuotaIncreaseRequest.Builder> requestServiceQuotaIncreaseRequest) {
        return requestServiceQuotaIncrease(RequestServiceQuotaIncreaseRequest.builder()
                .applyMutation(requestServiceQuotaIncreaseRequest).build());
    }
}
