/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicequotas.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ErrorCode {
    DEPENDENCY_ACCESS_DENIED_ERROR("DEPENDENCY_ACCESS_DENIED_ERROR"),
    DEPENDENCY_THROTTLING_ERROR("DEPENDENCY_THROTTLING_ERROR"),
    DEPENDENCY_SERVICE_ERROR("DEPENDENCY_SERVICE_ERROR"),
    SERVICE_QUOTA_NOT_AVAILABLE_ERROR("SERVICE_QUOTA_NOT_AVAILABLE_ERROR"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ErrorCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ErrorCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ErrorCode.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ErrorCode> knownValues() {
        return Stream.of(ErrorCode.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

