/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicequotas.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteServiceQuotaIncreaseRequestFromTemplateRequest extends ServiceQuotasRequest
        implements
        ToCopyableBuilder<DeleteServiceQuotaIncreaseRequestFromTemplateRequest.Builder, DeleteServiceQuotaIncreaseRequestFromTemplateRequest> {
    private static final SdkField<String> SERVICE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteServiceQuotaIncreaseRequestFromTemplateRequest::serviceCode))
            .setter(setter(Builder::serviceCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceCode").build()).build();

    private static final SdkField<String> QUOTA_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteServiceQuotaIncreaseRequestFromTemplateRequest::quotaCode)).setter(setter(Builder::quotaCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuotaCode").build()).build();

    private static final SdkField<String> AWS_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteServiceQuotaIncreaseRequestFromTemplateRequest::awsRegion)).setter(setter(Builder::awsRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsRegion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_CODE_FIELD,
            QUOTA_CODE_FIELD, AWS_REGION_FIELD));

    private final String serviceCode;

    private final String quotaCode;

    private final String awsRegion;

    private DeleteServiceQuotaIncreaseRequestFromTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.serviceCode = builder.serviceCode;
        this.quotaCode = builder.quotaCode;
        this.awsRegion = builder.awsRegion;
    }

    /**
     * <p>
     * Specifies the code for the service that you want to delete.
     * </p>
     * 
     * @return Specifies the code for the service that you want to delete.
     */
    public String serviceCode() {
        return serviceCode;
    }

    /**
     * <p>
     * Specifies the code for the quota that you want to delete.
     * </p>
     * 
     * @return Specifies the code for the quota that you want to delete.
     */
    public String quotaCode() {
        return quotaCode;
    }

    /**
     * <p>
     * Specifies the AWS Region for the quota that you want to delete.
     * </p>
     * 
     * @return Specifies the AWS Region for the quota that you want to delete.
     */
    public String awsRegion() {
        return awsRegion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serviceCode());
        hashCode = 31 * hashCode + Objects.hashCode(quotaCode());
        hashCode = 31 * hashCode + Objects.hashCode(awsRegion());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteServiceQuotaIncreaseRequestFromTemplateRequest)) {
            return false;
        }
        DeleteServiceQuotaIncreaseRequestFromTemplateRequest other = (DeleteServiceQuotaIncreaseRequestFromTemplateRequest) obj;
        return Objects.equals(serviceCode(), other.serviceCode()) && Objects.equals(quotaCode(), other.quotaCode())
                && Objects.equals(awsRegion(), other.awsRegion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeleteServiceQuotaIncreaseRequestFromTemplateRequest").add("ServiceCode", serviceCode())
                .add("QuotaCode", quotaCode()).add("AwsRegion", awsRegion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceCode":
            return Optional.ofNullable(clazz.cast(serviceCode()));
        case "QuotaCode":
            return Optional.ofNullable(clazz.cast(quotaCode()));
        case "AwsRegion":
            return Optional.ofNullable(clazz.cast(awsRegion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteServiceQuotaIncreaseRequestFromTemplateRequest, T> g) {
        return obj -> g.apply((DeleteServiceQuotaIncreaseRequestFromTemplateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceQuotasRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteServiceQuotaIncreaseRequestFromTemplateRequest> {
        /**
         * <p>
         * Specifies the code for the service that you want to delete.
         * </p>
         * 
         * @param serviceCode
         *        Specifies the code for the service that you want to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceCode(String serviceCode);

        /**
         * <p>
         * Specifies the code for the quota that you want to delete.
         * </p>
         * 
         * @param quotaCode
         *        Specifies the code for the quota that you want to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quotaCode(String quotaCode);

        /**
         * <p>
         * Specifies the AWS Region for the quota that you want to delete.
         * </p>
         * 
         * @param awsRegion
         *        Specifies the AWS Region for the quota that you want to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsRegion(String awsRegion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ServiceQuotasRequest.BuilderImpl implements Builder {
        private String serviceCode;

        private String quotaCode;

        private String awsRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteServiceQuotaIncreaseRequestFromTemplateRequest model) {
            super(model);
            serviceCode(model.serviceCode);
            quotaCode(model.quotaCode);
            awsRegion(model.awsRegion);
        }

        public final String getServiceCode() {
            return serviceCode;
        }

        @Override
        public final Builder serviceCode(String serviceCode) {
            this.serviceCode = serviceCode;
            return this;
        }

        public final void setServiceCode(String serviceCode) {
            this.serviceCode = serviceCode;
        }

        public final String getQuotaCode() {
            return quotaCode;
        }

        @Override
        public final Builder quotaCode(String quotaCode) {
            this.quotaCode = quotaCode;
            return this;
        }

        public final void setQuotaCode(String quotaCode) {
            this.quotaCode = quotaCode;
        }

        public final String getAwsRegion() {
            return awsRegion;
        }

        @Override
        public final Builder awsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
            return this;
        }

        public final void setAwsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteServiceQuotaIncreaseRequestFromTemplateRequest build() {
            return new DeleteServiceQuotaIncreaseRequestFromTemplateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
