/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicequotas.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetServiceQuotaIncreaseRequestFromTemplateResponse extends ServiceQuotasResponse
        implements
        ToCopyableBuilder<GetServiceQuotaIncreaseRequestFromTemplateResponse.Builder, GetServiceQuotaIncreaseRequestFromTemplateResponse> {
    private static final SdkField<ServiceQuotaIncreaseRequestInTemplate> SERVICE_QUOTA_INCREASE_REQUEST_IN_TEMPLATE_FIELD = SdkField
            .<ServiceQuotaIncreaseRequestInTemplate> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetServiceQuotaIncreaseRequestFromTemplateResponse::serviceQuotaIncreaseRequestInTemplate))
            .setter(setter(Builder::serviceQuotaIncreaseRequestInTemplate))
            .constructor(ServiceQuotaIncreaseRequestInTemplate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ServiceQuotaIncreaseRequestInTemplate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(SERVICE_QUOTA_INCREASE_REQUEST_IN_TEMPLATE_FIELD));

    private final ServiceQuotaIncreaseRequestInTemplate serviceQuotaIncreaseRequestInTemplate;

    private GetServiceQuotaIncreaseRequestFromTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.serviceQuotaIncreaseRequestInTemplate = builder.serviceQuotaIncreaseRequestInTemplate;
    }

    /**
     * <p>
     * This object contains the details about the quota increase request.
     * </p>
     * 
     * @return This object contains the details about the quota increase request.
     */
    public ServiceQuotaIncreaseRequestInTemplate serviceQuotaIncreaseRequestInTemplate() {
        return serviceQuotaIncreaseRequestInTemplate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serviceQuotaIncreaseRequestInTemplate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetServiceQuotaIncreaseRequestFromTemplateResponse)) {
            return false;
        }
        GetServiceQuotaIncreaseRequestFromTemplateResponse other = (GetServiceQuotaIncreaseRequestFromTemplateResponse) obj;
        return Objects.equals(serviceQuotaIncreaseRequestInTemplate(), other.serviceQuotaIncreaseRequestInTemplate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetServiceQuotaIncreaseRequestFromTemplateResponse")
                .add("ServiceQuotaIncreaseRequestInTemplate", serviceQuotaIncreaseRequestInTemplate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceQuotaIncreaseRequestInTemplate":
            return Optional.ofNullable(clazz.cast(serviceQuotaIncreaseRequestInTemplate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetServiceQuotaIncreaseRequestFromTemplateResponse, T> g) {
        return obj -> g.apply((GetServiceQuotaIncreaseRequestFromTemplateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceQuotasResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetServiceQuotaIncreaseRequestFromTemplateResponse> {
        /**
         * <p>
         * This object contains the details about the quota increase request.
         * </p>
         * 
         * @param serviceQuotaIncreaseRequestInTemplate
         *        This object contains the details about the quota increase request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceQuotaIncreaseRequestInTemplate(ServiceQuotaIncreaseRequestInTemplate serviceQuotaIncreaseRequestInTemplate);

        /**
         * <p>
         * This object contains the details about the quota increase request.
         * </p>
         * This is a convenience that creates an instance of the {@link ServiceQuotaIncreaseRequestInTemplate.Builder}
         * avoiding the need to create one manually via {@link ServiceQuotaIncreaseRequestInTemplate#builder()}.
         *
         * When the {@link Consumer} completes, {@link ServiceQuotaIncreaseRequestInTemplate.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #serviceQuotaIncreaseRequestInTemplate(ServiceQuotaIncreaseRequestInTemplate)}.
         * 
         * @param serviceQuotaIncreaseRequestInTemplate
         *        a consumer that will call methods on {@link ServiceQuotaIncreaseRequestInTemplate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceQuotaIncreaseRequestInTemplate(ServiceQuotaIncreaseRequestInTemplate)
         */
        default Builder serviceQuotaIncreaseRequestInTemplate(
                Consumer<ServiceQuotaIncreaseRequestInTemplate.Builder> serviceQuotaIncreaseRequestInTemplate) {
            return serviceQuotaIncreaseRequestInTemplate(ServiceQuotaIncreaseRequestInTemplate.builder()
                    .applyMutation(serviceQuotaIncreaseRequestInTemplate).build());
        }
    }

    static final class BuilderImpl extends ServiceQuotasResponse.BuilderImpl implements Builder {
        private ServiceQuotaIncreaseRequestInTemplate serviceQuotaIncreaseRequestInTemplate;

        private BuilderImpl() {
        }

        private BuilderImpl(GetServiceQuotaIncreaseRequestFromTemplateResponse model) {
            super(model);
            serviceQuotaIncreaseRequestInTemplate(model.serviceQuotaIncreaseRequestInTemplate);
        }

        public final ServiceQuotaIncreaseRequestInTemplate.Builder getServiceQuotaIncreaseRequestInTemplate() {
            return serviceQuotaIncreaseRequestInTemplate != null ? serviceQuotaIncreaseRequestInTemplate.toBuilder() : null;
        }

        @Override
        public final Builder serviceQuotaIncreaseRequestInTemplate(
                ServiceQuotaIncreaseRequestInTemplate serviceQuotaIncreaseRequestInTemplate) {
            this.serviceQuotaIncreaseRequestInTemplate = serviceQuotaIncreaseRequestInTemplate;
            return this;
        }

        public final void setServiceQuotaIncreaseRequestInTemplate(
                ServiceQuotaIncreaseRequestInTemplate.BuilderImpl serviceQuotaIncreaseRequestInTemplate) {
            this.serviceQuotaIncreaseRequestInTemplate = serviceQuotaIncreaseRequestInTemplate != null ? serviceQuotaIncreaseRequestInTemplate
                    .build() : null;
        }

        @Override
        public GetServiceQuotaIncreaseRequestFromTemplateResponse build() {
            return new GetServiceQuotaIncreaseRequestFromTemplateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
