/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicequotas.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that uses CloudWatch metrics to gather data about the service quota.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MetricInfo implements SdkPojo, Serializable, ToCopyableBuilder<MetricInfo.Builder, MetricInfo> {
    private static final SdkField<String> METRIC_NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MetricInfo::metricNamespace)).setter(setter(Builder::metricNamespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricNamespace").build()).build();

    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MetricInfo::metricName)).setter(setter(Builder::metricName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricName").build()).build();

    private static final SdkField<Map<String, String>> METRIC_DIMENSIONS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(MetricInfo::metricDimensions))
            .setter(setter(Builder::metricDimensions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricDimensions").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> METRIC_STATISTIC_RECOMMENDATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(MetricInfo::metricStatisticRecommendation))
            .setter(setter(Builder::metricStatisticRecommendation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricStatisticRecommendation")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_NAMESPACE_FIELD,
            METRIC_NAME_FIELD, METRIC_DIMENSIONS_FIELD, METRIC_STATISTIC_RECOMMENDATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String metricNamespace;

    private final String metricName;

    private final Map<String, String> metricDimensions;

    private final String metricStatisticRecommendation;

    private MetricInfo(BuilderImpl builder) {
        this.metricNamespace = builder.metricNamespace;
        this.metricName = builder.metricName;
        this.metricDimensions = builder.metricDimensions;
        this.metricStatisticRecommendation = builder.metricStatisticRecommendation;
    }

    /**
     * <p>
     * The namespace of the metric. The namespace is a container for CloudWatch metrics. You can specify a name for the
     * namespace when you create a metric.
     * </p>
     * 
     * @return The namespace of the metric. The namespace is a container for CloudWatch metrics. You can specify a name
     *         for the namespace when you create a metric.
     */
    public String metricNamespace() {
        return metricNamespace;
    }

    /**
     * <p>
     * The name of the CloudWatch metric that measures usage of a service quota. This is a required field.
     * </p>
     * 
     * @return The name of the CloudWatch metric that measures usage of a service quota. This is a required field.
     */
    public String metricName() {
        return metricName;
    }

    /**
     * Returns true if the MetricDimensions property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasMetricDimensions() {
        return metricDimensions != null && !(metricDimensions instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A dimension is a name/value pair that is part of the identity of a metric. Every metric has specific
     * characteristics that describe it, and you can think of dimensions as categories for those characteristics. These
     * dimensions are part of the CloudWatch Metric Identity that measures usage against a particular service quota.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMetricDimensions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A dimension is a name/value pair that is part of the identity of a metric. Every metric has specific
     *         characteristics that describe it, and you can think of dimensions as categories for those
     *         characteristics. These dimensions are part of the CloudWatch Metric Identity that measures usage against
     *         a particular service quota.
     */
    public Map<String, String> metricDimensions() {
        return metricDimensions;
    }

    /**
     * <p>
     * Statistics are metric data aggregations over specified periods of time. This is the recommended statistic to use
     * when comparing usage in the CloudWatch Metric against your Service Quota.
     * </p>
     * 
     * @return Statistics are metric data aggregations over specified periods of time. This is the recommended statistic
     *         to use when comparing usage in the CloudWatch Metric against your Service Quota.
     */
    public String metricStatisticRecommendation() {
        return metricStatisticRecommendation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(metricNamespace());
        hashCode = 31 * hashCode + Objects.hashCode(metricName());
        hashCode = 31 * hashCode + Objects.hashCode(metricDimensions());
        hashCode = 31 * hashCode + Objects.hashCode(metricStatisticRecommendation());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricInfo)) {
            return false;
        }
        MetricInfo other = (MetricInfo) obj;
        return Objects.equals(metricNamespace(), other.metricNamespace()) && Objects.equals(metricName(), other.metricName())
                && Objects.equals(metricDimensions(), other.metricDimensions())
                && Objects.equals(metricStatisticRecommendation(), other.metricStatisticRecommendation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("MetricInfo").add("MetricNamespace", metricNamespace()).add("MetricName", metricName())
                .add("MetricDimensions", metricDimensions())
                .add("MetricStatisticRecommendation", metricStatisticRecommendation()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MetricNamespace":
            return Optional.ofNullable(clazz.cast(metricNamespace()));
        case "MetricName":
            return Optional.ofNullable(clazz.cast(metricName()));
        case "MetricDimensions":
            return Optional.ofNullable(clazz.cast(metricDimensions()));
        case "MetricStatisticRecommendation":
            return Optional.ofNullable(clazz.cast(metricStatisticRecommendation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MetricInfo, T> g) {
        return obj -> g.apply((MetricInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MetricInfo> {
        /**
         * <p>
         * The namespace of the metric. The namespace is a container for CloudWatch metrics. You can specify a name for
         * the namespace when you create a metric.
         * </p>
         * 
         * @param metricNamespace
         *        The namespace of the metric. The namespace is a container for CloudWatch metrics. You can specify a
         *        name for the namespace when you create a metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricNamespace(String metricNamespace);

        /**
         * <p>
         * The name of the CloudWatch metric that measures usage of a service quota. This is a required field.
         * </p>
         * 
         * @param metricName
         *        The name of the CloudWatch metric that measures usage of a service quota. This is a required field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricName(String metricName);

        /**
         * <p>
         * A dimension is a name/value pair that is part of the identity of a metric. Every metric has specific
         * characteristics that describe it, and you can think of dimensions as categories for those characteristics.
         * These dimensions are part of the CloudWatch Metric Identity that measures usage against a particular service
         * quota.
         * </p>
         * 
         * @param metricDimensions
         *        A dimension is a name/value pair that is part of the identity of a metric. Every metric has specific
         *        characteristics that describe it, and you can think of dimensions as categories for those
         *        characteristics. These dimensions are part of the CloudWatch Metric Identity that measures usage
         *        against a particular service quota.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricDimensions(Map<String, String> metricDimensions);

        /**
         * <p>
         * Statistics are metric data aggregations over specified periods of time. This is the recommended statistic to
         * use when comparing usage in the CloudWatch Metric against your Service Quota.
         * </p>
         * 
         * @param metricStatisticRecommendation
         *        Statistics are metric data aggregations over specified periods of time. This is the recommended
         *        statistic to use when comparing usage in the CloudWatch Metric against your Service Quota.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricStatisticRecommendation(String metricStatisticRecommendation);
    }

    static final class BuilderImpl implements Builder {
        private String metricNamespace;

        private String metricName;

        private Map<String, String> metricDimensions = DefaultSdkAutoConstructMap.getInstance();

        private String metricStatisticRecommendation;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricInfo model) {
            metricNamespace(model.metricNamespace);
            metricName(model.metricName);
            metricDimensions(model.metricDimensions);
            metricStatisticRecommendation(model.metricStatisticRecommendation);
        }

        public final String getMetricNamespace() {
            return metricNamespace;
        }

        @Override
        public final Builder metricNamespace(String metricNamespace) {
            this.metricNamespace = metricNamespace;
            return this;
        }

        public final void setMetricNamespace(String metricNamespace) {
            this.metricNamespace = metricNamespace;
        }

        public final String getMetricName() {
            return metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public final Map<String, String> getMetricDimensions() {
            return metricDimensions;
        }

        @Override
        public final Builder metricDimensions(Map<String, String> metricDimensions) {
            this.metricDimensions = MetricDimensionsMapDefinitionCopier.copy(metricDimensions);
            return this;
        }

        public final void setMetricDimensions(Map<String, String> metricDimensions) {
            this.metricDimensions = MetricDimensionsMapDefinitionCopier.copy(metricDimensions);
        }

        public final String getMetricStatisticRecommendation() {
            return metricStatisticRecommendation;
        }

        @Override
        public final Builder metricStatisticRecommendation(String metricStatisticRecommendation) {
            this.metricStatisticRecommendation = metricStatisticRecommendation;
            return this;
        }

        public final void setMetricStatisticRecommendation(String metricStatisticRecommendation) {
            this.metricStatisticRecommendation = metricStatisticRecommendation;
        }

        @Override
        public MetricInfo build() {
            return new MetricInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
