/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicequotas.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListServiceQuotasResponse extends ServiceQuotasResponse implements
        ToCopyableBuilder<ListServiceQuotasResponse.Builder, ListServiceQuotasResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListServiceQuotasResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<ServiceQuota>> QUOTAS_FIELD = SdkField
            .<List<ServiceQuota>> builder(MarshallingType.LIST)
            .memberName("Quotas")
            .getter(getter(ListServiceQuotasResponse::quotas))
            .setter(setter(Builder::quotas))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Quotas").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ServiceQuota> builder(MarshallingType.SDK_POJO)
                                            .constructor(ServiceQuota::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(NEXT_TOKEN_FIELD, QUOTAS_FIELD));

    private final String nextToken;

    private final List<ServiceQuota> quotas;

    private ListServiceQuotasResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.quotas = builder.quotas;
    }

    /**
     * <p>
     * If present in the response, this value indicates there's more output available that what's included in the
     * current response. This can occur even when the response includes no values at all, such as when you ask for a
     * filtered view of a very long list. Use this value in the <code>NextToken</code> request parameter in a subsequent
     * call to the operation to continue processing and get the next part of the output. You should repeat this until
     * the <code>NextToken</code> response element comes back empty (as <code>null</code>).
     * </p>
     * 
     * @return If present in the response, this value indicates there's more output available that what's included in
     *         the current response. This can occur even when the response includes no values at all, such as when you
     *         ask for a filtered view of a very long list. Use this value in the <code>NextToken</code> request
     *         parameter in a subsequent call to the operation to continue processing and get the next part of the
     *         output. You should repeat this until the <code>NextToken</code> response element comes back empty (as
     *         <code>null</code>).
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the Quotas property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasQuotas() {
        return quotas != null && !(quotas instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The response information for a quota lists all attribute information for the quota.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasQuotas()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The response information for a quota lists all attribute information for the quota.
     */
    public List<ServiceQuota> quotas() {
        return quotas;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasQuotas() ? quotas() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServiceQuotasResponse)) {
            return false;
        }
        ListServiceQuotasResponse other = (ListServiceQuotasResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasQuotas() == other.hasQuotas()
                && Objects.equals(quotas(), other.quotas());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListServiceQuotasResponse").add("NextToken", nextToken())
                .add("Quotas", hasQuotas() ? quotas() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Quotas":
            return Optional.ofNullable(clazz.cast(quotas()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListServiceQuotasResponse, T> g) {
        return obj -> g.apply((ListServiceQuotasResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceQuotasResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListServiceQuotasResponse> {
        /**
         * <p>
         * If present in the response, this value indicates there's more output available that what's included in the
         * current response. This can occur even when the response includes no values at all, such as when you ask for a
         * filtered view of a very long list. Use this value in the <code>NextToken</code> request parameter in a
         * subsequent call to the operation to continue processing and get the next part of the output. You should
         * repeat this until the <code>NextToken</code> response element comes back empty (as <code>null</code>).
         * </p>
         * 
         * @param nextToken
         *        If present in the response, this value indicates there's more output available that what's included in
         *        the current response. This can occur even when the response includes no values at all, such as when
         *        you ask for a filtered view of a very long list. Use this value in the <code>NextToken</code> request
         *        parameter in a subsequent call to the operation to continue processing and get the next part of the
         *        output. You should repeat this until the <code>NextToken</code> response element comes back empty (as
         *        <code>null</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The response information for a quota lists all attribute information for the quota.
         * </p>
         * 
         * @param quotas
         *        The response information for a quota lists all attribute information for the quota.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quotas(Collection<ServiceQuota> quotas);

        /**
         * <p>
         * The response information for a quota lists all attribute information for the quota.
         * </p>
         * 
         * @param quotas
         *        The response information for a quota lists all attribute information for the quota.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quotas(ServiceQuota... quotas);

        /**
         * <p>
         * The response information for a quota lists all attribute information for the quota.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ServiceQuota>.Builder} avoiding the need to
         * create one manually via {@link List<ServiceQuota>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ServiceQuota>.Builder#build()} is called immediately and its
         * result is passed to {@link #quotas(List<ServiceQuota>)}.
         * 
         * @param quotas
         *        a consumer that will call methods on {@link List<ServiceQuota>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #quotas(List<ServiceQuota>)
         */
        Builder quotas(Consumer<ServiceQuota.Builder>... quotas);
    }

    static final class BuilderImpl extends ServiceQuotasResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<ServiceQuota> quotas = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListServiceQuotasResponse model) {
            super(model);
            nextToken(model.nextToken);
            quotas(model.quotas);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<ServiceQuota.Builder> getQuotas() {
            if (quotas instanceof SdkAutoConstructList) {
                return null;
            }
            return quotas != null ? quotas.stream().map(ServiceQuota::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder quotas(Collection<ServiceQuota> quotas) {
            this.quotas = ServiceQuotaListDefinitionCopier.copy(quotas);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder quotas(ServiceQuota... quotas) {
            quotas(Arrays.asList(quotas));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder quotas(Consumer<ServiceQuota.Builder>... quotas) {
            quotas(Stream.of(quotas).map(c -> ServiceQuota.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setQuotas(Collection<ServiceQuota.BuilderImpl> quotas) {
            this.quotas = ServiceQuotaListDefinitionCopier.copyFromBuilder(quotas);
        }

        @Override
        public ListServiceQuotasResponse build() {
            return new ListServiceQuotasResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
