/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicequotas.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RequestServiceQuotaIncreaseRequest extends ServiceQuotasRequest implements
        ToCopyableBuilder<RequestServiceQuotaIncreaseRequest.Builder, RequestServiceQuotaIncreaseRequest> {
    private static final SdkField<String> SERVICE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceCode").getter(getter(RequestServiceQuotaIncreaseRequest::serviceCode))
            .setter(setter(Builder::serviceCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceCode").build()).build();

    private static final SdkField<String> QUOTA_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QuotaCode").getter(getter(RequestServiceQuotaIncreaseRequest::quotaCode))
            .setter(setter(Builder::quotaCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuotaCode").build()).build();

    private static final SdkField<Double> DESIRED_VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("DesiredValue").getter(getter(RequestServiceQuotaIncreaseRequest::desiredValue))
            .setter(setter(Builder::desiredValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_CODE_FIELD,
            QUOTA_CODE_FIELD, DESIRED_VALUE_FIELD));

    private final String serviceCode;

    private final String quotaCode;

    private final Double desiredValue;

    private RequestServiceQuotaIncreaseRequest(BuilderImpl builder) {
        super(builder);
        this.serviceCode = builder.serviceCode;
        this.quotaCode = builder.quotaCode;
        this.desiredValue = builder.desiredValue;
    }

    /**
     * <p>
     * The service identifier.
     * </p>
     * 
     * @return The service identifier.
     */
    public final String serviceCode() {
        return serviceCode;
    }

    /**
     * <p>
     * The quota identifier.
     * </p>
     * 
     * @return The quota identifier.
     */
    public final String quotaCode() {
        return quotaCode;
    }

    /**
     * <p>
     * The new, increased value for the quota.
     * </p>
     * 
     * @return The new, increased value for the quota.
     */
    public final Double desiredValue() {
        return desiredValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serviceCode());
        hashCode = 31 * hashCode + Objects.hashCode(quotaCode());
        hashCode = 31 * hashCode + Objects.hashCode(desiredValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RequestServiceQuotaIncreaseRequest)) {
            return false;
        }
        RequestServiceQuotaIncreaseRequest other = (RequestServiceQuotaIncreaseRequest) obj;
        return Objects.equals(serviceCode(), other.serviceCode()) && Objects.equals(quotaCode(), other.quotaCode())
                && Objects.equals(desiredValue(), other.desiredValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RequestServiceQuotaIncreaseRequest").add("ServiceCode", serviceCode())
                .add("QuotaCode", quotaCode()).add("DesiredValue", desiredValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceCode":
            return Optional.ofNullable(clazz.cast(serviceCode()));
        case "QuotaCode":
            return Optional.ofNullable(clazz.cast(quotaCode()));
        case "DesiredValue":
            return Optional.ofNullable(clazz.cast(desiredValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RequestServiceQuotaIncreaseRequest, T> g) {
        return obj -> g.apply((RequestServiceQuotaIncreaseRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceQuotasRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, RequestServiceQuotaIncreaseRequest> {
        /**
         * <p>
         * The service identifier.
         * </p>
         * 
         * @param serviceCode
         *        The service identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceCode(String serviceCode);

        /**
         * <p>
         * The quota identifier.
         * </p>
         * 
         * @param quotaCode
         *        The quota identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quotaCode(String quotaCode);

        /**
         * <p>
         * The new, increased value for the quota.
         * </p>
         * 
         * @param desiredValue
         *        The new, increased value for the quota.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredValue(Double desiredValue);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ServiceQuotasRequest.BuilderImpl implements Builder {
        private String serviceCode;

        private String quotaCode;

        private Double desiredValue;

        private BuilderImpl() {
        }

        private BuilderImpl(RequestServiceQuotaIncreaseRequest model) {
            super(model);
            serviceCode(model.serviceCode);
            quotaCode(model.quotaCode);
            desiredValue(model.desiredValue);
        }

        public final String getServiceCode() {
            return serviceCode;
        }

        @Override
        public final Builder serviceCode(String serviceCode) {
            this.serviceCode = serviceCode;
            return this;
        }

        public final void setServiceCode(String serviceCode) {
            this.serviceCode = serviceCode;
        }

        public final String getQuotaCode() {
            return quotaCode;
        }

        @Override
        public final Builder quotaCode(String quotaCode) {
            this.quotaCode = quotaCode;
            return this;
        }

        public final void setQuotaCode(String quotaCode) {
            this.quotaCode = quotaCode;
        }

        public final Double getDesiredValue() {
            return desiredValue;
        }

        @Override
        public final Builder desiredValue(Double desiredValue) {
            this.desiredValue = desiredValue;
            return this;
        }

        public final void setDesiredValue(Double desiredValue) {
            this.desiredValue = desiredValue;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RequestServiceQuotaIncreaseRequest build() {
            return new RequestServiceQuotaIncreaseRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
