/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicequotas.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetServiceQuotaResponse extends ServiceQuotasResponse implements
        ToCopyableBuilder<GetServiceQuotaResponse.Builder, GetServiceQuotaResponse> {
    private static final SdkField<ServiceQuota> QUOTA_FIELD = SdkField.<ServiceQuota> builder(MarshallingType.SDK_POJO)
            .memberName("Quota").getter(getter(GetServiceQuotaResponse::quota)).setter(setter(Builder::quota))
            .constructor(ServiceQuota::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Quota").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUOTA_FIELD));

    private final ServiceQuota quota;

    private GetServiceQuotaResponse(BuilderImpl builder) {
        super(builder);
        this.quota = builder.quota;
    }

    /**
     * <p>
     * Information about the quota.
     * </p>
     * 
     * @return Information about the quota.
     */
    public final ServiceQuota quota() {
        return quota;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(quota());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetServiceQuotaResponse)) {
            return false;
        }
        GetServiceQuotaResponse other = (GetServiceQuotaResponse) obj;
        return Objects.equals(quota(), other.quota());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetServiceQuotaResponse").add("Quota", quota()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Quota":
            return Optional.ofNullable(clazz.cast(quota()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetServiceQuotaResponse, T> g) {
        return obj -> g.apply((GetServiceQuotaResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceQuotasResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetServiceQuotaResponse> {
        /**
         * <p>
         * Information about the quota.
         * </p>
         * 
         * @param quota
         *        Information about the quota.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quota(ServiceQuota quota);

        /**
         * <p>
         * Information about the quota.
         * </p>
         * This is a convenience that creates an instance of the {@link ServiceQuota.Builder} avoiding the need to
         * create one manually via {@link ServiceQuota#builder()}.
         *
         * When the {@link Consumer} completes, {@link ServiceQuota.Builder#build()} is called immediately and its
         * result is passed to {@link #quota(ServiceQuota)}.
         * 
         * @param quota
         *        a consumer that will call methods on {@link ServiceQuota.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #quota(ServiceQuota)
         */
        default Builder quota(Consumer<ServiceQuota.Builder> quota) {
            return quota(ServiceQuota.builder().applyMutation(quota).build());
        }
    }

    static final class BuilderImpl extends ServiceQuotasResponse.BuilderImpl implements Builder {
        private ServiceQuota quota;

        private BuilderImpl() {
        }

        private BuilderImpl(GetServiceQuotaResponse model) {
            super(model);
            quota(model.quota);
        }

        public final ServiceQuota.Builder getQuota() {
            return quota != null ? quota.toBuilder() : null;
        }

        @Override
        public final Builder quota(ServiceQuota quota) {
            this.quota = quota;
            return this;
        }

        public final void setQuota(ServiceQuota.BuilderImpl quota) {
            this.quota = quota != null ? quota.build() : null;
        }

        @Override
        public GetServiceQuotaResponse build() {
            return new GetServiceQuotaResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
