/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicequotas.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.servicequotas.ServiceQuotasClient;
import software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryRequest;
import software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryResponse;
import software.amazon.awssdk.services.servicequotas.model.RequestedServiceQuotaChange;

public class ListRequestedServiceQuotaChangeHistoryIterable
implements SdkIterable<ListRequestedServiceQuotaChangeHistoryResponse> {
    private final ServiceQuotasClient client;
    private final ListRequestedServiceQuotaChangeHistoryRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRequestedServiceQuotaChangeHistoryIterable(ServiceQuotasClient client, ListRequestedServiceQuotaChangeHistoryRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListRequestedServiceQuotaChangeHistoryResponseFetcher();
    }

    public Iterator<ListRequestedServiceQuotaChangeHistoryResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RequestedServiceQuotaChange> requestedQuotas() {
        Function<ListRequestedServiceQuotaChangeHistoryResponse, Iterator> getIterator = response -> {
            if (response != null && response.requestedQuotas() != null) {
                return response.requestedQuotas().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListRequestedServiceQuotaChangeHistoryResponseFetcher
    implements SyncPageFetcher<ListRequestedServiceQuotaChangeHistoryResponse> {
        private ListRequestedServiceQuotaChangeHistoryResponseFetcher() {
        }

        public boolean hasNextPage(ListRequestedServiceQuotaChangeHistoryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRequestedServiceQuotaChangeHistoryResponse nextPage(ListRequestedServiceQuotaChangeHistoryResponse previousPage) {
            if (previousPage == null) {
                return ListRequestedServiceQuotaChangeHistoryIterable.this.client.listRequestedServiceQuotaChangeHistory(ListRequestedServiceQuotaChangeHistoryIterable.this.firstRequest);
            }
            return ListRequestedServiceQuotaChangeHistoryIterable.this.client.listRequestedServiceQuotaChangeHistory((ListRequestedServiceQuotaChangeHistoryRequest)((Object)ListRequestedServiceQuotaChangeHistoryIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

