/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicequotas.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.servicequotas.model.RequestedServiceQuotaChange;
import software.amazon.awssdk.services.servicequotas.model.RequestedServiceQuotaChangeHistoryListDefinitionCopier;
import software.amazon.awssdk.services.servicequotas.model.ServiceQuotasResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRequestedServiceQuotaChangeHistoryByQuotaResponse
extends ServiceQuotasResponse
implements ToCopyableBuilder<Builder, ListRequestedServiceQuotaChangeHistoryByQuotaResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListRequestedServiceQuotaChangeHistoryByQuotaResponse.getter(ListRequestedServiceQuotaChangeHistoryByQuotaResponse::nextToken)).setter(ListRequestedServiceQuotaChangeHistoryByQuotaResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<RequestedServiceQuotaChange>> REQUESTED_QUOTAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RequestedQuotas").getter(ListRequestedServiceQuotaChangeHistoryByQuotaResponse.getter(ListRequestedServiceQuotaChangeHistoryByQuotaResponse::requestedQuotas)).setter(ListRequestedServiceQuotaChangeHistoryByQuotaResponse.setter(Builder::requestedQuotas)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestedQuotas").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RequestedServiceQuotaChange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, REQUESTED_QUOTAS_FIELD));
    private final String nextToken;
    private final List<RequestedServiceQuotaChange> requestedQuotas;

    private ListRequestedServiceQuotaChangeHistoryByQuotaResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.requestedQuotas = builder.requestedQuotas;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasRequestedQuotas() {
        return this.requestedQuotas != null && !(this.requestedQuotas instanceof SdkAutoConstructList);
    }

    public final List<RequestedServiceQuotaChange> requestedQuotas() {
        return this.requestedQuotas;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRequestedQuotas() ? this.requestedQuotas() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRequestedServiceQuotaChangeHistoryByQuotaResponse)) {
            return false;
        }
        ListRequestedServiceQuotaChangeHistoryByQuotaResponse other = (ListRequestedServiceQuotaChangeHistoryByQuotaResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasRequestedQuotas() == other.hasRequestedQuotas() && Objects.equals(this.requestedQuotas(), other.requestedQuotas());
    }

    public final String toString() {
        return ToString.builder((String)"ListRequestedServiceQuotaChangeHistoryByQuotaResponse").add("NextToken", (Object)this.nextToken()).add("RequestedQuotas", this.hasRequestedQuotas() ? this.requestedQuotas() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "RequestedQuotas": {
                return Optional.ofNullable(clazz.cast(this.requestedQuotas()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRequestedServiceQuotaChangeHistoryByQuotaResponse, T> g) {
        return obj -> g.apply((ListRequestedServiceQuotaChangeHistoryByQuotaResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceQuotasResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<RequestedServiceQuotaChange> requestedQuotas = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListRequestedServiceQuotaChangeHistoryByQuotaResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.requestedQuotas(model.requestedQuotas);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<RequestedServiceQuotaChange.Builder> getRequestedQuotas() {
            List<RequestedServiceQuotaChange.Builder> result = RequestedServiceQuotaChangeHistoryListDefinitionCopier.copyToBuilder(this.requestedQuotas);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRequestedQuotas(Collection<RequestedServiceQuotaChange.BuilderImpl> requestedQuotas) {
            this.requestedQuotas = RequestedServiceQuotaChangeHistoryListDefinitionCopier.copyFromBuilder(requestedQuotas);
        }

        @Override
        @Transient
        public final Builder requestedQuotas(Collection<RequestedServiceQuotaChange> requestedQuotas) {
            this.requestedQuotas = RequestedServiceQuotaChangeHistoryListDefinitionCopier.copy(requestedQuotas);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder requestedQuotas(RequestedServiceQuotaChange ... requestedQuotas) {
            this.requestedQuotas(Arrays.asList(requestedQuotas));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder requestedQuotas(Consumer<RequestedServiceQuotaChange.Builder> ... requestedQuotas) {
            this.requestedQuotas(Stream.of(requestedQuotas).map(c -> (RequestedServiceQuotaChange)((RequestedServiceQuotaChange.Builder)RequestedServiceQuotaChange.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListRequestedServiceQuotaChangeHistoryByQuotaResponse build() {
            return new ListRequestedServiceQuotaChangeHistoryByQuotaResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ServiceQuotasResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRequestedServiceQuotaChangeHistoryByQuotaResponse> {
        public Builder nextToken(String var1);

        public Builder requestedQuotas(Collection<RequestedServiceQuotaChange> var1);

        public Builder requestedQuotas(RequestedServiceQuotaChange ... var1);

        public Builder requestedQuotas(Consumer<RequestedServiceQuotaChange.Builder> ... var1);
    }
}

