/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicequotas;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.servicequotas.ServiceQuotasClient;
import software.amazon.awssdk.services.servicequotas.model.AccessDeniedException;
import software.amazon.awssdk.services.servicequotas.model.AssociateServiceQuotaTemplateRequest;
import software.amazon.awssdk.services.servicequotas.model.AssociateServiceQuotaTemplateResponse;
import software.amazon.awssdk.services.servicequotas.model.AwsServiceAccessNotEnabledException;
import software.amazon.awssdk.services.servicequotas.model.DeleteServiceQuotaIncreaseRequestFromTemplateRequest;
import software.amazon.awssdk.services.servicequotas.model.DeleteServiceQuotaIncreaseRequestFromTemplateResponse;
import software.amazon.awssdk.services.servicequotas.model.DependencyAccessDeniedException;
import software.amazon.awssdk.services.servicequotas.model.DisassociateServiceQuotaTemplateRequest;
import software.amazon.awssdk.services.servicequotas.model.DisassociateServiceQuotaTemplateResponse;
import software.amazon.awssdk.services.servicequotas.model.GetAssociationForServiceQuotaTemplateRequest;
import software.amazon.awssdk.services.servicequotas.model.GetAssociationForServiceQuotaTemplateResponse;
import software.amazon.awssdk.services.servicequotas.model.GetAwsDefaultServiceQuotaRequest;
import software.amazon.awssdk.services.servicequotas.model.GetAwsDefaultServiceQuotaResponse;
import software.amazon.awssdk.services.servicequotas.model.GetRequestedServiceQuotaChangeRequest;
import software.amazon.awssdk.services.servicequotas.model.GetRequestedServiceQuotaChangeResponse;
import software.amazon.awssdk.services.servicequotas.model.GetServiceQuotaIncreaseRequestFromTemplateRequest;
import software.amazon.awssdk.services.servicequotas.model.GetServiceQuotaIncreaseRequestFromTemplateResponse;
import software.amazon.awssdk.services.servicequotas.model.GetServiceQuotaRequest;
import software.amazon.awssdk.services.servicequotas.model.GetServiceQuotaResponse;
import software.amazon.awssdk.services.servicequotas.model.IllegalArgumentException;
import software.amazon.awssdk.services.servicequotas.model.InvalidPaginationTokenException;
import software.amazon.awssdk.services.servicequotas.model.InvalidResourceStateException;
import software.amazon.awssdk.services.servicequotas.model.ListAwsDefaultServiceQuotasRequest;
import software.amazon.awssdk.services.servicequotas.model.ListAwsDefaultServiceQuotasResponse;
import software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaRequest;
import software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaResponse;
import software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryRequest;
import software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryResponse;
import software.amazon.awssdk.services.servicequotas.model.ListServiceQuotaIncreaseRequestsInTemplateRequest;
import software.amazon.awssdk.services.servicequotas.model.ListServiceQuotaIncreaseRequestsInTemplateResponse;
import software.amazon.awssdk.services.servicequotas.model.ListServiceQuotasRequest;
import software.amazon.awssdk.services.servicequotas.model.ListServiceQuotasResponse;
import software.amazon.awssdk.services.servicequotas.model.ListServicesRequest;
import software.amazon.awssdk.services.servicequotas.model.ListServicesResponse;
import software.amazon.awssdk.services.servicequotas.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.servicequotas.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.servicequotas.model.NoAvailableOrganizationException;
import software.amazon.awssdk.services.servicequotas.model.NoSuchResourceException;
import software.amazon.awssdk.services.servicequotas.model.OrganizationNotInAllFeaturesModeException;
import software.amazon.awssdk.services.servicequotas.model.PutServiceQuotaIncreaseRequestIntoTemplateRequest;
import software.amazon.awssdk.services.servicequotas.model.PutServiceQuotaIncreaseRequestIntoTemplateResponse;
import software.amazon.awssdk.services.servicequotas.model.QuotaExceededException;
import software.amazon.awssdk.services.servicequotas.model.RequestServiceQuotaIncreaseRequest;
import software.amazon.awssdk.services.servicequotas.model.RequestServiceQuotaIncreaseResponse;
import software.amazon.awssdk.services.servicequotas.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.servicequotas.model.ServiceException;
import software.amazon.awssdk.services.servicequotas.model.ServiceQuotaTemplateNotInUseException;
import software.amazon.awssdk.services.servicequotas.model.ServiceQuotasException;
import software.amazon.awssdk.services.servicequotas.model.ServiceQuotasRequest;
import software.amazon.awssdk.services.servicequotas.model.TagPolicyViolationException;
import software.amazon.awssdk.services.servicequotas.model.TagResourceRequest;
import software.amazon.awssdk.services.servicequotas.model.TagResourceResponse;
import software.amazon.awssdk.services.servicequotas.model.TemplatesNotAvailableInRegionException;
import software.amazon.awssdk.services.servicequotas.model.TooManyRequestsException;
import software.amazon.awssdk.services.servicequotas.model.TooManyTagsException;
import software.amazon.awssdk.services.servicequotas.model.UntagResourceRequest;
import software.amazon.awssdk.services.servicequotas.model.UntagResourceResponse;
import software.amazon.awssdk.services.servicequotas.paginators.ListAWSDefaultServiceQuotasIterable;
import software.amazon.awssdk.services.servicequotas.paginators.ListRequestedServiceQuotaChangeHistoryByQuotaIterable;
import software.amazon.awssdk.services.servicequotas.paginators.ListRequestedServiceQuotaChangeHistoryIterable;
import software.amazon.awssdk.services.servicequotas.paginators.ListServiceQuotaIncreaseRequestsInTemplateIterable;
import software.amazon.awssdk.services.servicequotas.paginators.ListServiceQuotasIterable;
import software.amazon.awssdk.services.servicequotas.paginators.ListServicesIterable;
import software.amazon.awssdk.services.servicequotas.transform.AssociateServiceQuotaTemplateRequestMarshaller;
import software.amazon.awssdk.services.servicequotas.transform.DeleteServiceQuotaIncreaseRequestFromTemplateRequestMarshaller;
import software.amazon.awssdk.services.servicequotas.transform.DisassociateServiceQuotaTemplateRequestMarshaller;
import software.amazon.awssdk.services.servicequotas.transform.GetAssociationForServiceQuotaTemplateRequestMarshaller;
import software.amazon.awssdk.services.servicequotas.transform.GetAwsDefaultServiceQuotaRequestMarshaller;
import software.amazon.awssdk.services.servicequotas.transform.GetRequestedServiceQuotaChangeRequestMarshaller;
import software.amazon.awssdk.services.servicequotas.transform.GetServiceQuotaIncreaseRequestFromTemplateRequestMarshaller;
import software.amazon.awssdk.services.servicequotas.transform.GetServiceQuotaRequestMarshaller;
import software.amazon.awssdk.services.servicequotas.transform.ListAwsDefaultServiceQuotasRequestMarshaller;
import software.amazon.awssdk.services.servicequotas.transform.ListRequestedServiceQuotaChangeHistoryByQuotaRequestMarshaller;
import software.amazon.awssdk.services.servicequotas.transform.ListRequestedServiceQuotaChangeHistoryRequestMarshaller;
import software.amazon.awssdk.services.servicequotas.transform.ListServiceQuotaIncreaseRequestsInTemplateRequestMarshaller;
import software.amazon.awssdk.services.servicequotas.transform.ListServiceQuotasRequestMarshaller;
import software.amazon.awssdk.services.servicequotas.transform.ListServicesRequestMarshaller;
import software.amazon.awssdk.services.servicequotas.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.servicequotas.transform.PutServiceQuotaIncreaseRequestIntoTemplateRequestMarshaller;
import software.amazon.awssdk.services.servicequotas.transform.RequestServiceQuotaIncreaseRequestMarshaller;
import software.amazon.awssdk.services.servicequotas.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.servicequotas.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultServiceQuotasClient
implements ServiceQuotasClient {
    private static final Logger log = Logger.loggerFor(DefaultServiceQuotasClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultServiceQuotasClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssociateServiceQuotaTemplateResponse associateServiceQuotaTemplate(AssociateServiceQuotaTemplateRequest associateServiceQuotaTemplateRequest) throws DependencyAccessDeniedException, AccessDeniedException, ServiceException, TooManyRequestsException, AwsServiceAccessNotEnabledException, OrganizationNotInAllFeaturesModeException, TemplatesNotAvailableInRegionException, NoAvailableOrganizationException, AwsServiceException, SdkClientException, ServiceQuotasException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateServiceQuotaTemplateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultServiceQuotasClient.resolveMetricPublishers(this.clientConfiguration, associateServiceQuotaTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Quotas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociateServiceQuotaTemplate");
            AssociateServiceQuotaTemplateResponse associateServiceQuotaTemplateResponse = (AssociateServiceQuotaTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateServiceQuotaTemplate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)associateServiceQuotaTemplateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AssociateServiceQuotaTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return associateServiceQuotaTemplateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceQuotasClient.lambda$associateServiceQuotaTemplate$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteServiceQuotaIncreaseRequestFromTemplateResponse deleteServiceQuotaIncreaseRequestFromTemplate(DeleteServiceQuotaIncreaseRequestFromTemplateRequest deleteServiceQuotaIncreaseRequestFromTemplateRequest) throws AccessDeniedException, ServiceException, DependencyAccessDeniedException, TooManyRequestsException, NoSuchResourceException, IllegalArgumentException, AwsServiceAccessNotEnabledException, TemplatesNotAvailableInRegionException, NoAvailableOrganizationException, AwsServiceException, SdkClientException, ServiceQuotasException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteServiceQuotaIncreaseRequestFromTemplateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultServiceQuotasClient.resolveMetricPublishers(this.clientConfiguration, deleteServiceQuotaIncreaseRequestFromTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Quotas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteServiceQuotaIncreaseRequestFromTemplate");
            DeleteServiceQuotaIncreaseRequestFromTemplateResponse deleteServiceQuotaIncreaseRequestFromTemplateResponse = (DeleteServiceQuotaIncreaseRequestFromTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteServiceQuotaIncreaseRequestFromTemplate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteServiceQuotaIncreaseRequestFromTemplateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteServiceQuotaIncreaseRequestFromTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteServiceQuotaIncreaseRequestFromTemplateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceQuotasClient.lambda$deleteServiceQuotaIncreaseRequestFromTemplate$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisassociateServiceQuotaTemplateResponse disassociateServiceQuotaTemplate(DisassociateServiceQuotaTemplateRequest disassociateServiceQuotaTemplateRequest) throws DependencyAccessDeniedException, ServiceQuotaTemplateNotInUseException, AccessDeniedException, ServiceException, TooManyRequestsException, AwsServiceAccessNotEnabledException, TemplatesNotAvailableInRegionException, NoAvailableOrganizationException, AwsServiceException, SdkClientException, ServiceQuotasException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateServiceQuotaTemplateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultServiceQuotasClient.resolveMetricPublishers(this.clientConfiguration, disassociateServiceQuotaTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Quotas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisassociateServiceQuotaTemplate");
            DisassociateServiceQuotaTemplateResponse disassociateServiceQuotaTemplateResponse = (DisassociateServiceQuotaTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateServiceQuotaTemplate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disassociateServiceQuotaTemplateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisassociateServiceQuotaTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disassociateServiceQuotaTemplateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceQuotasClient.lambda$disassociateServiceQuotaTemplate$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAwsDefaultServiceQuotaResponse getAWSDefaultServiceQuota(GetAwsDefaultServiceQuotaRequest getAwsDefaultServiceQuotaRequest) throws AccessDeniedException, NoSuchResourceException, IllegalArgumentException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, ServiceQuotasException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAwsDefaultServiceQuotaResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultServiceQuotasClient.resolveMetricPublishers(this.clientConfiguration, getAwsDefaultServiceQuotaRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Quotas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAWSDefaultServiceQuota");
            GetAwsDefaultServiceQuotaResponse getAwsDefaultServiceQuotaResponse = (GetAwsDefaultServiceQuotaResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAWSDefaultServiceQuota").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getAwsDefaultServiceQuotaRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetAwsDefaultServiceQuotaRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getAwsDefaultServiceQuotaResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceQuotasClient.lambda$getAWSDefaultServiceQuota$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAssociationForServiceQuotaTemplateResponse getAssociationForServiceQuotaTemplate(GetAssociationForServiceQuotaTemplateRequest getAssociationForServiceQuotaTemplateRequest) throws DependencyAccessDeniedException, ServiceQuotaTemplateNotInUseException, AccessDeniedException, ServiceException, TooManyRequestsException, AwsServiceAccessNotEnabledException, TemplatesNotAvailableInRegionException, NoAvailableOrganizationException, AwsServiceException, SdkClientException, ServiceQuotasException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAssociationForServiceQuotaTemplateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultServiceQuotasClient.resolveMetricPublishers(this.clientConfiguration, getAssociationForServiceQuotaTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Quotas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAssociationForServiceQuotaTemplate");
            GetAssociationForServiceQuotaTemplateResponse getAssociationForServiceQuotaTemplateResponse = (GetAssociationForServiceQuotaTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAssociationForServiceQuotaTemplate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getAssociationForServiceQuotaTemplateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetAssociationForServiceQuotaTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getAssociationForServiceQuotaTemplateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceQuotasClient.lambda$getAssociationForServiceQuotaTemplate$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetRequestedServiceQuotaChangeResponse getRequestedServiceQuotaChange(GetRequestedServiceQuotaChangeRequest getRequestedServiceQuotaChangeRequest) throws AccessDeniedException, NoSuchResourceException, IllegalArgumentException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, ServiceQuotasException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRequestedServiceQuotaChangeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultServiceQuotasClient.resolveMetricPublishers(this.clientConfiguration, getRequestedServiceQuotaChangeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Quotas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRequestedServiceQuotaChange");
            GetRequestedServiceQuotaChangeResponse getRequestedServiceQuotaChangeResponse = (GetRequestedServiceQuotaChangeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRequestedServiceQuotaChange").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getRequestedServiceQuotaChangeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetRequestedServiceQuotaChangeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getRequestedServiceQuotaChangeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceQuotasClient.lambda$getRequestedServiceQuotaChange$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetServiceQuotaResponse getServiceQuota(GetServiceQuotaRequest getServiceQuotaRequest) throws AccessDeniedException, NoSuchResourceException, IllegalArgumentException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, ServiceQuotasException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetServiceQuotaResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultServiceQuotasClient.resolveMetricPublishers(this.clientConfiguration, getServiceQuotaRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Quotas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetServiceQuota");
            GetServiceQuotaResponse getServiceQuotaResponse = (GetServiceQuotaResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetServiceQuota").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getServiceQuotaRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetServiceQuotaRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getServiceQuotaResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceQuotasClient.lambda$getServiceQuota$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetServiceQuotaIncreaseRequestFromTemplateResponse getServiceQuotaIncreaseRequestFromTemplate(GetServiceQuotaIncreaseRequestFromTemplateRequest getServiceQuotaIncreaseRequestFromTemplateRequest) throws AccessDeniedException, DependencyAccessDeniedException, ServiceException, TooManyRequestsException, NoSuchResourceException, IllegalArgumentException, AwsServiceAccessNotEnabledException, TemplatesNotAvailableInRegionException, NoAvailableOrganizationException, AwsServiceException, SdkClientException, ServiceQuotasException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetServiceQuotaIncreaseRequestFromTemplateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultServiceQuotasClient.resolveMetricPublishers(this.clientConfiguration, getServiceQuotaIncreaseRequestFromTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Quotas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetServiceQuotaIncreaseRequestFromTemplate");
            GetServiceQuotaIncreaseRequestFromTemplateResponse getServiceQuotaIncreaseRequestFromTemplateResponse = (GetServiceQuotaIncreaseRequestFromTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetServiceQuotaIncreaseRequestFromTemplate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getServiceQuotaIncreaseRequestFromTemplateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetServiceQuotaIncreaseRequestFromTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getServiceQuotaIncreaseRequestFromTemplateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceQuotasClient.lambda$getServiceQuotaIncreaseRequestFromTemplate$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAwsDefaultServiceQuotasResponse listAWSDefaultServiceQuotas(ListAwsDefaultServiceQuotasRequest listAwsDefaultServiceQuotasRequest) throws AccessDeniedException, NoSuchResourceException, IllegalArgumentException, InvalidPaginationTokenException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, ServiceQuotasException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAwsDefaultServiceQuotasResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultServiceQuotasClient.resolveMetricPublishers(this.clientConfiguration, listAwsDefaultServiceQuotasRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Quotas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAWSDefaultServiceQuotas");
            ListAwsDefaultServiceQuotasResponse listAwsDefaultServiceQuotasResponse = (ListAwsDefaultServiceQuotasResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAWSDefaultServiceQuotas").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listAwsDefaultServiceQuotasRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListAwsDefaultServiceQuotasRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listAwsDefaultServiceQuotasResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceQuotasClient.lambda$listAWSDefaultServiceQuotas$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListAWSDefaultServiceQuotasIterable listAWSDefaultServiceQuotasPaginator(ListAwsDefaultServiceQuotasRequest listAwsDefaultServiceQuotasRequest) throws AccessDeniedException, NoSuchResourceException, IllegalArgumentException, InvalidPaginationTokenException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, ServiceQuotasException {
        return new ListAWSDefaultServiceQuotasIterable(this, this.applyPaginatorUserAgent(listAwsDefaultServiceQuotasRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListRequestedServiceQuotaChangeHistoryResponse listRequestedServiceQuotaChangeHistory(ListRequestedServiceQuotaChangeHistoryRequest listRequestedServiceQuotaChangeHistoryRequest) throws AccessDeniedException, NoSuchResourceException, IllegalArgumentException, InvalidPaginationTokenException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, ServiceQuotasException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRequestedServiceQuotaChangeHistoryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultServiceQuotasClient.resolveMetricPublishers(this.clientConfiguration, listRequestedServiceQuotaChangeHistoryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Quotas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListRequestedServiceQuotaChangeHistory");
            ListRequestedServiceQuotaChangeHistoryResponse listRequestedServiceQuotaChangeHistoryResponse = (ListRequestedServiceQuotaChangeHistoryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRequestedServiceQuotaChangeHistory").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listRequestedServiceQuotaChangeHistoryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListRequestedServiceQuotaChangeHistoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listRequestedServiceQuotaChangeHistoryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceQuotasClient.lambda$listRequestedServiceQuotaChangeHistory$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListRequestedServiceQuotaChangeHistoryIterable listRequestedServiceQuotaChangeHistoryPaginator(ListRequestedServiceQuotaChangeHistoryRequest listRequestedServiceQuotaChangeHistoryRequest) throws AccessDeniedException, NoSuchResourceException, IllegalArgumentException, InvalidPaginationTokenException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, ServiceQuotasException {
        return new ListRequestedServiceQuotaChangeHistoryIterable(this, this.applyPaginatorUserAgent(listRequestedServiceQuotaChangeHistoryRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListRequestedServiceQuotaChangeHistoryByQuotaResponse listRequestedServiceQuotaChangeHistoryByQuota(ListRequestedServiceQuotaChangeHistoryByQuotaRequest listRequestedServiceQuotaChangeHistoryByQuotaRequest) throws AccessDeniedException, NoSuchResourceException, IllegalArgumentException, InvalidPaginationTokenException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, ServiceQuotasException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRequestedServiceQuotaChangeHistoryByQuotaResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultServiceQuotasClient.resolveMetricPublishers(this.clientConfiguration, listRequestedServiceQuotaChangeHistoryByQuotaRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Quotas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListRequestedServiceQuotaChangeHistoryByQuota");
            ListRequestedServiceQuotaChangeHistoryByQuotaResponse listRequestedServiceQuotaChangeHistoryByQuotaResponse = (ListRequestedServiceQuotaChangeHistoryByQuotaResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRequestedServiceQuotaChangeHistoryByQuota").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listRequestedServiceQuotaChangeHistoryByQuotaRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListRequestedServiceQuotaChangeHistoryByQuotaRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listRequestedServiceQuotaChangeHistoryByQuotaResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceQuotasClient.lambda$listRequestedServiceQuotaChangeHistoryByQuota$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListRequestedServiceQuotaChangeHistoryByQuotaIterable listRequestedServiceQuotaChangeHistoryByQuotaPaginator(ListRequestedServiceQuotaChangeHistoryByQuotaRequest listRequestedServiceQuotaChangeHistoryByQuotaRequest) throws AccessDeniedException, NoSuchResourceException, IllegalArgumentException, InvalidPaginationTokenException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, ServiceQuotasException {
        return new ListRequestedServiceQuotaChangeHistoryByQuotaIterable(this, this.applyPaginatorUserAgent(listRequestedServiceQuotaChangeHistoryByQuotaRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListServiceQuotaIncreaseRequestsInTemplateResponse listServiceQuotaIncreaseRequestsInTemplate(ListServiceQuotaIncreaseRequestsInTemplateRequest listServiceQuotaIncreaseRequestsInTemplateRequest) throws AccessDeniedException, DependencyAccessDeniedException, ServiceException, TooManyRequestsException, IllegalArgumentException, AwsServiceAccessNotEnabledException, TemplatesNotAvailableInRegionException, NoAvailableOrganizationException, AwsServiceException, SdkClientException, ServiceQuotasException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListServiceQuotaIncreaseRequestsInTemplateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultServiceQuotasClient.resolveMetricPublishers(this.clientConfiguration, listServiceQuotaIncreaseRequestsInTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Quotas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListServiceQuotaIncreaseRequestsInTemplate");
            ListServiceQuotaIncreaseRequestsInTemplateResponse listServiceQuotaIncreaseRequestsInTemplateResponse = (ListServiceQuotaIncreaseRequestsInTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListServiceQuotaIncreaseRequestsInTemplate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listServiceQuotaIncreaseRequestsInTemplateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListServiceQuotaIncreaseRequestsInTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listServiceQuotaIncreaseRequestsInTemplateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceQuotasClient.lambda$listServiceQuotaIncreaseRequestsInTemplate$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListServiceQuotaIncreaseRequestsInTemplateIterable listServiceQuotaIncreaseRequestsInTemplatePaginator(ListServiceQuotaIncreaseRequestsInTemplateRequest listServiceQuotaIncreaseRequestsInTemplateRequest) throws AccessDeniedException, DependencyAccessDeniedException, ServiceException, TooManyRequestsException, IllegalArgumentException, AwsServiceAccessNotEnabledException, TemplatesNotAvailableInRegionException, NoAvailableOrganizationException, AwsServiceException, SdkClientException, ServiceQuotasException {
        return new ListServiceQuotaIncreaseRequestsInTemplateIterable(this, this.applyPaginatorUserAgent(listServiceQuotaIncreaseRequestsInTemplateRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListServiceQuotasResponse listServiceQuotas(ListServiceQuotasRequest listServiceQuotasRequest) throws AccessDeniedException, NoSuchResourceException, IllegalArgumentException, InvalidPaginationTokenException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, ServiceQuotasException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListServiceQuotasResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultServiceQuotasClient.resolveMetricPublishers(this.clientConfiguration, listServiceQuotasRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Quotas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListServiceQuotas");
            ListServiceQuotasResponse listServiceQuotasResponse = (ListServiceQuotasResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListServiceQuotas").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listServiceQuotasRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListServiceQuotasRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listServiceQuotasResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceQuotasClient.lambda$listServiceQuotas$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListServiceQuotasIterable listServiceQuotasPaginator(ListServiceQuotasRequest listServiceQuotasRequest) throws AccessDeniedException, NoSuchResourceException, IllegalArgumentException, InvalidPaginationTokenException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, ServiceQuotasException {
        return new ListServiceQuotasIterable(this, this.applyPaginatorUserAgent(listServiceQuotasRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListServicesResponse listServices(ListServicesRequest listServicesRequest) throws AccessDeniedException, IllegalArgumentException, InvalidPaginationTokenException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, ServiceQuotasException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListServicesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultServiceQuotasClient.resolveMetricPublishers(this.clientConfiguration, listServicesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Quotas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListServices");
            ListServicesResponse listServicesResponse = (ListServicesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListServices").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listServicesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListServicesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listServicesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceQuotasClient.lambda$listServices$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListServicesIterable listServicesPaginator(ListServicesRequest listServicesRequest) throws AccessDeniedException, IllegalArgumentException, InvalidPaginationTokenException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, ServiceQuotasException {
        return new ListServicesIterable(this, this.applyPaginatorUserAgent(listServicesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws TooManyRequestsException, NoSuchResourceException, IllegalArgumentException, AccessDeniedException, ServiceException, AwsServiceException, SdkClientException, ServiceQuotasException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultServiceQuotasClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Quotas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceQuotasClient.lambda$listTagsForResource$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutServiceQuotaIncreaseRequestIntoTemplateResponse putServiceQuotaIncreaseRequestIntoTemplate(PutServiceQuotaIncreaseRequestIntoTemplateRequest putServiceQuotaIncreaseRequestIntoTemplateRequest) throws AccessDeniedException, DependencyAccessDeniedException, ServiceException, TooManyRequestsException, IllegalArgumentException, QuotaExceededException, NoSuchResourceException, AwsServiceAccessNotEnabledException, TemplatesNotAvailableInRegionException, NoAvailableOrganizationException, AwsServiceException, SdkClientException, ServiceQuotasException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutServiceQuotaIncreaseRequestIntoTemplateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultServiceQuotasClient.resolveMetricPublishers(this.clientConfiguration, putServiceQuotaIncreaseRequestIntoTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Quotas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutServiceQuotaIncreaseRequestIntoTemplate");
            PutServiceQuotaIncreaseRequestIntoTemplateResponse putServiceQuotaIncreaseRequestIntoTemplateResponse = (PutServiceQuotaIncreaseRequestIntoTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutServiceQuotaIncreaseRequestIntoTemplate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putServiceQuotaIncreaseRequestIntoTemplateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutServiceQuotaIncreaseRequestIntoTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putServiceQuotaIncreaseRequestIntoTemplateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceQuotasClient.lambda$putServiceQuotaIncreaseRequestIntoTemplate$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RequestServiceQuotaIncreaseResponse requestServiceQuotaIncrease(RequestServiceQuotaIncreaseRequest requestServiceQuotaIncreaseRequest) throws DependencyAccessDeniedException, QuotaExceededException, ResourceAlreadyExistsException, AccessDeniedException, NoSuchResourceException, IllegalArgumentException, InvalidResourceStateException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, ServiceQuotasException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RequestServiceQuotaIncreaseResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultServiceQuotasClient.resolveMetricPublishers(this.clientConfiguration, requestServiceQuotaIncreaseRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Quotas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RequestServiceQuotaIncrease");
            RequestServiceQuotaIncreaseResponse requestServiceQuotaIncreaseResponse = (RequestServiceQuotaIncreaseResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RequestServiceQuotaIncrease").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)requestServiceQuotaIncreaseRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RequestServiceQuotaIncreaseRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return requestServiceQuotaIncreaseResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceQuotasClient.lambda$requestServiceQuotaIncrease$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws TooManyRequestsException, NoSuchResourceException, TooManyTagsException, TagPolicyViolationException, IllegalArgumentException, AccessDeniedException, ServiceException, AwsServiceException, SdkClientException, ServiceQuotasException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultServiceQuotasClient.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Quotas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceQuotasClient.lambda$tagResource$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws TooManyRequestsException, NoSuchResourceException, IllegalArgumentException, AccessDeniedException, ServiceException, AwsServiceException, SdkClientException, ServiceQuotasException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultServiceQuotasClient.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Quotas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceQuotasClient.lambda$untagResource$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private <T extends ServiceQuotasRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.20.22").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((ServiceQuotasRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public final String serviceName() {
        return "servicequotas";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(ServiceQuotasException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyTagsException").exceptionBuilderSupplier(TooManyTagsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").exceptionBuilderSupplier(InvalidResourceStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("IllegalArgumentException").exceptionBuilderSupplier(IllegalArgumentException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceException").exceptionBuilderSupplier(ServiceException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AWSServiceAccessNotEnabledException").exceptionBuilderSupplier(AwsServiceAccessNotEnabledException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DependencyAccessDeniedException").exceptionBuilderSupplier(DependencyAccessDeniedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchResourceException").exceptionBuilderSupplier(NoSuchResourceException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("QuotaExceededException").exceptionBuilderSupplier(QuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").exceptionBuilderSupplier(NoAvailableOrganizationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TemplatesNotAvailableInRegionException").exceptionBuilderSupplier(TemplatesNotAvailableInRegionException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").exceptionBuilderSupplier(InvalidPaginationTokenException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyRequestsException").exceptionBuilderSupplier(TooManyRequestsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").exceptionBuilderSupplier(TagPolicyViolationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceQuotaTemplateNotInUseException").exceptionBuilderSupplier(ServiceQuotaTemplateNotInUseException::builder).httpStatusCode(Integer.valueOf(400)).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$untagResource$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$requestServiceQuotaIncrease$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putServiceQuotaIncreaseRequestIntoTemplate$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listServices$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listServiceQuotas$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listServiceQuotaIncreaseRequestsInTemplate$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listRequestedServiceQuotaChangeHistoryByQuota$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listRequestedServiceQuotaChangeHistory$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAWSDefaultServiceQuotas$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getServiceQuotaIncreaseRequestFromTemplate$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getServiceQuota$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRequestedServiceQuotaChange$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAssociationForServiceQuotaTemplate$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAWSDefaultServiceQuota$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disassociateServiceQuotaTemplate$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteServiceQuotaIncreaseRequestFromTemplate$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$associateServiceQuotaTemplate$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

