/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicequotas;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.servicequotas.DefaultServiceQuotasAsyncClient;
import software.amazon.awssdk.services.servicequotas.DefaultServiceQuotasBaseClientBuilder;
import software.amazon.awssdk.services.servicequotas.ServiceQuotasAsyncClient;
import software.amazon.awssdk.services.servicequotas.ServiceQuotasAsyncClientBuilder;
import software.amazon.awssdk.services.servicequotas.ServiceQuotasServiceClientConfiguration;
import software.amazon.awssdk.services.servicequotas.endpoints.ServiceQuotasEndpointProvider;

@SdkInternalApi
final class DefaultServiceQuotasAsyncClientBuilder
extends DefaultServiceQuotasBaseClientBuilder<ServiceQuotasAsyncClientBuilder, ServiceQuotasAsyncClient>
implements ServiceQuotasAsyncClientBuilder {
    DefaultServiceQuotasAsyncClientBuilder() {
    }

    @Override
    public DefaultServiceQuotasAsyncClientBuilder endpointProvider(ServiceQuotasEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final ServiceQuotasAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultServiceQuotasAsyncClientBuilder.validateClientOptions(clientConfiguration);
        ServiceQuotasServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultServiceQuotasAsyncClient client = new DefaultServiceQuotasAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private ServiceQuotasServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return ServiceQuotasServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

