/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicequotas.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PeriodUnit {
    MICROSECOND("MICROSECOND"),
    MILLISECOND("MILLISECOND"),
    SECOND("SECOND"),
    MINUTE("MINUTE"),
    HOUR("HOUR"),
    DAY("DAY"),
    WEEK("WEEK"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PeriodUnit> VALUE_MAP;
    private final String value;

    private PeriodUnit(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PeriodUnit fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PeriodUnit> knownValues() {
        EnumSet<PeriodUnit> knownValues = EnumSet.allOf(PeriodUnit.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PeriodUnit.class, PeriodUnit::toString);
    }
}

