/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicequotas.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.servicequotas.model.AppliedLevelEnum;
import software.amazon.awssdk.services.servicequotas.model.ServiceQuotasRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListServiceQuotasRequest
extends ServiceQuotasRequest
implements ToCopyableBuilder<Builder, ListServiceQuotasRequest> {
    private static final SdkField<String> SERVICE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceCode").getter(ListServiceQuotasRequest.getter(ListServiceQuotasRequest::serviceCode)).setter(ListServiceQuotasRequest.setter(Builder::serviceCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceCode").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListServiceQuotasRequest.getter(ListServiceQuotasRequest::nextToken)).setter(ListServiceQuotasRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListServiceQuotasRequest.getter(ListServiceQuotasRequest::maxResults)).setter(ListServiceQuotasRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> QUOTA_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QuotaCode").getter(ListServiceQuotasRequest.getter(ListServiceQuotasRequest::quotaCode)).setter(ListServiceQuotasRequest.setter(Builder::quotaCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuotaCode").build()}).build();
    private static final SdkField<String> QUOTA_APPLIED_AT_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QuotaAppliedAtLevel").getter(ListServiceQuotasRequest.getter(ListServiceQuotasRequest::quotaAppliedAtLevelAsString)).setter(ListServiceQuotasRequest.setter(Builder::quotaAppliedAtLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuotaAppliedAtLevel").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_CODE_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, QUOTA_CODE_FIELD, QUOTA_APPLIED_AT_LEVEL_FIELD));
    private final String serviceCode;
    private final String nextToken;
    private final Integer maxResults;
    private final String quotaCode;
    private final String quotaAppliedAtLevel;

    private ListServiceQuotasRequest(BuilderImpl builder) {
        super(builder);
        this.serviceCode = builder.serviceCode;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.quotaCode = builder.quotaCode;
        this.quotaAppliedAtLevel = builder.quotaAppliedAtLevel;
    }

    public final String serviceCode() {
        return this.serviceCode;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String quotaCode() {
        return this.quotaCode;
    }

    public final AppliedLevelEnum quotaAppliedAtLevel() {
        return AppliedLevelEnum.fromValue(this.quotaAppliedAtLevel);
    }

    public final String quotaAppliedAtLevelAsString() {
        return this.quotaAppliedAtLevel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.quotaCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.quotaAppliedAtLevelAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServiceQuotasRequest)) {
            return false;
        }
        ListServiceQuotasRequest other = (ListServiceQuotasRequest)((Object)obj);
        return Objects.equals(this.serviceCode(), other.serviceCode()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.quotaCode(), other.quotaCode()) && Objects.equals(this.quotaAppliedAtLevelAsString(), other.quotaAppliedAtLevelAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ListServiceQuotasRequest").add("ServiceCode", (Object)this.serviceCode()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("QuotaCode", (Object)this.quotaCode()).add("QuotaAppliedAtLevel", (Object)this.quotaAppliedAtLevelAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceCode": {
                return Optional.ofNullable(clazz.cast(this.serviceCode()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "QuotaCode": {
                return Optional.ofNullable(clazz.cast(this.quotaCode()));
            }
            case "QuotaAppliedAtLevel": {
                return Optional.ofNullable(clazz.cast(this.quotaAppliedAtLevelAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListServiceQuotasRequest, T> g) {
        return obj -> g.apply((ListServiceQuotasRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceQuotasRequest.BuilderImpl
    implements Builder {
        private String serviceCode;
        private String nextToken;
        private Integer maxResults;
        private String quotaCode;
        private String quotaAppliedAtLevel;

        private BuilderImpl() {
        }

        private BuilderImpl(ListServiceQuotasRequest model) {
            super(model);
            this.serviceCode(model.serviceCode);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.quotaCode(model.quotaCode);
            this.quotaAppliedAtLevel(model.quotaAppliedAtLevel);
        }

        public final String getServiceCode() {
            return this.serviceCode;
        }

        public final void setServiceCode(String serviceCode) {
            this.serviceCode = serviceCode;
        }

        @Override
        public final Builder serviceCode(String serviceCode) {
            this.serviceCode = serviceCode;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getQuotaCode() {
            return this.quotaCode;
        }

        public final void setQuotaCode(String quotaCode) {
            this.quotaCode = quotaCode;
        }

        @Override
        public final Builder quotaCode(String quotaCode) {
            this.quotaCode = quotaCode;
            return this;
        }

        public final String getQuotaAppliedAtLevel() {
            return this.quotaAppliedAtLevel;
        }

        public final void setQuotaAppliedAtLevel(String quotaAppliedAtLevel) {
            this.quotaAppliedAtLevel = quotaAppliedAtLevel;
        }

        @Override
        public final Builder quotaAppliedAtLevel(String quotaAppliedAtLevel) {
            this.quotaAppliedAtLevel = quotaAppliedAtLevel;
            return this;
        }

        @Override
        public final Builder quotaAppliedAtLevel(AppliedLevelEnum quotaAppliedAtLevel) {
            this.quotaAppliedAtLevel(quotaAppliedAtLevel == null ? null : quotaAppliedAtLevel.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListServiceQuotasRequest build() {
            return new ListServiceQuotasRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ServiceQuotasRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListServiceQuotasRequest> {
        public Builder serviceCode(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder quotaCode(String var1);

        public Builder quotaAppliedAtLevel(String var1);

        public Builder quotaAppliedAtLevel(AppliedLevelEnum var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

